/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5;

import io.vertx.core.Vertx;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@DisplayName(value="Test multiple @BeforeAll methods")
class AsyncBeforeAllTest {
    private static boolean started1;
    private static boolean started2;
    private static final AtomicInteger count;

    AsyncBeforeAllTest() {
    }

    @BeforeAll
    static void before1(VertxTestContext context, Vertx vertx) {
        int c = count.get();
        boolean s = started2;
        if (c == 1) {
            Assertions.assertTrue((boolean)s);
        }
        Checkpoint checkpoint = context.checkpoint();
        vertx.setTimer(20L, id -> {
            started1 = true;
            count.incrementAndGet();
            checkpoint.flag();
        });
    }

    @BeforeAll
    static void before2(VertxTestContext context, Vertx vertx) {
        int c = count.get();
        boolean s = started1;
        if (c == 1) {
            Assertions.assertTrue((boolean)s);
        }
        Checkpoint checkpoint = context.checkpoint();
        vertx.setTimer(20L, id -> {
            started2 = true;
            count.incrementAndGet();
            checkpoint.flag();
        });
    }

    @Test
    void check_async_before_completed() {
        Assertions.assertEquals((int)2, (int)count.get());
        Assertions.assertTrue((boolean)started1);
        Assertions.assertTrue((boolean)started2);
    }

    static {
        count = new AtomicInteger();
    }
}

