package io.grpc.testing.integration;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.GrpcServer;

import java.util.ArrayList;
import java.util.List;

public class VertxUnimplementedServiceGrpcServer  {

  public static final ServiceMethod<com.google.protobuf.EmptyProtos.Empty, com.google.protobuf.EmptyProtos.Empty> UnimplementedCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "UnimplementedService"),
    "UnimplementedCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(com.google.protobuf.EmptyProtos.Empty.parser()));

  public interface UnimplementedServiceApi {

    default Future<com.google.protobuf.EmptyProtos.Empty> unimplementedCall(com.google.protobuf.EmptyProtos.Empty request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void unimplementedCall(com.google.protobuf.EmptyProtos.Empty request, Promise<com.google.protobuf.EmptyProtos.Empty> response) {
      unimplementedCall(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }

    default UnimplementedServiceApi bind_unimplementedCall(GrpcServer server) {
      server.callHandler(UnimplementedCall, request -> {
        Promise<com.google.protobuf.EmptyProtos.Empty> promise = Promise.promise();
        request.handler(req -> {
          try {
            unimplementedCall(req, promise);
          } catch (RuntimeException err) {
            promise.tryFail(err);
          }
        });
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
      });
      return this;
    }

    default UnimplementedServiceApi bindAll(GrpcServer server) {
      bind_unimplementedCall(server);
      return this;
    }
  }
}
