package io.grpc.testing.integration;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.GrpcServer;

import java.util.ArrayList;
import java.util.List;

public class VertxTestServiceGrpcServer  {

  public static final ServiceMethod<com.google.protobuf.EmptyProtos.Empty, com.google.protobuf.EmptyProtos.Empty> EmptyCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "TestService"),
    "EmptyCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(com.google.protobuf.EmptyProtos.Empty.parser()));
  public static final ServiceMethod<io.grpc.testing.integration.Messages.SimpleRequest, io.grpc.testing.integration.Messages.SimpleResponse> UnaryCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "TestService"),
    "UnaryCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(io.grpc.testing.integration.Messages.SimpleRequest.parser()));
  public static final ServiceMethod<io.grpc.testing.integration.Messages.StreamingOutputCallRequest, io.grpc.testing.integration.Messages.StreamingOutputCallResponse> StreamingOutputCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "TestService"),
    "StreamingOutputCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(io.grpc.testing.integration.Messages.StreamingOutputCallRequest.parser()));
  public static final ServiceMethod<io.grpc.testing.integration.Messages.StreamingInputCallRequest, io.grpc.testing.integration.Messages.StreamingInputCallResponse> StreamingInputCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "TestService"),
    "StreamingInputCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(io.grpc.testing.integration.Messages.StreamingInputCallRequest.parser()));
  public static final ServiceMethod<io.grpc.testing.integration.Messages.StreamingOutputCallRequest, io.grpc.testing.integration.Messages.StreamingOutputCallResponse> FullDuplexCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "TestService"),
    "FullDuplexCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(io.grpc.testing.integration.Messages.StreamingOutputCallRequest.parser()));
  public static final ServiceMethod<io.grpc.testing.integration.Messages.StreamingOutputCallRequest, io.grpc.testing.integration.Messages.StreamingOutputCallResponse> HalfDuplexCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "TestService"),
    "HalfDuplexCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(io.grpc.testing.integration.Messages.StreamingOutputCallRequest.parser()));
  public static final ServiceMethod<com.google.protobuf.EmptyProtos.Empty, com.google.protobuf.EmptyProtos.Empty> UnimplementedCall = ServiceMethod.server(
    ServiceName.create("grpc.testing", "TestService"),
    "UnimplementedCall",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(com.google.protobuf.EmptyProtos.Empty.parser()));

  public interface TestServiceApi {

    default Future<com.google.protobuf.EmptyProtos.Empty> emptyCall(com.google.protobuf.EmptyProtos.Empty request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void emptyCall(com.google.protobuf.EmptyProtos.Empty request, Promise<com.google.protobuf.EmptyProtos.Empty> response) {
      emptyCall(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }
    default Future<io.grpc.testing.integration.Messages.SimpleResponse> unaryCall(io.grpc.testing.integration.Messages.SimpleRequest request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void unaryCall(io.grpc.testing.integration.Messages.SimpleRequest request, Promise<io.grpc.testing.integration.Messages.SimpleResponse> response) {
      unaryCall(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }
    default Future<com.google.protobuf.EmptyProtos.Empty> unimplementedCall(com.google.protobuf.EmptyProtos.Empty request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void unimplementedCall(com.google.protobuf.EmptyProtos.Empty request, Promise<com.google.protobuf.EmptyProtos.Empty> response) {
      unimplementedCall(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }
    default ReadStream<io.grpc.testing.integration.Messages.StreamingOutputCallResponse> streamingOutputCall(io.grpc.testing.integration.Messages.StreamingOutputCallRequest request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void streamingOutputCall(io.grpc.testing.integration.Messages.StreamingOutputCallRequest request, WriteStream<io.grpc.testing.integration.Messages.StreamingOutputCallResponse> response) {
      streamingOutputCall(request)
        .handler(msg -> response.write(msg))
        .endHandler(msg -> response.end())
        .resume();
    }
    default Future<io.grpc.testing.integration.Messages.StreamingInputCallResponse> streamingInputCall(ReadStream<io.grpc.testing.integration.Messages.StreamingInputCallRequest> request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void streamingInputCall(ReadStream<io.grpc.testing.integration.Messages.StreamingInputCallRequest> request, Promise<io.grpc.testing.integration.Messages.StreamingInputCallResponse> response) {
      streamingInputCall(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }
    default ReadStream<io.grpc.testing.integration.Messages.StreamingOutputCallResponse> fullDuplexCall(ReadStream<io.grpc.testing.integration.Messages.StreamingOutputCallRequest> request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void fullDuplexCall(ReadStream<io.grpc.testing.integration.Messages.StreamingOutputCallRequest> request, WriteStream<io.grpc.testing.integration.Messages.StreamingOutputCallResponse> response) {
      fullDuplexCall(request)
        .handler(msg -> response.write(msg))
        .endHandler(msg -> response.end())
        .resume();
    }
    default ReadStream<io.grpc.testing.integration.Messages.StreamingOutputCallResponse> halfDuplexCall(ReadStream<io.grpc.testing.integration.Messages.StreamingOutputCallRequest> request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void halfDuplexCall(ReadStream<io.grpc.testing.integration.Messages.StreamingOutputCallRequest> request, WriteStream<io.grpc.testing.integration.Messages.StreamingOutputCallResponse> response) {
      halfDuplexCall(request)
        .handler(msg -> response.write(msg))
        .endHandler(msg -> response.end())
        .resume();
    }

    default TestServiceApi bind_emptyCall(GrpcServer server) {
      server.callHandler(EmptyCall, request -> {
        Promise<com.google.protobuf.EmptyProtos.Empty> promise = Promise.promise();
        request.handler(req -> {
          try {
            emptyCall(req, promise);
          } catch (RuntimeException err) {
            promise.tryFail(err);
          }
        });
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
      });
      return this;
    }
    default TestServiceApi bind_unaryCall(GrpcServer server) {
      server.callHandler(UnaryCall, request -> {
        Promise<io.grpc.testing.integration.Messages.SimpleResponse> promise = Promise.promise();
        request.handler(req -> {
          try {
            unaryCall(req, promise);
          } catch (RuntimeException err) {
            promise.tryFail(err);
          }
        });
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
      });
      return this;
    }
    default TestServiceApi bind_unimplementedCall(GrpcServer server) {
      server.callHandler(UnimplementedCall, request -> {
        Promise<com.google.protobuf.EmptyProtos.Empty> promise = Promise.promise();
        request.handler(req -> {
          try {
            unimplementedCall(req, promise);
          } catch (RuntimeException err) {
            promise.tryFail(err);
          }
        });
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
      });
      return this;
    }
    default TestServiceApi bind_streamingOutputCall(GrpcServer server) {
      server.callHandler(StreamingOutputCall, request -> {
        request.handler(req -> {
          try {
            streamingOutputCall(req, request.response());
          } catch (RuntimeException err) {
            request.response().status(GrpcStatus.INTERNAL).end();
          }
        });
      });
      return this;
    }
    default TestServiceApi bind_streamingInputCall(GrpcServer server) {
      server.callHandler(StreamingInputCall, request -> {
        Promise<io.grpc.testing.integration.Messages.StreamingInputCallResponse> promise = Promise.promise();
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
        try {
          streamingInputCall(request, promise);
        } catch (RuntimeException err) {
          promise.tryFail(err);
        }
      });
      return this;
    }
    default TestServiceApi bind_fullDuplexCall(GrpcServer server) {
      server.callHandler(FullDuplexCall, request -> {
        try {
          fullDuplexCall(request, request.response());
        } catch (RuntimeException err) {
          request.response().status(GrpcStatus.INTERNAL).end();
        }
      });
      return this;
    }
    default TestServiceApi bind_halfDuplexCall(GrpcServer server) {
      server.callHandler(HalfDuplexCall, request -> {
        try {
          halfDuplexCall(request, request.response());
        } catch (RuntimeException err) {
          request.response().status(GrpcStatus.INTERNAL).end();
        }
      });
      return this;
    }

    default TestServiceApi bindAll(GrpcServer server) {
      bind_emptyCall(server);
      bind_unaryCall(server);
      bind_streamingOutputCall(server);
      bind_streamingInputCall(server);
      bind_fullDuplexCall(server);
      bind_halfDuplexCall(server);
      bind_unimplementedCall(server);
      return this;
    }
  }
}
