package io.grpc.testing.integration;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.GrpcServer;

import java.util.ArrayList;
import java.util.List;

public class VertxReconnectServiceGrpcServer  {

  public static final ServiceMethod<com.google.protobuf.EmptyProtos.Empty, com.google.protobuf.EmptyProtos.Empty> Start = ServiceMethod.server(
    ServiceName.create("grpc.testing", "ReconnectService"),
    "Start",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(com.google.protobuf.EmptyProtos.Empty.parser()));
  public static final ServiceMethod<com.google.protobuf.EmptyProtos.Empty, io.grpc.testing.integration.Messages.ReconnectInfo> Stop = ServiceMethod.server(
    ServiceName.create("grpc.testing", "ReconnectService"),
    "Stop",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(com.google.protobuf.EmptyProtos.Empty.parser()));

  public interface ReconnectServiceApi {

    default Future<com.google.protobuf.EmptyProtos.Empty> start(com.google.protobuf.EmptyProtos.Empty request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void start(com.google.protobuf.EmptyProtos.Empty request, Promise<com.google.protobuf.EmptyProtos.Empty> response) {
      start(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }
    default Future<io.grpc.testing.integration.Messages.ReconnectInfo> stop(com.google.protobuf.EmptyProtos.Empty request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void stop(com.google.protobuf.EmptyProtos.Empty request, Promise<io.grpc.testing.integration.Messages.ReconnectInfo> response) {
      stop(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }

    default ReconnectServiceApi bind_start(GrpcServer server) {
      server.callHandler(Start, request -> {
        Promise<com.google.protobuf.EmptyProtos.Empty> promise = Promise.promise();
        request.handler(req -> {
          try {
            start(req, promise);
          } catch (RuntimeException err) {
            promise.tryFail(err);
          }
        });
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
      });
      return this;
    }
    default ReconnectServiceApi bind_stop(GrpcServer server) {
      server.callHandler(Stop, request -> {
        Promise<io.grpc.testing.integration.Messages.ReconnectInfo> promise = Promise.promise();
        request.handler(req -> {
          try {
            stop(req, promise);
          } catch (RuntimeException err) {
            promise.tryFail(err);
          }
        });
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
      });
      return this;
    }

    default ReconnectServiceApi bindAll(GrpcServer server) {
      bind_start(server);
      bind_stop(server);
      return this;
    }
  }
}
