package io.grpc.examples.manualflowcontrol;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.GrpcServer;

import java.util.ArrayList;
import java.util.List;

public class VertxStreamingGreeterGrpcServer  {

  public static final ServiceMethod<io.grpc.examples.manualflowcontrol.HelloRequest, io.grpc.examples.manualflowcontrol.HelloReply> SayHelloStreaming = ServiceMethod.server(
    ServiceName.create("manualflowcontrol", "StreamingGreeter"),
    "SayHelloStreaming",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(io.grpc.examples.manualflowcontrol.HelloRequest.parser()));

  public interface StreamingGreeterApi {

    default ReadStream<io.grpc.examples.manualflowcontrol.HelloReply> sayHelloStreaming(ReadStream<io.grpc.examples.manualflowcontrol.HelloRequest> request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void sayHelloStreaming(ReadStream<io.grpc.examples.manualflowcontrol.HelloRequest> request, WriteStream<io.grpc.examples.manualflowcontrol.HelloReply> response) {
      sayHelloStreaming(request)
        .handler(msg -> response.write(msg))
        .endHandler(msg -> response.end())
        .resume();
    }

    default StreamingGreeterApi bind_sayHelloStreaming(GrpcServer server) {
      server.callHandler(SayHelloStreaming, request -> {
        try {
          sayHelloStreaming(request, request.response());
        } catch (RuntimeException err) {
          request.response().status(GrpcStatus.INTERNAL).end();
        }
      });
      return this;
    }

    default StreamingGreeterApi bindAll(GrpcServer server) {
      bind_sayHelloStreaming(server);
      return this;
    }
  }
}
