package io.grpc.examples.helloworld;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.server.GrpcServer;

import java.util.ArrayList;
import java.util.List;

public class VertxGreeterGrpcServer  {

  public static final ServiceMethod<io.grpc.examples.helloworld.HelloRequest, io.grpc.examples.helloworld.HelloReply> SayHello = ServiceMethod.server(
    ServiceName.create("helloworld", "Greeter"),
    "SayHello",
    GrpcMessageEncoder.encoder(),
    GrpcMessageDecoder.decoder(io.grpc.examples.helloworld.HelloRequest.parser()));

  public interface GreeterApi {

    default Future<io.grpc.examples.helloworld.HelloReply> sayHello(io.grpc.examples.helloworld.HelloRequest request) {
      throw new UnsupportedOperationException("Not implemented");
    }
    default void sayHello(io.grpc.examples.helloworld.HelloRequest request, Promise<io.grpc.examples.helloworld.HelloReply> response) {
      sayHello(request)
        .onSuccess(msg -> response.complete(msg))
        .onFailure(error -> response.fail(error));
    }

    default GreeterApi bind_sayHello(GrpcServer server) {
      server.callHandler(SayHello, request -> {
        Promise<io.grpc.examples.helloworld.HelloReply> promise = Promise.promise();
        request.handler(req -> {
          try {
            sayHello(req, promise);
          } catch (RuntimeException err) {
            promise.tryFail(err);
          }
        });
        promise.future()
          .onFailure(err -> request.response().status(GrpcStatus.INTERNAL).end())
          .onSuccess(resp -> request.response().end(resp));
      });
      return this;
    }

    default GreeterApi bindAll(GrpcServer server) {
      bind_sayHello(server);
      return this;
    }
  }
}
