/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.ReadConcern;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import com.mongodb.client.model.changestream.UpdateDescription;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDiagnosticContext;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.Entity;
import io.vena.bosk.EnumerableByIdentifier;
import io.vena.bosk.Identifier;
import io.vena.bosk.MapValue;
import io.vena.bosk.Path;
import io.vena.bosk.Reference;
import io.vena.bosk.RootReference;
import io.vena.bosk.StateTreeNode;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.BsonSurgeon;
import io.vena.bosk.drivers.mongo.Demultiplexer;
import io.vena.bosk.drivers.mongo.FlushLock;
import io.vena.bosk.drivers.mongo.FormatDriver;
import io.vena.bosk.drivers.mongo.FormatMisconfigurationException;
import io.vena.bosk.drivers.mongo.Formatter;
import io.vena.bosk.drivers.mongo.MainDriver;
import io.vena.bosk.drivers.mongo.Manifest;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.PandoFormat;
import io.vena.bosk.drivers.mongo.RevisionFieldDisruptedException;
import io.vena.bosk.drivers.mongo.StateAndMetadata;
import io.vena.bosk.drivers.mongo.TransactionalCollection;
import io.vena.bosk.drivers.mongo.UninitializedCollectionException;
import io.vena.bosk.drivers.mongo.UnprocessableEventException;
import io.vena.bosk.drivers.mongo.UnrecognizedFormatException;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import io.vena.bosk.exceptions.NotYetImplementedException;
import io.vena.bosk.util.Classes;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PandoFormatDriver<R extends StateTreeNode>
implements FormatDriver<R> {
    private final String description;
    private final PandoFormat format;
    private final MongoDriverSettings settings;
    private final Formatter formatter;
    private final TransactionalCollection<BsonDocument> collection;
    private final RootReference<R> rootRef;
    private final BoskDriver<R> downstream;
    private final FlushLock flushLock;
    private final BsonSurgeon bsonSurgeon;
    private final Demultiplexer demultiplexer = new Demultiplexer();
    private volatile BsonInt64 revisionToSkip = null;
    static final BsonString ROOT_DOCUMENT_ID = new BsonString("|");
    private static final Set<String> ALREADY_WARNED = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final BsonDocument ROOT_DOCUMENT_FILTER = new BsonDocument("_id", (BsonValue)ROOT_DOCUMENT_ID);
    private static final EnumSet<OperationType> OPERATIONS_TO_INCLUDE_IN_GATHER = EnumSet.of(OperationType.INSERT);
    private static final Logger LOGGER = LoggerFactory.getLogger(PandoFormatDriver.class);

    PandoFormatDriver(Bosk<R> bosk, TransactionalCollection<BsonDocument> collection, MongoDriverSettings driverSettings, PandoFormat format, BsonPlugin bsonPlugin, FlushLock flushLock, BoskDriver<R> downstream) {
        this.description = PandoFormatDriver.class.getSimpleName() + ": " + driverSettings;
        this.settings = driverSettings;
        this.format = format;
        this.formatter = new Formatter(bosk, bsonPlugin);
        this.collection = collection;
        this.rootRef = bosk.rootReference();
        this.downstream = downstream;
        this.flushLock = flushLock;
        this.bsonSurgeon = new BsonSurgeon(format.separateCollections().stream().map(s -> PandoFormatDriver.referenceTo(s, this.rootRef)).sorted(Comparator.comparing(ref -> ref.path().length()).reversed()).collect(Collectors.toList()));
    }

    private static Reference<EnumerableByIdentifier<Entity>> referenceTo(String pathString, RootReference<?> rootRef) {
        try {
            return rootRef.then(Classes.enumerableByIdentifier(Entity.class), Path.parseParameterized((String)pathString));
        }
        catch (InvalidTypeException e) {
            throw new FormatMisconfigurationException("Path does not point to a Catalog or SideTable: " + pathString, e);
        }
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        this.doReplacement(target, newValue);
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        this.collection.ensureTransactionStarted();
        Reference<T> mainRef = this.mainRef(target);
        BsonDocument filter = this.documentFilter(mainRef).append(Formatter.dottedFieldNameOf(target, mainRef), (BsonValue)new BsonDocument("$exists", (BsonValue)BsonBoolean.TRUE));
        if (this.documentExists(filter)) {
            LOGGER.debug("Already exists: {}", (Object)filter);
            this.collection.abortTransaction();
            return;
        }
        this.doReplacement(target, newValue);
    }

    public <T> void submitDeletion(Reference<T> target) {
        this.doDelete(target);
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        this.collection.ensureTransactionStarted();
        if (this.preconditionFailed(precondition, requiredValue)) {
            this.collection.abortTransaction();
            return;
        }
        this.doReplacement(target, newValue);
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        this.collection.ensureTransactionStarted();
        if (this.preconditionFailed(precondition, requiredValue)) {
            this.collection.abortTransaction();
            return;
        }
        this.doDelete(target);
    }

    public void flush() throws IOException, InterruptedException {
        this.flushLock.awaitRevision(this.readRevisionNumber());
        LOGGER.debug("| Flush downstream");
        this.downstream.flush();
    }

    @Override
    public void close() {
        LOGGER.debug("+ close()");
        this.flushLock.close();
    }

    @Override
    public StateAndMetadata<R> loadAllState() throws IOException, UninitializedCollectionException {
        ArrayList<BsonDocument> allParts = new ArrayList<BsonDocument>();
        try (MongoCursor cursor = this.collection.withReadConcern(ReadConcern.LOCAL).find(Filters.regex((String)"_id", (String)("^" + Pattern.quote("|")))).sort((Bson)new BsonDocument("_id", (BsonValue)new BsonInt32(-1))).cursor();){
            while (cursor.hasNext()) {
                allParts.add((BsonDocument)cursor.next());
            }
        }
        catch (NoSuchElementException e) {
            throw new UninitializedCollectionException("No existing document", e);
        }
        BsonDocument mainPart = (BsonDocument)allParts.get(allParts.size() - 1);
        if (!ROOT_DOCUMENT_ID.equals((Object)mainPart.get((Object)"_id"))) {
            throw new IllegalStateException("Cannot locate root document");
        }
        BsonValue revision = mainPart.get((Object)Formatter.DocumentFields.revision.name(), (BsonValue)Formatter.REVISION_ZERO);
        MapValue<String> diagnosticAttributes = this.formatter.getDiagnosticAttributesFromFullDocument(mainPart);
        BsonDocument combinedState = this.bsonSurgeon.gather(allParts);
        StateTreeNode root = (StateTreeNode)this.formatter.document2object(combinedState, this.rootRef);
        return new StateAndMetadata<StateTreeNode>(root, revision.asInt64(), diagnosticAttributes);
    }

    @Override
    public void initializeCollection(StateAndMetadata<R> priorContents) {
        BsonValue initialState = this.formatter.object2bsonValue(priorContents.state, this.rootRef.targetType());
        BsonInt64 newRevision = new BsonInt64(1L + priorContents.revision.longValue());
        LOGGER.debug("** Initial upsert for {}", (Object)ROOT_DOCUMENT_ID.getValue());
        this.collection.ensureTransactionStarted();
        if (initialState instanceof BsonDocument) {
            this.upsertAndRemoveSubParts((Reference)this.rootRef, initialState.asDocument());
        }
        BsonDocument update = new BsonDocument("$set", (BsonValue)this.initialDocument(initialState, newRevision));
        BsonDocument filter = this.rootDocumentFilter();
        UpdateOptions options = new UpdateOptions().upsert(true);
        LOGGER.trace("| Filter: {}", (Object)filter);
        LOGGER.trace("| Update: {}", (Object)update);
        LOGGER.trace("| Options: {}", (Object)options);
        UpdateResult result = this.collection.updateOne((Bson)filter, (Bson)update, options);
        LOGGER.debug("| Result: {}", (Object)result);
        if (this.settings.experimental().manifestMode() == MongoDriverSettings.ManifestMode.CREATE_IF_ABSENT) {
            this.writeManifest();
        }
    }

    private void writeManifest() {
        BsonDocument doc = new BsonDocument("_id", (BsonValue)MainDriver.MANIFEST_ID);
        doc.putAll((Map)((BsonDocument)this.formatter.object2bsonValue(Manifest.forPando(this.format), (Type)((Object)Manifest.class))));
        BsonDocument update = new BsonDocument("$set", (BsonValue)doc);
        BsonDocument filter = new BsonDocument("_id", (BsonValue)MainDriver.MANIFEST_ID);
        UpdateOptions options = new UpdateOptions().upsert(true);
        LOGGER.debug("| Initial manifest: {}", (Object)doc);
        UpdateResult result = this.collection.updateOne((Bson)filter, (Bson)update, options);
        LOGGER.debug("| Manifest result: {}", (Object)result);
    }

    @Override
    public void onEvent(ChangeStreamDocument<BsonDocument> event) throws UnprocessableEventException {
        if (event.getDocumentKey() == null) {
            throw new UnprocessableEventException("Null document key", event.getOperationType());
        }
        BsonValue bsonDocumentID = event.getDocumentKey().get((Object)"_id");
        if (!(bsonDocumentID instanceof BsonString)) {
            LOGGER.debug("Ignoring event for unrecognized non-string document key: {} type {}", (Object)event.getDocumentKey(), bsonDocumentID.getClass());
            return;
        }
        if (MainDriver.MANIFEST_ID.equals((Object)bsonDocumentID)) {
            this.onManifestEvent(event);
            return;
        }
        if (event.getTxnNumber() == null) {
            LOGGER.debug("Processing standalone event {} on {}", (Object)event.getOperationType(), (Object)event.getDocumentKey());
            this.processTransaction(Collections.singletonList(event));
        } else {
            this.demultiplexer.add(event);
            if (this.isFinalEventOfTransaction(event)) {
                LOGGER.debug("Processing final event {} on {}", (Object)event.getOperationType(), (Object)event.getDocumentKey());
                this.processTransaction(this.demultiplexer.pop(event));
            } else {
                LOGGER.debug("Queueing transaction event {} on {}", (Object)event.getOperationType(), (Object)event.getDocumentKey());
            }
        }
    }

    private boolean isFinalEventOfTransaction(ChangeStreamDocument<BsonDocument> event) {
        return ROOT_DOCUMENT_ID.equals((Object)event.getDocumentKey().get((Object)"_id")) && PandoFormatDriver.updateEventHasField(event, Formatter.DocumentFields.revision);
    }

    private void processTransaction(List<ChangeStreamDocument<BsonDocument>> events) throws UnprocessableEventException {
        ChangeStreamDocument<BsonDocument> finalEvent = events.get(events.size() - 1);
        switch (finalEvent.getOperationType()) {
            case INSERT: 
            case REPLACE: {
                BsonDocument fullDocument = (BsonDocument)finalEvent.getFullDocument();
                if (fullDocument == null) {
                    throw new UnprocessableEventException("Missing fullDocument on final event", finalEvent.getOperationType());
                }
                BsonInt64 revision = this.formatter.getRevisionFromFullDocument(fullDocument);
                if (this.shouldSkip(revision)) {
                    LOGGER.debug("Skipping revision {}", (Object)revision.longValue());
                    return;
                }
                MapValue<String> diagnosticAttributes = this.formatter.eventDiagnosticAttributesFromFullDocument(fullDocument);
                try (BoskDiagnosticContext.DiagnosticScope __ = this.rootRef.diagnosticContext().withOnly(diagnosticAttributes);){
                    BsonDocument state = fullDocument.getDocument((Object)Formatter.DocumentFields.state.name());
                    if (state == null) {
                        ChangeStreamDocument<BsonDocument> mainEvent = events.get(events.size() - 2);
                        LOGGER.debug("Main event is {} on {}", (Object)mainEvent.getOperationType(), (Object)mainEvent.getDocumentKey());
                        this.propagateDownstream(mainEvent, events.subList(0, events.size() - 2));
                    } else {
                        LOGGER.debug("Main event is final event");
                        this.propagateDownstream(finalEvent, events.subList(0, events.size() - 1));
                    }
                }
                this.flushLock.finishedRevision(revision);
                break;
            }
            case UPDATE: {
                BsonInt64 revision = this.formatter.getRevisionFromUpdateEvent(finalEvent);
                if (this.shouldSkip(revision)) {
                    LOGGER.debug("Skipping revision {}", (Object)revision.longValue());
                    return;
                }
                MapValue<String> attributes = this.formatter.eventDiagnosticAttributesFromUpdate(finalEvent);
                try (BoskDiagnosticContext.DiagnosticScope __ = this.rootRef.diagnosticContext().withOnly(attributes);){
                    boolean mainEventIsFinalEvent = PandoFormatDriver.updateEventHasField(finalEvent, Formatter.DocumentFields.state);
                    if (mainEventIsFinalEvent) {
                        LOGGER.debug("Main event is final event");
                        this.propagateDownstream(finalEvent, events.subList(0, events.size() - 1));
                    } else if (events.size() < 2) {
                        LOGGER.debug("Main event is a no-op");
                    } else {
                        ChangeStreamDocument<BsonDocument> mainEvent = events.get(events.size() - 2);
                        LOGGER.debug("Main event is {} on {}", (Object)mainEvent.getOperationType(), (Object)mainEvent.getDocumentKey());
                        this.propagateDownstream(mainEvent, events.subList(0, events.size() - 2));
                    }
                }
                this.flushLock.finishedRevision(revision);
                break;
            }
            case DELETE: {
                LOGGER.debug("Document containing revision field has been deleted; assuming revision=0");
                this.flushLock.finishedRevision(Formatter.REVISION_ZERO);
                this.revisionToSkip = null;
                break;
            }
            default: {
                throw new UnprocessableEventException("Cannot process event", finalEvent.getOperationType());
            }
        }
    }

    private void propagateDownstream(ChangeStreamDocument<BsonDocument> mainEvent, List<ChangeStreamDocument<BsonDocument>> priorEvents) throws UnprocessableEventException {
        switch (mainEvent.getOperationType()) {
            case INSERT: 
            case REPLACE: {
                Reference<?> mainRef;
                BsonDocument bsonState;
                BsonDocument fullDocument = (BsonDocument)mainEvent.getFullDocument();
                if (fullDocument == null) {
                    throw new UnprocessableEventException("Missing fullDocument on main event", mainEvent.getOperationType());
                }
                BsonDocument state = fullDocument.getDocument((Object)Formatter.DocumentFields.state.name(), null);
                if (state == null) {
                    throw new UnprocessableEventException("Missing state field", mainEvent.getOperationType());
                }
                if (priorEvents == null) {
                    LOGGER.debug("No prior events");
                    bsonState = state;
                    mainRef = this.documentID2MainRef(mainEvent.getDocumentKey().getString((Object)"_id").getValue(), mainEvent);
                } else {
                    LOGGER.debug("{} prior events", (Object)priorEvents.size());
                    List<BsonDocument> parts = this.subpartDocuments(priorEvents);
                    parts.add(fullDocument);
                    bsonState = this.bsonSurgeon.gather(parts);
                    mainRef = this.documentID2MainRef(fullDocument.getString((Object)"_id").getValue(), mainEvent);
                }
                LOGGER.debug("| Replace downstream {}", mainRef);
                this.submitReplacementDownstream(mainRef, bsonState);
                break;
            }
            case UPDATE: {
                Reference<?> mainRef = this.documentID2MainRef(mainEvent.getDocumentKey().getString((Object)"_id").getValue(), mainEvent);
                UpdateDescription updateDescription = mainEvent.getUpdateDescription();
                if (updateDescription == null) break;
                this.replaceUpdatedFields(mainRef, updateDescription.getUpdatedFields(), this.subpartDocuments(priorEvents), mainEvent.getOperationType());
                this.deleteRemovedFields(mainRef, updateDescription.getRemovedFields(), mainEvent.getOperationType());
                break;
            }
            case DELETE: {
                Reference<?> mainRef = this.mainRef(this.documentID2MainRef(mainEvent.getDocumentKey().getString((Object)"_id").getValue(), mainEvent));
                LOGGER.debug("| Delete downstream {}", mainRef);
                this.downstream.submitDeletion(mainRef);
                break;
            }
            default: {
                throw new UnprocessableEventException("Cannot process event", mainEvent.getOperationType());
            }
        }
    }

    private List<BsonDocument> subpartDocuments(List<ChangeStreamDocument<BsonDocument>> priorEvents) {
        return priorEvents.stream().filter(e -> OPERATIONS_TO_INCLUDE_IN_GATHER.contains(e.getOperationType())).map(this::fullDocumentForSubPart).collect(Collectors.toCollection(ArrayList::new));
    }

    @NonNull
    private BsonDocument fullDocumentForSubPart(ChangeStreamDocument<BsonDocument> event) {
        BsonDocument result = (BsonDocument)event.getFullDocument();
        if (result == null) {
            throw new IllegalStateException("No full document in change stream event for subpart: " + event.getOperationType() + " on " + event.getDocumentKey());
        }
        return result;
    }

    private <T> void submitReplacementDownstream(Reference<T> mainRef, BsonDocument bsonState) {
        T newValue = this.formatter.document2object(bsonState, mainRef);
        this.downstream.submitReplacement(mainRef, newValue);
    }

    private Reference<?> documentID2MainRef(String pipedPath, ChangeStreamDocument<BsonDocument> event) throws UnprocessableEventException {
        String dottedName = "state" + pipedPath.replace('|', '.');
        try {
            return Formatter.referenceTo(dottedName, this.rootRef);
        }
        catch (InvalidTypeException e) {
            throw new UnprocessableEventException("Invalid path from document ID: \"" + pipedPath + "\"", e, event.getOperationType());
        }
    }

    private void onManifestEvent(ChangeStreamDocument<BsonDocument> event) throws UnprocessableEventException {
        if (event.getOperationType() == OperationType.INSERT) {
            Manifest manifest;
            BsonDocument manifestDoc = Objects.requireNonNull((BsonDocument)event.getFullDocument());
            try {
                manifest = this.formatter.decodeManifest(manifestDoc);
            }
            catch (UnrecognizedFormatException e) {
                throw new UnprocessableEventException("Invalid manifest", e, event.getOperationType());
            }
            if (!manifest.equals(Manifest.forPando(this.format))) {
                throw new UnprocessableEventException("Manifest indicates format has changed", event.getOperationType());
            }
        } else {
            throw new UnprocessableEventException("Unexpected change to manifest document", event.getOperationType());
        }
        LOGGER.debug("Ignoring benign manifest change event");
    }

    @Override
    public void onRevisionToSkip(BsonInt64 revision) {
        LOGGER.debug("+ onRevisionToSkip({})", (Object)revision.longValue());
        this.revisionToSkip = revision;
        this.flushLock.finishedRevision(revision);
    }

    private static boolean updateEventHasField(ChangeStreamDocument<BsonDocument> event, Formatter.DocumentFields field) {
        if (event == null) {
            return false;
        }
        UpdateDescription updateDescription = event.getUpdateDescription();
        if (updateDescription == null) {
            return false;
        }
        BsonDocument updatedFields = updateDescription.getUpdatedFields();
        if (updatedFields != null && updatedFields.keySet().stream().anyMatch(k -> k.startsWith(field.name()))) {
            return true;
        }
        List removedFields = updateDescription.getRemovedFields();
        return removedFields != null && removedFields.stream().anyMatch(k -> k.startsWith(field.name()));
    }

    private <T> void doReplacement(Reference<T> target, T newValue) {
        this.collection.ensureTransactionStarted();
        Object mainRef = this.mainRef(target);
        BsonValue value = this.formatter.object2bsonValue(newValue, target.targetType());
        if (value instanceof BsonDocument) {
            this.deletePartsUnder(target);
            this.upsertAndRemoveSubParts(target, value.asDocument());
        }
        if (this.rootRef.equals(mainRef)) {
            LOGGER.debug("| Root ref is main ref");
            LOGGER.debug("| Pre-delete on root document");
            String key = Formatter.dottedFieldNameOf(target, this.rootRef);
            LOGGER.debug("| Pre-delete field {}", (Object)key);
            this.doUpdate(new BsonDocument("$unset", (BsonValue)new BsonDocument(key, (BsonValue)BsonNull.VALUE)), this.standardRootPreconditions(target));
            LOGGER.debug("| Update root document");
            this.doUpdate(this.replacementDoc(target, value, (Reference<?>)this.rootRef), this.standardRootPreconditions(target));
        } else {
            BsonDocument filter = this.documentFilter((Reference<?>)mainRef);
            if (target.equals(mainRef)) {
                LOGGER.debug("| Pre-delete main document");
                this.collection.deleteOne((Bson)filter);
                LOGGER.debug("| Update main document");
                BsonDocument update = new BsonDocument("$set", (BsonValue)filter.clone().append(Formatter.DocumentFields.state.name(), value));
                LOGGER.debug("| Update: {}", (Object)update);
                LOGGER.debug("| Filter: {}", (Object)filter);
                this.collection.updateOne((Bson)filter, (Bson)update, new UpdateOptions().upsert(true));
                try {
                    mainRef = this.mainRef(mainRef.enclosingReference(Object.class));
                    filter = this.documentFilter((Reference<?>)mainRef);
                    value = BsonBoolean.TRUE;
                    LOGGER.debug("| Move up to enclosing main reference {}", mainRef);
                }
                catch (InvalidTypeException e) {
                    throw new AssertionError((Object)"Every non-root reference has an enclosing reference");
                }
            }
            String key = Formatter.dottedFieldNameOf(target, mainRef);
            LOGGER.debug("| Pre-delete field {} in {}", (Object)key, mainRef);
            BsonDocument preDelete = new BsonDocument("$unset", (BsonValue)new BsonDocument(key, (BsonValue)BsonNull.VALUE));
            this.doUpdate(preDelete, this.standardPreconditions(target, (Reference<?>)mainRef, filter));
            LOGGER.debug("| Set field {} in {}: {}", new Object[]{key, mainRef, value});
            BsonDocument mainUpdate = new BsonDocument("$set", (BsonValue)new BsonDocument(key, value));
            this.doUpdate(mainUpdate, this.standardPreconditions(target, (Reference<?>)mainRef, filter));
            LOGGER.debug("| Bump revision on root document");
            this.doUpdate(this.blankUpdateDoc(), this.rootDocumentFilter());
        }
    }

    private <T> void doDelete(Reference<T> target) {
        this.collection.ensureTransactionStarted();
        this.deletePartsUnder(target);
        Object mainRef = this.mainRef(target);
        if (mainRef.equals(target)) {
            if (this.settings.experimental().orphanDocumentMode() != MongoDriverSettings.OrphanDocumentMode.HASTY) {
                throw new NotYetImplementedException("Earnest mode not yet implemented");
            }
            LOGGER.debug("Skipping deleting document({}) in {} mode", target, (Object)MongoDriverSettings.OrphanDocumentMode.HASTY);
            assert (!mainRef.path().isEmpty()) : "Can't delete the root reference";
            try {
                mainRef = this.mainRef(mainRef.enclosingReference(Object.class));
                LOGGER.debug("Move up to enclosing main reference {}", mainRef);
            }
            catch (InvalidTypeException e) {
                throw new AssertionError((Object)"Every non-root reference has an enclosing reference");
            }
        }
        if (this.doUpdate(this.deletionDoc(target, (Reference<?>)mainRef), this.standardPreconditions(target, (Reference<?>)mainRef, this.documentFilter((Reference<?>)mainRef)))) {
            if (!this.rootRef.equals(mainRef)) {
                this.doUpdate(this.blankUpdateDoc(), this.rootDocumentFilter());
            }
        } else {
            LOGGER.debug("Deletion had no effect; aborting transaction");
            this.collection.abortTransaction();
        }
    }

    private boolean preconditionFailed(Reference<Identifier> precondition, Identifier requiredValue) {
        boolean result;
        Reference<Identifier> mainRef = this.mainRef(precondition);
        BsonDocument filter = this.documentFilter(mainRef).append(Formatter.dottedFieldNameOf(precondition, mainRef), (BsonValue)new BsonString(requiredValue.toString()));
        LOGGER.debug("Precondition filter: {}", (Object)filter);
        boolean bl = result = !this.documentExists(filter);
        if (result) {
            LOGGER.debug("Precondition fail: {} != {}", precondition, (Object)requiredValue);
        }
        return result;
    }

    private boolean documentExists(BsonDocument filter) {
        return 0L != this.collection.countDocuments((Bson)filter, new CountOptions().limit(1));
    }

    private Reference<?> mainRef(Reference<?> target) {
        if (target.path().isEmpty()) {
            return this.rootRef;
        }
        int targetPathLength = target.path().length();
        for (BsonSurgeon.GraftPoint graftPoint : this.bsonSurgeon.graftPoints) {
            Reference<? extends EnumerableByIdentifier<?>> candidateContainer = graftPoint.containerRef();
            int containerPathLength = candidateContainer.path().length();
            if (containerPathLength > targetPathLength - 1 || !candidateContainer.path().matchesPrefixOf(target.path())) continue;
            try {
                return candidateContainer.boundBy(target.path()).then(Object.class, new String[]{target.path().segment(containerPathLength)});
            }
            catch (InvalidTypeException e) {
                throw new AssertionError((Object)("Unexpected exception forming mainRef from container " + candidateContainer + " and target " + target));
            }
        }
        return this.rootRef;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BsonInt64 readRevisionNumber() throws FlushFailureException {
        LOGGER.debug("readRevisionNumber");
        try (MongoCursor cursor = this.collection.withReadConcern(ReadConcern.LOCAL).find((Bson)ROOT_DOCUMENT_FILTER).limit(1).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{Formatter.DocumentFields.revision.name()})})).cursor();){
            BsonDocument doc = (BsonDocument)cursor.next();
            BsonInt64 result = doc.getInt64((Object)Formatter.DocumentFields.revision.name(), null);
            if (result == null) {
                LOGGER.debug("No revision field; assuming {}", (Object)Formatter.REVISION_ZERO.longValue());
                BsonInt64 bsonInt642 = Formatter.REVISION_ZERO;
                return bsonInt642;
            }
            LOGGER.debug("Read revision {}", (Object)result);
            BsonInt64 bsonInt64 = result;
            return bsonInt64;
        }
        catch (NoSuchElementException e) {
            LOGGER.debug("Document is missing", (Throwable)e);
            throw new RevisionFieldDisruptedException(e);
        }
        catch (RuntimeException e) {
            LOGGER.debug("readRevisionNumber failed", (Throwable)e);
            throw new FlushFailureException((Throwable)e);
        }
    }

    private BsonDocument rootDocumentFilter() {
        return new BsonDocument("_id", (BsonValue)ROOT_DOCUMENT_ID);
    }

    private BsonDocument documentFilter(Reference<?> docRef) {
        String id = '|' + String.join((CharSequence)"|", BsonSurgeon.docSegments(docRef, this.rootRef));
        return new BsonDocument("_id", (BsonValue)new BsonString(id));
    }

    private <T> BsonDocument standardRootPreconditions(Reference<T> target) {
        return this.standardPreconditions(target, (Reference<?>)this.rootRef, this.rootDocumentFilter());
    }

    private <T> BsonDocument standardPreconditions(Reference<T> target, Reference<?> startingRef, BsonDocument filter) {
        if (!target.path().equals(startingRef.path())) {
            String enclosingObjectKey = Formatter.dottedFieldNameOf(Formatter.enclosingReference(target), startingRef);
            BsonDocument condition = new BsonDocument("$type", (BsonValue)new BsonString("object"));
            filter.put(enclosingObjectKey, (BsonValue)condition);
            LOGGER.debug("| Precondition: {} {}", (Object)enclosingObjectKey, (Object)condition);
        }
        return filter;
    }

    private <T> BsonDocument explicitPreconditions(Reference<T> target, Reference<Identifier> preconditionRef, Identifier requiredValue) {
        BsonDocument filter = this.standardRootPreconditions(target);
        BsonDocument precondition = new BsonDocument("$eq", (BsonValue)new BsonString(requiredValue.toString()));
        filter.put(Formatter.dottedFieldNameOf(preconditionRef, this.rootRef), (BsonValue)precondition);
        return filter;
    }

    private <T> BsonDocument replacementDoc(Reference<T> target, BsonValue value, Reference<?> startingRef) {
        String key = Formatter.dottedFieldNameOf(target, startingRef);
        LOGGER.debug("| Set field {}: {}", (Object)key, (Object)value);
        BsonDocument result = this.blankUpdateDoc();
        result.compute((Object)"$set", (__, existing) -> {
            if (existing == null) {
                return new BsonDocument(key, value);
            }
            return existing.asDocument().append(key, value);
        });
        return result;
    }

    private <T> BsonDocument deletionDoc(Reference<T> target, Reference<?> startingRef) {
        String key = Formatter.dottedFieldNameOf(target, startingRef);
        LOGGER.debug("| Unset field {}", (Object)key);
        return this.blankUpdateDoc().append("$unset", (BsonValue)new BsonDocument(key, (BsonValue)BsonNull.VALUE));
    }

    private BsonDocument blankUpdateDoc() {
        return new BsonDocument("$inc", (BsonValue)new BsonDocument(Formatter.DocumentFields.revision.name(), (BsonValue)new BsonInt64(1L))).append("$set", (BsonValue)new BsonDocument(Formatter.DocumentFields.diagnostics.name(), (BsonValue)this.formatter.encodeDiagnostics((MapValue<String>)this.rootRef.diagnosticContext().getAttributes())));
    }

    private BsonDocument initialDocument(BsonValue initialState, BsonInt64 revision) {
        BsonDocument fieldValues = new BsonDocument("_id", (BsonValue)ROOT_DOCUMENT_ID);
        fieldValues.put(Formatter.DocumentFields.path.name(), (BsonValue)new BsonString("/"));
        fieldValues.put(Formatter.DocumentFields.state.name(), initialState);
        fieldValues.put(Formatter.DocumentFields.revision.name(), (BsonValue)revision);
        fieldValues.put(Formatter.DocumentFields.diagnostics.name(), (BsonValue)this.formatter.encodeDiagnostics((MapValue<String>)this.rootRef.diagnosticContext().getAttributes()));
        return fieldValues;
    }

    private boolean doUpdate(BsonDocument updateDoc, BsonDocument filter) {
        LOGGER.debug("| Update: {}", (Object)updateDoc);
        LOGGER.debug("| Filter: {}", (Object)filter);
        UpdateResult result = this.collection.updateOne((Bson)filter, (Bson)updateDoc);
        LOGGER.debug("| Update result: {}", (Object)result);
        if (result.wasAcknowledged()) {
            assert (result.getMatchedCount() <= 1L);
            return result.getMatchedCount() >= 1L;
        }
        LOGGER.error("MongoDB write was not acknowledged");
        LOGGER.trace("Details of MongoDB write not acknowledged:\n\tFilter: {}\n\tUpdate: {}\n\tResult: {}", new Object[]{filter, updateDoc, result});
        throw new IllegalStateException("Mongo write was not acknowledged: " + result);
    }

    private void replaceUpdatedFields(Reference<?> mainRef, @Nullable BsonDocument updatedFields, List<BsonDocument> subParts, OperationType operationType) throws UnprocessableEventException {
        if (updatedFields != null) {
            boolean alreadyUsedSubparts = false;
            for (Map.Entry entry : updatedFields.entrySet()) {
                Reference ref;
                String dottedName = (String)entry.getKey();
                if (!dottedName.startsWith(Formatter.DocumentFields.state.name())) continue;
                try {
                    ref = Formatter.referenceTo(dottedName, mainRef);
                }
                catch (InvalidTypeException e) {
                    this.logNonexistentField(dottedName, e);
                    continue;
                }
                if (alreadyUsedSubparts) {
                    throw new IllegalStateException("Not expecting an update event that changes multiple state fields");
                }
                alreadyUsedSubparts = true;
                BsonValue replacementValue = (BsonValue)entry.getValue();
                if (replacementValue instanceof BsonDocument) {
                    LOGGER.debug("Replacement value is a document; gather along with {} subparts", (Object)subParts.size());
                    String mainID = "|" + String.join((CharSequence)"|", BsonSurgeon.docSegments(ref, mainRef));
                    BsonDocument mainDocument = new BsonDocument().append("_id", (BsonValue)new BsonString(mainID)).append("state", replacementValue);
                    ArrayList<BsonDocument> parts = new ArrayList<BsonDocument>(subParts.size() + 1);
                    parts.addAll(subParts);
                    parts.add(mainDocument);
                    replacementValue = this.bsonSurgeon.gather(parts);
                } else if (subParts.isEmpty()) {
                    LOGGER.debug("Replacement value is scalar: {}", (Object)replacementValue);
                } else if (BsonBoolean.TRUE.equals((Object)replacementValue)) {
                    LOGGER.debug("Replacement value is stub; gather {} subparts", (Object)subParts.size());
                    replacementValue = this.bsonSurgeon.gather(subParts);
                } else {
                    throw new UnprocessableEventException("Scalar " + replacementValue + " has subparts:\n\t" + subParts, operationType);
                }
                LOGGER.debug("| Replace {}", ref);
                LOGGER.trace("| New value: {}", (Object)replacementValue);
                Object replacement = this.formatter.bsonValue2object(replacementValue, ref);
                this.downstream.submitReplacement(ref, replacement);
                LOGGER.trace("| Done replacing {}", ref);
            }
        }
    }

    private boolean shouldSkip(BsonInt64 revision) {
        return revision != null && this.revisionToSkip != null && revision.longValue() <= this.revisionToSkip.longValue();
    }

    private void deleteRemovedFields(Reference<?> mainRef, @Nullable List<String> removedFields, OperationType operationType) throws UnprocessableEventException {
        if (removedFields != null) {
            for (String dottedName : removedFields) {
                if (dottedName.startsWith(Formatter.DocumentFields.state.name())) {
                    Reference ref;
                    try {
                        ref = Formatter.referenceTo(dottedName, mainRef);
                    }
                    catch (InvalidTypeException e) {
                        this.logNonexistentField(dottedName, e);
                        continue;
                    }
                    LOGGER.debug("| Delete {}", ref);
                    this.downstream.submitDeletion(ref);
                    continue;
                }
                throw new UnprocessableEventException("Deletion of metadata field " + dottedName, operationType);
            }
        }
    }

    private <T> void deletePartsUnder(Reference<T> target) {
        Reference<T> mainRef = this.mainRef(target);
        if (mainRef.equals(target)) {
            if (this.settings.experimental().orphanDocumentMode() == MongoDriverSettings.OrphanDocumentMode.HASTY) {
                LOGGER.debug("Skipping deletePartsUnder({}) in {} mode", target, (Object)MongoDriverSettings.OrphanDocumentMode.HASTY);
            } else {
                String prefix = mainRef.path().isEmpty() ? "|" : "|" + String.join((CharSequence)"|", BsonSurgeon.docSegments(mainRef, this.rootRef)) + "|";
                Bson filter = Filters.regex((String)"_id", (String)("^" + Pattern.quote(prefix) + "."));
                DeleteResult result = this.collection.deleteMany(filter);
                LOGGER.debug("deletePartsUnder({}) result: {} filter: {}", new Object[]{mainRef, result, filter});
            }
        } else {
            LOGGER.debug("Skipping deletePartsUnder({}) because mainRef is different: {}", target, mainRef);
        }
    }

    private <T> BsonDocument upsertAndRemoveSubParts(Reference<T> target, BsonDocument value) {
        List<BsonDocument> allParts = this.bsonSurgeon.scatter(target, value, (Reference<?>)this.rootRef);
        List<BsonDocument> subParts = allParts.subList(0, allParts.size() - 1);
        LOGGER.debug("Document has {} sub-parts", (Object)subParts.size());
        for (BsonDocument part : subParts) {
            BsonDocument filter = new BsonDocument("_id", part.get((Object)"_id"));
            LOGGER.debug("Pre-delete sub-part: filter={}", (Object)filter);
            this.collection.deleteOne((Bson)filter);
            LOGGER.debug("Insert sub-part: filter={} replacement={}", (Object)filter, (Object)part);
            InsertOneResult result = this.collection.insertOne(part);
            LOGGER.debug("| Insert result: {}", (Object)result);
        }
        return allParts.get(allParts.size() - 1);
    }

    private void logNonexistentField(String dottedName, InvalidTypeException e) {
        LOGGER.trace("Nonexistent field {}", (Object)dottedName, (Object)e);
        if (LOGGER.isWarnEnabled() && ALREADY_WARNED.add(dottedName)) {
            LOGGER.warn("Ignoring updates of nonexistent field {}", (Object)dottedName);
        }
    }

    public String toString() {
        return this.description;
    }
}

