/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import io.vena.bosk.drivers.mongo.DisconnectedException;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.exceptions.FlushFailureException;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.bson.BsonInt64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlushLock
implements Closeable {
    private final MongoDriverSettings settings;
    private final Lock queueLock = new ReentrantLock();
    private final PriorityBlockingQueue<Waiter> queue = new PriorityBlockingQueue();
    private volatile long alreadySeen;
    private boolean isClosed;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlushLock.class);

    public FlushLock(MongoDriverSettings settings, long revisionAlreadySeen) {
        LOGGER.debug("New flush lock at revision {} [{}]", (Object)revisionAlreadySeen, (Object)System.identityHashCode(this));
        this.settings = settings;
        this.alreadySeen = revisionAlreadySeen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitRevision(BsonInt64 revision) throws InterruptedException, FlushFailureException {
        long past;
        long revisionValue = revision.longValue();
        Semaphore semaphore = new Semaphore(0);
        try {
            this.queueLock.lock();
            if (this.isClosed) {
                throw new DisconnectedException("FlushLock is closed");
            }
            this.queue.add(new Waiter(revisionValue, semaphore));
            past = this.alreadySeen;
        }
        finally {
            this.queueLock.unlock();
        }
        if (revisionValue > past) {
            LOGGER.debug("Awaiting revision {} > {} [{}]", new Object[]{revisionValue, past, System.identityHashCode(this)});
            if (!semaphore.tryAcquire(this.settings.flushTimeoutMS(), TimeUnit.MILLISECONDS)) {
                throw new FlushFailureException("Timed out waiting for revision " + revisionValue + " > " + this.alreadySeen);
            }
            if (this.isClosed) {
                throw new DisconnectedException("FlushLock was closed while waiting");
            }
            LOGGER.debug("Done awaiting revision {} [{}]", (Object)revisionValue, (Object)System.identityHashCode(this));
        } else {
            LOGGER.debug("Revision {} <= {} is in the past; don't wait [{}]", new Object[]{revisionValue, past, System.identityHashCode(this)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishedRevision(BsonInt64 revision) {
        if (revision == null) {
            return;
        }
        try {
            Waiter w;
            this.queueLock.lock();
            long revisionValue = revision.longValue();
            if (this.isClosed) {
                LOGGER.debug("Closed FlushLock ignoring revision {} [{}]", (Object)revisionValue, (Object)System.identityHashCode(this));
                return;
            }
            if (revisionValue <= this.alreadySeen) {
                LOGGER.debug("Note: revision did not advance: {} <= {} [{}]", new Object[]{revisionValue, this.alreadySeen, System.identityHashCode(this)});
            }
            while ((w = this.queue.peek()) != null && w.revision <= revisionValue) {
                Waiter removed = (Waiter)this.queue.remove();
                assert (w == removed);
                w.semaphore.release();
            }
            this.alreadySeen = revisionValue;
            LOGGER.debug("Finished {} [{}]", (Object)revisionValue, (Object)System.identityHashCode(this));
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            Waiter w;
            this.queueLock.lock();
            LOGGER.debug("Closing [{}]", (Object)System.identityHashCode(this));
            this.isClosed = true;
            while ((w = this.queue.poll()) != null) {
                w.semaphore.release();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private static final class Waiter
    implements Comparable<Waiter> {
        private final long revision;
        private final Semaphore semaphore;

        @Override
        public int compareTo(Waiter other) {
            return Long.compare(this.revision, other.revision);
        }

        @ConstructorProperties(value={"revision", "semaphore"})
        @Generated
        public Waiter(long revision, Semaphore semaphore) {
            this.revision = revision;
            this.semaphore = semaphore;
        }

        @Generated
        public long revision() {
            return this.revision;
        }

        @Generated
        public Semaphore semaphore() {
            return this.semaphore;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Waiter)) {
                return false;
            }
            Waiter other = (Waiter)o;
            if (this.revision() != other.revision()) {
                return false;
            }
            Semaphore this$semaphore = this.semaphore();
            Semaphore other$semaphore = other.semaphore();
            return !(this$semaphore == null ? other$semaphore != null : !this$semaphore.equals(other$semaphore));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $revision = this.revision();
            result = result * 59 + (int)($revision >>> 32 ^ $revision);
            Semaphore $semaphore = this.semaphore();
            result = result * 59 + ($semaphore == null ? 43 : $semaphore.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FlushLock.Waiter(revision=" + this.revision() + ", semaphore=" + this.semaphore() + ")";
        }
    }
}

