/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.BsonInt64;

class Demultiplexer {
    private final Map<TransactionID, List<ChangeStreamDocument<BsonDocument>>> transactionsInProgress = new ConcurrentHashMap<TransactionID, List<ChangeStreamDocument<BsonDocument>>>();

    Demultiplexer() {
    }

    public void add(ChangeStreamDocument<BsonDocument> event) {
        TransactionID key = TransactionID.from(Objects.requireNonNull(event));
        this.transactionsInProgress.computeIfAbsent(key, __ -> new ArrayList()).add(event);
    }

    public List<ChangeStreamDocument<BsonDocument>> pop(ChangeStreamDocument<BsonDocument> finalEvent) {
        return this.transactionsInProgress.remove(TransactionID.from(finalEvent));
    }

    private static final class TransactionID {
        private final BsonDocument lsid;
        private final BsonInt64 txnNumber;

        public static TransactionID from(ChangeStreamDocument<?> event) {
            return new TransactionID(Objects.requireNonNull(event.getLsid()), Objects.requireNonNull(event.getTxnNumber()));
        }

        @ConstructorProperties(value={"lsid", "txnNumber"})
        @Generated
        public TransactionID(BsonDocument lsid, BsonInt64 txnNumber) {
            this.lsid = lsid;
            this.txnNumber = txnNumber;
        }

        @Generated
        public BsonDocument lsid() {
            return this.lsid;
        }

        @Generated
        public BsonInt64 txnNumber() {
            return this.txnNumber;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionID)) {
                return false;
            }
            TransactionID other = (TransactionID)o;
            BsonDocument this$lsid = this.lsid();
            BsonDocument other$lsid = other.lsid();
            if (this$lsid == null ? other$lsid != null : !this$lsid.equals(other$lsid)) {
                return false;
            }
            BsonInt64 this$txnNumber = this.txnNumber();
            BsonInt64 other$txnNumber = other.txnNumber();
            return !(this$txnNumber == null ? other$txnNumber != null : !this$txnNumber.equals(other$txnNumber));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BsonDocument $lsid = this.lsid();
            result = result * 59 + ($lsid == null ? 43 : $lsid.hashCode());
            BsonInt64 $txnNumber = this.txnNumber();
            result = result * 59 + ($txnNumber == null ? 43 : $txnNumber.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Demultiplexer.TransactionID(lsid=" + this.lsid() + ", txnNumber=" + this.txnNumber() + ")";
        }
    }
}

