/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v3;

import com.mongodb.ReadConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.OperationType;
import com.mongodb.client.model.changestream.UpdateDescription;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.StateTreeNode;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.v3.FlushLock;
import io.vena.bosk.drivers.mongo.v3.FormatDriver;
import io.vena.bosk.drivers.mongo.v3.Formatter;
import io.vena.bosk.drivers.mongo.v3.RevisionFieldDisruptedException;
import io.vena.bosk.drivers.mongo.v3.StateAndMetadata;
import io.vena.bosk.drivers.mongo.v3.UninitializedCollectionException;
import io.vena.bosk.drivers.mongo.v3.UnprocessableEventException;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SingleDocFormatDriver<R extends StateTreeNode>
implements FormatDriver<R> {
    private final String description;
    private final MongoDriverSettings settings;
    private final Formatter formatter;
    private final MongoCollection<Document> collection;
    private final Reference<R> rootRef;
    private final String echoPrefix;
    private final BoskDriver<R> downstream;
    private final FlushLock flushLock;
    private volatile BsonInt64 revisionToSkip = null;
    static final BsonString DOCUMENT_ID = new BsonString("boskDocument");
    private static final Set<String> ALREADY_WARNED = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final BsonDocument DOCUMENT_FILTER = new BsonDocument("_id", (BsonValue)DOCUMENT_ID);
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleDocFormatDriver.class);

    SingleDocFormatDriver(Bosk<R> bosk, MongoCollection<Document> collection, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin, FlushLock flushLock, BoskDriver<R> downstream) {
        this.description = SingleDocFormatDriver.class.getSimpleName() + ": " + driverSettings;
        this.settings = driverSettings;
        this.formatter = new Formatter(bosk, bsonPlugin);
        this.collection = collection;
        this.echoPrefix = bosk.instanceID().toString();
        this.rootRef = bosk.rootReference();
        this.downstream = downstream;
        this.flushLock = flushLock;
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        this.doUpdate(this.replacementDoc(target, newValue), this.standardPreconditions(target));
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        BsonDocument filter = this.standardPreconditions(target);
        filter.put(Formatter.dottedFieldNameOf(target, this.rootRef), (BsonValue)new BsonDocument("$exists", (BsonValue)BsonBoolean.FALSE));
        if (this.doUpdate(this.replacementDoc(target, newValue), filter)) {
            LOGGER.debug("| Object initialized");
        } else {
            LOGGER.debug("| No update");
        }
    }

    public <T> void submitDeletion(Reference<T> target) {
        this.doUpdate(this.deletionDoc(target), this.standardPreconditions(target));
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        this.doUpdate(this.replacementDoc(target, newValue), this.explicitPreconditions(target, precondition, requiredValue));
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        this.doUpdate(this.deletionDoc(target), this.explicitPreconditions(target, precondition, requiredValue));
    }

    public void flush() throws IOException, InterruptedException {
        this.flushLock.awaitRevision(this.readRevisionNumber());
        LOGGER.debug("| Flush downstream");
        this.downstream.flush();
    }

    @Override
    public void close() {
        LOGGER.debug("+ close()");
        this.flushLock.close();
    }

    @Override
    public StateAndMetadata<R> loadAllState() throws IOException, UninitializedCollectionException {
        StateAndMetadata<StateTreeNode> stateAndMetadata;
        block9: {
            MongoCursor cursor = this.collection.withReadConcern(ReadConcern.LOCAL).find((Bson)this.documentFilter()).limit(1).cursor();
            try {
                Document document = (Document)cursor.next();
                Document state = (Document)document.get((Object)Formatter.DocumentFields.state.name(), Document.class);
                Long revision = (Long)document.get((Object)Formatter.DocumentFields.revision.name(), (Object)0L);
                if (state == null) {
                    throw new IOException("No existing state in document");
                }
                StateTreeNode root = (StateTreeNode)this.formatter.document2object(state, this.rootRef);
                BsonInt64 rev = new BsonInt64(revision.longValue());
                stateAndMetadata = new StateAndMetadata<StateTreeNode>(root, rev);
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchElementException e) {
                    throw new UninitializedCollectionException("No existing document", e);
                }
            }
            cursor.close();
        }
        return stateAndMetadata;
    }

    @Override
    public void initializeCollection(StateAndMetadata<R> priorContents) {
        BsonValue initialState = this.formatter.object2bsonValue(priorContents.state, this.rootRef.targetType());
        BsonInt64 newRevision = new BsonInt64(1L + priorContents.revision.longValue());
        BsonDocument update = new BsonDocument("$set", (BsonValue)this.initialDocument(initialState, newRevision));
        BsonDocument filter = this.documentFilter();
        UpdateOptions options = new UpdateOptions().upsert(true);
        LOGGER.debug("** Initial tenant upsert for {}", (Object)DOCUMENT_ID);
        LOGGER.trace("| Filter: {}", (Object)filter);
        LOGGER.trace("| Update: {}", (Object)update);
        LOGGER.trace("| Options: {}", (Object)options);
        UpdateResult result = this.collection.updateOne((Bson)filter, (Bson)update, options);
        LOGGER.debug("| Result: {}", (Object)result);
    }

    @Override
    public void onEvent(ChangeStreamDocument<Document> event) throws UnprocessableEventException {
        if (!DOCUMENT_FILTER.equals((Object)event.getDocumentKey())) {
            LOGGER.debug("Ignoring event for unrecognized document key: {}", (Object)event.getDocumentKey());
            return;
        }
        switch (event.getOperationType()) {
            case INSERT: 
            case REPLACE: {
                Document fullDocument = (Document)event.getFullDocument();
                if (fullDocument == null) {
                    throw new UnprocessableEventException("Missing fullDocument", event.getOperationType());
                }
                BsonInt64 revision = this.getRevisionFromFullDocumentEvent(fullDocument);
                Document state = (Document)fullDocument.get((Object)Formatter.DocumentFields.state.name(), Document.class);
                if (state == null) {
                    throw new UnprocessableEventException("Missing state field", event.getOperationType());
                }
                StateTreeNode newRoot = (StateTreeNode)this.formatter.document2object(state, this.rootRef);
                LOGGER.debug("| Replace {}", this.rootRef);
                this.downstream.submitReplacement(this.rootRef, (Object)newRoot);
                this.flushLock.finishedRevision(revision);
                break;
            }
            case UPDATE: {
                UpdateDescription updateDescription = event.getUpdateDescription();
                if (updateDescription == null) break;
                BsonInt64 revision = SingleDocFormatDriver.getRevisionFromUpdateEvent(event);
                if (this.shouldNotSkip(revision)) {
                    this.replaceUpdatedFields(updateDescription.getUpdatedFields());
                    this.deleteRemovedFields(updateDescription.getRemovedFields(), event.getOperationType());
                }
                this.flushLock.finishedRevision(revision);
                break;
            }
            case DELETE: {
                LOGGER.debug("Document containing revision field has been deleted; assuming revision=0");
                this.flushLock.finishedRevision(Formatter.REVISION_ZERO);
                break;
            }
            default: {
                throw new UnprocessableEventException("Cannot process event", event.getOperationType());
            }
        }
    }

    @Override
    public void onRevisionToSkip(BsonInt64 revision) {
        this.revisionToSkip = revision;
        this.flushLock.finishedRevision(revision);
    }

    private BsonInt64 getRevisionFromFullDocumentEvent(Document fullDocument) {
        if (fullDocument == null) {
            return null;
        }
        Long revision = fullDocument.getLong((Object)Formatter.DocumentFields.revision.name());
        if (revision == null) {
            return null;
        }
        return new BsonInt64(revision.longValue());
    }

    private static BsonInt64 getRevisionFromUpdateEvent(ChangeStreamDocument<Document> event) {
        if (event == null) {
            return null;
        }
        UpdateDescription updateDescription = event.getUpdateDescription();
        if (updateDescription == null) {
            return null;
        }
        BsonDocument updatedFields = updateDescription.getUpdatedFields();
        if (updatedFields == null) {
            return null;
        }
        return updatedFields.getInt64((Object)Formatter.DocumentFields.revision.name(), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BsonInt64 readRevisionNumber() throws FlushFailureException {
        LOGGER.debug("readRevisionNumber");
        try (MongoCursor cursor = this.collection.withReadConcern(ReadConcern.LOCAL).find((Bson)DOCUMENT_FILTER).limit(1).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{Formatter.DocumentFields.revision.name()})})).cursor();){
            Document doc = (Document)cursor.next();
            Long result = (Long)doc.get((Object)Formatter.DocumentFields.revision.name(), Long.class);
            if (result == null) {
                LOGGER.debug("No revision field; assuming {}", (Object)Formatter.REVISION_ZERO.longValue());
                BsonInt64 bsonInt642 = Formatter.REVISION_ZERO;
                return bsonInt642;
            }
            LOGGER.debug("Read revision {}", (Object)result);
            BsonInt64 bsonInt64 = new BsonInt64(result.longValue());
            return bsonInt64;
        }
        catch (NoSuchElementException e) {
            LOGGER.debug("Document is missing", (Throwable)e);
            throw new RevisionFieldDisruptedException(e);
        }
        catch (RuntimeException e) {
            LOGGER.debug("readRevisionNumber failed", (Throwable)e);
            throw new FlushFailureException((Throwable)e);
        }
    }

    private BsonDocument documentFilter() {
        return new BsonDocument("_id", (BsonValue)DOCUMENT_ID);
    }

    private <T> BsonDocument standardPreconditions(Reference<T> target) {
        BsonDocument filter = this.documentFilter();
        if (!target.path().isEmpty()) {
            String enclosingObjectKey = Formatter.dottedFieldNameOf(Formatter.enclosingReference(target), this.rootRef);
            BsonDocument condition = new BsonDocument("$type", (BsonValue)new BsonString("object"));
            filter.put(enclosingObjectKey, (BsonValue)condition);
            LOGGER.debug("| Precondition: {} {}", (Object)enclosingObjectKey, (Object)condition);
        }
        return filter;
    }

    private <T> BsonDocument explicitPreconditions(Reference<T> target, Reference<Identifier> preconditionRef, Identifier requiredValue) {
        BsonDocument filter = this.standardPreconditions(target);
        BsonDocument precondition = new BsonDocument("$eq", (BsonValue)new BsonString(requiredValue.toString()));
        filter.put(Formatter.dottedFieldNameOf(preconditionRef, this.rootRef), (BsonValue)precondition);
        return filter;
    }

    private <T> BsonDocument replacementDoc(Reference<T> target, T newValue) {
        String key = Formatter.dottedFieldNameOf(target, this.rootRef);
        BsonValue value = this.formatter.object2bsonValue(newValue, target.targetType());
        LOGGER.debug("| Set field {}: {}", (Object)key, (Object)value);
        return this.updateDoc().append("$set", (BsonValue)new BsonDocument(key, value));
    }

    private <T> BsonDocument deletionDoc(Reference<T> target) {
        String key = Formatter.dottedFieldNameOf(target, this.rootRef);
        LOGGER.debug("| Unset field {}", (Object)key);
        return this.updateDoc().append("$unset", (BsonValue)new BsonDocument(key, (BsonValue)new BsonNull()));
    }

    private BsonDocument updateDoc() {
        return new BsonDocument("$inc", (BsonValue)new BsonDocument(Formatter.DocumentFields.revision.name(), (BsonValue)new BsonInt64(1L)));
    }

    private BsonDocument initialDocument(BsonValue initialState, BsonInt64 revision) {
        BsonDocument fieldValues = new BsonDocument("_id", (BsonValue)DOCUMENT_ID);
        fieldValues.put(Formatter.DocumentFields.path.name(), (BsonValue)new BsonString("/"));
        fieldValues.put(Formatter.DocumentFields.state.name(), initialState);
        fieldValues.put(Formatter.DocumentFields.echo.name(), (BsonValue)new BsonString(String.format("%s_9999", this.echoPrefix)));
        fieldValues.put(Formatter.DocumentFields.revision.name(), (BsonValue)revision);
        return fieldValues;
    }

    private boolean doUpdate(BsonDocument updateDoc, BsonDocument filter) {
        LOGGER.debug("| Update: {}", (Object)updateDoc);
        if (this.settings.testing().eventDelayMS() < 0L) {
            LOGGER.debug("| Sleeping");
            try {
                Thread.sleep(-this.settings.testing().eventDelayMS());
            }
            catch (InterruptedException e) {
                LOGGER.debug("| Interrupted");
            }
        }
        LOGGER.debug("| Filter: {}", (Object)filter);
        UpdateResult result = this.collection.updateOne((Bson)filter, (Bson)updateDoc);
        LOGGER.debug("| Update result: {}", (Object)result);
        if (result.wasAcknowledged()) {
            assert (result.getMatchedCount() <= 1L);
            return result.getMatchedCount() >= 1L;
        }
        LOGGER.error("MongoDB write was not acknowledged");
        LOGGER.trace("Details of MongoDB write not acknowledged:\n\tFilter: {}\n\tUpdate: {}\n\tResult: {}", new Object[]{filter, updateDoc, result});
        throw new IllegalStateException("Mongo write was not acknowledged: " + result);
    }

    private void replaceUpdatedFields(@Nullable BsonDocument updatedFields) {
        if (updatedFields != null) {
            for (Map.Entry entry : updatedFields.entrySet()) {
                Reference ref;
                String dottedName = (String)entry.getKey();
                if (!dottedName.startsWith(Formatter.DocumentFields.state.name())) continue;
                try {
                    ref = Formatter.referenceTo(dottedName, this.rootRef);
                }
                catch (InvalidTypeException e) {
                    this.logNonexistentField(dottedName, e);
                    continue;
                }
                LOGGER.debug("| Replace {}", ref);
                Object replacement = this.formatter.bsonValue2object((BsonValue)entry.getValue(), ref);
                this.downstream.submitReplacement(ref, replacement);
            }
        }
    }

    private boolean shouldNotSkip(BsonInt64 revision) {
        return revision == null || this.revisionToSkip == null || revision.longValue() > this.revisionToSkip.longValue();
    }

    private void deleteRemovedFields(@Nullable List<String> removedFields, OperationType operationType) throws UnprocessableEventException {
        if (removedFields != null) {
            for (String dottedName : removedFields) {
                if (dottedName.startsWith(Formatter.DocumentFields.state.name())) {
                    Reference ref;
                    try {
                        ref = Formatter.referenceTo(dottedName, this.rootRef);
                    }
                    catch (InvalidTypeException e) {
                        this.logNonexistentField(dottedName, e);
                        continue;
                    }
                    LOGGER.debug("| Delete {}", ref);
                    this.downstream.submitDeletion(ref);
                    continue;
                }
                throw new UnprocessableEventException("Deletion of metadata field " + dottedName, operationType);
            }
        }
    }

    private void logNonexistentField(String dottedName, InvalidTypeException e) {
        LOGGER.trace("Nonexistent field {}", (Object)dottedName, (Object)e);
        if (LOGGER.isWarnEnabled() && ALREADY_WARNED.add(dottedName)) {
            LOGGER.warn("Ignoring updates of nonexistent field {}", (Object)dottedName);
        }
    }

    public String toString() {
        return this.description;
    }
}

