/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v3;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.MongoDriver;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.v3.ChangeListener;
import io.vena.bosk.drivers.mongo.v3.ChangeReceiver;
import io.vena.bosk.drivers.mongo.v3.DisconnectedDriver;
import io.vena.bosk.drivers.mongo.v3.DisconnectedException;
import io.vena.bosk.drivers.mongo.v3.DownstreamInitialRootException;
import io.vena.bosk.drivers.mongo.v3.FlushLock;
import io.vena.bosk.drivers.mongo.v3.FormatDriver;
import io.vena.bosk.drivers.mongo.v3.Formatter;
import io.vena.bosk.drivers.mongo.v3.InitialRootException;
import io.vena.bosk.drivers.mongo.v3.MappedDiagnosticContext;
import io.vena.bosk.drivers.mongo.v3.RevisionFieldDisruptedException;
import io.vena.bosk.drivers.mongo.v3.SingleDocFormatDriver;
import io.vena.bosk.drivers.mongo.v3.StateAndMetadata;
import io.vena.bosk.drivers.mongo.v3.UninitializedCollectionException;
import io.vena.bosk.drivers.mongo.v3.UnprocessableEventException;
import io.vena.bosk.drivers.mongo.v3.UnrecognizedFormatException;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InitializationFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDriver<R extends Entity>
implements MongoDriver<R> {
    private final Bosk<R> bosk;
    private final ChangeReceiver receiver;
    private final MongoDriverSettings driverSettings;
    private final BsonPlugin bsonPlugin;
    private final BoskDriver<R> downstream;
    private final MongoClient mongoClient;
    private final MongoCollection<Document> collection;
    private final Listener listener;
    private final ReentrantLock formatDriverLock = new ReentrantLock();
    private final Condition formatDriverChanged = this.formatDriverLock.newCondition();
    private volatile FormatDriver<R> formatDriver = new DisconnectedDriver("Driver not yet initialized");
    private volatile boolean isClosed = false;
    public static final String COLLECTION_NAME = "boskCollection";
    private static final Logger LOGGER = LoggerFactory.getLogger(MainDriver.class);

    public MainDriver(Bosk<R> bosk, MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin, BoskDriver<R> downstream) {
        try (MappedDiagnosticContext.MDCScope __ = MappedDiagnosticContext.setupMDC(bosk.name());){
            this.bosk = bosk;
            this.driverSettings = driverSettings;
            this.bsonPlugin = bsonPlugin;
            this.downstream = downstream;
            this.mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder((MongoClientSettings)clientSettings).readConcern(ReadConcern.MAJORITY).writeConcern(WriteConcern.MAJORITY).build());
            this.collection = this.mongoClient.getDatabase(driverSettings.database()).getCollection(COLLECTION_NAME);
            LOGGER.debug("Initializing Listener with doInitialRootTask so that it blocks until initialRoot runs");
            Type rootType = bosk.rootReference().targetType();
            this.listener = new Listener(new FutureTask<Entity>(() -> this.doInitialRoot(rootType)));
            this.receiver = new ChangeReceiver(bosk.name(), this.listener, driverSettings, this.collection);
        }
    }

    public R initialRoot(Type rootType) throws InvalidTypeException, InterruptedException, IOException {
        try (MappedDiagnosticContext.MDCScope __ = this.beginDriverOperation("initialRoot({})", rootType);){
            Entity entity;
            FutureTask task = this.listener.taskRef.get();
            if (task == null) {
                throw new IllegalStateException("initialRoot has already run");
            }
            try {
                entity = (Entity)task.get();
            }
            catch (ExecutionException e) {
                Throwable exception = e.getCause();
                if (exception instanceof DownstreamInitialRootException) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof InvalidTypeException) {
                        throw (InvalidTypeException)cause;
                    }
                    if (cause instanceof InterruptedException) {
                        throw (InterruptedException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new AssertionError("Unexpected exception during initialRoot: " + e.getClass().getSimpleName(), e);
                }
                throw new AssertionError("Exception from initialRoot was not wrapped in DownstreamInitialRootException: " + e.getClass().getSimpleName(), e);
            }
            return (R)entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R doInitialRoot(Type rootType) {
        Object root;
        this.quietlySetFormatDriver(new DisconnectedDriver("Failure to compute initial root"));
        try {
            FormatDriver<R> detectedDriver = this.detectFormat();
            StateAndMetadata<R> loadedState = detectedDriver.loadAllState();
            root = loadedState.state;
            detectedDriver.onRevisionToSkip(loadedState.revision);
            this.publishFormatDriver(detectedDriver);
        }
        catch (UninitializedCollectionException e) {
            LOGGER.debug("Database collection is uninitialized; will initialize using downstream.initialRoot");
            root = this.callDownstreamInitialRoot(rootType);
            try {
                FormatDriver<R> preferredDriver = this.newPreferredFormatDriver();
                this.initializeCollectionTransaction(root, preferredDriver);
                preferredDriver.onRevisionToSkip(Formatter.REVISION_ONE);
                this.publishFormatDriver(preferredDriver);
            }
            catch (IOException | RuntimeException e2) {
                LOGGER.debug("Failed to initialize database; disconnecting", (Throwable)e);
                this.quietlySetFormatDriver(new DisconnectedDriver(e2.toString()));
            }
        }
        catch (UnrecognizedFormatException | IOException | RuntimeException e) {
            LOGGER.debug("Unable to load initial root from database; will proceed with downstream.initialRoot", (Throwable)e);
            this.quietlySetFormatDriver(new DisconnectedDriver(e.toString()));
            root = this.callDownstreamInitialRoot(rootType);
        }
        finally {
            LOGGER.debug("Done initialRoot");
            this.listener.taskRef.set(null);
        }
        return root;
    }

    private R callDownstreamInitialRoot(Type rootType) {
        Entity root;
        try {
            root = this.downstream.initialRoot(rootType);
        }
        catch (InvalidTypeException | IOException | InterruptedException | RuntimeException e) {
            LOGGER.error("Downstream driver failed to compute initial root", e);
            throw new DownstreamInitialRootException("Fatal error: downstream driver failed to compute initial root", e);
        }
        return (R)root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCollectionTransaction(R result, FormatDriver<R> newDriver) throws InitializationFailureException {
        ClientSessionOptions sessionOptions = ClientSessionOptions.builder().causallyConsistent(true).defaultTransactionOptions(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).readConcern(ReadConcern.MAJORITY).build()).build();
        try (ClientSession session = this.mongoClient.startSession(sessionOptions);){
            try {
                newDriver.initializeCollection(new StateAndMetadata<R>(result, Formatter.REVISION_ZERO));
            }
            finally {
                if (session.hasActiveTransaction()) {
                    session.abortTransaction();
                }
            }
        }
    }

    private void refurbishTransaction() throws IOException {
        ClientSessionOptions sessionOptions = ClientSessionOptions.builder().causallyConsistent(true).defaultTransactionOptions(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).readConcern(ReadConcern.MAJORITY).build()).build();
        try (ClientSession session = this.mongoClient.startSession(sessionOptions);){
            try {
                session.startTransaction();
                StateAndMetadata<R> result = this.formatDriver.loadAllState();
                FormatDriver<R> newFormatDriver = this.newPreferredFormatDriver();
                this.collection.deleteMany((Bson)new BsonDocument());
                newFormatDriver.initializeCollection(result);
                session.commitTransaction();
                this.publishFormatDriver(newFormatDriver);
            }
            catch (UninitializedCollectionException e) {
                throw new IOException("Unable to refurbish uninitialized database collection", e);
            }
            finally {
                if (session.hasActiveTransaction()) {
                    session.abortTransaction();
                }
            }
        }
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        this.doRetryableDriverOperation(() -> this.formatDriver.submitReplacement(target, newValue), "submitReplacement({})", target);
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        this.doRetryableDriverOperation(() -> this.formatDriver.submitConditionalReplacement(target, newValue, precondition, requiredValue), "submitConditionalReplcament({}, {}={})", target, precondition, requiredValue);
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        this.doRetryableDriverOperation(() -> this.formatDriver.submitInitialization(target, newValue), "submitInitialization({})", target);
    }

    public <T> void submitDeletion(Reference<T> target) {
        this.doRetryableDriverOperation(() -> this.formatDriver.submitDeletion(target), "submitDeletion({})", target);
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        this.doRetryableDriverOperation(() -> this.formatDriver.submitConditionalDeletion(target, precondition, requiredValue), "submitConditionalDeletion({}, {}={})", target, precondition, requiredValue);
    }

    public void flush() throws IOException, InterruptedException {
        try {
            RetryableOperation flushOperation = () -> this.formatDriver.flush();
            try (MappedDiagnosticContext.MDCScope __ = this.beginDriverOperation("flush", new Object[0]);){
                try {
                    flushOperation.run();
                }
                catch (DisconnectedException e) {
                    LOGGER.debug("Driver is disconnected ({}); will wait and retry operation", (Object)e.getMessage());
                    this.waitAndRetry(flushOperation, "flush", new Object[0]);
                }
                catch (RevisionFieldDisruptedException e) {
                    LOGGER.debug("Revision field has been disrupted; wait for receiver to notice something is wrong", (Throwable)((Object)e));
                    this.waitAndRetry(flushOperation, "flush", new Object[0]);
                }
            }
        }
        catch (DisconnectedException e) {
            throw new FlushFailureException((Throwable)e);
        }
    }

    @Override
    public void refurbish() throws IOException {
        this.doRetryableDriverOperation(() -> this.refurbishTransaction(), "refurbish", new Object[0]);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.receiver.close();
        this.formatDriver.close();
    }

    private FormatDriver<R> newPreferredFormatDriver() {
        if (this.driverSettings.preferredDatabaseFormat() == MongoDriverSettings.DatabaseFormat.SINGLE_DOC) {
            return this.newSingleDocFormatDriver(Formatter.REVISION_ZERO.longValue());
        }
        throw new AssertionError((Object)("Unknown database format setting: " + (Object)((Object)this.driverSettings.preferredDatabaseFormat())));
    }

    private FormatDriver<R> detectFormat() throws UninitializedCollectionException, UnrecognizedFormatException {
        FindIterable result = this.collection.find((Bson)new BsonDocument("_id", (BsonValue)SingleDocFormatDriver.DOCUMENT_ID));
        try (MongoCursor cursor = result.cursor();){
            if (cursor.hasNext()) {
                Long revision = (Long)((Document)cursor.next()).get((Object)Formatter.DocumentFields.revision.name(), (Object)0L);
                SingleDocFormatDriver<R> singleDocFormatDriver = this.newSingleDocFormatDriver(revision);
                return singleDocFormatDriver;
            }
            throw new UninitializedCollectionException("Document doesn't exist");
        }
    }

    private SingleDocFormatDriver<R> newSingleDocFormatDriver(long revisionAlreadySeen) {
        return new SingleDocFormatDriver<R>(this.bosk, this.collection, this.driverSettings, this.bsonPlugin, new FlushLock(this.driverSettings, revisionAlreadySeen), this.downstream);
    }

    private MappedDiagnosticContext.MDCScope beginDriverOperation(String description, Object ... args) {
        if (this.isClosed) {
            throw new IllegalStateException("Driver is closed");
        }
        MappedDiagnosticContext.MDCScope ex = MappedDiagnosticContext.setupMDC(this.bosk.name());
        LOGGER.debug(description, args);
        return ex;
    }

    private <X extends Exception, Y extends Exception> void doRetryableDriverOperation(RetryableOperation<X, Y> operation, String description, Object ... args) throws X, Y {
        try (MappedDiagnosticContext.MDCScope __ = this.beginDriverOperation(description, args);){
            try {
                operation.run();
            }
            catch (DisconnectedException e) {
                LOGGER.debug("Driver is disconnected ({}); will wait and retry operation", (Object)e.getMessage());
                this.waitAndRetry(operation, description, args);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X extends Exception, Y extends Exception> void waitAndRetry(RetryableOperation<X, Y> operation, String description, Object ... args) throws X, Y {
        try {
            this.formatDriverLock.lock();
            boolean success = this.formatDriverChanged.await(5L * this.driverSettings.recoveryPollingMS(), TimeUnit.MILLISECONDS);
            if (!success) {
                LOGGER.debug("Timed out waiting for new FormatDriver; will retry anyway");
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Interrupted while waiting to retry; proceeding");
        }
        finally {
            this.formatDriverLock.unlock();
        }
        LOGGER.debug("Retrying " + description, args);
        operation.run();
    }

    void quietlySetFormatDriver(FormatDriver<R> newFormatDriver) {
        LOGGER.debug("quietlySetFormatDriver({}) (was {})", (Object)newFormatDriver.getClass().getSimpleName(), (Object)this.formatDriver.getClass().getSimpleName());
        try {
            this.formatDriverLock.lock();
            this.formatDriver.close();
            this.formatDriver = newFormatDriver;
        }
        finally {
            this.formatDriverLock.unlock();
        }
    }

    void publishFormatDriver(FormatDriver<R> newFormatDriver) {
        LOGGER.debug("publishFormatDriver({}) (was {})", (Object)newFormatDriver.getClass().getSimpleName(), (Object)this.formatDriver.getClass().getSimpleName());
        try {
            this.formatDriverLock.lock();
            this.formatDriver.close();
            this.formatDriver = newFormatDriver;
            LOGGER.debug("Signaling");
            this.formatDriverChanged.signalAll();
        }
        finally {
            this.formatDriverLock.unlock();
        }
    }

    private class Listener
    implements ChangeListener {
        final AtomicReference<FutureTask<R>> taskRef;

        private Listener(FutureTask<R> initialRootAction) {
            this.taskRef = new AtomicReference(initialRootAction);
        }

        @Override
        public void onConnectionSucceeded() throws UnrecognizedFormatException, UninitializedCollectionException, InterruptedException, IOException, InitialRootException, TimeoutException {
            LOGGER.debug("onConnectionSucceeded");
            FutureTask initialRootAction = this.taskRef.get();
            if (initialRootAction == null) {
                LOGGER.debug("Loading database state to submit to downstream driver");
                FormatDriver newDriver = MainDriver.this.detectFormat();
                StateAndMetadata loadedState = newDriver.loadAllState();
                MainDriver.this.downstream.submitReplacement(MainDriver.this.bosk.rootReference(), loadedState.state);
                newDriver.onRevisionToSkip(loadedState.revision);
                MainDriver.this.publishFormatDriver(newDriver);
            } else {
                LOGGER.debug("Running initialRoot action");
                this.runInitialRootAction(initialRootAction);
            }
        }

        private void runInitialRootAction(FutureTask<R> initialRootAction) throws InterruptedException, TimeoutException, InitialRootException {
            initialRootAction.run();
            try {
                initialRootAction.get(5L * MainDriver.this.driverSettings.recoveryPollingMS(), TimeUnit.MILLISECONDS);
                LOGGER.debug("initialRoot action completed successfully");
            }
            catch (ExecutionException e) {
                LOGGER.debug("initialRoot action failed", (Throwable)e);
                throw new InitialRootException(e.getCause());
            }
        }

        @Override
        public void onEvent(ChangeStreamDocument<Document> event) throws UnprocessableEventException {
            LOGGER.debug("onEvent({})", (Object)event.getOperationType().getValue());
            MainDriver.this.formatDriver.onEvent(event);
        }

        @Override
        public void onConnectionFailed(Exception e) throws InterruptedException, InitialRootException, TimeoutException {
            LOGGER.debug("onConnectionFailed");
            FutureTask initialRootAction = this.taskRef.get();
            if (initialRootAction == null) {
                LOGGER.debug("Nothing to do");
            } else {
                LOGGER.debug("Running initialRoot action");
                this.runInitialRootAction(initialRootAction);
            }
        }

        @Override
        public void onDisconnect(Exception e) {
            LOGGER.debug("onDisconnect({})", (Object)e.toString());
            MainDriver.this.formatDriver.close();
            MainDriver.this.quietlySetFormatDriver(new DisconnectedDriver(e.toString()));
        }
    }

    private static interface RetryableOperation<X extends Exception, Y extends Exception> {
        public void run() throws X, Y;
    }
}

