/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v3;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.v3.DisconnectedException;
import io.vena.bosk.drivers.mongo.v3.FormatDriver;
import io.vena.bosk.drivers.mongo.v3.StateAndMetadata;
import io.vena.bosk.drivers.mongo.v3.UninitializedCollectionException;
import io.vena.bosk.exceptions.InitializationFailureException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.bson.BsonInt64;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DisconnectedDriver<R extends Entity>
implements FormatDriver<R> {
    private final String reason;
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectedDriver.class);

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        throw this.disconnected();
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected();
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        throw this.disconnected();
    }

    public <T> void submitDeletion(Reference<T> target) {
        throw this.disconnected();
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected();
    }

    public void flush() throws IOException, InterruptedException {
        throw this.disconnected();
    }

    @Override
    public void close() {
    }

    @Override
    public void onEvent(ChangeStreamDocument<Document> event) {
        LOGGER.debug("Already disconnected; ignoring event ({})", (Object)event.getOperationType().getValue());
    }

    @Override
    public void onRevisionToSkip(BsonInt64 revision) {
        throw new AssertionError((Object)"Resynchronization should not tell DisconnectedDriver to skip a revision");
    }

    @Override
    public StateAndMetadata<R> loadAllState() throws IOException, UninitializedCollectionException {
        throw this.disconnected();
    }

    @Override
    public void initializeCollection(StateAndMetadata<R> priorContents) throws InitializationFailureException {
        throw this.disconnected();
    }

    private DisconnectedException disconnected() {
        return new DisconnectedException(this.reason);
    }

    @ConstructorProperties(value={"reason"})
    @Generated
    public DisconnectedDriver(String reason) {
        this.reason = reason;
    }
}

