/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v3;

import com.mongodb.MongoInterruptedException;
import com.mongodb.client.MongoChangeStreamCursor;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.v3.ChangeListener;
import io.vena.bosk.drivers.mongo.v3.UnexpectedEventProcessingException;
import io.vena.bosk.drivers.mongo.v3.UnprocessableEventException;
import java.io.Closeable;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeReceiver
implements Closeable {
    private final String boskName;
    private final ChangeListener listener;
    private final MongoDriverSettings settings;
    private final MongoCollection<Document> collection;
    private final ScheduledExecutorService ex = Executors.newScheduledThreadPool(1);
    private volatile boolean isClosed = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeReceiver.class);

    ChangeReceiver(String boskName, ChangeListener listener, MongoDriverSettings settings, MongoCollection<Document> collection) {
        this.boskName = boskName;
        this.listener = listener;
        this.settings = settings;
        this.collection = collection;
        this.ex.scheduleWithFixedDelay(this::connectionLoop, 0L, settings.recoveryPollingMS(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.ex.shutdownNow();
    }

    /*
     * Exception decompiling
     */
    private void connectionLoop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MongoChangeStreamCursor<ChangeStreamDocument<Document>> openCursor() {
        MongoChangeStreamCursor result = this.collection.watch().maxAwaitTime(this.settings.recoveryPollingMS(), TimeUnit.MILLISECONDS).cursor();
        LOGGER.debug("Cursor is open");
        return result;
    }

    private void eventLoop(MongoChangeStreamCursor<ChangeStreamDocument<Document>> cursor) throws UnprocessableEventException, UnexpectedEventProcessingException {
        if (this.isClosed) {
            LOGGER.debug("Receiver is closed");
            return;
        }
        try {
            LOGGER.debug("Starting event loop");
            while (!this.isClosed) {
                ChangeStreamDocument event;
                try {
                    event = (ChangeStreamDocument)cursor.next();
                }
                catch (NoSuchElementException e) {
                    LOGGER.debug("Cursor is finished");
                    break;
                }
                catch (MongoInterruptedException e) {
                    LOGGER.debug("Interrupted while waiting for change event: {}", (Object)e.toString());
                    break;
                }
                this.processEvent((ChangeStreamDocument<Document>)event);
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Unexpected {} while processing events", (Object)e.getClass().getSimpleName(), (Object)e);
            throw new UnexpectedEventProcessingException(e);
        }
        finally {
            LOGGER.debug("Exited event loop");
        }
    }

    private void processEvent(ChangeStreamDocument<Document> event) throws UnprocessableEventException {
        switch (event.getOperationType()) {
            case INSERT: 
            case UPDATE: 
            case REPLACE: 
            case DELETE: 
            case RENAME: {
                this.listener.onEvent(event);
                break;
            }
            case DROP: 
            case DROP_DATABASE: 
            case INVALIDATE: 
            case OTHER: {
                throw new UnprocessableEventException("Disruptive event received", event.getOperationType());
            }
        }
    }
}

