/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v2;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.MongoDriver;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.v2.ChangeEventListener;
import io.vena.bosk.drivers.mongo.v2.ChangeEventReceiver;
import io.vena.bosk.drivers.mongo.v2.DisconnectedDriver;
import io.vena.bosk.drivers.mongo.v2.DisconnectedException;
import io.vena.bosk.drivers.mongo.v2.FlushLock;
import io.vena.bosk.drivers.mongo.v2.FormatDriver;
import io.vena.bosk.drivers.mongo.v2.Formatter;
import io.vena.bosk.drivers.mongo.v2.ReceiverInitializationException;
import io.vena.bosk.drivers.mongo.v2.SingleDocFormatDriver;
import io.vena.bosk.drivers.mongo.v2.StateAndMetadata;
import io.vena.bosk.drivers.mongo.v2.UninitializedCollectionException;
import io.vena.bosk.drivers.mongo.v2.UnprocessableEventException;
import io.vena.bosk.drivers.mongo.v2.UnrecognizedFormatException;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import io.vena.bosk.exceptions.NotYetImplementedException;
import io.vena.bosk.exceptions.TunneledCheckedException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MainDriver<R extends Entity>
implements MongoDriver<R> {
    private final Bosk<R> bosk;
    private final MongoDriverSettings driverSettings;
    private final BsonPlugin bsonPlugin;
    private final BoskDriver<R> downstream;
    private final Reference<R> rootRef;
    private final MongoClient mongoClient;
    private final MongoCollection<Document> collection;
    private final ChangeEventReceiver receiver;
    private final AtomicReference<FutureTask<R>> initializationInProgress = new AtomicReference();
    private volatile FormatDriver<R> formatDriver = new DisconnectedDriver("Driver not yet initialized");
    private volatile boolean isClosed = false;
    public static final String COLLECTION_NAME = "boskCollection";
    private static final Logger LOGGER = LoggerFactory.getLogger(MainDriver.class);
    private static final String MDC_KEY = "MongoDriver";

    public MainDriver(Bosk<R> bosk, MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin, BoskDriver<R> downstream) {
        this.validateMongoClientSettings(clientSettings);
        this.bosk = bosk;
        this.driverSettings = driverSettings;
        this.bsonPlugin = bsonPlugin;
        this.downstream = downstream;
        this.rootRef = bosk.rootReference();
        this.mongoClient = MongoClients.create((MongoClientSettings)clientSettings);
        this.collection = this.mongoClient.getDatabase(driverSettings.database()).getCollection(COLLECTION_NAME);
        this.receiver = new ChangeEventReceiver(bosk.name(), driverSettings, this.collection);
    }

    private void validateMongoClientSettings(MongoClientSettings clientSettings) {
        if (clientSettings.getReadConcern() != ReadConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify ReadConcern.MAJORITY");
        }
        if (clientSettings.getWriteConcern() != WriteConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify WriteConcern.MAJORITY");
        }
    }

    public R initialRoot(Type rootType) throws InvalidTypeException, IOException, InterruptedException {
        try (MDCScope __ = this.beginDriverOperation("initialRoot", new Object[0]);){
            Object object;
            Object result;
            try {
                result = this.initializeReplication();
            }
            catch (UninitializedCollectionException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Creating collection", (Throwable)e);
                } else {
                    LOGGER.info("Creating collection");
                }
                FormatDriver<R> newDriver = this.newPreferredFormatDriver();
                result = this.downstream.initialRoot(rootType);
                newDriver.initializeCollection(new StateAndMetadata<R>(result, Formatter.REVISION_ONE));
                this.formatDriver = newDriver;
            }
            catch (ReceiverInitializationException | IOException e) {
                LOGGER.debug("Unable to initialize replication", (Throwable)e);
                result = null;
            }
            if (this.receiver.isReady()) {
                this.receiver.start();
            } else {
                LOGGER.debug("Receiver not started");
            }
            if (result == null) {
                object = this.downstream.initialRoot(rootType);
                return object;
            }
            object = result;
            return object;
        }
    }

    private FormatDriver<R> newPreferredFormatDriver() {
        if (this.driverSettings.preferredDatabaseFormat() == MongoDriverSettings.DatabaseFormat.SINGLE_DOC) {
            return this.newSingleDocFormatDriver(Formatter.REVISION_ONE.longValue());
        }
        throw new AssertionError((Object)("Unknown database format setting: " + (Object)((Object)this.driverSettings.preferredDatabaseFormat())));
    }

    /*
     * Loose catch block
     */
    private void recoverFrom(Exception exception) {
        block19: {
            try (MDCScope __ = this.beginDriverOperation("recoverFrom({})", exception.getClass().getSimpleName());){
                R result;
                if (this.isClosed) {
                    LOGGER.debug("Closed driver ignoring exception", (Throwable)exception);
                    return;
                }
                if (exception instanceof DisconnectedException) {
                    LOGGER.debug("Recovering from {}; reinitializing", (Object)exception.getClass().getSimpleName(), (Object)exception);
                } else {
                    LOGGER.error("Recovering from unexpected {}; reinitializing", (Object)exception.getClass().getSimpleName(), (Object)exception);
                }
                try {
                    result = this.initializeReplication();
                }
                catch (UninitializedCollectionException e) {
                    LOGGER.warn("Collection is uninitialized; driver is disconnected", (Throwable)e);
                    if (__ != null) {
                        __.close();
                    }
                    return;
                }
                catch (ReceiverInitializationException | IOException e) {
                    LOGGER.warn("Unable to initialize receiver", (Throwable)e);
                    if (__ != null) {
                        __.close();
                    }
                    return;
                }
                if (result != null) {
                    this.downstream.submitReplacement(this.rootRef, result);
                }
                if (!this.isClosed) {
                    this.receiver.start();
                }
                break block19;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        this.runWithRetry(() -> this.formatDriver.submitReplacement(target, newValue), "submitReplacement({})", target);
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        this.runWithRetry(() -> this.formatDriver.submitConditionalReplacement(target, newValue, precondition, requiredValue), "submitConditionalReplacement({}, {} = {})", target, precondition, requiredValue);
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        this.runWithRetry(() -> this.formatDriver.submitInitialization(target, newValue), "submitInitialization({})", target);
    }

    public <T> void submitDeletion(Reference<T> target) {
        if (target.path().isEmpty()) {
            throw new IllegalArgumentException("Can't delete the root of the bosk");
        }
        this.runWithRetry(() -> this.formatDriver.submitDeletion(target), "submitDeletion({}, {})", target);
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        this.runWithRetry(() -> this.formatDriver.submitConditionalDeletion(target, precondition, requiredValue), "submitConditionalDeletion({}, {} = {})", target, precondition, requiredValue);
    }

    @Override
    public void refurbish() throws IOException {
        this.runWithRetry(this::doRefurbish, "refurbish", new Object[0]);
    }

    public void flush() throws IOException, InterruptedException {
        try (MDCScope __ = this.beginDriverOperation("flush", new Object[0]);){
            try {
                this.formatDriver.flush();
            }
            catch (FlushFailureException | RuntimeException e1) {
                this.recoverFrom((Exception)e1);
                LOGGER.debug("Retrying flush");
                try {
                    this.formatDriver.flush();
                }
                catch (DisconnectedException e2) {
                    throw new FlushFailureException(e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }

    private void doRefurbish() throws IOException {
        ClientSessionOptions sessionOptions = ClientSessionOptions.builder().causallyConsistent(true).defaultTransactionOptions(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).readConcern(ReadConcern.MAJORITY).build()).build();
        try (ClientSession session = this.mongoClient.startSession(sessionOptions);){
            try {
                session.startTransaction();
                StateAndMetadata<R> result = this.formatDriver.loadAllState();
                FormatDriver<R> newFormatDriver = this.newPreferredFormatDriver();
                this.collection.deleteMany((Bson)new BsonDocument());
                newFormatDriver.initializeCollection(result);
                session.commitTransaction();
                this.formatDriver = newFormatDriver;
            }
            catch (UninitializedCollectionException e) {
                throw new IOException("Unable to refurbish uninitialized database collection", e);
            }
            finally {
                if (session.hasActiveTransaction()) {
                    session.abortTransaction();
                }
            }
        }
    }

    private <X extends Exception, Y extends Exception> void runWithRetry(Action<X, Y> action, String description, Object ... args) throws X, Y {
        try (MDCScope __ = this.beginDriverOperation(description, args);){
            try {
                action.run();
            }
            catch (RuntimeException e) {
                this.recoverFrom(e);
                LOGGER.debug("Retrying");
                action.run();
            }
        }
    }

    @Override
    public void close() {
        try (MDCScope __ = MainDriver.setupMDC(this.bosk.name());){
            LOGGER.debug("close");
            this.isClosed = true;
            this.receiver.close();
            this.formatDriver.close();
        }
    }

    private R initializeReplication() throws UninitializedCollectionException, ReceiverInitializationException, IOException {
        if (this.isClosed) {
            LOGGER.debug("Don't initialize replication on closed driver");
            return null;
        }
        FutureTask<Entity> initTask = new FutureTask<Entity>(() -> {
            LOGGER.debug("Initializing replication");
            try {
                this.formatDriver.close();
                this.formatDriver = new DisconnectedDriver("Driver initialization failed");
                if (this.receiver.initialize(new Listener())) {
                    FormatDriver<R> newDriver = this.detectFormat();
                    StateAndMetadata<R> result = newDriver.loadAllState();
                    newDriver.onRevisionToSkip(result.revision);
                    this.formatDriver = newDriver;
                    Object r = result.state;
                    return r;
                }
                LOGGER.warn("Unable to fetch resume token; disconnecting");
                this.formatDriver = new DisconnectedDriver("Unable to fetch resume token");
                Entity newDriver = null;
                return newDriver;
            }
            catch (ReceiverInitializationException | IOException | RuntimeException e) {
                LOGGER.warn("Failed to initialize replication", (Throwable)e);
                this.formatDriver = new DisconnectedDriver(e.toString());
                throw new TunneledCheckedException(e);
            }
            finally {
                this.initializationInProgress.set(null);
            }
        });
        FutureTask<R> init = this.initializationInProgress.updateAndGet(x -> {
            if (x == null) {
                LOGGER.debug("Will perform initialization");
                return initTask;
            }
            LOGGER.debug("Will wait for initialization already underway");
            return x;
        });
        init.run();
        try {
            Entity result = (Entity)init.get();
            LOGGER.debug("Initialization returned {}", (Object)(result == null ? "null" : "new root"));
            return (R)result;
        }
        catch (InterruptedException e) {
            LOGGER.debug("Initialization interrupted", (Throwable)e);
            throw new NotYetImplementedException((Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.debug("Initialization threw {}", (Object)e.getCause().getClass().getSimpleName(), (Object)e.getCause());
            if (e.getCause() instanceof UninitializedCollectionException) {
                throw (UninitializedCollectionException)e.getCause();
            }
            if (e.getCause() instanceof TunneledCheckedException) {
                Exception cause = ((TunneledCheckedException)e.getCause()).getCause();
                if (cause instanceof UninitializedCollectionException) {
                    throw (UninitializedCollectionException)cause;
                }
                if (cause instanceof ReceiverInitializationException) {
                    throw (ReceiverInitializationException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new NotYetImplementedException((Throwable)cause);
            }
            throw new NotYetImplementedException((Throwable)e);
        }
    }

    private FormatDriver<R> detectFormat() throws UninitializedCollectionException, UnrecognizedFormatException {
        FindIterable result = this.collection.find((Bson)new BsonDocument("_id", (BsonValue)SingleDocFormatDriver.DOCUMENT_ID));
        try (MongoCursor cursor = result.cursor();){
            if (cursor.hasNext()) {
                Long revision = (Long)((Document)cursor.next()).get((Object)Formatter.DocumentFields.revision.name(), (Object)0L);
                SingleDocFormatDriver<R> singleDocFormatDriver = this.newSingleDocFormatDriver(revision);
                return singleDocFormatDriver;
            }
            throw new UninitializedCollectionException("Document doesn't exist");
        }
    }

    private SingleDocFormatDriver<R> newSingleDocFormatDriver(long revisionAlreadySeen) {
        return new SingleDocFormatDriver<R>(this.bosk, this.collection, this.driverSettings, this.bsonPlugin, new FlushLock(this.driverSettings, revisionAlreadySeen), this.downstream);
    }

    private MDCScope beginDriverOperation(String description, Object ... args) {
        if (this.isClosed) {
            throw new IllegalStateException("Driver is closed");
        }
        MDCScope ex = MainDriver.setupMDC(this.bosk.name());
        LOGGER.debug(description, args);
        return ex;
    }

    static MDCScope setupMDC(String boskName) {
        MDCScope result = new MDCScope();
        MDC.put((String)MDC_KEY, (String)(" [" + boskName + "]"));
        return result;
    }

    static final class MDCScope
    implements AutoCloseable {
        final String oldValue = MDC.get((String)"MongoDriver");

        MDCScope() {
        }

        @Override
        public void close() {
            MDC.put((String)MainDriver.MDC_KEY, (String)this.oldValue);
        }
    }

    private static interface Action<X extends Exception, Y extends Exception> {
        public void run() throws X, Y;
    }

    private final class Listener
    implements ChangeEventListener {
        volatile boolean isListening = true;

        private Listener() {
        }

        @Override
        public void onEvent(ChangeStreamDocument<Document> event) throws UnprocessableEventException {
            if (this.isListening) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("# EVENT: {} {}", (Object)event.getOperationType().getValue(), event);
                } else {
                    LOGGER.debug("# EVENT: {}", (Object)event.getOperationType().getValue());
                }
                try {
                    MainDriver.this.formatDriver.onEvent(event);
                }
                catch (RuntimeException e) {
                    this.onException(e);
                }
            }
        }

        @Override
        public void onException(Exception e) {
            this.isListening = false;
            MainDriver.this.recoverFrom(e);
        }
    }
}

