/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v2;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.v2.DisconnectedException;
import io.vena.bosk.drivers.mongo.v2.FormatDriver;
import io.vena.bosk.drivers.mongo.v2.StateAndMetadata;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.bson.BsonInt64;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DisconnectedDriver<R extends Entity>
implements FormatDriver<R> {
    final String reason;
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectedDriver.class);

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        throw this.disconnected("submitReplacement");
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected("submitConditionalReplacement");
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        throw this.disconnected("submitInitialization");
    }

    public <T> void submitDeletion(Reference<T> target) {
        throw this.disconnected("submitDeletion");
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected("submitConditionalDeletion");
    }

    public void flush() throws IOException, InterruptedException {
        throw this.disconnected("flush");
    }

    @Override
    public void close() {
    }

    @Override
    public StateAndMetadata<R> loadAllState() {
        throw this.disconnected("loadAllState");
    }

    @Override
    public void initializeCollection(StateAndMetadata<R> contents) {
    }

    @Override
    public void onRevisionToSkip(BsonInt64 revision) {
        throw new AssertionError((Object)"Resynchronization should not tell DisconnectedDriver to skip a revision");
    }

    private DisconnectedException disconnected(String name) {
        return new DisconnectedException("Cannot execute " + name + " while disconnected (due to: " + this.reason + ")");
    }

    @Override
    public void onEvent(ChangeStreamDocument<Document> event) {
        LOGGER.info("Ignoring {} event while disconnected (due to: {})", (Object)event.getOperationType(), (Object)this.reason);
    }

    @ConstructorProperties(value={"reason"})
    @Generated
    public DisconnectedDriver(String reason) {
        this.reason = reason;
    }
}

