/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.Formatter;
import io.vena.bosk.drivers.mongo.MongoDriver;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.MongoReceiver;
import io.vena.bosk.drivers.mongo.SingleDocumentMongoChangeStreamReceiver;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import io.vena.bosk.exceptions.NotYetImplementedException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SingleDocumentMongoDriver<R extends Entity>
implements MongoDriver<R> {
    private final String description;
    private final MongoDriverSettings settings;
    private final Formatter formatter;
    private final MongoReceiver<R> receiver;
    private final MongoClient mongoClient;
    private final MongoCollection<Document> collection;
    private final BsonString documentID;
    private final Reference<R> rootRef;
    private final String echoPrefix;
    private final AtomicLong echoCounter = new AtomicLong(1000000000000L);
    static final String COLLECTION_NAME = "boskCollection";
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleDocumentMongoDriver.class);

    SingleDocumentMongoDriver(Bosk<R> bosk, MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin, BoskDriver<R> downstream) {
        this.validateMongoClientSettings(clientSettings);
        this.description = SingleDocumentMongoDriver.class.getSimpleName() + ": " + driverSettings;
        this.settings = driverSettings;
        this.mongoClient = MongoClients.create((MongoClientSettings)clientSettings);
        this.formatter = new Formatter(bosk, bsonPlugin);
        this.collection = this.mongoClient.getDatabase(driverSettings.database()).getCollection(COLLECTION_NAME);
        this.receiver = new SingleDocumentMongoChangeStreamReceiver<R>(downstream, bosk.rootReference(), this.collection, this.formatter, this.settings);
        this.echoPrefix = bosk.instanceID().toString();
        this.documentID = new BsonString("boskDocument");
        this.rootRef = bosk.rootReference();
    }

    private void validateMongoClientSettings(MongoClientSettings clientSettings) {
        if (clientSettings.getReadConcern() != ReadConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify ReadConcern.MAJORITY");
        }
        if (clientSettings.getWriteConcern() != WriteConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify WriteConcern.MAJORITY");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R initialRoot(Type rootType) throws InvalidTypeException, IOException, InterruptedException {
        LOGGER.debug("+ initialRoot");
        this.bumpRevision();
        try (MongoCursor cursor = this.collection.find((Bson)this.documentFilter()).limit(1).cursor();){
            Document newDocument = (Document)cursor.next();
            Document newState = (Document)newDocument.get((Object)Formatter.DocumentFields.state.name(), Document.class);
            if (newState != null) {
                LOGGER.debug("| From database: {}", (Object)newState);
                this.bumpRevision();
                Entity entity = (Entity)this.formatter.document2object(newState, this.rootRef);
                return (R)entity;
            }
            LOGGER.debug("| No existing state; delegating downstream");
        }
        catch (NoSuchElementException e) {
            LOGGER.debug("| No tenant document; delegating downstream");
        }
        R root = this.receiver.initialRoot(rootType);
        this.ensureDocumentExists(this.formatter.object2bsonValue(root, rootType), "$setOnInsert");
        this.bumpRevision();
        return root;
    }

    private void bumpRevision() {
        this.doUpdate(this.updateDoc(), this.documentFilter());
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        LOGGER.debug("+ submitReplacement({})", target);
        this.doUpdate(this.replacementDoc(target, newValue), this.standardPreconditions(target));
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        LOGGER.debug("+ submitInitialization({})", target);
        BsonDocument filter = this.standardPreconditions(target);
        filter.put(Formatter.dottedFieldNameOf(target, this.rootRef), (BsonValue)new BsonDocument("$exists", (BsonValue)BsonBoolean.FALSE));
        if (this.doUpdate(this.replacementDoc(target, newValue), filter)) {
            LOGGER.debug("| Object initialized");
        } else {
            LOGGER.debug("| No update");
        }
    }

    public <T> void submitDeletion(Reference<T> target) {
        LOGGER.debug("+ submitDeletion({})", target);
        if (target.path().isEmpty()) {
            throw new IllegalArgumentException("Can't delete the root of the bosk");
        }
        this.doUpdate(this.deletionDoc(target), this.standardPreconditions(target));
    }

    public void flush() throws IOException, InterruptedException {
        LOGGER.debug("+ flush");
        switch (this.settings.experimental().flushMode()) {
            case REVISION_FIELD_ONLY: {
                this.receiver.awaitLatestRevision();
                break;
            }
            default: {
                LOGGER.warn("Unrecognized flush mode {}; defaulting to ECHO", (Object)this.settings.experimental().flushMode());
            }
            case ECHO: {
                this.performEcho();
            }
        }
        this.receiver.flushDownstream();
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        LOGGER.debug("+ submitConditionalReplacement({}, {} = {})", new Object[]{target, precondition, requiredValue});
        this.doUpdate(this.replacementDoc(target, newValue), this.explicitPreconditions(target, precondition, requiredValue));
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        LOGGER.debug("+ submitConditionalDeletion({}, {} = {})", new Object[]{target, precondition, requiredValue});
        this.doUpdate(this.deletionDoc(target), this.explicitPreconditions(target, precondition, requiredValue));
    }

    @Override
    public void close() {
        try {
            this.receiver.close();
        }
        finally {
            this.mongoClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refurbish() {
        ClientSessionOptions sessionOptions = ClientSessionOptions.builder().causallyConsistent(true).defaultTransactionOptions(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).readConcern(ReadConcern.MAJORITY).build()).build();
        ClientSession session = this.mongoClient.startSession(sessionOptions);
        try {
            try {
                Document stateFromDB;
                Document documentFromDB;
                session.startTransaction();
                try (MongoCursor cursor = this.collection.find((Bson)this.documentFilter()).limit(1).cursor();){
                    documentFromDB = (Document)cursor.next();
                    stateFromDB = (Document)documentFromDB.get((Object)Formatter.DocumentFields.state.name(), Document.class);
                }
                catch (NoSuchElementException e) {
                    LOGGER.debug("No document to refurbish", (Throwable)e);
                    if (session.hasActiveTransaction()) {
                        session.abortTransaction();
                    }
                    if (session != null) {
                        session.close();
                    }
                    return;
                }
                if (stateFromDB == null) {
                    LOGGER.debug("No state to refurbish");
                    return;
                }
                Entity root = (Entity)this.formatter.document2object(stateFromDB, this.rootRef);
                BsonValue initialState = this.formatter.object2bsonValue(root, this.rootRef.targetType());
                this.collection.replaceOne((Bson)this.documentFilter(), (Object)new Document());
                this.ensureDocumentExists(initialState, "$set");
                long newValue = 1L + (Long)documentFromDB.get((Object)Formatter.DocumentFields.revision.name(), (Object)Formatter.REVISION_ZERO.longValue());
                this.doUpdate(new BsonDocument("$set", (BsonValue)new BsonDocument(Formatter.DocumentFields.revision.name(), (BsonValue)new BsonInt64(newValue))), this.documentFilter());
                session.commitTransaction();
            }
            finally {
                if (session.hasActiveTransaction()) {
                    session.abortTransaction();
                }
            }
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private BsonDocument documentFilter() {
        return new BsonDocument("_id", (BsonValue)this.documentID);
    }

    private <T> BsonDocument standardPreconditions(Reference<T> target) {
        BsonDocument filter = this.documentFilter();
        if (!target.path().isEmpty()) {
            String enclosingObjectKey = Formatter.dottedFieldNameOf(Formatter.enclosingReference(target), this.rootRef);
            BsonDocument condition = new BsonDocument("$type", (BsonValue)new BsonString("object"));
            filter.put(enclosingObjectKey, (BsonValue)condition);
            LOGGER.debug("| Precondition: {} {}", (Object)enclosingObjectKey, (Object)condition);
        }
        return filter;
    }

    private <T> BsonDocument explicitPreconditions(Reference<T> target, Reference<Identifier> preconditionRef, Identifier requiredValue) {
        BsonDocument filter = this.standardPreconditions(target);
        BsonDocument precondition = new BsonDocument("$eq", (BsonValue)new BsonString(requiredValue.toString()));
        filter.put(Formatter.dottedFieldNameOf(preconditionRef, this.rootRef), (BsonValue)precondition);
        return filter;
    }

    private <T> BsonDocument replacementDoc(Reference<T> target, T newValue) {
        String key = Formatter.dottedFieldNameOf(target, this.rootRef);
        BsonValue value = this.formatter.object2bsonValue(newValue, target.targetType());
        LOGGER.debug("| Set field {}: {}", (Object)key, (Object)value);
        return this.updateDoc().append("$set", (BsonValue)new BsonDocument(key, value));
    }

    private <T> BsonDocument deletionDoc(Reference<T> target) {
        String key = Formatter.dottedFieldNameOf(target, this.rootRef);
        LOGGER.debug("| Unset field {}", (Object)key);
        return this.updateDoc().append("$unset", (BsonValue)new BsonDocument(key, (BsonValue)new BsonNull()));
    }

    private BsonDocument updateDoc() {
        return new BsonDocument("$inc", (BsonValue)new BsonDocument(Formatter.DocumentFields.revision.name(), (BsonValue)Formatter.REVISION_ONE));
    }

    private void ensureDocumentExists(BsonValue initialState, String updateCommand) {
        UpdateResult result;
        BsonDocument update = new BsonDocument(updateCommand, (BsonValue)this.initialDocument(initialState));
        BsonDocument filter = this.documentFilter();
        UpdateOptions options = new UpdateOptions();
        options.upsert(true);
        LOGGER.debug("** Initial tenant upsert for {}", (Object)this.documentID);
        LOGGER.trace("| Filter: {}", (Object)filter);
        LOGGER.trace("| Update: {}", (Object)update);
        LOGGER.trace("| Options: {}", (Object)options);
        try {
            result = this.collection.updateOne((Bson)filter, (Bson)update, options);
        }
        catch (MongoWriteException e) {
            if (ErrorCategory.DUPLICATE_KEY == ErrorCategory.fromErrorCode((int)e.getCode())) {
                LOGGER.debug("| Retrying: {}", (Object)e.getMessage());
                result = this.collection.updateOne((Bson)filter, (Bson)update, options);
            }
            throw e;
        }
        LOGGER.debug("| Result: {}", (Object)result);
    }

    private BsonDocument initialDocument(BsonValue initialState) {
        BsonDocument fieldValues = new BsonDocument("_id", (BsonValue)this.documentID);
        fieldValues.put(Formatter.DocumentFields.path.name(), (BsonValue)new BsonString("/"));
        fieldValues.put(Formatter.DocumentFields.state.name(), initialState);
        fieldValues.put(Formatter.DocumentFields.echo.name(), (BsonValue)new BsonString(this.uniqueEchoToken()));
        fieldValues.put(Formatter.DocumentFields.revision.name(), (BsonValue)Formatter.REVISION_ONE);
        return fieldValues;
    }

    private boolean doUpdate(BsonDocument updateDoc, BsonDocument filter) {
        LOGGER.debug("| Update: {}", (Object)updateDoc);
        if (this.settings.testing().eventDelayMS() < 0L) {
            LOGGER.debug("| Sleeping");
            try {
                Thread.sleep(-this.settings.testing().eventDelayMS());
            }
            catch (InterruptedException e) {
                LOGGER.debug("| Interrupted");
            }
        }
        LOGGER.debug("| Filter: {}", (Object)filter);
        UpdateResult result = this.collection.updateOne((Bson)filter, (Bson)updateDoc);
        LOGGER.debug("| Update result: {}", (Object)result);
        if (result.wasAcknowledged()) {
            assert (result.getMatchedCount() <= 1L);
            return result.getMatchedCount() >= 1L;
        }
        LOGGER.error("Mongo write was not acknowledged.\n\tFilter: {}\n\tUpdate: {}\n\tResult: {}", new Object[]{filter, updateDoc, result});
        throw new NotYetImplementedException("Mongo write was not acknowledged");
    }

    private String uniqueEchoToken() {
        return String.format("%s_%012d", this.echoPrefix, this.echoCounter.addAndGet(1L));
    }

    private void performEcho() throws InterruptedException, FlushFailureException {
        String echoToken = this.uniqueEchoToken();
        ArrayBlockingQueue<BsonDocument> listener = new ArrayBlockingQueue<BsonDocument>(1);
        try {
            this.receiver.putEchoListener(echoToken, listener);
            BsonDocument updateDoc = this.updateDoc().append("$set", (BsonValue)new BsonDocument(Formatter.DocumentFields.echo.name(), (BsonValue)new BsonString(echoToken)));
            LOGGER.debug("| Update: {}", (Object)updateDoc);
            UpdateResult result = this.collection.updateOne((Bson)this.documentFilter(), (Bson)updateDoc);
            if (result.getModifiedCount() == 0L) {
                LOGGER.debug("Document does not exist; echo succeeds trivially. Response: {}", (Object)result);
                return;
            }
            LOGGER.debug("| Waiting");
            BsonDocument resumeToken = (BsonDocument)listener.poll(this.settings.flushTimeoutMS(), TimeUnit.MILLISECONDS);
            if (resumeToken == null) {
                throw new FlushFailureException("No flush response after " + this.settings.flushTimeoutMS() + "ms");
            }
            MongoResumeTokenSequenceMark sequenceMark = new MongoResumeTokenSequenceMark(resumeToken.getString((Object)"_data").getValue());
            LOGGER.debug("| SequenceMark: {}", (Object)sequenceMark);
        }
        catch (MongoException e) {
            throw new FlushFailureException((Throwable)e);
        }
        finally {
            this.receiver.removeEchoListener(echoToken);
        }
    }

    public String toString() {
        return this.description;
    }

    private static final class MongoResumeTokenSequenceMark {
        private final String tokenData;

        public String toString() {
            return this.tokenData;
        }

        @ConstructorProperties(value={"tokenData"})
        @Generated
        public MongoResumeTokenSequenceMark(String tokenData) {
            this.tokenData = tokenData;
        }

        @Generated
        public String tokenData() {
            return this.tokenData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MongoResumeTokenSequenceMark)) {
                return false;
            }
            MongoResumeTokenSequenceMark other = (MongoResumeTokenSequenceMark)o;
            String this$tokenData = this.tokenData();
            String other$tokenData = other.tokenData();
            return !(this$tokenData == null ? other$tokenData != null : !this$tokenData.equals(other$tokenData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tokenData = this.tokenData();
            result = result * 59 + ($tokenData == null ? 43 : $tokenData.hashCode());
            return result;
        }
    }
}

