/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v2;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.MongoDriver;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.v2.ChangeEventListener;
import io.vena.bosk.drivers.mongo.v2.ChangeEventReceiver;
import io.vena.bosk.drivers.mongo.v2.DisconnectedDriver;
import io.vena.bosk.drivers.mongo.v2.DisconnectedException;
import io.vena.bosk.drivers.mongo.v2.FlushLock;
import io.vena.bosk.drivers.mongo.v2.FormatDriver;
import io.vena.bosk.drivers.mongo.v2.Formatter;
import io.vena.bosk.drivers.mongo.v2.ReceiverInitializationException;
import io.vena.bosk.drivers.mongo.v2.SingleDocFormatDriver;
import io.vena.bosk.drivers.mongo.v2.StateAndMetadata;
import io.vena.bosk.drivers.mongo.v2.UninitializedCollectionException;
import io.vena.bosk.drivers.mongo.v2.UnrecognizedFormatException;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import io.vena.bosk.exceptions.NotYetImplementedException;
import io.vena.bosk.exceptions.TunneledCheckedException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainDriver<R extends Entity>
implements MongoDriver<R> {
    private final Bosk<R> bosk;
    private final MongoDriverSettings driverSettings;
    private final BsonPlugin bsonPlugin;
    private final BoskDriver<R> downstream;
    private final Reference<R> rootRef;
    private final MongoClient mongoClient;
    private final MongoDatabase database;
    private final MongoCollection<Document> collection;
    private final ChangeEventReceiver receiver;
    private final AtomicReference<FutureTask<R>> initializationInProgress = new AtomicReference();
    private volatile FormatDriver<R> formatDriver = new DisconnectedDriver();
    private volatile boolean isClosed = false;
    public static final String COLLECTION_NAME = "boskCollection";
    private static final Logger LOGGER = LoggerFactory.getLogger(MainDriver.class);

    public MainDriver(Bosk<R> bosk, MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin, BoskDriver<R> downstream) {
        this.validateMongoClientSettings(clientSettings);
        this.bosk = bosk;
        this.driverSettings = driverSettings;
        this.bsonPlugin = bsonPlugin;
        this.downstream = downstream;
        this.rootRef = bosk.rootReference();
        this.mongoClient = MongoClients.create((MongoClientSettings)clientSettings);
        this.database = this.mongoClient.getDatabase(driverSettings.database());
        this.collection = this.database.getCollection(COLLECTION_NAME);
        this.receiver = new ChangeEventReceiver(bosk.name(), driverSettings, this.collection);
    }

    private void validateMongoClientSettings(MongoClientSettings clientSettings) {
        if (clientSettings.getReadConcern() != ReadConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify ReadConcern.MAJORITY");
        }
        if (clientSettings.getWriteConcern() != WriteConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify WriteConcern.MAJORITY");
        }
    }

    public R initialRoot(Type rootType) throws InvalidTypeException, IOException, InterruptedException {
        Object result;
        this.beginDriverOperation("initialRoot", new Object[0]);
        try {
            result = this.initializeReplication();
        }
        catch (UninitializedCollectionException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Creating collection", (Throwable)e);
            } else {
                LOGGER.info("Creating collection");
            }
            SingleDocFormatDriver<R> newDriver = this.newSingleDocFormatDriver(Formatter.REVISION_ONE.longValue());
            result = this.downstream.initialRoot(rootType);
            newDriver.initializeCollection(new StateAndMetadata<R>(result, Formatter.REVISION_ONE));
            this.formatDriver = newDriver;
        }
        catch (ReceiverInitializationException e) {
            LOGGER.debug("Unable to initialize replication", (Throwable)e);
            result = null;
        }
        if (this.receiver.isReady()) {
            this.receiver.start();
        } else {
            LOGGER.debug("Receiver not started");
        }
        if (result == null) {
            return (R)this.downstream.initialRoot(rootType);
        }
        return result;
    }

    private void recoverFrom(Exception exception) {
        R result;
        if (this.isClosed) {
            LOGGER.debug("Closed driver ignoring exception", (Throwable)exception);
            return;
        }
        LOGGER.error("Recovering from unexpected exception; reinitializing", (Throwable)exception);
        try {
            result = this.initializeReplication();
        }
        catch (UninitializedCollectionException e) {
            LOGGER.warn("Collection is uninitialized; driver is disconnected", (Throwable)e);
            return;
        }
        catch (ReceiverInitializationException e) {
            LOGGER.warn("Unable to initialize receiver", (Throwable)e);
            return;
        }
        if (result != null) {
            this.downstream.submitReplacement(this.rootRef, result);
        }
        if (!this.isClosed) {
            this.receiver.start();
        }
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        this.beginDriverOperation("submitReplacement({})", target);
        this.retryIfDisconnected(() -> this.formatDriver.submitReplacement(target, newValue));
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        this.beginDriverOperation("submitConditionalReplacement({}, {} = {})", target, precondition, requiredValue);
        this.retryIfDisconnected(() -> this.formatDriver.submitConditionalReplacement(target, newValue, precondition, requiredValue));
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        this.beginDriverOperation("submitInitialization({})", target);
        this.retryIfDisconnected(() -> this.formatDriver.submitInitialization(target, newValue));
    }

    public <T> void submitDeletion(Reference<T> target) {
        this.beginDriverOperation("submitDeletion({}, {})", target);
        this.retryIfDisconnected(() -> this.formatDriver.submitDeletion(target));
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        this.beginDriverOperation("submitConditionalDeletion({}, {} = {})", target, precondition, requiredValue);
        this.retryIfDisconnected(() -> this.formatDriver.submitConditionalDeletion(target, precondition, requiredValue));
    }

    public void flush() throws IOException, InterruptedException {
        this.beginDriverOperation("flush", new Object[0]);
        try {
            this.retryIfDisconnected(() -> this.formatDriver.flush());
        }
        catch (DisconnectedException e) {
            throw new FlushFailureException("Unable to connect to database", (Throwable)e);
        }
    }

    @Override
    public void refurbish() throws IOException {
        this.beginDriverOperation("refurbish", new Object[0]);
        this.retryIfDisconnected(this::doRefurbish);
    }

    private void doRefurbish() throws IOException {
        ClientSessionOptions sessionOptions = ClientSessionOptions.builder().causallyConsistent(true).defaultTransactionOptions(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).readConcern(ReadConcern.MAJORITY).build()).build();
        try (ClientSession session = this.mongoClient.startSession(sessionOptions);){
            try {
                session.startTransaction();
                StateAndMetadata<R> result = this.formatDriver.loadAllState();
                FormatDriver<R> newFormatDriver = this.detectFormat();
                this.collection.deleteMany((Bson)new BsonDocument());
                newFormatDriver.initializeCollection(result);
                session.commitTransaction();
                this.formatDriver = newFormatDriver;
            }
            catch (UninitializedCollectionException e) {
                throw new IOException("Unable to refurbish uninitialized database collection", e);
            }
            finally {
                if (session.hasActiveTransaction()) {
                    session.abortTransaction();
                }
            }
        }
    }

    @Override
    public void close() {
        this.logDriverOperation("close", new Object[0]);
        this.isClosed = true;
        this.receiver.close();
        this.formatDriver.close();
    }

    private <X extends Exception, Y extends Exception> void retryIfDisconnected(Action<X, Y> action) throws X, Y {
        try {
            action.run();
        }
        catch (DisconnectedException e) {
            this.recoverFrom(e);
            LOGGER.debug("Retrying");
            action.run();
        }
    }

    private R initializeReplication() throws UninitializedCollectionException, ReceiverInitializationException {
        if (this.isClosed) {
            LOGGER.debug("Don't initialize replication on closed driver");
            return null;
        }
        FutureTask<Entity> initTask = new FutureTask<Entity>(() -> {
            LOGGER.debug("Initializing replication");
            try {
                this.formatDriver = new DisconnectedDriver();
                if (this.receiver.initialize(new Listener())) {
                    FormatDriver<R> newDriver = this.detectFormat();
                    StateAndMetadata<R> result = newDriver.loadAllState();
                    newDriver.onRevisionToSkip(result.revision);
                    this.formatDriver = newDriver;
                    Object r = result.state;
                    return r;
                }
                LOGGER.warn("Unable to fetch resume token; disconnected");
                Entity newDriver = null;
                return newDriver;
            }
            catch (ReceiverInitializationException | IOException e) {
                LOGGER.warn("Failed to initialize replication", (Throwable)e);
                throw new TunneledCheckedException(e);
            }
            finally {
                this.initializationInProgress.set(null);
            }
        });
        FutureTask<R> init = this.initializationInProgress.updateAndGet(x -> x == null ? initTask : x);
        init.run();
        try {
            return (R)((Entity)init.get());
        }
        catch (InterruptedException e) {
            throw new NotYetImplementedException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UninitializedCollectionException) {
                throw (UninitializedCollectionException)e.getCause();
            }
            if (e.getCause() instanceof TunneledCheckedException) {
                Exception cause = ((TunneledCheckedException)e.getCause()).getCause();
                if (cause instanceof UninitializedCollectionException) {
                    throw (UninitializedCollectionException)cause;
                }
                if (cause instanceof ReceiverInitializationException) {
                    throw (ReceiverInitializationException)cause;
                }
                throw new NotYetImplementedException((Throwable)cause);
            }
            throw new NotYetImplementedException((Throwable)e);
        }
    }

    private FormatDriver<R> detectFormat() throws UninitializedCollectionException, UnrecognizedFormatException {
        FindIterable result = this.collection.find((Bson)new BsonDocument("_id", (BsonValue)SingleDocFormatDriver.DOCUMENT_ID));
        try (MongoCursor cursor = result.cursor();){
            if (cursor.hasNext()) {
                Long revision = (Long)((Document)cursor.next()).get((Object)Formatter.DocumentFields.revision.name(), (Object)0L);
                SingleDocFormatDriver<R> singleDocFormatDriver = this.newSingleDocFormatDriver(revision);
                return singleDocFormatDriver;
            }
            throw new UninitializedCollectionException("Document doesn't exist");
        }
    }

    private SingleDocFormatDriver<R> newSingleDocFormatDriver(long revisionAlreadySeen) {
        return new SingleDocFormatDriver<R>(this.bosk, this.collection, this.driverSettings, this.bsonPlugin, new FlushLock(this.driverSettings, revisionAlreadySeen), this.downstream);
    }

    private void beginDriverOperation(String description, Object ... args) {
        if (this.isClosed) {
            throw new IllegalStateException("Driver is closed");
        }
        this.logDriverOperation(description, args);
    }

    private void logDriverOperation(String description, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            String formatString = "+[" + this.bosk.name() + "] " + description;
            LOGGER.debug(formatString, args);
        }
    }

    private static interface Action<X extends Exception, Y extends Exception> {
        public void run() throws X, Y;
    }

    private final class Listener
    implements ChangeEventListener {
        volatile boolean isListening = true;

        private Listener() {
        }

        @Override
        public void onEvent(ChangeStreamDocument<Document> event) {
            if (this.isListening) {
                try {
                    MainDriver.this.formatDriver.onEvent(event);
                }
                catch (RuntimeException e) {
                    this.onException(e);
                }
            }
        }

        @Override
        public void onException(Exception e) {
            this.isListening = false;
            MainDriver.this.recoverFrom(e);
        }
    }
}

