/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.v2;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.v2.DisconnectedException;
import io.vena.bosk.drivers.mongo.v2.FormatDriver;
import io.vena.bosk.drivers.mongo.v2.StateAndMetadata;
import java.io.IOException;
import org.bson.BsonInt64;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DisconnectedDriver<R extends Entity>
implements FormatDriver<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectedDriver.class);

    DisconnectedDriver() {
    }

    @Override
    public boolean isDisconnected() {
        return true;
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        throw this.disconnected("submitReplacement");
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected("submitConditionalReplacement");
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        throw this.disconnected("submitInitialization");
    }

    public <T> void submitDeletion(Reference<T> target) {
        throw this.disconnected("submitDeletion");
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected("submitConditionalDeletion");
    }

    public void flush() throws IOException, InterruptedException {
        throw this.disconnected("flush");
    }

    @Override
    public void close() {
    }

    @Override
    public StateAndMetadata<R> loadAllState() {
        throw this.disconnected("loadAllState");
    }

    @Override
    public void initializeCollection(StateAndMetadata<R> contents) {
    }

    @Override
    public void onRevisionToSkip(BsonInt64 revision) {
        throw new AssertionError((Object)"Resynchronization should not tell DisconnectedDriver to skip a revision");
    }

    private DisconnectedException disconnected(String name) {
        return new DisconnectedException("Disconnected driver cannot execute " + name);
    }

    @Override
    public void onEvent(ChangeStreamDocument<Document> event) {
        LOGGER.info("Event received in disconnected mode: {} {}", (Object)event.getOperationType(), (Object)event.getResumeToken());
    }
}

