/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.MongoClientSettings;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.DriverFactory;
import io.vena.bosk.Entity;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.SingleDocumentMongoDriver;
import io.vena.bosk.drivers.mongo.v2.MainDriver;
import java.io.IOException;

public interface MongoDriver<R extends Entity>
extends BoskDriver<R> {
    public void refurbish() throws IOException;

    public void close();

    public static <RR extends Entity> MongoDriverFactory<RR> factory(MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin) {
        if (driverSettings.implementationKind() == MongoDriverSettings.ImplementationKind.RESILIENT) {
            return (b, d) -> new MainDriver(b, clientSettings, driverSettings, bsonPlugin, d);
        }
        return (b, d) -> new SingleDocumentMongoDriver(b, clientSettings, driverSettings, bsonPlugin, d);
    }

    public static interface MongoDriverFactory<RR extends Entity>
    extends DriverFactory<RR> {
        public MongoDriver<RR> build(Bosk<RR> var1, BoskDriver<RR> var2);
    }
}

