/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import io.vena.bosk.Bosk;
import io.vena.bosk.Catalog;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.ListValue;
import io.vena.bosk.Listing;
import io.vena.bosk.ListingEntry;
import io.vena.bosk.MapValue;
import io.vena.bosk.Path;
import io.vena.bosk.Phantom;
import io.vena.bosk.Reference;
import io.vena.bosk.ReferenceUtils;
import io.vena.bosk.SerializationPlugin;
import io.vena.bosk.SideTable;
import io.vena.bosk.StateTreeNode;
import io.vena.bosk.drivers.mongo.BsonFormatException;
import io.vena.bosk.drivers.mongo.Formatter;
import io.vena.bosk.exceptions.InvalidTypeException;
import io.vena.bosk.exceptions.UnexpectedPathException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BsonPlugin
extends SerializationPlugin {
    private final ValueCodecProvider valueCodecProvider = new ValueCodecProvider();
    private final Map<Type, Codec<?>> memoizedCodecs = new ConcurrentHashMap();
    private static final Set<Class<?>> EASYGOING_GENERICS = new HashSet<Class>(Arrays.asList(Reference.class, Listing.class));
    private static final Set<String> ALREADY_WARNED = Collections.synchronizedSet(new HashSet());
    private static final Logger LOGGER = LoggerFactory.getLogger(BsonPlugin.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle WRITE_FIELD;
    private static final MethodHandle WRITE_CATALOG;
    private static final MethodHandle WRITE_SIDE_TABLE;
    private static final MethodHandle WRITE_NOTHING;
    private static final MethodHandle GET_ANY_CODEC;
    private static final MethodHandle OPTIONAL_IS_PRESENT;
    private static final MethodHandle OPTIONAL_GET;

    private static MethodHandle computeFactoryHandle(Constructor<?> constructor) throws AssertionError {
        MethodHandle ctorHandle;
        try {
            ctorHandle = LOOKUP.unreflectConstructor(constructor);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Shouldn't happen for classes that pass Bosk validation", e);
        }
        return ctorHandle.asSpreader(Object[].class, constructor.getParameterCount());
    }

    public <R extends Entity> CodecProvider codecProviderFor(final Bosk<R> bosk) {
        return new CodecProvider(){

            public <T> Codec<T> get(Class<T> targetClass, CodecRegistry registry) {
                return BsonPlugin.this.getCodec(targetClass, targetClass, registry, bosk);
            }
        };
    }

    public <T, R extends Entity> Codec<T> getCodec(Type targetType, Class<T> targetClass, CodecRegistry registry, Bosk<R> bosk) {
        if (ReferenceUtils.rawClass((Type)targetType) != targetClass) {
            throw new IllegalArgumentException("Type does not match Class " + targetClass.getSimpleName() + ": " + targetType);
        }
        Codec result = this.memoizedCodecs.get(targetType);
        if (result == null && (result = this.computeCodec(targetType, targetClass, registry, bosk)) != null) {
            this.memoizedCodecs.putIfAbsent(targetType, result);
        }
        return result;
    }

    private <T, R extends Entity> Codec<T> getAnyCodec(Type targetType, Class<T> targetClass, CodecRegistry registry, Bosk<R> bosk) {
        Codec<T> result = this.getCodec(targetType, targetClass, registry, bosk);
        if (result == null) {
            return Objects.requireNonNull(registry.get(targetClass), "Codec required for " + targetType);
        }
        return result;
    }

    private Codec computeCodec(Type targetType, Class targetClass, CodecRegistry registry, Bosk bosk) {
        if (Identifier.class.isAssignableFrom(targetClass)) {
            return BsonPlugin.identifierCodec();
        }
        if (ListingEntry.class.isAssignableFrom(targetClass)) {
            return BsonPlugin.listingEntryCodec();
        }
        if (Reference.class.isAssignableFrom(targetClass)) {
            return BsonPlugin.referenceCodec(bosk);
        }
        if (Enum.class.isAssignableFrom(targetClass)) {
            return BsonPlugin.enumCodec(targetClass);
        }
        if (Listing.class.isAssignableFrom(targetClass)) {
            return BsonPlugin.listingCodec(targetClass, registry);
        }
        if (StateTreeNode.class.isAssignableFrom(targetClass)) {
            return this.stateTreeNodeCodec(targetClass, registry, bosk);
        }
        if (Catalog.class.isAssignableFrom(targetClass)) {
            return this.catalogCodec(targetType, targetClass, registry, bosk);
        }
        if (SideTable.class.isAssignableFrom(targetClass)) {
            return this.sideTableCodec(targetType, targetClass, registry, bosk);
        }
        if (ListValue.class.isAssignableFrom(targetClass)) {
            return this.listValueCodec(targetType, targetClass, registry, bosk);
        }
        if (MapValue.class.isAssignableFrom(targetClass)) {
            return this.mapValueCodec(targetType, targetClass, registry, bosk);
        }
        if (Optional.class.isAssignableFrom(targetClass)) {
            throw new IllegalArgumentException("Cannot serialize an Optional on its own; only as a field of another object");
        }
        if (Phantom.class.isAssignableFrom(targetClass)) {
            throw new IllegalArgumentException("Cannot serialize a Phantom on its own; only as a field of another object");
        }
        if (targetClass.getTypeParameters().length == 0) {
            return this.valueCodecProvider.get(targetClass, registry);
        }
        return null;
    }

    private static Codec<Identifier> identifierCodec() {
        return new Codec<Identifier>(){

            public Class<Identifier> getEncoderClass() {
                return Identifier.class;
            }

            public void encode(BsonWriter writer, Identifier value, EncoderContext encoderContext) {
                writer.writeString(value.toString());
            }

            public Identifier decode(BsonReader reader, DecoderContext decoderContext) {
                return Identifier.from((String)reader.readString());
            }
        };
    }

    private static Codec<ListingEntry> listingEntryCodec() {
        return new Codec<ListingEntry>(){

            public Class<ListingEntry> getEncoderClass() {
                return ListingEntry.class;
            }

            public void encode(BsonWriter writer, ListingEntry value, EncoderContext encoderContext) {
                writer.writeBoolean(true);
            }

            public ListingEntry decode(BsonReader reader, DecoderContext decoderContext) {
                boolean result = reader.readBoolean();
                if (result) {
                    return ListingEntry.LISTING_ENTRY;
                }
                throw new BsonFormatException("Unexpected value for Listing entry: " + result);
            }
        };
    }

    private static <E extends Enum<E>> Codec<E> enumCodec(final Class<E> enumClass) {
        return new Codec<E>(){

            public Class<E> getEncoderClass() {
                return enumClass;
            }

            public void encode(BsonWriter writer, E value, EncoderContext encoderContext) {
                writer.writeString(((Enum)value).name());
            }

            public E decode(BsonReader reader, DecoderContext decoderContext) {
                return Enum.valueOf(enumClass, reader.readString());
            }
        };
    }

    private static <E extends Entity> Codec<Listing<E>> listingCodec(final Class<Listing<E>> targetClass, CodecRegistry registry) {
        final Codec referenceCodec = registry.get(Reference.class);
        return new Codec<Listing<E>>(){

            public Class<Listing<E>> getEncoderClass() {
                return targetClass;
            }

            public void encode(BsonWriter writer, Listing<E> value, EncoderContext encoderContext) {
                writer.writeStartDocument();
                writer.writeName("domain");
                referenceCodec.encode(writer, (Object)value.domain(), encoderContext);
                writer.writeName("ids");
                writer.writeStartDocument();
                for (Identifier id : value.ids()) {
                    writer.writeName(Formatter.dottedFieldNameSegment(id.toString()));
                    writer.writeBoolean(true);
                }
                writer.writeEndDocument();
                writer.writeEndDocument();
            }

            public Listing<E> decode(BsonReader reader, DecoderContext decoderContext) {
                if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
                    reader.readStartDocument();
                }
                reader.readName("domain");
                Reference domain = (Reference)referenceCodec.decode(reader, decoderContext);
                reader.readName("ids");
                ArrayList<Identifier> ids = new ArrayList<Identifier>();
                reader.readStartDocument();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    String id = Formatter.undottedFieldNameSegment(reader.readName());
                    reader.readBoolean();
                    ids.add(Identifier.from((String)id));
                }
                reader.readEndDocument();
                reader.readEndDocument();
                Listing result = Listing.of((Reference)domain, ids);
                if (result.size() > ids.size()) {
                    throw new BsonFormatException("Duplicate ids");
                }
                return result;
            }
        };
    }

    private <V> Codec<MapValue<V>> mapValueCodec(Type mapValueType, final Class<MapValue<V>> targetClass, CodecRegistry registry, Bosk<?> bosk) {
        Type valueType = ReferenceUtils.parameterType((Type)mapValueType, MapValue.class, (int)0);
        Class valueClass = ReferenceUtils.rawClass((Type)valueType);
        final Codec valueCodec = this.getCodec(valueType, valueClass, registry, bosk);
        return new Codec<MapValue<V>>(){

            public Class<MapValue<V>> getEncoderClass() {
                return targetClass;
            }

            public void encode(BsonWriter writer, MapValue<V> mapValue, EncoderContext encoderContext) {
                writer.writeStartDocument();
                mapValue.forEach((key, value) -> {
                    writer.writeName(key);
                    valueCodec.encode(writer, value, encoderContext);
                });
                writer.writeEndDocument();
            }

            public MapValue<V> decode(BsonReader reader, DecoderContext decoderContext) {
                LinkedHashMap<String, Object> entries = new LinkedHashMap<String, Object>();
                reader.readStartDocument();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    Object value;
                    String key = reader.readName();
                    Object old = entries.put(key, value = valueCodec.decode(reader, decoderContext));
                    if (old == null) continue;
                    throw new BsonFormatException("Duplicate keys in MapValue: \"" + key + "\"");
                }
                reader.readEndDocument();
                return MapValue.fromOrderedMap(entries);
            }
        };
    }

    private <V> Codec<ListValue<V>> listValueCodec(final Type listValueType, final Class<ListValue<V>> targetClass, CodecRegistry registry, Bosk<?> bosk) {
        final Constructor ctor = ReferenceUtils.theOnlyConstructorFor(targetClass);
        Type entryType = ReferenceUtils.parameterType((Type)listValueType, ListValue.class, (int)0);
        final Class entryClass = ReferenceUtils.rawClass((Type)entryType);
        final Codec entryCodec = this.getCodec(entryType, entryClass, registry, bosk);
        return new Codec<ListValue<V>>(){

            public Class<ListValue<V>> getEncoderClass() {
                return targetClass;
            }

            public void encode(BsonWriter writer, ListValue<V> value, EncoderContext encoderContext) {
                writer.writeStartArray();
                for (Object entry : value) {
                    entryCodec.encode(writer, entry, encoderContext);
                }
                writer.writeEndArray();
            }

            public ListValue<V> decode(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Object> entries = new ArrayList<Object>();
                reader.readStartArray();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    entries.add(entryCodec.decode(reader, decoderContext));
                }
                reader.readEndArray();
                try {
                    return (ListValue)ctor.newInstance(new Object[]{entries.toArray((Object[])Array.newInstance(entryClass, entries.size()))});
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IllegalStateException("Error reading " + listValueType, e);
                }
            }
        };
    }

    private static <R extends Entity> Codec<Reference<?>> referenceCodec(final Bosk<R> bosk) {
        return new Codec<Reference<?>>(){

            public Class<Reference<?>> getEncoderClass() {
                return Reference.class;
            }

            public void encode(BsonWriter writer, Reference<?> value, EncoderContext encoderContext) {
                writer.writeString(value.path().urlEncoded());
            }

            public Reference<?> decode(BsonReader reader, DecoderContext decoderContext) {
                String urlEncoded = reader.readString();
                try {
                    return bosk.reference(Object.class, Path.parse((String)urlEncoded));
                }
                catch (InvalidTypeException e) {
                    throw new UnexpectedPathException((Throwable)e);
                }
            }
        };
    }

    private <T extends StateTreeNode, R extends Entity> Codec<T> stateTreeNodeCodec(final Class<T> nodeClass, final CodecRegistry registry, final Bosk<R> bosk) {
        Constructor constructor = ReferenceUtils.theOnlyConstructorFor(nodeClass);
        final LinkedHashMap parametersByName = Stream.of(constructor.getParameters()).collect(Collectors.toMap(Parameter::getName, p -> p, (x, y) -> {
            throw new BsonFormatException("Two parameters with same name \"" + x.getName() + "\": " + x + "; " + y);
        }, LinkedHashMap::new));
        final MethodHandle writerHandle = this.computeAllFieldsWriterHandle(nodeClass, parametersByName, registry, bosk);
        final MethodHandle factoryHandle = BsonPlugin.computeFactoryHandle(constructor);
        return new Codec<T>(){

            public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
                writer.writeStartDocument();
                try {
                    writerHandle.invoke((StateTreeNode)value, writer, encoderContext);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Error encoding " + nodeClass + ": " + e.getMessage(), e);
                }
                writer.writeEndDocument();
            }

            public T decode(BsonReader reader, DecoderContext decoderContext) {
                reader.readStartDocument();
                Map parameterValuesByName = BsonPlugin.this.gatherParameterValuesByName(nodeClass, parametersByName, reader, decoderContext, registry, bosk);
                reader.readEndDocument();
                List parameterValues = BsonPlugin.this.parameterValueList(nodeClass, parameterValuesByName, parametersByName, bosk);
                try {
                    return factoryHandle.invoke(parameterValues.toArray());
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Error decoding " + nodeClass.getSimpleName() + ": " + e.getMessage(), e);
                }
            }

            public Class<T> getEncoderClass() {
                return nodeClass;
            }
        };
    }

    private <E extends Entity, R extends Entity> Codec<Catalog<E>> catalogCodec(final Type catalogType, final Class<Catalog<E>> catalogClass, final CodecRegistry registry, final Bosk<R> bosk) {
        Type entryType = ReferenceUtils.parameterType((Type)catalogType, Catalog.class, (int)0);
        final Class<Entity> entryClass = ReferenceUtils.rawClass((Type)entryType).asSubclass(Entity.class);
        final Codec<Entity> entryCodec = this.getCodec(entryType, entryClass, registry, bosk);
        return new Codec<Catalog<E>>(){

            public Class<Catalog<E>> getEncoderClass() {
                return catalogClass;
            }

            public void encode(BsonWriter writer, Catalog<E> value, EncoderContext encoderContext) {
                MethodHandle fieldWriter = this.catalogWriterHandle(entryClass, registry, bosk);
                try {
                    fieldWriter.invoke(value, writer, encoderContext);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Error encoding " + catalogType + ": " + e.getMessage(), e);
                }
            }

            public Catalog<E> decode(BsonReader reader, DecoderContext decoderContext) {
                reader.readStartDocument();
                ArrayList<Entity> entries = new ArrayList<Entity>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    Entity entry;
                    String fieldName = Formatter.undottedFieldNameSegment(reader.readName());
                    Identifier entryId = Identifier.from((String)fieldName);
                    try (SerializationPlugin.DeserializationScope s = BsonPlugin.this.innerDeserializationScope(fieldName);){
                        entry = (Entity)entryCodec.decode(reader, decoderContext);
                    }
                    if (entryId.equals((Object)entry.id())) {
                        entries.add(entry);
                        continue;
                    }
                    throw new BsonFormatException("Catalog entry ID mismatch: " + entryId + " vs " + entry.id());
                }
                reader.readEndDocument();
                Catalog result = Catalog.of(entries);
                if (result.size() > entries.size()) {
                    throw new BsonFormatException("Duplicate entry IDs in catalog");
                }
                return result;
            }

            private MethodHandle catalogWriterHandle(Class<? extends Entity> entryClass2, CodecRegistry codecRegistry, Bosk<R> bosk2) {
                return MethodHandles.collectArguments(WRITE_CATALOG, 0, BsonPlugin.this.codecSupplierHandle(entryClass2, codecRegistry, bosk2));
            }
        };
    }

    private <K extends Entity, V, R extends Entity> Codec<SideTable<K, V>> sideTableCodec(final Type sideTableType, final Class<SideTable<K, V>> sideTableClass, final CodecRegistry registry, final Bosk<R> bosk) {
        final Type valueType = ReferenceUtils.parameterType((Type)sideTableType, SideTable.class, (int)1);
        Class valueClass = ReferenceUtils.rawClass((Type)valueType);
        final Codec valueCodec = this.getCodec(valueType, valueClass, registry, bosk);
        final Codec<Reference> referenceCodec = this.getCodec((Type)((Object)Reference.class), (Class)Reference.class, registry, bosk);
        return new Codec<SideTable<K, V>>(){

            public Class<SideTable<K, V>> getEncoderClass() {
                return sideTableClass;
            }

            public void encode(BsonWriter writer, SideTable<K, V> value, EncoderContext encoderContext) {
                MethodHandle fieldWriter = this.sideTableWriterHandle(valueType, registry, bosk);
                try {
                    fieldWriter.invoke(value, writer, encoderContext);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Error encoding " + sideTableType + ": " + e.getMessage(), e);
                }
            }

            public SideTable<K, V> decode(BsonReader reader, DecoderContext decoderContext) {
                reader.readStartDocument();
                reader.readName("domain");
                Reference domain = (Reference)referenceCodec.decode(reader, decoderContext);
                reader.readName("valuesById");
                LinkedHashMap<Identifier, Object> valuesById = new LinkedHashMap<Identifier, Object>();
                reader.readStartDocument();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    Object value;
                    String fieldName = Formatter.undottedFieldNameSegment(reader.readName());
                    Identifier id = Identifier.from((String)fieldName);
                    try (SerializationPlugin.DeserializationScope s = BsonPlugin.this.innerDeserializationScope(fieldName);){
                        value = valueCodec.decode(reader, decoderContext);
                    }
                    Object old = valuesById.put(id, value);
                    if (old == null) continue;
                    throw new BsonFormatException("Duplicate IDs in sideTable: " + id);
                }
                reader.readEndDocument();
                reader.readEndDocument();
                return SideTable.fromOrderedMap((Reference)domain, valuesById);
            }

            private MethodHandle sideTableWriterHandle(Type valueType2, CodecRegistry codecRegistry, Bosk<R> bosk2) {
                return MethodHandles.collectArguments(MethodHandles.collectArguments(WRITE_SIDE_TABLE, 0, BsonPlugin.this.codecSupplierHandle(Reference.class, codecRegistry, bosk2)), 0, BsonPlugin.this.codecSupplierHandle(valueType2, codecRegistry, bosk2));
            }
        };
    }

    private <R extends Entity> Map<String, Object> gatherParameterValuesByName(Class<? extends StateTreeNode> nodeClass, Map<String, Parameter> parametersByName, BsonReader reader, DecoderContext decoderContext, CodecRegistry registry, Bosk<R> bosk) {
        HashMap<String, Object> parameterValuesByName = new HashMap<String, Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            Object value;
            String fieldName = reader.readName();
            Parameter parameter = parametersByName.get(fieldName);
            if (parameter == null) {
                if (LOGGER.isWarnEnabled() && ALREADY_WARNED.add(nodeClass.getName() + " " + fieldName)) {
                    LOGGER.warn("Ignoring unrecognized field \"{}\" in {}", (Object)fieldName, (Object)nodeClass.getSimpleName());
                }
                reader.skipValue();
                continue;
            }
            try (SerializationPlugin.DeserializationScope s = this.nodeFieldDeserializationScope(nodeClass, fieldName);){
                value = this.decodeValue(parameter.getParameterizedType(), reader, decoderContext, registry, bosk);
            }
            Object old = parameterValuesByName.put(fieldName, value);
            if (old == null) continue;
            throw new BsonFormatException("Hey, two " + fieldName + " fields");
        }
        return parameterValuesByName;
    }

    private <R extends Entity> Object decodeValue(Type valueType, BsonReader reader, DecoderContext decoderContext, CodecRegistry registry, Bosk<R> bosk) {
        Optional<Object> value;
        Class valueClass = ReferenceUtils.rawClass((Type)valueType);
        if (Phantom.class.isAssignableFrom(valueClass)) {
            throw new BsonFormatException("Unexpected Phantom field");
        }
        if (Optional.class.isAssignableFrom(valueClass)) {
            Type contentsType = ReferenceUtils.parameterType((Type)valueType, Optional.class, (int)0);
            value = Optional.of(this.decodeValue(contentsType, reader, decoderContext, registry, bosk));
        } else {
            value = this.getCodec(valueType, valueClass, registry, bosk).decode(reader, decoderContext);
        }
        return value;
    }

    private <T extends StateTreeNode, R extends Entity> MethodHandle computeAllFieldsWriterHandle(Class<T> nodeClass, Map<String, Parameter> parametersByName, CodecRegistry codecRegistry, Bosk<R> bosk) {
        MethodHandle handleUnderConstruction = BsonPlugin.writeNothingHandle(nodeClass);
        for (Map.Entry<String, Parameter> e : parametersByName.entrySet()) {
            MethodHandle getter;
            String name = e.getKey();
            Parameter parameter = e.getValue();
            try {
                getter = LOOKUP.unreflect(ReferenceUtils.getterMethod(nodeClass, (String)name));
            }
            catch (InvalidTypeException | IllegalAccessException e1) {
                throw new IllegalStateException("Eh?", e1);
            }
            MethodHandle fieldWriter = this.parameterWriterHandle(nodeClass, name, parameter, codecRegistry, bosk);
            MethodHandle writerCall = MethodHandles.filterArguments(fieldWriter, 0, getter);
            MethodHandle nestedCall = MethodHandles.collectArguments(writerCall, 0, handleUnderConstruction);
            handleUnderConstruction = MethodHandles.permuteArguments(nestedCall, writerCall.type(), 0, 1, 2, 0, 1, 2);
        }
        return handleUnderConstruction;
    }

    private <R extends Entity> MethodHandle parameterWriterHandle(Class<?> nodeClass, String name, Parameter parameter, CodecRegistry codecRegistry, Bosk<R> bosk) {
        if (BsonPlugin.isImplicitParameter(nodeClass, (Parameter)parameter)) {
            return BsonPlugin.writeNothingHandle(parameter.getType());
        }
        return this.valueWriterHandle(name, parameter.getParameterizedType(), codecRegistry, bosk);
    }

    private <R extends Entity> MethodHandle valueWriterHandle(String name, Type valueType, CodecRegistry codecRegistry, Bosk<R> bosk) {
        MethodHandle fieldWriter;
        Class valueClass = ReferenceUtils.rawClass((Type)valueType);
        if (Phantom.class.isAssignableFrom(valueClass)) {
            return BsonPlugin.writeNothingHandle(valueClass);
        }
        if (Optional.class.isAssignableFrom(valueClass)) {
            Type contentsType = ReferenceUtils.parameterType((Type)valueType, Optional.class, (int)0);
            MethodHandle contentsWriter = this.valueWriterHandle(name, contentsType, codecRegistry, bosk);
            MethodHandle unwrapper = MethodHandles.filterArguments(contentsWriter, 0, OPTIONAL_GET.asType(OPTIONAL_GET.type().changeReturnType(ReferenceUtils.rawClass((Type)contentsType))));
            fieldWriter = MethodHandles.guardWithTest(OPTIONAL_IS_PRESENT, unwrapper, BsonPlugin.writeNothingHandle(Optional.class));
        } else {
            MethodHandle customized = MethodHandles.collectArguments(MethodHandles.insertArguments(WRITE_FIELD, 0, name), 0, this.codecSupplierHandle(valueType, codecRegistry, bosk));
            fieldWriter = customized.asType(customized.type().changeParameterType(0, valueClass));
        }
        return fieldWriter;
    }

    private MethodHandle codecSupplierHandle(Type targetType, CodecRegistry codecRegistry, Bosk<?> bosk) {
        Class targetClass = ReferenceUtils.rawClass((Type)targetType);
        if (targetClass.getTypeParameters().length >= 1 && !(targetType instanceof ParameterizedType) && !EASYGOING_GENERICS.contains(targetClass)) {
            throw new AssertionError((Object)("Class " + targetClass.getSimpleName() + " requires type parameters"));
        }
        return MethodHandles.insertArguments(GET_ANY_CODEC, 0, new Object[]{this, targetType, targetClass, codecRegistry, bosk});
    }

    private static MethodHandle writeNothingHandle(Class<?> nodeClass) {
        return MethodHandles.explicitCastArguments(WRITE_NOTHING, WRITE_NOTHING.type().changeParameterType(0, nodeClass));
    }

    private static <F> void writeField(String name, Codec<F> codec, F fieldValue, BsonWriter writer, EncoderContext encoderContext) {
        writer.writeName(name);
        codec.encode(writer, fieldValue, encoderContext);
    }

    private static <E extends Entity> void writeCatalog(Codec<E> entryCodec, Catalog<E> catalog, BsonWriter writer, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Entity entry : catalog) {
            writer.writeName(Formatter.dottedFieldNameSegment(entry.id().toString()));
            entryCodec.encode(writer, (Object)entry, encoderContext);
        }
        writer.writeEndDocument();
    }

    private static <K extends Entity, V> void writeSideTable(Codec<Reference<?>> referenceCodec, Codec<V> valueCodec, SideTable<K, V> sideTable, BsonWriter writer, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeName("domain");
        referenceCodec.encode(writer, (Object)sideTable.domain(), encoderContext);
        writer.writeName("valuesById");
        writer.writeStartDocument();
        for (Map.Entry entry : sideTable.idEntrySet()) {
            writer.writeName(Formatter.dottedFieldNameSegment(((Identifier)entry.getKey()).toString()));
            valueCodec.encode(writer, entry.getValue(), encoderContext);
        }
        writer.writeEndDocument();
        writer.writeEndDocument();
    }

    private static void writeNothing(Object node, BsonWriter writer, EncoderContext context) {
    }

    static {
        try {
            WRITE_FIELD = LOOKUP.findStatic(BsonPlugin.class, "writeField", MethodType.methodType(Void.TYPE, String.class, Codec.class, Object.class, BsonWriter.class, EncoderContext.class));
            WRITE_CATALOG = LOOKUP.findStatic(BsonPlugin.class, "writeCatalog", MethodType.methodType(Void.TYPE, Codec.class, Catalog.class, BsonWriter.class, EncoderContext.class));
            WRITE_SIDE_TABLE = LOOKUP.findStatic(BsonPlugin.class, "writeSideTable", MethodType.methodType(Void.TYPE, Codec.class, Codec.class, SideTable.class, BsonWriter.class, EncoderContext.class));
            WRITE_NOTHING = LOOKUP.findStatic(BsonPlugin.class, "writeNothing", MethodType.methodType(Void.TYPE, Object.class, BsonWriter.class, EncoderContext.class));
            GET_ANY_CODEC = LOOKUP.findVirtual(BsonPlugin.class, "getAnyCodec", MethodType.methodType(Codec.class, Type.class, Class.class, CodecRegistry.class, Bosk.class));
            OPTIONAL_IS_PRESENT = LOOKUP.findVirtual(Optional.class, "isPresent", MethodType.methodType(Boolean.TYPE));
            OPTIONAL_GET = LOOKUP.findVirtual(Optional.class, "get", MethodType.methodType(Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError("Unexpected failure on MethodHandle lookup", e);
        }
    }
}

