/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import io.vena.bosk.Bosk;
import io.vena.bosk.Listing;
import io.vena.bosk.Reference;
import io.vena.bosk.ReferenceUtils;
import io.vena.bosk.SerializationPlugin;
import io.vena.bosk.SideTable;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.exceptions.InvalidTypeException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

final class Formatter {
    private final CodecRegistry simpleCodecs;
    private final Function<Type, Codec<?>> preferredBoskCodecs;
    private final Function<Reference<?>, SerializationPlugin.DeserializationScope> deserializationScopeFunction;
    private static final UnaryOperator<String> DECODER = s -> {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    };
    private static final UnaryOperator<String> ENCODER = s -> s.replace("%", "%25").replace("$", "%24").replace(".", "%2E");

    Formatter(Bosk<?> bosk, BsonPlugin bsonPlugin) {
        this.simpleCodecs = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{bsonPlugin.codecProviderFor(bosk), new ValueCodecProvider(), new DocumentCodecProvider()});
        this.preferredBoskCodecs = type -> bsonPlugin.getCodec((Type)type, ReferenceUtils.rawClass((Type)type), this.simpleCodecs, bosk);
        this.deserializationScopeFunction = arg_0 -> ((BsonPlugin)bsonPlugin).newDeserializationScope(arg_0);
    }

    Codec<?> codecFor(Type type) {
        Codec<?> result = this.preferredBoskCodecs.apply(type);
        if (result == null) {
            return this.simpleCodecs.get(ReferenceUtils.rawClass((Type)type));
        }
        return result;
    }

    <T> T document2object(Document document, Reference<T> target) {
        BsonDocument doc = document.toBsonDocument(BsonDocument.class, this.simpleCodecs);
        Type type = target.targetType();
        Class objectClass = ReferenceUtils.rawClass((Type)type);
        Codec<?> objectCodec = this.codecFor(type);
        try (SerializationPlugin.DeserializationScope scope = this.deserializationScopeFunction.apply(target);){
            Object t = objectClass.cast(objectCodec.decode(doc.asBsonReader(), DecoderContext.builder().build()));
            return t;
        }
    }

    <T> BsonValue object2bsonValue(T object, Type type) {
        ReferenceUtils.rawClass((Type)type).cast(object);
        Codec<?> objectCodec = this.codecFor(type);
        BsonDocument document = new BsonDocument();
        try (BsonDocumentWriter writer = new BsonDocumentWriter(document);){
            writer.writeStartDocument();
            writer.writeName("value");
            objectCodec.encode((BsonWriter)writer, object, EncoderContext.builder().build());
            writer.writeEndDocument();
        }
        return document.get((Object)"value");
    }

    /*
     * Exception decompiling
     */
    <T> T bsonValue2object(BsonValue bson, Reference<T> target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static <T> String dottedFieldNameOf(Reference<T> ref, Reference<?> startingRef) {
        assert (startingRef.path().isPrefixOf(ref.path())) : "'" + ref + "' must be under '" + startingRef + "'";
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(DocumentFields.state.name());
        Formatter.buildDottedFieldNameOf(ref, startingRef.path().length(), segments);
        return String.join((CharSequence)".", segments.toArray(new String[0]));
    }

    private static <T> void buildDottedFieldNameOf(Reference<T> ref, int startingRefLength, ArrayList<String> segments) {
        if (ref.path().length() > startingRefLength) {
            Reference<?> enclosingReference = Formatter.enclosingReference(ref);
            Formatter.buildDottedFieldNameOf(enclosingReference, startingRefLength, segments);
            if (Listing.class.isAssignableFrom(enclosingReference.targetClass())) {
                segments.add("ids");
            } else if (SideTable.class.isAssignableFrom(enclosingReference.targetClass())) {
                segments.add("valuesById");
            }
            segments.add((String)ENCODER.apply(ref.path().lastSegment()));
        }
    }

    static <T> Reference<T> referenceTo(String dottedName, Reference<?> startingReference) throws InvalidTypeException {
        Reference ref = startingReference;
        Iterator<String> iter = Arrays.asList(dottedName.split(Pattern.quote("."))).iterator();
        Formatter.skipField(ref, iter, DocumentFields.state.name());
        while (iter.hasNext()) {
            if (Listing.class.isAssignableFrom(ref.targetClass())) {
                Formatter.skipField(ref, iter, "ids");
            } else if (SideTable.class.isAssignableFrom(ref.targetClass())) {
                Formatter.skipField(ref, iter, "valuesById");
            }
            if (!iter.hasNext()) continue;
            String segment = (String)DECODER.apply(iter.next());
            ref = ref.then(Object.class, new String[]{segment});
        }
        return ref;
    }

    private static void skipField(Reference<?> ref, Iterator<String> iter, String expectedName) {
        String actualName;
        try {
            actualName = iter.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Expected '" + expectedName + "' for " + ref.targetClass().getSimpleName() + "; encountered end of dotted field name");
        }
        if (!expectedName.equals(actualName)) {
            throw new IllegalStateException("Expected '" + expectedName + "' for " + ref.targetClass().getSimpleName() + "; was: " + actualName);
        }
    }

    static <T> Reference<?> enclosingReference(Reference<T> ref) {
        assert (!ref.path().isEmpty());
        try {
            return ref.enclosingReference(Object.class);
        }
        catch (InvalidTypeException e) {
            throw new AssertionError(String.format("Reference must have an enclosing Object: '%s'", ref), e);
        }
    }

    static enum DocumentFields {
        state,
        echo;

    }
}

