/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.DriverFactory;
import io.vena.bosk.Entity;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.Formatter;
import io.vena.bosk.drivers.mongo.MongoChangeStreamReceiver;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.MongoReceiver;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import io.vena.bosk.exceptions.NotYetImplementedException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDriver<R extends Entity>
implements BoskDriver<R> {
    private final String description;
    private final MongoDriverSettings settings;
    private final Formatter formatter;
    private final MongoReceiver<R> receiver;
    private final MongoClient mongoClient;
    private final MongoCollection<Document> collection;
    private final BsonString documentID;
    private final Reference<R> rootRef;
    private final String echoPrefix;
    private final AtomicLong echoCounter = new AtomicLong(1000000000000L);
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDriver.class);

    public MongoDriver(Bosk<R> bosk, MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin, BoskDriver<R> downstream) {
        this.validateMongoClientSettings(clientSettings);
        this.description = MongoDriver.class.getSimpleName() + ": " + driverSettings;
        this.settings = driverSettings;
        this.mongoClient = MongoClients.create((MongoClientSettings)clientSettings);
        this.formatter = new Formatter(bosk, bsonPlugin);
        this.collection = this.mongoClient.getDatabase(driverSettings.database()).getCollection(driverSettings.collection());
        this.receiver = new MongoChangeStreamReceiver<R>(downstream, bosk.rootReference(), this.collection, this.formatter);
        this.echoPrefix = bosk.instanceID().toString();
        this.documentID = new BsonString("boskDocument");
        this.rootRef = bosk.rootReference();
    }

    public static <RR extends Entity> DriverFactory<RR> factory(MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin) {
        return (b, d) -> new MongoDriver(b, clientSettings, driverSettings, bsonPlugin, d);
    }

    private void validateMongoClientSettings(MongoClientSettings clientSettings) {
        if (clientSettings.getReadConcern() != ReadConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify ReadConcern.MAJORITY");
        }
        if (clientSettings.getWriteConcern() != WriteConcern.MAJORITY) {
            throw new IllegalArgumentException("MongoDriver requires MongoClientSettings to specify WriteConcern.MAJORITY");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R initialRoot(Type rootType) throws InvalidTypeException, IOException, InterruptedException {
        LOGGER.debug("+ initialRoot");
        this.flushToChangeStreamReceiver();
        try (MongoCursor cursor = this.collection.find((Bson)this.documentFilter()).limit(1).cursor();){
            Document newDocument = (Document)cursor.next();
            Document newState = (Document)newDocument.get((Object)Formatter.DocumentFields.state.name(), Document.class);
            if (newState != null) {
                LOGGER.debug("| From database: {}", (Object)newState);
                Entity entity = (Entity)this.formatter.document2object(newState, this.rootRef);
                return (R)entity;
            }
            LOGGER.debug("| No existing state; delegating downstream");
        }
        catch (NoSuchElementException e) {
            LOGGER.debug("| No tenant document; delegating downstream");
        }
        R root = this.receiver.initialRoot(rootType);
        this.ensureTenantDocumentExists(this.formatter.object2bsonValue(root, rootType));
        return root;
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        LOGGER.debug("+ submitReplacement({})", target);
        this.doUpdate(this.replacementDoc(target, newValue), this.standardPreconditions(target));
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        LOGGER.debug("+ submitInitialization({})", target);
        BsonDocument filter = this.standardPreconditions(target);
        filter.put(Formatter.dottedFieldNameOf(target, this.rootRef), (BsonValue)new BsonDocument("$exists", (BsonValue)BsonBoolean.FALSE));
        if (this.doUpdate(this.replacementDoc(target, newValue), filter)) {
            LOGGER.debug("| Object initialized");
        } else {
            LOGGER.debug("| No update");
        }
    }

    public <T> void submitDeletion(Reference<T> target) {
        LOGGER.debug("+ submitDeletion({})", target);
        if (target.path().isEmpty()) {
            throw new IllegalArgumentException("Can't delete the root of the bosk");
        }
        this.doUpdate(this.deletionDoc(target), this.standardPreconditions(target));
    }

    public void flush() throws IOException, InterruptedException {
        LOGGER.debug("+ flush");
        this.flushToChangeStreamReceiver();
        this.receiver.flushDownstream();
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        LOGGER.debug("+ submitConditionalReplacement({}, {} = {})", new Object[]{target, precondition, requiredValue});
        this.doUpdate(this.replacementDoc(target, newValue), this.explicitPreconditions(target, precondition, requiredValue));
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        LOGGER.debug("+ submitConditionalDeletion({}, {} = {})", new Object[]{target, precondition, requiredValue});
        this.doUpdate(this.deletionDoc(target), this.explicitPreconditions(target, precondition, requiredValue));
    }

    public void close() {
        try {
            this.receiver.close();
        }
        finally {
            this.mongoClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refurbish() {
        ClientSessionOptions sessionOptions = ClientSessionOptions.builder().causallyConsistent(true).defaultTransactionOptions(TransactionOptions.builder().writeConcern(WriteConcern.MAJORITY).readConcern(ReadConcern.MAJORITY).build()).build();
        try (ClientSession session = this.mongoClient.startSession(sessionOptions);){
            try {
                Document newState;
                session.startTransaction();
                try (MongoCursor cursor = this.collection.find((Bson)this.documentFilter()).limit(1).cursor();){
                    Document newDocument = (Document)cursor.next();
                    newState = (Document)newDocument.get((Object)Formatter.DocumentFields.state.name(), Document.class);
                }
                catch (NoSuchElementException e) {
                    LOGGER.debug("No document to refurbish", (Throwable)e);
                    if (session.hasActiveTransaction()) {
                        session.abortTransaction();
                    }
                    if (session != null) {
                        if (var3_3 != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable) {
                                var3_3.addSuppressed(throwable);
                            }
                        } else {
                            session.close();
                        }
                    }
                    return;
                }
                if (newState == null) {
                    LOGGER.debug("No state to refurbish");
                    return;
                }
                Entity root = (Entity)this.formatter.document2object(newState, this.rootRef);
                this.doUpdate(this.replacementDoc(this.rootRef, root), this.documentFilter());
                session.commitTransaction();
            }
            finally {
                if (session.hasActiveTransaction()) {
                    session.abortTransaction();
                }
            }
        }
    }

    private BsonDocument documentFilter() {
        return new BsonDocument("_id", (BsonValue)this.documentID);
    }

    private <T> BsonDocument standardPreconditions(Reference<T> target) {
        BsonDocument filter = this.documentFilter();
        if (!target.path().isEmpty()) {
            String enclosingObjectKey = Formatter.dottedFieldNameOf(Formatter.enclosingReference(target), this.rootRef);
            BsonDocument condition = new BsonDocument("$type", (BsonValue)new BsonString("object"));
            filter.put(enclosingObjectKey, (BsonValue)condition);
            LOGGER.debug("| Precondition: {} {}", (Object)enclosingObjectKey, (Object)condition);
        }
        return filter;
    }

    private <T> BsonDocument explicitPreconditions(Reference<T> target, Reference<Identifier> preconditionRef, Identifier requiredValue) {
        BsonDocument filter = this.standardPreconditions(target);
        BsonDocument precondition = new BsonDocument("$eq", (BsonValue)new BsonString(requiredValue.toString()));
        filter.put(Formatter.dottedFieldNameOf(preconditionRef, this.rootRef), (BsonValue)precondition);
        return filter;
    }

    private <T> BsonDocument replacementDoc(Reference<T> target, T newValue) {
        String key = Formatter.dottedFieldNameOf(target, this.rootRef);
        BsonValue value = this.formatter.object2bsonValue(newValue, target.targetType());
        LOGGER.debug("| Set field {}: {}", (Object)key, (Object)value);
        return new BsonDocument("$set", (BsonValue)new BsonDocument(key, value));
    }

    private <T> BsonDocument deletionDoc(Reference<T> target) {
        String key = Formatter.dottedFieldNameOf(target, this.rootRef);
        LOGGER.debug("| Unset field {}", (Object)key);
        return new BsonDocument("$unset", (BsonValue)new BsonDocument(key, (BsonValue)new BsonNull()));
    }

    private void ensureTenantDocumentExists(BsonValue initialState) {
        UpdateResult result;
        BsonDocument filter = this.documentFilter();
        BsonDocument update = this.initialTenantUpsert(initialState);
        UpdateOptions options = new UpdateOptions();
        options.upsert(true);
        LOGGER.debug("** Initial tenant upsert for {}", (Object)this.documentID);
        LOGGER.trace("| Filter: {}", (Object)filter);
        LOGGER.trace("| Update: {}", (Object)update);
        LOGGER.trace("| Options: {}", (Object)options);
        try {
            result = this.collection.updateOne((Bson)filter, (Bson)update, options);
        }
        catch (MongoWriteException e) {
            if (ErrorCategory.DUPLICATE_KEY == ErrorCategory.fromErrorCode((int)e.getCode())) {
                LOGGER.debug("| Retrying: {}", (Object)e.getMessage());
                result = this.collection.updateOne((Bson)filter, (Bson)update, options);
            }
            throw e;
        }
        LOGGER.debug("| Result: {}", (Object)result);
    }

    BsonDocument initialTenantUpsert(BsonValue initialState) {
        BsonDocument fieldValues = new BsonDocument("_id", (BsonValue)this.documentID);
        fieldValues.put(Formatter.DocumentFields.state.name(), initialState);
        fieldValues.put(Formatter.DocumentFields.echo.name(), (BsonValue)new BsonString(this.uniqueEchoToken()));
        return new BsonDocument("$setOnInsert", (BsonValue)fieldValues);
    }

    private boolean doUpdate(BsonDocument updateDoc, BsonDocument filter) {
        LOGGER.debug("| Update: {}", (Object)updateDoc);
        LOGGER.debug("| Filter: {}", (Object)filter);
        UpdateResult result = this.collection.updateOne((Bson)filter, (Bson)updateDoc);
        LOGGER.debug("| Update result: {}", (Object)result);
        if (result.wasAcknowledged()) {
            assert (result.getMatchedCount() <= 1L);
            return result.getMatchedCount() >= 1L;
        }
        LOGGER.error("Mongo write was not acknowledged.\n\tFilter: {}\n\tUpdate: {}\n\tResult: {}", new Object[]{filter, updateDoc, result});
        throw new NotYetImplementedException("Mongo write was not acknowledged");
    }

    private String uniqueEchoToken() {
        return String.format("%s_%012d", this.echoPrefix, this.echoCounter.addAndGet(1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToChangeStreamReceiver() throws InterruptedException, FlushFailureException {
        String echoToken = this.uniqueEchoToken();
        ArrayBlockingQueue<BsonDocument> listener = new ArrayBlockingQueue<BsonDocument>(1);
        try {
            this.receiver.putEchoListener(echoToken, listener);
            BsonDocument updateDoc = new BsonDocument("$set", (BsonValue)new BsonDocument(Formatter.DocumentFields.echo.name(), (BsonValue)new BsonString(echoToken)));
            LOGGER.debug("| Update: {}", (Object)updateDoc);
            UpdateResult result = this.collection.updateOne((Bson)this.documentFilter(), (Bson)updateDoc);
            if (result.getModifiedCount() == 0L) {
                LOGGER.debug("Document does not exist; echo succeeds trivially. Response: {}", (Object)result);
                return;
            }
            LOGGER.debug("| Waiting");
            BsonDocument resumeToken = (BsonDocument)listener.poll(this.settings.flushTimeoutMS(), TimeUnit.MILLISECONDS);
            if (resumeToken == null) {
                throw new FlushFailureException("No flush response after " + this.settings.flushTimeoutMS() + "ms");
            }
            MongoResumeTokenSequenceMark sequenceMark = new MongoResumeTokenSequenceMark(resumeToken.getString((Object)"_data").getValue());
            LOGGER.debug("| SequenceMark: {}", (Object)sequenceMark);
        }
        finally {
            this.receiver.removeEchoListener(echoToken);
        }
    }

    public String toString() {
        return this.description;
    }

    private static final class MongoResumeTokenSequenceMark {
        private final String tokenData;

        public String toString() {
            return this.tokenData;
        }

        @ConstructorProperties(value={"tokenData"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MongoResumeTokenSequenceMark(String tokenData) {
            this.tokenData = tokenData;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getTokenData() {
            return this.tokenData;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MongoResumeTokenSequenceMark)) {
                return false;
            }
            MongoResumeTokenSequenceMark other = (MongoResumeTokenSequenceMark)o;
            String this$tokenData = this.getTokenData();
            String other$tokenData = other.getTokenData();
            return !(this$tokenData == null ? other$tokenData != null : !this$tokenData.equals(other$tokenData));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tokenData = this.getTokenData();
            result = result * 59 + ($tokenData == null ? 43 : $tokenData.hashCode());
            return result;
        }
    }
}

