/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo.status;

import io.vena.bosk.drivers.mongo.status.Difference;
import io.vena.bosk.drivers.mongo.status.MultipleDifferences;
import io.vena.bosk.drivers.mongo.status.NoDifference;
import io.vena.bosk.drivers.mongo.status.NodeMissing;
import io.vena.bosk.drivers.mongo.status.PrimitiveDifference;
import io.vena.bosk.drivers.mongo.status.UnexpectedNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class BsonComparator {
    public static final int MAX_DIFFERENCES = 4;

    public Difference difference(BsonValue expected, BsonValue actual) {
        if (expected.getBsonType() != actual.getBsonType()) {
            return new PrimitiveDifference("");
        }
        if (expected instanceof BsonDocument) {
            BsonDocument expectedDoc = (BsonDocument)expected;
            if (actual instanceof BsonDocument) {
                BsonValue expectedValue;
                BsonDocument actualDoc = (BsonDocument)actual;
                ArrayList<Difference> differences = new ArrayList<Difference>();
                for (String expectedKey : expectedDoc.keySet()) {
                    expectedValue = expectedDoc.get((Object)expectedKey);
                    BsonValue actualValue = actualDoc.get((Object)expectedKey);
                    if (actualValue == null) {
                        differences.add(new NodeMissing(expectedKey));
                    } else {
                        Difference fieldDifference = this.difference(expectedValue, actualValue);
                        if (!(fieldDifference instanceof NoDifference)) {
                            differences.add(fieldDifference.withPrefix(expectedKey));
                        }
                    }
                    if (differences.size() < 4) continue;
                    break;
                }
                for (Map.Entry entry : actualDoc.entrySet()) {
                    expectedValue = expectedDoc.get(entry.getKey());
                    if (expectedValue == null) {
                        differences.add(new UnexpectedNode((String)entry.getKey()));
                    }
                    if (differences.size() < 4) continue;
                    break;
                }
                return switch (differences.size()) {
                    case 0 -> new NoDifference();
                    case 1 -> (Difference)differences.get(0);
                    default -> {
                        int numCompounds = 0;
                        Iterator iter = differences.iterator();
                        while (iter.hasNext()) {
                            Difference difference = (Difference)iter.next();
                            if (!(difference instanceof MultipleDifferences)) continue;
                            if (numCompounds == 0) {
                                ++numCompounds;
                                continue;
                            }
                            iter.remove();
                        }
                        yield new MultipleDifferences("", differences);
                    }
                };
            }
        }
        if (expected.equals(actual)) {
            return new NoDifference();
        }
        return new PrimitiveDifference("");
    }
}

