/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.UpdateDescription;
import io.vena.bosk.BoskInfo;
import io.vena.bosk.Listing;
import io.vena.bosk.MapValue;
import io.vena.bosk.Reference;
import io.vena.bosk.ReferenceUtils;
import io.vena.bosk.SerializationPlugin;
import io.vena.bosk.SideTable;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.Manifest;
import io.vena.bosk.drivers.mongo.UnrecognizedFormatException;
import io.vena.bosk.exceptions.InvalidTypeException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Formatter {
    private final CodecRegistry simpleCodecs;
    private final Function<Type, Codec<?>> preferredBoskCodecs;
    private final Function<Reference<?>, SerializationPlugin.DeserializationScope> deserializationScopeFunction;
    private volatile MapValue<String> lastEventDiagnosticAttributes = MapValue.empty();
    static final BsonInt64 REVISION_ZERO = new BsonInt64(0L);
    static final BsonInt64 REVISION_ONE = new BsonInt64(1L);
    private final BsonInt32 SUPPORTED_MANIFEST_VERSION = new BsonInt32(1);
    private static final UnaryOperator<String> DECODER = s -> {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    };
    private static final UnaryOperator<String> ENCODER = s -> {
        int cp;
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            switch (cp) {
                case 0: 
                case 32: 
                case 33: 
                case 36: 
                case 37: 
                case 43: 
                case 46: 
                case 91: 
                case 93: 
                case 124: 
                case 126: {
                    Formatter.appendPercentEncoded(sb, cp);
                    continue block3;
                }
                default: {
                    sb.appendCodePoint(cp);
                }
            }
        }
        return sb.toString();
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(Formatter.class);

    Formatter(BoskInfo<?> boskInfo, BsonPlugin bsonPlugin) {
        this.simpleCodecs = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{bsonPlugin.codecProviderFor(boskInfo), new ValueCodecProvider(), new DocumentCodecProvider()});
        this.preferredBoskCodecs = type -> bsonPlugin.getCodec((Type)type, ReferenceUtils.rawClass((Type)type), this.simpleCodecs, boskInfo);
        this.deserializationScopeFunction = arg_0 -> ((BsonPlugin)bsonPlugin).newDeserializationScope(arg_0);
    }

    Codec<?> codecFor(Type type) {
        Codec<?> result = this.preferredBoskCodecs.apply(type);
        if (result == null) {
            return this.simpleCodecs.get(ReferenceUtils.rawClass((Type)type));
        }
        return result;
    }

    <T> T document2object(BsonDocument doc, Reference<T> target) {
        Type type = target.targetType();
        Class objectClass = ReferenceUtils.rawClass((Type)type);
        Codec<?> objectCodec = this.codecFor(type);
        try (SerializationPlugin.DeserializationScope scope = this.deserializationScopeFunction.apply(target);){
            Object t = objectClass.cast(objectCodec.decode(doc.asBsonReader(), DecoderContext.builder().build()));
            return t;
        }
    }

    void validateManifest(BsonDocument manifest) throws UnrecognizedFormatException {
        try {
            HashSet keys = new HashSet(manifest.keySet());
            List<String> supportedFormats = Arrays.asList("sequoia", "pando");
            String detectedFormat = null;
            for (String format : supportedFormats) {
                if (!keys.remove(format)) continue;
                if (detectedFormat == null) {
                    detectedFormat = format;
                    continue;
                }
                throw new UnrecognizedFormatException("Found two supported formats: " + detectedFormat + " and " + format);
            }
            if (detectedFormat == null) {
                throw new UnrecognizedFormatException("Found none of the supported formats: " + supportedFormats);
            }
            HashSet<String> requiredKeys = new HashSet<String>(Collections.singletonList("version"));
            if (!keys.equals(requiredKeys)) {
                keys.removeAll(requiredKeys);
                if (keys.isEmpty()) {
                    requiredKeys.removeAll(manifest.keySet());
                    throw new UnrecognizedFormatException("Missing keys in manifest: " + requiredKeys);
                }
                throw new UnrecognizedFormatException("Unrecognized keys in manifest: " + keys);
            }
            if (!this.SUPPORTED_MANIFEST_VERSION.equals((Object)manifest.getInt32((Object)"version"))) {
                throw new UnrecognizedFormatException("Manifest version " + manifest.getInt32((Object)"version") + " not suppoted");
            }
        }
        catch (ClassCastException e) {
            throw new UnrecognizedFormatException("Manifest field has unexpected type", e);
        }
    }

    Manifest decodeManifest(BsonDocument manifestDoc) throws UnrecognizedFormatException {
        BsonDocument manifest = manifestDoc.clone();
        manifest.remove((Object)"_id");
        this.validateManifest(manifest);
        return (Manifest)this.codecFor((Type)((Object)Manifest.class)).decode((BsonReader)new BsonDocumentReader(manifest), DecoderContext.builder().build());
    }

    BsonDocument encodeDiagnostics(MapValue<String> attributes) {
        BsonDocument result = new BsonDocument();
        attributes.forEach((name, value) -> result.put(name, (BsonValue)new BsonString(value)));
        return new BsonDocument("attributes", (BsonValue)result);
    }

    MapValue<String> decodeDiagnosticAttributes(BsonDocument diagnostics) {
        MapValue result = MapValue.empty();
        for (Map.Entry foo : diagnostics.getDocument((Object)"attributes").entrySet()) {
            String name = (String)foo.getKey();
            String value = ((BsonValue)foo.getValue()).asString().getValue();
            result = result.with(name, (Object)value);
        }
        return result;
    }

    <T> BsonValue object2bsonValue(T object, Type type) {
        ReferenceUtils.rawClass((Type)type).cast(object);
        Codec<?> objectCodec = this.codecFor(type);
        BsonDocument document = new BsonDocument();
        try (BsonDocumentWriter writer = new BsonDocumentWriter(document);){
            writer.writeStartDocument();
            writer.writeName("value");
            objectCodec.encode((BsonWriter)writer, object, EncoderContext.builder().build());
            writer.writeEndDocument();
        }
        return document.get((Object)"value");
    }

    <T> T bsonValue2object(BsonValue bson, Reference<T> target) {
        Codec<?> objectCodec = this.codecFor(target.targetType());
        BsonDocument document = new BsonDocument();
        document.append("value", bson);
        try (SerializationPlugin.DeserializationScope scope = this.deserializationScopeFunction.apply(target);){
            Object object;
            block12: {
                BsonReader reader = document.asBsonReader();
                try {
                    reader.readStartDocument();
                    reader.readName("value");
                    object = objectCodec.decode(reader, DecoderContext.builder().build());
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return (T)object;
        }
    }

    long bsonValueBinarySize(BsonValue bson) {
        BsonValueCodec codec = new BsonValueCodec();
        try (BasicOutputBuffer buffer = new BasicOutputBuffer();){
            long l;
            try (BsonBinaryWriter w = new BsonBinaryWriter((BsonOutput)buffer);){
                codec.encode((BsonWriter)w, (Object)bson, EncoderContext.builder().build());
                l = buffer.getPosition();
            }
            return l;
        }
    }

    BsonInt64 getRevisionFromFullDocument(BsonDocument fullDocument) {
        if (fullDocument == null) {
            return null;
        }
        return fullDocument.getInt64((Object)DocumentFields.revision.name(), null);
    }

    @NonNull
    MapValue<String> eventDiagnosticAttributesFromFullDocument(BsonDocument fullDocument) {
        return this.getOrSetEventDiagnosticAttributes(this.getDiagnosticAttributesFromFullDocument(fullDocument));
    }

    MapValue<String> getDiagnosticAttributesFromFullDocument(BsonDocument fullDocument) {
        BsonDocument diagnostics = Formatter.getDiagnosticAttributesIfAny(fullDocument);
        return diagnostics == null ? null : this.decodeDiagnosticAttributes(diagnostics);
    }

    BsonInt64 getRevisionFromUpdateEvent(ChangeStreamDocument<BsonDocument> event) {
        BsonDocument updatedFields = Formatter.getUpdatedFieldsIfAny(event);
        if (updatedFields == null) {
            return null;
        }
        return updatedFields.getInt64((Object)DocumentFields.revision.name(), null);
    }

    @NonNull
    MapValue<String> eventDiagnosticAttributesFromUpdate(ChangeStreamDocument<BsonDocument> event) {
        return this.getOrSetEventDiagnosticAttributes(this.getDiagnosticAttributesFromUpdateEvent(event));
    }

    MapValue<String> getDiagnosticAttributesFromUpdateEvent(ChangeStreamDocument<BsonDocument> event) {
        BsonDocument updatedFields = Formatter.getUpdatedFieldsIfAny(event);
        BsonDocument diagnostics = Formatter.getDiagnosticAttributesIfAny(updatedFields);
        return diagnostics == null ? null : this.decodeDiagnosticAttributes(diagnostics);
    }

    private static BsonDocument getUpdatedFieldsIfAny(ChangeStreamDocument<BsonDocument> event) {
        if (event == null) {
            return null;
        }
        UpdateDescription updateDescription = event.getUpdateDescription();
        if (updateDescription == null) {
            return null;
        }
        return updateDescription.getUpdatedFields();
    }

    static BsonDocument getDiagnosticAttributesIfAny(BsonDocument fullDocument) {
        if (fullDocument == null) {
            return null;
        }
        BsonDocument diagnostics = fullDocument.getDocument((Object)DocumentFields.diagnostics.name(), null);
        if (diagnostics == null) {
            return null;
        }
        return diagnostics;
    }

    @NonNull
    private MapValue<String> getOrSetEventDiagnosticAttributes(MapValue<String> fromEvent) {
        if (fromEvent == null) {
            LOGGER.debug("No diagnostic attributes in event; assuming they are unchanged");
            return this.lastEventDiagnosticAttributes;
        }
        this.lastEventDiagnosticAttributes = fromEvent;
        return fromEvent;
    }

    static <T> String dottedFieldNameOf(Reference<T> ref, Reference<?> startingRef) {
        return Formatter.dottedFieldNameOf(ref, ref.path().length(), startingRef);
    }

    static <T> String dottedFieldNameOf(Reference<T> ref, int refLength, Reference<?> startingRef) {
        ArrayList<String> segments = Formatter.dottedFieldNameSegments(ref, refLength, startingRef);
        return String.join((CharSequence)".", segments.toArray(new String[0]));
    }

    static <T> ArrayList<String> dottedFieldNameSegments(Reference<T> ref, int refLength, Reference<?> startingRef) {
        assert (startingRef.path().matchesPrefixOf(ref.path())) : "'" + ref + "' must be under '" + startingRef + "'";
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(DocumentFields.state.name());
        Formatter.buildDottedFieldNameOf(ref, startingRef.path().length(), refLength, segments);
        return segments;
    }

    static <T> List<String> containerSegments(Reference<T> elementRef, int elementRefLength, Reference<?> startingRef) {
        ArrayList<String> elementSegments = Formatter.dottedFieldNameSegments(elementRef, elementRefLength, startingRef);
        return elementSegments.subList(0, elementSegments.size() - 1);
    }

    private static <T> void buildDottedFieldNameOf(Reference<T> ref, int startLength, int refLength, ArrayList<String> segments) {
        if (ref.path().length() > startLength) {
            Reference<?> enclosingReference = Formatter.enclosingReference(ref);
            Formatter.buildDottedFieldNameOf(enclosingReference, startLength, refLength, segments);
            if (ref.path().length() <= refLength) {
                if (Listing.class.isAssignableFrom(enclosingReference.targetClass())) {
                    segments.add("ids");
                } else if (SideTable.class.isAssignableFrom(enclosingReference.targetClass())) {
                    segments.add("valuesById");
                }
                segments.add(Formatter.dottedFieldNameSegment(ref.path().lastSegment()));
            }
        }
    }

    static String dottedFieldNameSegment(String segment) {
        return (String)ENCODER.apply(segment);
    }

    static String undottedFieldNameSegment(String dottedSegment) {
        return (String)DECODER.apply(dottedSegment);
    }

    static <T> Reference<T> referenceTo(String dottedName, Reference<?> startingReference) throws InvalidTypeException {
        Reference ref = startingReference;
        Iterator<String> iter = Arrays.asList(dottedName.split(Pattern.quote("."))).iterator();
        Formatter.skipField(ref, iter, DocumentFields.state.name());
        while (iter.hasNext()) {
            if (Listing.class.isAssignableFrom(ref.targetClass())) {
                Formatter.skipField(ref, iter, "ids");
            } else if (SideTable.class.isAssignableFrom(ref.targetClass())) {
                Formatter.skipField(ref, iter, "valuesById");
            }
            if (!iter.hasNext()) continue;
            String segment = Formatter.undottedFieldNameSegment(iter.next());
            ref = ref.then(Object.class, new String[]{segment});
        }
        return ref;
    }

    private static void skipField(Reference<?> ref, Iterator<String> iter, String expectedName) {
        String actualName;
        try {
            actualName = iter.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Expected '" + expectedName + "' for " + ref.targetClass().getSimpleName() + "; encountered end of dotted field name");
        }
        if (!expectedName.equals(actualName)) {
            throw new IllegalStateException("Expected '" + expectedName + "' for " + ref.targetClass().getSimpleName() + "; was: " + actualName);
        }
    }

    static <T> Reference<?> enclosingReference(Reference<T> ref) {
        assert (!ref.path().isEmpty());
        try {
            return ref.enclosingReference(Object.class);
        }
        catch (InvalidTypeException e) {
            throw new AssertionError(String.format("Reference must have an enclosing Object: '%s'", ref), e);
        }
    }

    private static void appendPercentEncoded(StringBuilder sb, int cp) {
        assert (0 <= cp && cp <= 255);
        sb.append('%').append(Formatter.hexCharForDigit(cp / 16)).append(Formatter.hexCharForDigit(cp % 16));
    }

    private static char hexCharForDigit(int value) {
        if (value < 10) {
            return (char)(48 + value);
        }
        return (char)(65 + value - 10);
    }

    static enum DocumentFields {
        path,
        state,
        revision,
        diagnostics;

    }
}

