/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import io.vena.bosk.EnumerableByIdentifier;
import io.vena.bosk.Identifier;
import io.vena.bosk.Path;
import io.vena.bosk.Reference;
import io.vena.bosk.drivers.mongo.Formatter;
import io.vena.bosk.exceptions.InvalidTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonString;
import org.bson.BsonValue;

class BsonSurgeon {
    final List<GraftPoint> graftPoints;
    private static final String BSON_PATH_FIELD = "_id";
    private static final String STATE_FIELD = Formatter.DocumentFields.state.name();

    BsonSurgeon(List<Reference<? extends EnumerableByIdentifier<?>>> graftPoints) {
        this.graftPoints = new ArrayList<GraftPoint>(graftPoints.size());
        graftPoints.stream().sorted(Comparator.comparing(ref -> ref.path().length()).reversed()).forEachOrdered(containerRef -> this.graftPoints.add(GraftPoint.of(containerRef, BsonSurgeon.entryRef(containerRef))));
    }

    static Reference<?> entryRef(Reference<? extends EnumerableByIdentifier<?>> containerRef) {
        String entryID = "SURGEON_PLACEHOLDER";
        try {
            return containerRef.then(Object.class, new String[]{entryID});
        }
        catch (InvalidTypeException e) {
            throw new IllegalArgumentException("Error constructing entry reference from \"" + containerRef + "\" of type " + containerRef.targetType(), e);
        }
    }

    public List<BsonDocument> scatter(Reference<?> docRef, BsonDocument document, Reference<?> rootRef) {
        ArrayList<BsonDocument> parts = new ArrayList<BsonDocument>();
        for (GraftPoint graftPoint : this.graftPoints) {
            this.scatterOneCollection(docRef, graftPoint, document, rootRef, parts);
        }
        String docBsonPath = "|" + String.join((CharSequence)"|", BsonSurgeon.docSegments(docRef, rootRef));
        parts.add(BsonSurgeon.createRecipe((BsonValue)document, docBsonPath));
        return parts;
    }

    static List<String> docSegments(Reference<?> docRef, Reference<?> rootRef) {
        ArrayList<String> allSegments = Formatter.dottedFieldNameSegments(docRef, docRef.path().length(), rootRef);
        return allSegments.subList(1, allSegments.size());
    }

    private void scatterOneCollection(Reference<?> docRef, GraftPoint graftPoint, BsonDocument docToScatter, Reference<?> rootRef, List<BsonDocument> parts) {
        Path graftPath = graftPoint.entryPlaceholderRef.path();
        Path docPath = docRef.path();
        if (graftPath.length() <= docPath.length()) {
            return;
        }
        if (!docPath.matches(graftPath.truncatedTo(docPath.length()))) {
            return;
        }
        Reference entryRef = graftPoint.entryPlaceholderRef.boundBy(docPath);
        Path entryRefPath = entryRef.path();
        if (entryRefPath.numParameters() == 0) {
            List<String> lookupSegments = BsonSurgeon.containerDocSegments(entryRef, entryRef.path().length(), docRef);
            BsonDocument containerDoc = BsonSurgeon.lookup(docToScatter, lookupSegments);
            String containerBsonPath = "|" + String.join((CharSequence)"|", BsonSurgeon.containerDocSegments(entryRef, entryRef.path().length(), rootRef));
            for (Map.Entry entry : containerDoc.entrySet()) {
                parts.add(BsonSurgeon.createRecipe((BsonValue)entry.getValue(), containerBsonPath + "|" + (String)entry.getKey()));
                entry.setValue(BsonBoolean.TRUE);
            }
        } else {
            List<String> lookupSegments = BsonSurgeon.containerDocSegments(entryRef, entryRefPath.firstParameterIndex() + 1, docRef);
            BsonDocument containerDoc = BsonSurgeon.lookup(docToScatter, lookupSegments);
            containerDoc.forEach((fieldName, value) -> {
                Identifier entryID = Identifier.from((String)Formatter.undottedFieldNameSegment(fieldName));
                this.scatterOneCollection(docRef, graftPoint.boundTo(entryID), docToScatter, rootRef, parts);
            });
        }
    }

    private static List<String> containerDocSegments(Reference<?> docRef, int docRefLength, Reference<?> entryRef) {
        List<String> allSegments = Formatter.containerSegments(docRef, docRefLength, entryRef);
        return allSegments.subList(1, allSegments.size());
    }

    private static BsonDocument createRecipe(BsonValue entryState, String bsonPathString) {
        return new BsonDocument().append(BSON_PATH_FIELD, (BsonValue)new BsonString(bsonPathString)).append(STATE_FIELD, entryState);
    }

    private static List<String> bsonPathSegments(BsonString bsonPath) {
        assert (bsonPath.getValue().startsWith("|")) : "bsonPath \"" + bsonPath + "\" must start with vertical bar";
        String bsonPathString = bsonPath.getValue().substring(1);
        if (bsonPathString.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(bsonPathString.split("\\|"));
    }

    private static BsonDocument lookup(BsonDocument entireDoc, List<String> segments) {
        BsonDocument result = entireDoc;
        for (String segment : segments) {
            try {
                result = result.getDocument((Object)segment);
            }
            catch (BsonInvalidOperationException e) {
                throw new IllegalArgumentException("Doc does not contain " + segments, e);
            }
        }
        return result;
    }

    public BsonDocument gather(List<BsonDocument> partsList) {
        partsList.sort(Comparator.comparing(doc -> doc.getString((Object)BSON_PATH_FIELD).getValue().length()));
        HashSet<BsonString> alreadySeen = new HashSet<BsonString>();
        BsonDocument rootRecipe = partsList.get(0);
        List<String> prefix = BsonSurgeon.bsonPathSegments(rootRecipe.getString((Object)BSON_PATH_FIELD));
        BsonDocument whole = rootRecipe.getDocument((Object)STATE_FIELD);
        for (BsonDocument entry : partsList.subList(1, partsList.size())) {
            BsonString bsonPath = entry.getString((Object)BSON_PATH_FIELD);
            if (!alreadySeen.add(bsonPath)) {
                throw new IllegalArgumentException("Duplicate path \"" + bsonPath.getValue() + "\"");
            }
            List<String> bsonSegments = BsonSurgeon.bsonPathSegments(bsonPath);
            if (!bsonSegments.subList(0, prefix.size()).equals(prefix)) {
                throw new IllegalArgumentException("Part doc is not contained within the root doc. Part: " + bsonSegments + " Root:" + prefix);
            }
            String key = bsonSegments.get(bsonSegments.size() - 1);
            BsonValue value = Objects.requireNonNull(entry.get((Object)STATE_FIELD));
            BsonDocument container = BsonSurgeon.lookup(whole, bsonSegments.subList(prefix.size(), bsonSegments.size() - 1));
            container.put(key, value);
        }
        return whole;
    }

    record GraftPoint(Reference<? extends EnumerableByIdentifier<?>> containerRef, Reference<?> entryPlaceholderRef) {
        public static GraftPoint of(Reference<? extends EnumerableByIdentifier<?>> containerRef, Reference<?> entryPlaceholderRef) {
            return new GraftPoint(containerRef, entryPlaceholderRef);
        }

        public GraftPoint boundTo(Identifier id) {
            return GraftPoint.of(this.containerRef.boundTo(new Identifier[]{id}), this.entryPlaceholderRef.boundTo(new Identifier[]{id}));
        }
    }
}

