/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import io.vena.bosk.MapValue;
import io.vena.bosk.RootReference;
import io.vena.bosk.StateTreeNode;
import io.vena.bosk.drivers.mongo.FormatDriver;
import io.vena.bosk.drivers.mongo.Formatter;
import io.vena.bosk.drivers.mongo.StateAndMetadata;
import io.vena.bosk.drivers.mongo.UninitializedCollectionException;
import io.vena.bosk.drivers.mongo.status.BsonComparator;
import io.vena.bosk.drivers.mongo.status.MongoStatus;
import io.vena.bosk.drivers.mongo.status.StateStatus;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonValue;

abstract class AbstractFormatDriver<R extends StateTreeNode>
implements FormatDriver<R> {
    final RootReference<R> rootRef;
    final Formatter formatter;

    @Override
    public MongoStatus readStatus() {
        try {
            BsonState dbContents = this.loadBsonState();
            BsonDocument loadedBsonState = dbContents.state;
            BsonValue inMemoryState = this.formatter.object2bsonValue((StateTreeNode)this.rootRef.value(), this.rootRef.targetType());
            BsonComparator comp = new BsonComparator();
            return new MongoStatus(null, null, new StateStatus(dbContents.revision.longValue(), this.formatter.bsonValueBinarySize((BsonValue)loadedBsonState), comp.difference(inMemoryState, (BsonValue)loadedBsonState)));
        }
        catch (UninitializedCollectionException e) {
            return new MongoStatus(e.toString(), null, null);
        }
    }

    @Override
    public StateAndMetadata<R> loadAllState() throws IOException, UninitializedCollectionException {
        BsonState bsonState = this.loadBsonState();
        if (bsonState.state() == null) {
            throw new IOException("No existing state in document");
        }
        StateTreeNode root = (StateTreeNode)this.formatter.document2object(bsonState.state(), this.rootRef);
        BsonInt64 revision = bsonState.revision() == null ? Formatter.REVISION_ZERO : bsonState.revision();
        MapValue<String> diagnosticAttributes = bsonState.diagnosticAttributes() == null ? MapValue.empty() : this.formatter.decodeDiagnosticAttributes(bsonState.diagnosticAttributes());
        return new StateAndMetadata<StateTreeNode>(root, revision, diagnosticAttributes);
    }

    abstract BsonState loadBsonState() throws UninitializedCollectionException;

    @ConstructorProperties(value={"rootRef", "formatter"})
    @Generated
    public AbstractFormatDriver(RootReference<R> rootRef, Formatter formatter) {
        this.rootRef = rootRef;
        this.formatter = formatter;
    }

    record BsonState(BsonDocument state, BsonInt64 revision, BsonDocument diagnosticAttributes) {
    }
}

