/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Bosk;
import io.vena.bosk.BoskDiagnosticContext;
import io.vena.bosk.BoskDriver;
import io.vena.bosk.Identifier;
import io.vena.bosk.MapValue;
import io.vena.bosk.Reference;
import io.vena.bosk.StateTreeNode;
import io.vena.bosk.drivers.mongo.BsonPlugin;
import io.vena.bosk.drivers.mongo.ChangeListener;
import io.vena.bosk.drivers.mongo.ChangeReceiver;
import io.vena.bosk.drivers.mongo.DisconnectedDriver;
import io.vena.bosk.drivers.mongo.DisconnectedException;
import io.vena.bosk.drivers.mongo.DownstreamInitialRootException;
import io.vena.bosk.drivers.mongo.FailedSessionException;
import io.vena.bosk.drivers.mongo.FlushLock;
import io.vena.bosk.drivers.mongo.FormatDriver;
import io.vena.bosk.drivers.mongo.Formatter;
import io.vena.bosk.drivers.mongo.InitialRootActionException;
import io.vena.bosk.drivers.mongo.InitialRootFailureException;
import io.vena.bosk.drivers.mongo.Manifest;
import io.vena.bosk.drivers.mongo.MappedDiagnosticContext;
import io.vena.bosk.drivers.mongo.MongoDriver;
import io.vena.bosk.drivers.mongo.MongoDriverSettings;
import io.vena.bosk.drivers.mongo.PandoFormat;
import io.vena.bosk.drivers.mongo.PandoFormatDriver;
import io.vena.bosk.drivers.mongo.SequoiaFormatDriver;
import io.vena.bosk.drivers.mongo.StateAndMetadata;
import io.vena.bosk.drivers.mongo.TransactionalCollection;
import io.vena.bosk.drivers.mongo.UninitializedCollectionException;
import io.vena.bosk.drivers.mongo.UnprocessableEventException;
import io.vena.bosk.drivers.mongo.UnrecognizedFormatException;
import io.vena.bosk.drivers.mongo.status.MongoStatus;
import io.vena.bosk.exceptions.FlushFailureException;
import io.vena.bosk.exceptions.InvalidTypeException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MainDriver<R extends StateTreeNode>
implements MongoDriver<R> {
    private final Bosk<R> bosk;
    private final ChangeReceiver receiver;
    private final MongoDriverSettings driverSettings;
    private final BsonPlugin bsonPlugin;
    private final BoskDriver<R> downstream;
    private final TransactionalCollection<BsonDocument> collection;
    private final Listener listener;
    final Formatter formatter;
    private final ReentrantLock formatDriverLock = new ReentrantLock();
    private final Condition formatDriverChanged = this.formatDriverLock.newCondition();
    private volatile FormatDriver<R> formatDriver = new DisconnectedDriver(new Exception("Driver not yet initialized"));
    private volatile boolean isClosed = false;
    public static final String COLLECTION_NAME = "boskCollection";
    public static final BsonString MANIFEST_ID = new BsonString("manifest");
    private static final Exception FAILURE_TO_COMPUTE_INITIAL_ROOT = new InitialRootFailureException("Failure to compute initial root");
    private static final Logger LOGGER = LoggerFactory.getLogger(MainDriver.class);

    MainDriver(Bosk<R> bosk, MongoClientSettings clientSettings, MongoDriverSettings driverSettings, BsonPlugin bsonPlugin, BoskDriver<R> downstream) {
        try (MappedDiagnosticContext.MDCScope __ = MappedDiagnosticContext.setupMDC(bosk.name(), bosk.instanceID());){
            this.bosk = bosk;
            this.driverSettings = driverSettings;
            this.bsonPlugin = bsonPlugin;
            this.downstream = downstream;
            MongoClient mongoClient = MongoClients.create((MongoClientSettings)MongoClientSettings.builder((MongoClientSettings)clientSettings).readConcern(ReadConcern.MAJORITY).writeConcern(WriteConcern.MAJORITY).build());
            MongoCollection rawCollection = mongoClient.getDatabase(driverSettings.database()).getCollection(COLLECTION_NAME, BsonDocument.class);
            this.collection = TransactionalCollection.of(rawCollection, mongoClient);
            LOGGER.debug("Using database \"{}\" collection \"{}\"", (Object)driverSettings.database(), (Object)COLLECTION_NAME);
            Type rootType = bosk.rootReference().targetType();
            this.listener = new Listener(new FutureTask<StateTreeNode>(() -> this.doInitialRoot(rootType)));
            this.formatter = new Formatter(bosk, bsonPlugin);
            this.receiver = new ChangeReceiver(bosk.name(), bosk.instanceID(), this.listener, driverSettings, (MongoCollection<BsonDocument>)rawCollection);
        }
    }

    /*
     * Loose catch block
     */
    public R initialRoot(Type rootType) throws InvalidTypeException, InterruptedException, IOException {
        try (MappedDiagnosticContext.MDCScope __ = this.beginDriverOperation("initialRoot({})", rootType);){
            StateTreeNode stateTreeNode;
            FutureTask task = this.listener.taskRef.get();
            if (task == null) {
                throw new IllegalStateException("initialRoot has already run");
            }
            try {
                stateTreeNode = (StateTreeNode)task.get();
            }
            catch (ExecutionException e) {
                Throwable exception = e.getCause();
                if (exception instanceof DownstreamInitialRootException) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof IOException) {
                        IOException i = (IOException)cause;
                        throw i;
                    }
                    if (cause instanceof InvalidTypeException) {
                        InvalidTypeException i = (InvalidTypeException)cause;
                        throw i;
                    }
                    if (cause instanceof InterruptedException) {
                        InterruptedException i = (InterruptedException)cause;
                        throw i;
                    }
                    if (cause instanceof RuntimeException) {
                        RuntimeException r = (RuntimeException)cause;
                        throw r;
                    }
                    throw new AssertionError("Unexpected exception during initialRoot: " + e.getClass().getSimpleName(), e);
                }
                if (exception instanceof InitialRootFailureException) {
                    InitialRootFailureException i = (InitialRootFailureException)exception;
                    throw i;
                }
                throw new AssertionError("Exception from initialRoot was not wrapped in DownstreamInitialRootException: " + e.getClass().getSimpleName(), e);
            }
            finally {
                LOGGER.debug("Done initialRoot");
                this.listener.taskRef.set(null);
            }
            return (R)stateTreeNode;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private R doInitialRoot(Type rootType) {
        R root;
        this.setDisconnectedDriver(FAILURE_TO_COMPUTE_INITIAL_ROOT);
        try (TransactionalCollection.Session __ = this.collection.newReadOnlySession();){
            FormatDriver<R> detectedDriver = this.detectFormat();
            StateAndMetadata<R> loadedState = detectedDriver.loadAllState();
            root = loadedState.state();
            this.publishFormatDriver(detectedDriver);
            detectedDriver.onRevisionToSkip(loadedState.revision());
        }
        catch (UninitializedCollectionException e) {
            LOGGER.warn("Database collection is uninitialized; initializing now. (" + e.getMessage() + ")");
            root = this.callDownstreamInitialRoot(rootType);
            try (TransactionalCollection.Session session = this.collection.newSession();){
                FormatDriver<R> preferredDriver = this.newPreferredFormatDriver();
                preferredDriver.initializeCollection(new StateAndMetadata<R>(root, Formatter.REVISION_ZERO, (MapValue<String>)this.bosk.diagnosticContext().getAttributes()));
                session.commitTransactionIfAny();
                this.publishFormatDriver(preferredDriver);
                preferredDriver.onRevisionToSkip(Formatter.REVISION_ONE);
            }
            catch (IOException | RuntimeException e2) {
                LOGGER.warn("Failed to initialize database; disconnecting", (Throwable)e2);
                this.setDisconnectedDriver(e2);
            }
        }
        catch (UnrecognizedFormatException | IOException | RuntimeException e) {
            switch (this.driverSettings.initialDatabaseUnavailableMode()) {
                case FAIL: {
                    LOGGER.debug("Unable to load initial root from database; aborting initialization", (Throwable)e);
                    throw new InitialRootFailureException("Unable to load initial state from MongoDB", e);
                }
                case DISCONNECT: {
                    LOGGER.info("Unable to load initial root from database; will proceed with downstream.initialRoot", (Throwable)e);
                    this.setDisconnectedDriver(e);
                    root = this.callDownstreamInitialRoot(rootType);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown " + MongoDriverSettings.InitialDatabaseUnavailableMode.class.getSimpleName() + ": " + this.driverSettings.initialDatabaseUnavailableMode()));
                }
            }
        }
        return root;
    }

    private R callDownstreamInitialRoot(Type rootType) {
        StateTreeNode root;
        try {
            root = this.downstream.initialRoot(rootType);
        }
        catch (InvalidTypeException | IOException | Error | InterruptedException | RuntimeException e) {
            LOGGER.error("Downstream driver failed to compute initial root", e);
            throw new DownstreamInitialRootException("Fatal error: downstream driver failed to compute initial root", e);
        }
        return (R)root;
    }

    private void refurbishTransaction() throws IOException {
        this.collection.ensureTransactionStarted();
        LOGGER.debug("Refurbishing to {}", (Object)this.driverSettings.preferredDatabaseFormat());
        try {
            BsonDocument deletionFilter;
            StateAndMetadata<R> result = this.formatDriver.loadAllState();
            FormatDriver<R> newFormatDriver = this.newPreferredFormatDriver();
            if (this.driverSettings.experimental().manifestMode() == MongoDriverSettings.ManifestMode.USE_IF_EXISTS) {
                deletionFilter = new BsonDocument();
                LOGGER.debug("Deleting manifest due to experimental USE_IF_EXISTS manifest mode");
            } else {
                deletionFilter = new BsonDocument("_id", (BsonValue)new BsonDocument("$ne", (BsonValue)MANIFEST_ID));
            }
            LOGGER.trace("Deleting state documents: {}", (Object)deletionFilter);
            this.collection.deleteMany((Bson)deletionFilter);
            newFormatDriver.initializeCollection(result);
            this.collection.commitTransaction();
            this.publishFormatDriver(newFormatDriver);
        }
        catch (UninitializedCollectionException e) {
            throw new IOException("Unable to refurbish uninitialized database collection", e);
        }
    }

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        this.doRetryableDriverOperation(() -> {
            this.bsonPlugin.initializeEnclosingPolyfills(target, this.formatDriver);
            this.formatDriver.submitReplacement(target, newValue);
        }, "submitReplacement({})", target);
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        this.doRetryableDriverOperation(() -> {
            this.bsonPlugin.initializeEnclosingPolyfills(target, this.formatDriver);
            this.formatDriver.submitConditionalReplacement(target, newValue, precondition, requiredValue);
        }, "submitConditionalReplacement({}, {}={})", target, precondition, requiredValue);
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        this.doRetryableDriverOperation(() -> {
            this.bsonPlugin.initializeEnclosingPolyfills(target, this.formatDriver);
            this.formatDriver.submitInitialization(target, newValue);
        }, "submitInitialization({})", target);
    }

    public <T> void submitDeletion(Reference<T> target) {
        this.doRetryableDriverOperation(() -> {
            this.bsonPlugin.initializeEnclosingPolyfills(target, this.formatDriver);
            this.formatDriver.submitDeletion(target);
        }, "submitDeletion({})", target);
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        this.doRetryableDriverOperation(() -> {
            this.bsonPlugin.initializeEnclosingPolyfills(target, this.formatDriver);
            this.formatDriver.submitConditionalDeletion(target, precondition, requiredValue);
        }, "submitConditionalDeletion({}, {}={})", target, precondition, requiredValue);
    }

    public void flush() throws IOException, InterruptedException {
        try {
            this.doRetryableDriverOperation(() -> this.formatDriver.flush(), "flush", new Object[0]);
        }
        catch (DisconnectedException | FailedSessionException e) {
            throw new FlushFailureException((Throwable)e);
        }
    }

    @Override
    public void refurbish() throws IOException {
        this.doRetryableDriverOperation(() -> this.refurbishTransaction(), "refurbish", new Object[0]);
    }

    @Override
    public MongoStatus readStatus() throws Exception {
        try (Bosk.ReadContext __1 = this.bosk.readContext();){
            TransactionalCollection.Session __2 = this.collection.newReadOnlySession();
            try {
                MongoStatus partialResult = this.detectFormat().readStatus();
                Manifest manifest = this.loadManifest();
                MongoStatus mongoStatus = partialResult.with(this.driverSettings.preferredDatabaseFormat(), manifest);
                if (__2 != null) {
                    __2.close();
                }
                return mongoStatus;
            }
            catch (Throwable throwable) {
                if (__2 != null) {
                    try {
                        __2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.receiver.close();
        this.formatDriver.close();
    }

    private FormatDriver<R> newPreferredFormatDriver() {
        MongoDriverSettings.DatabaseFormat preferred = this.driverSettings.preferredDatabaseFormat();
        if (preferred.equals(MongoDriverSettings.DatabaseFormat.SEQUOIA) || preferred instanceof PandoFormat) {
            return this.newFormatDriver(Formatter.REVISION_ZERO.longValue(), preferred);
        }
        throw new AssertionError((Object)("Unknown database format setting: " + preferred));
    }

    private FormatDriver<R> detectFormat() throws UninitializedCollectionException, UnrecognizedFormatException {
        Manifest manifest = this.loadManifest();
        MongoDriverSettings.DatabaseFormat format = manifest.pando().isPresent() ? (MongoDriverSettings.DatabaseFormat)manifest.pando().get() : MongoDriverSettings.DatabaseFormat.SEQUOIA;
        BsonString documentId = format == MongoDriverSettings.DatabaseFormat.SEQUOIA ? SequoiaFormatDriver.DOCUMENT_ID : PandoFormatDriver.ROOT_DOCUMENT_ID;
        FindIterable<BsonDocument> result = this.collection.find((Bson)new BsonDocument("_id", (BsonValue)documentId));
        try (MongoCursor cursor = result.cursor();){
            if (cursor.hasNext()) {
                BsonInt64 revision = ((BsonDocument)cursor.next()).getInt64((Object)Formatter.DocumentFields.revision.name(), Formatter.REVISION_ZERO);
                long revisionAlreadySeen = revision.longValue() - 1L;
                FormatDriver<R> formatDriver = this.newFormatDriver(revisionAlreadySeen, format);
                return formatDriver;
            }
            throw new UninitializedCollectionException("Document doesn't exist: collection=" + this.driverSettings.database() + ".boskCollection id=" + documentId.getValue());
        }
    }

    private Manifest loadManifest() throws UnrecognizedFormatException {
        try (MongoCursor cursor = this.collection.find((Bson)new BsonDocument("_id", (BsonValue)MANIFEST_ID)).cursor();){
            if (cursor.hasNext()) {
                LOGGER.debug("Found manifest");
                Manifest manifest = this.formatter.decodeManifest((BsonDocument)cursor.next());
                return manifest;
            }
            LOGGER.debug("Manifest is missing; checking for Sequoia format in " + this.driverSettings.database());
            Manifest manifest = Manifest.forSequoia();
            return manifest;
        }
    }

    private FormatDriver<R> newFormatDriver(long revisionAlreadySeen, MongoDriverSettings.DatabaseFormat format) {
        if (format.equals(MongoDriverSettings.DatabaseFormat.SEQUOIA)) {
            return new SequoiaFormatDriver<R>(this.bosk, this.collection, this.driverSettings, this.bsonPlugin, new FlushLock(this.driverSettings, revisionAlreadySeen), this.downstream);
        }
        if (format instanceof PandoFormat) {
            PandoFormat pandoFormat = (PandoFormat)format;
            return new PandoFormatDriver<R>(this.bosk, this.collection, this.driverSettings, pandoFormat, this.bsonPlugin, new FlushLock(this.driverSettings, revisionAlreadySeen), this.downstream);
        }
        throw new IllegalArgumentException("Unexpected database format: " + format);
    }

    private MappedDiagnosticContext.MDCScope beginDriverOperation(String description, Object ... args) {
        if (this.isClosed) {
            throw new IllegalStateException("Driver is closed");
        }
        MappedDiagnosticContext.MDCScope ex = MappedDiagnosticContext.setupMDC(this.bosk.name(), this.bosk.instanceID());
        LOGGER.debug(description, args);
        if (this.driverSettings.testing().eventDelayMS() < 0L) {
            LOGGER.debug("| eventDelayMS {}ms ", (Object)this.driverSettings.testing().eventDelayMS());
            try {
                Thread.sleep(-this.driverSettings.testing().eventDelayMS());
            }
            catch (InterruptedException e) {
                LOGGER.debug("Sleep interrupted", (Throwable)e);
            }
        }
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X extends Exception, Y extends Exception> void doRetryableDriverOperation(RetryableOperation<X, Y> operation, String description, Object ... args) throws X, Y {
        RetryableOperation operationInSession = () -> {
            int immediateRetriesLeft = 2;
            while (true) {
                try (TransactionalCollection.Session session = this.collection.newSession();){
                    operation.run();
                    session.commitTransactionIfAny();
                }
                catch (FailedSessionException e) {
                    this.setDisconnectedDriver(e);
                    throw new DisconnectedException(e);
                }
                catch (MongoException e) {
                    if (e.hasErrorLabel("TransientTransactionError")) {
                        if (immediateRetriesLeft >= 1) {
                            --immediateRetriesLeft;
                            LOGGER.debug("Transient transaction error; retrying immediately", (Throwable)e);
                            continue;
                        }
                        LOGGER.warn("Exhausted immediate retry attempts for transient transaction error", (Throwable)e);
                        this.setDisconnectedDriver(e);
                        throw new DisconnectedException(e);
                    }
                    LOGGER.debug("MongoException is not recoverable; rethrowing", (Throwable)e);
                    throw e;
                }
                break;
            }
        };
        try (MappedDiagnosticContext.MDCScope __ = this.beginDriverOperation(description, args);){
            try {
                operationInSession.run();
            }
            catch (DisconnectedException e) {
                LOGGER.debug("Driver is disconnected ({}); will wait and retry operation", (Object)e.getMessage());
                this.waitAndRetry(operationInSession, description, args);
            }
            catch (Exception e) {
                LOGGER.debug("Unexpected exception; will wait and retry operation", (Throwable)e);
                this.waitAndRetry(operationInSession, description, args);
            }
            finally {
                LOGGER.debug("Finished operation " + description, args);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X extends Exception, Y extends Exception> void waitAndRetry(RetryableOperation<X, Y> operation, String description, Object ... args) throws X, Y {
        try {
            this.formatDriverLock.lock();
            long waitTimeMS = 5L * this.driverSettings.recoveryPollingMS();
            LOGGER.debug("Waiting for new FormatDriver for {} ms", (Object)waitTimeMS);
            boolean success = this.formatDriverChanged.await(waitTimeMS, TimeUnit.MILLISECONDS);
            if (!success) {
                LOGGER.warn("Timed out waiting for MongoDB to recover; will retry anyway, but the operation may fail");
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Interrupted while waiting to retry; proceeding");
        }
        finally {
            this.formatDriverLock.unlock();
        }
        LOGGER.debug("Retrying " + description, args);
        operation.run();
    }

    void setDisconnectedDriver(Throwable reason) {
        LOGGER.debug("quietlySetDisconnectedDriver({}) (previously {})", (Object)reason.getClass().getSimpleName(), (Object)this.formatDriver.getClass().getSimpleName());
        try {
            this.formatDriverLock.lock();
            this.formatDriver.close();
            this.formatDriver = new DisconnectedDriver(reason);
        }
        finally {
            this.formatDriverLock.unlock();
        }
    }

    void publishFormatDriver(FormatDriver<R> newFormatDriver) {
        LOGGER.debug("publishFormatDriver({}) (was {})", (Object)newFormatDriver.getClass().getSimpleName(), (Object)this.formatDriver.getClass().getSimpleName());
        try {
            this.formatDriverLock.lock();
            this.formatDriver.close();
            this.formatDriver = newFormatDriver;
            LOGGER.debug("Signaling");
            this.formatDriverChanged.signalAll();
        }
        finally {
            this.formatDriverLock.unlock();
        }
    }

    private class Listener
    implements ChangeListener {
        final AtomicReference<FutureTask<R>> taskRef;

        private Listener(FutureTask<R> initialRootAction) {
            this.taskRef = new AtomicReference(initialRootAction);
        }

        @Override
        public void onConnectionSucceeded() throws UnrecognizedFormatException, UninitializedCollectionException, InterruptedException, IOException, InitialRootActionException, TimeoutException {
            LOGGER.debug("onConnectionSucceeded");
            FutureTask initialRootAction = this.taskRef.get();
            if (initialRootAction == null) {
                StateAndMetadata loadedState;
                FormatDriver newDriver;
                try (TransactionalCollection.Session __ = MainDriver.this.collection.newReadOnlySession();){
                    LOGGER.debug("Loading database state to submit to downstream driver");
                    newDriver = MainDriver.this.detectFormat();
                    loadedState = newDriver.loadAllState();
                    LOGGER.trace("Loaded state: {}", loadedState);
                }
                MainDriver.this.publishFormatDriver(newDriver);
                try (BoskDiagnosticContext.DiagnosticScope ___ = MainDriver.this.bosk.rootReference().diagnosticContext().withOnly(loadedState.diagnosticAttributes());){
                    MainDriver.this.downstream.submitReplacement((Reference)MainDriver.this.bosk.rootReference(), loadedState.state());
                    LOGGER.debug("Done submitting downstream");
                }
                newDriver.onRevisionToSkip(loadedState.revision());
            } else {
                LOGGER.debug("Running initialRoot action");
                this.runInitialRootAction(initialRootAction);
            }
        }

        private void runInitialRootAction(FutureTask<R> initialRootAction) throws InterruptedException, TimeoutException, InitialRootActionException {
            initialRootAction.run();
            try {
                initialRootAction.get(5L * MainDriver.this.driverSettings.recoveryPollingMS(), TimeUnit.MILLISECONDS);
                LOGGER.debug("initialRoot action completed successfully");
            }
            catch (ExecutionException e) {
                LOGGER.debug("initialRoot action failed", (Throwable)e);
                throw new InitialRootActionException(e.getCause());
            }
        }

        @Override
        public void onEvent(ChangeStreamDocument<BsonDocument> event) throws UnprocessableEventException {
            LOGGER.debug("onEvent({}:{})", (Object)event.getOperationType().getValue(), this.getDocumentKeyValue(event));
            LOGGER.trace("Event details: {}", event);
            MainDriver.this.formatDriver.onEvent(event);
        }

        private Object getDocumentKeyValue(ChangeStreamDocument<BsonDocument> event) {
            BsonDocument documentKey = event.getDocumentKey();
            if (documentKey == null) {
                return null;
            }
            BsonValue value = documentKey.get((Object)"_id");
            if (value instanceof BsonString) {
                BsonString b = (BsonString)value;
                return b.getValue();
            }
            return value;
        }

        @Override
        public void onConnectionFailed(Exception e) throws InterruptedException, InitialRootActionException, TimeoutException {
            LOGGER.debug("onConnectionFailed");
            FutureTask initialRootAction = this.taskRef.get();
            if (initialRootAction == null) {
                LOGGER.debug("Nothing to do");
            } else {
                LOGGER.debug("Running doomed initialRootAction because the main thread is waiting");
                try {
                    this.runInitialRootAction(initialRootAction);
                }
                catch (InitialRootActionException e2) {
                    LOGGER.debug("Predictably, initialRootAction failed", (Throwable)e2);
                }
            }
        }

        @Override
        public void onDisconnect(Throwable e) {
            LOGGER.debug("onDisconnect({})", (Object)e.toString());
            MainDriver.this.formatDriver.close();
            MainDriver.this.setDisconnectedDriver(e);
        }
    }

    private static interface RetryableOperation<X extends Exception, Y extends Exception> {
        public void run() throws X, Y;
    }
}

