/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BsonDocument;
import org.bson.BsonInt64;

class Demultiplexer {
    private final Map<TransactionID, List<ChangeStreamDocument<BsonDocument>>> transactionsInProgress = new ConcurrentHashMap<TransactionID, List<ChangeStreamDocument<BsonDocument>>>();

    Demultiplexer() {
    }

    public void add(ChangeStreamDocument<BsonDocument> event) {
        TransactionID key = TransactionID.from(Objects.requireNonNull(event));
        this.transactionsInProgress.computeIfAbsent(key, __ -> new ArrayList()).add(event);
    }

    public List<ChangeStreamDocument<BsonDocument>> pop(ChangeStreamDocument<BsonDocument> finalEvent) {
        return this.transactionsInProgress.remove(TransactionID.from(finalEvent));
    }

    private record TransactionID(BsonDocument lsid, BsonInt64 txnNumber) {
        private TransactionID {
            Objects.requireNonNull(lsid);
            Objects.requireNonNull(txnNumber);
        }

        public static TransactionID from(ChangeStreamDocument<?> event) {
            return new TransactionID(event.getLsid(), event.getTxnNumber());
        }
    }
}

