/*
 * Decompiled with CFR 0.152.
 */
package io.vena.bosk.drivers.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vena.bosk.Identifier;
import io.vena.bosk.Reference;
import io.vena.bosk.StateTreeNode;
import io.vena.bosk.drivers.mongo.DisconnectedException;
import io.vena.bosk.drivers.mongo.FormatDriver;
import io.vena.bosk.drivers.mongo.StateAndMetadata;
import io.vena.bosk.drivers.mongo.UninitializedCollectionException;
import io.vena.bosk.exceptions.InitializationFailureException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DisconnectedDriver<R extends StateTreeNode>
implements FormatDriver<R> {
    private final Throwable reason;
    private static final Logger LOGGER = LoggerFactory.getLogger(DisconnectedDriver.class);

    public <T> void submitReplacement(Reference<T> target, T newValue) {
        throw this.disconnected();
    }

    public <T> void submitConditionalReplacement(Reference<T> target, T newValue, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected();
    }

    public <T> void submitInitialization(Reference<T> target, T newValue) {
        throw this.disconnected();
    }

    public <T> void submitDeletion(Reference<T> target) {
        throw this.disconnected();
    }

    public <T> void submitConditionalDeletion(Reference<T> target, Reference<Identifier> precondition, Identifier requiredValue) {
        throw this.disconnected();
    }

    public void flush() throws IOException, InterruptedException {
        throw this.disconnected();
    }

    @Override
    public void close() {
    }

    @Override
    public void onEvent(ChangeStreamDocument<BsonDocument> event) {
        LOGGER.debug("Already disconnected; ignoring event ({})", (Object)event.getOperationType().getValue());
    }

    @Override
    public void onRevisionToSkip(BsonInt64 revision) {
        throw new AssertionError((Object)"Resynchronization should not tell DisconnectedDriver to skip a revision");
    }

    @Override
    public StateAndMetadata<R> loadAllState() throws IOException, UninitializedCollectionException {
        throw this.disconnected();
    }

    @Override
    public void initializeCollection(StateAndMetadata<R> priorContents) throws InitializationFailureException {
        throw this.disconnected();
    }

    private DisconnectedException disconnected() {
        return new DisconnectedException(this.reason);
    }

    @ConstructorProperties(value={"reason"})
    @Generated
    public DisconnectedDriver(Throwable reason) {
        this.reason = reason;
    }
}

