/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.StripedHashtable$;
import cats.effect.unsafe.ThreadSafeHashtable$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;

public final class ThreadSafeHashtable {
    private final int initialCapacity;
    private Function1<Throwable, BoxedUnit>[] hashtable;
    private int size;
    private int mask;
    private int capacity;
    private final int log2NumTables;
    private final Function1<Throwable, BoxedUnit> Tombstone;

    public ThreadSafeHashtable(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.hashtable = new Function1[initialCapacity];
        this.size = 0;
        this.mask = initialCapacity - 1;
        this.capacity = initialCapacity;
        this.log2NumTables = StripedHashtable$.MODULE$.log2NumTables();
        this.Tombstone = ThreadSafeHashtable$.MODULE$.Tombstone();
    }

    public void put(Function1<Throwable, BoxedUnit> cb, int hash) {
        ThreadSafeHashtable threadSafeHashtable = this;
        synchronized (threadSafeHashtable) {
            int sz = this.size;
            int cap = this.capacity;
            if (sz << 1 >= cap) {
                int newCap = cap << 1;
                int newMask = newCap - 1;
                Function1[] newHashtable = new Function1[newCap];
                Function1<Throwable, BoxedUnit>[] table = this.hashtable;
                for (int i = 0; i < cap; ++i) {
                    Function1<Throwable, BoxedUnit> cur = table[i];
                    if (cur == null || cur == this.Tombstone) continue;
                    this.insert(newHashtable, newMask, cur, System.identityHashCode(cur) >> this.log2NumTables);
                }
                this.hashtable = newHashtable;
                this.mask = newMask;
                this.capacity = newCap;
            }
            this.insert(this.hashtable, this.mask, cb, hash);
            this.size = sz + 1;
        }
    }

    private void insert(Function1<Throwable, BoxedUnit>[] table, int mask, Function1<Throwable, BoxedUnit> cb, int hash) {
        int idx = hash & mask;
        for (int remaining = mask; remaining >= 0; --remaining) {
            Function1<Throwable, BoxedUnit> cur = table[idx];
            if (cur == null || cur == this.Tombstone) {
                table[idx] = cb;
                return;
            }
            idx = idx + 1 & mask;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Function1<Throwable, BoxedUnit> cb, int hash) {
        ThreadSafeHashtable threadSafeHashtable = this;
        synchronized (threadSafeHashtable) {
            block7: {
                int init;
                int msk = this.mask;
                int idx = init = hash & msk;
                Function1<Throwable, BoxedUnit>[] table = this.hashtable;
                int remaining = msk;
                while (remaining >= 0) {
                    Function1<Throwable, BoxedUnit> cur = table[idx];
                    if (cb == cur) {
                        table[idx] = this.Tombstone;
                        --this.size;
                        int sz = this.size;
                        int cap = this.capacity;
                        if (cap <= this.initialCapacity) return;
                        if (sz << 2 >= cap) return;
                        int newCap = cap >>> 1;
                        int newMask = newCap - 1;
                        Function1[] newHashtable = new Function1[newCap];
                        Function1<Throwable, BoxedUnit>[] table2 = this.hashtable;
                        for (int i = 0; i < cap; ++i) {
                            Function1<Throwable, BoxedUnit> cur2 = table2[i];
                            if (cur2 == null || cur2 == this.Tombstone) continue;
                            this.insert(newHashtable, newMask, cur2, System.identityHashCode(cur2) >> this.log2NumTables);
                        }
                        this.hashtable = newHashtable;
                        this.mask = newMask;
                        this.capacity = newCap;
                        break block7;
                    }
                    if (cur == null) return;
                    idx = idx + 1 & msk;
                    --remaining;
                }
                return;
            }
            return;
        }
    }

    public Function1<Throwable, BoxedUnit>[] unsafeHashtable() {
        return this.hashtable;
    }

    public boolean isEmpty() {
        Object object;
        return this.size == 0 && ArrayOps$.MODULE$.forall$extension(object = Predef$.MODULE$.refArrayOps((Object[])this.hashtable), (Function1 & Serializable)cb -> cb == null || cb == this.Tombstone);
    }

    public int unsafeCapacity() {
        return this.capacity;
    }

    public int unsafeInitialCapacity() {
        return this.initialCapacity;
    }
}

