/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.tracing;

import cats.effect.tracing.RingBuffer;
import cats.effect.tracing.TracingConstants$;
import cats.effect.tracing.TracingEvent;
import cats.effect.tracing.TracingPlatform;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class Tracing$
extends TracingPlatform
implements Serializable {
    private static final String[] runLoopFilter;
    public static final Tracing$ MODULE$;

    private Tracing$() {
    }

    static {
        MODULE$ = new Tracing$();
        runLoopFilter = new String[]{"cats.effect.", "scala.runtime."};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tracing$.class);
    }

    public TracingEvent buildEvent() {
        return new TracingEvent.StackTrace();
    }

    public StackTraceElement cats$effect$tracing$Tracing$$$getOpAndCallSite(StackTraceElement[] stackTrace) {
        int len = stackTrace.length;
        for (int idx = 1; idx < len; ++idx) {
            String callSiteFileName;
            String callSiteMethodName;
            StackTraceElement methodSite = stackTrace[idx - 1];
            StackTraceElement callSite = stackTrace[idx];
            String callSiteClassName = callSite.getClassName();
            if (this.applyStackTraceFilter(callSiteClassName, callSiteMethodName = callSite.getMethodName(), callSiteFileName = callSite.getFileName())) continue;
            String methodSiteMethodName = methodSite.getMethodName();
            String op = this.decodeMethodName(methodSiteMethodName);
            return new StackTraceElement(op + " @ " + callSiteClassName, callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
        }
        return null;
    }

    public void augmentThrowable(boolean enhancedExceptions, Throwable t, RingBuffer events) {
        Object[] stackTrace;
        Object object;
        if (TracingConstants$.MODULE$.isStackTracing() && enhancedExceptions && !ArrayOps$.MODULE$.isEmpty$extension(object = Predef$.MODULE$.refArrayOps(stackTrace = t.getStackTrace()))) {
            boolean augmented;
            Object object2 = Predef$.MODULE$.refArrayOps(stackTrace);
            boolean bl = augmented = ((StackTraceElement)ArrayOps$.MODULE$.last$extension(object2)).getClassName().indexOf(64) != -1;
            if (!augmented) {
                Object[] prefix = this.dropRunLoopFrames$1((StackTraceElement[])stackTrace);
                StackTraceElement[] suffix = (StackTraceElement[])this.getFrames(events).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                Object object3 = Predef$.MODULE$.refArrayOps(prefix);
                t.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (Object)suffix, ClassTag$.MODULE$.apply(StackTraceElement.class)));
            }
        }
    }

    public List<StackTraceElement> getFrames(RingBuffer events) {
        return events.toList().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(TracingEvent x) {
                boolean bl;
                TracingEvent tracingEvent = x;
                if (tracingEvent instanceof TracingEvent.StackTrace) {
                    TracingEvent.StackTrace ev = (TracingEvent.StackTrace)tracingEvent;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(TracingEvent x, Function1 function1) {
                Object object;
                TracingEvent tracingEvent = x;
                if (tracingEvent instanceof TracingEvent.StackTrace) {
                    TracingEvent.StackTrace ev = (TracingEvent.StackTrace)tracingEvent;
                    object = Tracing$.MODULE$.cats$effect$tracing$Tracing$$$getOpAndCallSite(ev.getStackTrace());
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }).filter((Function1 & Serializable)_$1 -> _$1 != null);
    }

    private final boolean applyRunLoopFilter$1(StackTraceElement ste) {
        String name = ste.getClassName();
        int len = runLoopFilter.length;
        for (int i = 0; i < len; ++i) {
            if (!name.startsWith(runLoopFilter[i])) continue;
            return true;
        }
        return false;
    }

    private final StackTraceElement[] dropRunLoopFrames$1(StackTraceElement[] frames) {
        ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
        for (StackTraceElement frame : frames) {
            if (this.applyRunLoopFilter$1(frame)) {
                return (StackTraceElement[])buffer.toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
            }
            ArrayBuffer cfr_ignored_0 = (ArrayBuffer)buffer.$plus$eq((Object)frame);
        }
        return (StackTraceElement[])buffer.toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
    }
}

