/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.effect.Trace$;
import cats.effect.tracing.RingBuffer;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Trace {
    private final List<StackTraceElement> frames;

    public static Trace apply(RingBuffer ringBuffer) {
        return Trace$.MODULE$.apply(ringBuffer);
    }

    public Trace(List<StackTraceElement> frames) {
        this.frames = frames;
    }

    private String renderStackTraceElement(StackTraceElement ste) {
        return "" + ste.getClassName() + "." + ste.getMethodName() + " (" + ste.getFileName() + ":" + ste.getLineNumber() + ")";
    }

    public String pretty() {
        String TurnRight = "\u2570";
        String Junction = "\u251c";
        IntRef captured = IntRef.create((int)0);
        List indexedRenderedStackTrace = this.frames.map((Function1 & Serializable)frame -> {
            void var3_4;
            int n;
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.renderStackTraceElement((StackTraceElement)frame));
            Tuple2 res = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)captured$1.elem));
            captured$1.elem = n = captured$1.elem + 1;
            return var3_4;
        });
        String acc0 = "Trace: " + captured.elem + " frames captured\n";
        String acc1 = indexedRenderedStackTrace.map((Function1 & Serializable)x$1 -> {
            String tag;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                tag = (String)tuple2._1();
            } else {
                throw new MatchError((Object)tuple2);
            }
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return index == 0 ? "" + Junction + " " + tag : (index == captured$2.elem - 1 ? "" + TurnRight + " " + tag : "" + Junction + " " + tag);
        }).mkString("\n");
        return acc0 + acc1;
    }

    public String compact() {
        return this.frames.map((Function1 & Serializable)ste -> this.renderStackTraceElement((StackTraceElement)ste)).mkString(", ");
    }

    public List<StackTraceElement> toList() {
        return this.frames;
    }

    public String toString() {
        return this.compact();
    }
}

