/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.effect.IO;
import cats.effect.kernel.Outcome;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class CallbackStack<A>
extends AtomicReference<CallbackStack<A>> {
    private Function1<Outcome<IO, Throwable, A>, BoxedUnit> callback;

    public CallbackStack(Function1<Outcome<IO, Throwable, A>, BoxedUnit> callback) {
        this.callback = callback;
    }

    public CallbackStack<A> push(Function1<Outcome<IO, Throwable, A>, BoxedUnit> next) {
        CallbackStack<A> attempt;
        CallbackStack cur;
        CallbackStack callbackStack = this;
        do {
            cur = (CallbackStack)callbackStack.get();
            attempt = new CallbackStack<A>(next);
            attempt.set(cur);
        } while (!callbackStack.compareAndSet(cur, attempt));
        return attempt;
    }

    public void apply(Outcome<IO, Throwable, A> oc) {
        CallbackStack callbackStack = this;
        while (true) {
            CallbackStack next;
            Function1<Outcome<IO, Throwable, A>, BoxedUnit> cb;
            if ((cb = callbackStack.callback) != null) {
                cb.apply(oc);
            }
            if ((next = (CallbackStack)callbackStack.get()) == null) break;
            callbackStack = next;
        }
    }

    public void clearCurrent() {
        this.callback = null;
    }
}

