/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

public final class ArrayStack<A> {
    private Object[] buffer;
    private int index;

    public ArrayStack(Object[] buffer, int index) {
        this.buffer = buffer;
        this.index = index;
    }

    public ArrayStack(int initBound) {
        this(new Object[initBound], 0);
    }

    public ArrayStack() {
        this(null, 0);
    }

    public void init(int bound) {
        this.buffer = new Object[bound];
        this.index = 0;
    }

    public void push(A a) {
        this.checkAndGrow();
        this.buffer[this.index] = a;
        ++this.index;
    }

    /*
     * WARNING - void declaration
     */
    public A pop() {
        void var1_1;
        --this.index;
        Object back = this.buffer[this.index];
        this.buffer[this.index] = null;
        return var1_1;
    }

    public A peek() {
        return (A)this.buffer[this.index - 1];
    }

    public boolean isEmpty() {
        return this.index <= 0;
    }

    public Object[] unsafeBuffer() {
        return this.buffer;
    }

    public int unsafeIndex() {
        return this.index;
    }

    public void unsafeSet(int newI) {
        for (int i = newI; i < this.index; ++i) {
            this.buffer[i] = null;
        }
        this.index = newI;
    }

    public void invalidate() {
        this.index = 0;
        this.buffer = null;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayStack<A> copy() {
        Object[] objectArray;
        if (this.index == 0) {
            objectArray = new Object[this.buffer.length];
        } else {
            void var2_1;
            Object[] buffer2 = new Object[this.buffer.length];
            System.arraycopy(this.buffer, 0, buffer2, 0, this.buffer.length);
            objectArray = var2_1;
        }
        Object[] buffer2 = objectArray;
        return new ArrayStack<A>(buffer2, this.index);
    }

    private void checkAndGrow() {
        if (this.index >= this.buffer.length) {
            int len = this.buffer.length;
            Object[] buffer2 = new Object[len * 2];
            System.arraycopy(this.buffer, 0, buffer2, 0, len);
            this.buffer = buffer2;
        }
    }
}

