/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.kernel.testkit;

import cats.effect.kernel.testkit.TestContext$;
import cats.effect.kernel.testkit.TestContext$State$;
import cats.effect.kernel.testkit.TestContext$Task$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.package$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;
import scala.util.control.NonFatal$;

public final class TestContext
implements ExecutionContext {
    private final long _seed;
    private final Random random;
    private State stateRef;

    public static TestContext apply() {
        return TestContext$.MODULE$.apply();
    }

    public static TestContext apply(String string) {
        return TestContext$.MODULE$.apply(string);
    }

    public TestContext(long _seed) {
        this._seed = _seed;
        ExecutionContext.$init$((ExecutionContext)this);
        this.random = new Random(_seed);
        this.stateRef = TestContext$State$.MODULE$.apply(0L, Duration$.MODULE$.Zero(), (SortedSet<Task>)((SortedSet)SortedSet$.MODULE$.empty(TestContext$Task$.MODULE$.ordering())), (Option<Throwable>)None$.MODULE$);
    }

    public void execute(Runnable r) {
        TestContext testContext = this;
        synchronized (testContext) {
            this.stateRef = this.stateRef.execute(r);
        }
    }

    public void reportFailure(Throwable cause) {
        TestContext testContext = this;
        synchronized (testContext) {
            State state = this.stateRef;
            Some some = Some$.MODULE$.apply((Object)cause);
            long l = state.copy$default$1();
            FiniteDuration finiteDuration = state.copy$default$2();
            SortedSet<Task> sortedSet = state.copy$default$3();
            this.stateRef = state.copy(l, finiteDuration, sortedSet, (Option<Throwable>)some);
        }
    }

    public State state() {
        State state;
        TestContext testContext = this;
        synchronized (testContext) {
            state = this.stateRef;
        }
        return state;
    }

    public FiniteDuration nextInterval() {
        State s = this.state();
        return ((Task)s.tasks().min(TestContext$Task$.MODULE$.ordering())).runsAt().$minus(s.clock()).max(Duration$.MODULE$.Zero());
    }

    public void advance(FiniteDuration time) {
        Predef$.MODULE$.require(time.$greater((Object)Duration$.MODULE$.Zero()));
        TestContext testContext = this;
        synchronized (testContext) {
            State state = this.stateRef;
            FiniteDuration finiteDuration = this.stateRef.clock().$plus(time);
            long l = state.copy$default$1();
            SortedSet<Task> sortedSet = state.copy$default$3();
            Option<Throwable> option = state.copy$default$4();
            this.stateRef = state.copy(l, finiteDuration, sortedSet, option);
        }
    }

    public void advanceAndTick(FiniteDuration time) {
        this.advance(time);
        this.tick();
    }

    public boolean tickOne() {
        boolean bl;
        TestContext testContext = this;
        synchronized (testContext) {
            boolean bl2;
            Tuple2 tuple2;
            State current = this.stateRef;
            Option<Tuple2<Task, SortedSet<Task>>> option = this.extractOneTask(current, current.clock(), this.random);
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Task head = (Task)tuple2._1();
                SortedSet rest = (SortedSet)tuple2._2();
                this.stateRef = current.copy(current.copy$default$1(), current.copy$default$2(), (SortedSet<Task>)rest, current.copy$default$4());
                this.liftedTree1$1(head);
                bl2 = true;
            } else if (None$.MODULE$.equals(option)) {
                bl2 = false;
            } else {
                throw new MatchError(option);
            }
            bl = bl2;
        }
        return bl;
    }

    public void tick() {
        TestContext testContext = this;
        while (testContext.tickOne()) {
        }
    }

    public void tick(FiniteDuration time) {
        this.tick();
        this.advanceAndTick(time);
    }

    public FiniteDuration tick$default$1() {
        return Duration$.MODULE$.Zero();
    }

    public void tickAll() {
        TestContext testContext = this;
        while (true) {
            testContext.tick();
            if (testContext.stateRef.tasks().isEmpty()) break;
            testContext.advance(testContext.nextInterval());
        }
    }

    public void tickAll(FiniteDuration time) {
        FiniteDuration finiteDuration = time;
        this.tickAll();
    }

    public FiniteDuration tickAll$default$1() {
        return Duration$.MODULE$.Zero();
    }

    public Function0<BoxedUnit> schedule(FiniteDuration delay, Runnable r) {
        Function0 function0;
        TestContext testContext = this;
        synchronized (testContext) {
            State newState;
            State current = this.stateRef;
            Tuple2<Function0<BoxedUnit>, State> tuple2 = current.scheduleOnce(delay, r, (Function1<Task, BoxedUnit>)(Function1 & Serializable)t -> {
                this.$anonfun$2((Task)t);
                return BoxedUnit.UNIT;
            });
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Function0 cancelable = (Function0)tuple2._1();
            State newState2 = (State)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)cancelable, (Object)newState2);
            Function0 cancelable2 = (Function0)tuple22._1();
            this.stateRef = newState = (State)tuple22._2();
            function0 = cancelable2;
        }
        return function0;
    }

    public ExecutionContext derive() {
        return new ExecutionContext(this){
            private final TestContext $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                ExecutionContext.$init$((ExecutionContext)this);
            }

            public void execute(Runnable runnable) {
                this.$outer.execute(runnable);
            }

            public void reportFailure(Throwable cause) {
                this.$outer.reportFailure(cause);
            }
        };
    }

    public ExecutionContext deriveBlocking() {
        return new ExecutionContext(this){
            private final TestContext $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                ExecutionContext.$init$((ExecutionContext)this);
            }

            public void execute(Runnable runnable) {
                package$.MODULE$.blocking((Function0 & Serializable)() -> {
                    this.execute$$anonfun$1(runnable);
                    return BoxedUnit.UNIT;
                });
            }

            public void reportFailure(Throwable cause) {
                this.$outer.reportFailure(cause);
            }

            private final void execute$$anonfun$1(Runnable runnable$1) {
                this.$outer.execute(runnable$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{execute$$anonfun$adapted$1(java.lang.Runnable )}, serializedLambda);
            }
        };
    }

    public FiniteDuration now() {
        return this.stateRef.clock();
    }

    public String seed() {
        return new String(TestContext$.cats$effect$kernel$testkit$TestContext$$$Encoder.encode(BoxesRunTime.boxToLong((long)this._seed).toString().getBytes()));
    }

    private Option<Tuple2<Task, SortedSet<Task>>> extractOneTask(State current, FiniteDuration clock, Random random) {
        None$ none$;
        Option option = current.tasks().headOption().filter((Function1 & Serializable)_$1 -> _$1.runsAt().$less$eq((Object)clock));
        if (option instanceof Some) {
            Task value = (Task)((Some)option).value();
            FiniteDuration firstTick = value.runsAt();
            Task[] arr = (Task[])current.tasks().iterator().takeWhile((Function1 & Serializable)_$2 -> {
                FiniteDuration finiteDuration = _$2.runsAt();
                FiniteDuration finiteDuration2 = firstTick;
                return !(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null);
            }).take(10).toArray(ClassTag$.MODULE$.apply(Task.class));
            Task forExecution = arr[random.nextInt(arr.length)];
            SortedSet remaining = (SortedSet)current.tasks().$minus((Object)forExecution);
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)forExecution, (Object)remaining));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    private void cancelTask(Task t) {
        TestContext testContext = this;
        synchronized (testContext) {
            State state = this.stateRef;
            SortedSet sortedSet = (SortedSet)this.stateRef.tasks().$minus((Object)t);
            long l = state.copy$default$1();
            FiniteDuration finiteDuration = state.copy$default$2();
            Option<Throwable> option = state.copy$default$4();
            this.stateRef = state.copy(l, finiteDuration, (SortedSet<Task>)sortedSet, option);
        }
    }

    private final void liftedTree1$1(Task head$1) {
        try {
            head$1.task().run();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = (Throwable)option.get();
                this.reportFailure(ex);
            }
            throw throwable;
        }
    }

    private final /* synthetic */ void $anonfun$2(Task t) {
        this.cancelTask(t);
    }

    public static final class State
    implements Product,
    Serializable {
        private final long lastID;
        private final FiniteDuration clock;
        private final SortedSet tasks;
        private final Option lastReportedFailure;

        public static State apply(long l, FiniteDuration finiteDuration, SortedSet<Task> sortedSet, Option<Throwable> option) {
            return TestContext$State$.MODULE$.apply(l, finiteDuration, sortedSet, option);
        }

        public static State fromProduct(Product product) {
            return TestContext$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return TestContext$State$.MODULE$.unapply(state);
        }

        public State(long lastID, FiniteDuration clock, SortedSet<Task> tasks, Option<Throwable> lastReportedFailure) {
            this.lastID = lastID;
            this.clock = clock;
            this.tasks = tasks;
            this.lastReportedFailure = lastReportedFailure;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lastID()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clock()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tasks()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastReportedFailure()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.lastID() != state.lastID()) return false;
            FiniteDuration finiteDuration = this.clock();
            FiniteDuration finiteDuration2 = state.clock();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            SortedSet<Task> sortedSet = this.tasks();
            SortedSet<Task> sortedSet2 = state.tasks();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            Option<Throwable> option = this.lastReportedFailure();
            Option<Throwable> option2 = state.lastReportedFailure();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "lastID";
                    break;
                }
                case 1: {
                    string = "clock";
                    break;
                }
                case 2: {
                    string = "tasks";
                    break;
                }
                case 3: {
                    string = "lastReportedFailure";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public long lastID() {
            return this.lastID;
        }

        public FiniteDuration clock() {
            return this.clock;
        }

        public SortedSet<Task> tasks() {
            return this.tasks;
        }

        public Option<Throwable> lastReportedFailure() {
            return this.lastReportedFailure;
        }

        public State execute(Runnable runnable) {
            long newID = this.lastID() + 1L;
            Task task = TestContext$Task$.MODULE$.apply(newID, runnable, this.clock());
            SortedSet sortedSet = (SortedSet)this.tasks().$plus((Object)task);
            FiniteDuration finiteDuration = this.copy$default$2();
            Option<Throwable> option = this.copy$default$4();
            return this.copy(newID, finiteDuration, (SortedSet<Task>)sortedSet, option);
        }

        public Tuple2<Function0<BoxedUnit>, State> scheduleOnce(FiniteDuration delay, Runnable r, Function1<Task, BoxedUnit> cancelTask) {
            FiniteDuration d = delay.$greater$eq((Object)Duration$.MODULE$.Zero()) ? delay : Duration$.MODULE$.Zero();
            long newID = this.lastID() + 1L;
            Task task = TestContext$Task$.MODULE$.apply(newID, r, this.clock().$plus(d));
            Function0 & Serializable cancelable = (Function0 & Serializable)() -> {
                this.$anonfun$1(cancelTask, task);
                return BoxedUnit.UNIT;
            };
            SortedSet sortedSet = (SortedSet)this.tasks().$plus((Object)task);
            FiniteDuration finiteDuration = this.copy$default$2();
            Option<Throwable> option = this.copy$default$4();
            return Tuple2$.MODULE$.apply((Object)cancelable, (Object)this.copy(newID, finiteDuration, (SortedSet<Task>)sortedSet, option));
        }

        public State copy(long lastID, FiniteDuration clock, SortedSet<Task> tasks, Option<Throwable> lastReportedFailure) {
            return new State(lastID, clock, tasks, lastReportedFailure);
        }

        public long copy$default$1() {
            return this.lastID();
        }

        public FiniteDuration copy$default$2() {
            return this.clock();
        }

        public SortedSet<Task> copy$default$3() {
            return this.tasks();
        }

        public Option<Throwable> copy$default$4() {
            return this.lastReportedFailure();
        }

        public long _1() {
            return this.lastID();
        }

        public FiniteDuration _2() {
            return this.clock();
        }

        public SortedSet<Task> _3() {
            return this.tasks();
        }

        public Option<Throwable> _4() {
            return this.lastReportedFailure();
        }

        private final /* synthetic */ void $anonfun$1(Function1 cancelTask$1, Task task$1) {
            cancelTask$1.apply((Object)task$1);
        }
    }

    public static final class Task
    implements Product,
    Serializable {
        private final long id;
        private final Runnable task;
        private final FiniteDuration runsAt;

        public static Task apply(long l, Runnable runnable, FiniteDuration finiteDuration) {
            return TestContext$Task$.MODULE$.apply(l, runnable, finiteDuration);
        }

        public static Task fromProduct(Product product) {
            return TestContext$Task$.MODULE$.fromProduct(product);
        }

        public static Ordering<Task> ordering() {
            return TestContext$Task$.MODULE$.ordering();
        }

        public static Task unapply(Task task) {
            return TestContext$Task$.MODULE$.unapply(task);
        }

        public Task(long id, Runnable task, FiniteDuration runsAt) {
            this.id = id;
            this.task = task;
            this.runsAt = runsAt;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.task()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.runsAt()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Task)) return false;
            Task task = (Task)object;
            if (this.id() != task.id()) return false;
            Runnable runnable = this.task();
            Runnable runnable2 = task.task();
            if (runnable == null) {
                if (runnable2 != null) {
                    return false;
                }
            } else if (!runnable.equals(runnable2)) return false;
            FiniteDuration finiteDuration = this.runsAt();
            FiniteDuration finiteDuration2 = task.runsAt();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Task;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Task";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "id";
                    break;
                }
                case 1: {
                    string = "task";
                    break;
                }
                case 2: {
                    string = "runsAt";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public long id() {
            return this.id;
        }

        public Runnable task() {
            return this.task;
        }

        public FiniteDuration runsAt() {
            return this.runsAt;
        }

        public Task copy(long id, Runnable task, FiniteDuration runsAt) {
            return new Task(id, task, runsAt);
        }

        public long copy$default$1() {
            return this.id();
        }

        public Runnable copy$default$2() {
            return this.task();
        }

        public FiniteDuration copy$default$3() {
            return this.runsAt();
        }

        public long _1() {
            return this.id();
        }

        public Runnable _2() {
            return this.task();
        }

        public FiniteDuration _3() {
            return this.runsAt();
        }
    }
}

