/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

public class SetParams {
    private ExistenceCondition existenceCondition;
    private ExpirationType expirationType;
    private Long expirationValue;
    private boolean get = false;

    public static SetParams setParams() {
        return new SetParams();
    }

    public SetParams nx() {
        this.existenceCondition = ExistenceCondition.NX;
        return this;
    }

    public SetParams xx() {
        this.existenceCondition = ExistenceCondition.XX;
        return this;
    }

    public SetParams ex(long seconds) {
        this.expirationType = ExpirationType.EX;
        this.expirationValue = seconds;
        return this;
    }

    public SetParams px(long milliseconds) {
        this.expirationType = ExpirationType.PX;
        this.expirationValue = milliseconds;
        return this;
    }

    public SetParams exAt(long unixTimeSeconds) {
        this.expirationType = ExpirationType.EXAT;
        this.expirationValue = unixTimeSeconds;
        return this;
    }

    public SetParams pxAt(long unixTimeMilliseconds) {
        this.expirationType = ExpirationType.PXAT;
        this.expirationValue = unixTimeMilliseconds;
        return this;
    }

    public SetParams keepTtl() {
        this.expirationType = ExpirationType.KEEPTTL;
        this.expirationValue = null;
        return this;
    }

    public SetParams get() {
        this.get = true;
        return this;
    }

    public ExistenceCondition getExistenceCondition() {
        return this.existenceCondition;
    }

    public ExpirationType getExpirationType() {
        return this.expirationType;
    }

    public Long getExpirationValue() {
        return this.expirationValue;
    }

    public boolean isGet() {
        return this.get;
    }

    public static enum ExpirationType {
        EX,
        PX,
        EXAT,
        PXAT,
        KEEPTTL;

    }

    public static enum ExistenceCondition {
        NX,
        XX;

    }
}

