/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

public class HSetExParams {
    private ExpiryType expirationType;
    private Long expirationValue;
    private ExistenceCondition existenceCondition;

    public static HSetExParams hSetExParams() {
        return new HSetExParams();
    }

    public HSetExParams ex(long seconds) {
        this.expirationType = ExpiryType.EX;
        this.expirationValue = seconds;
        return this;
    }

    public HSetExParams px(long milliseconds) {
        this.expirationType = ExpiryType.PX;
        this.expirationValue = milliseconds;
        return this;
    }

    public HSetExParams exAt(long unixTimeSeconds) {
        this.expirationType = ExpiryType.EXAT;
        this.expirationValue = unixTimeSeconds;
        return this;
    }

    public HSetExParams pxAt(long unixTimeMilliseconds) {
        this.expirationType = ExpiryType.PXAT;
        this.expirationValue = unixTimeMilliseconds;
        return this;
    }

    public HSetExParams keepTtl() {
        this.expirationType = ExpiryType.KEEPTTL;
        this.expirationValue = null;
        return this;
    }

    public HSetExParams fnx() {
        this.existenceCondition = ExistenceCondition.FNX;
        return this;
    }

    public HSetExParams fxx() {
        this.existenceCondition = ExistenceCondition.FXX;
        return this;
    }

    public ExpiryType getExpirationType() {
        return this.expirationType;
    }

    public Long getExpirationValue() {
        return this.expirationValue;
    }

    public ExistenceCondition getExistenceCondition() {
        return this.existenceCondition;
    }

    public static enum ExistenceCondition {
        FNX,
        FXX;

    }

    public static enum ExpiryType {
        EX,
        PX,
        EXAT,
        PXAT,
        KEEPTTL;

    }
}

