/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import glide.api.BaseClient;
import glide.api.GlideClient;
import glide.api.GlideClusterClient;
import glide.api.models.ClusterValue;
import glide.api.models.GlideString;
import glide.api.models.commands.ExpireOptions;
import glide.api.models.commands.GetExOptions;
import glide.api.models.commands.RestoreOptions;
import glide.api.models.commands.SetOptions;
import glide.api.models.commands.SortBaseOptions;
import glide.api.models.commands.SortOptions;
import glide.api.models.commands.SortOptionsBinary;
import glide.api.models.commands.bitmap.BitmapIndexType;
import glide.api.models.commands.bitmap.BitwiseOperation;
import glide.api.models.commands.scan.ClusterScanCursor;
import glide.api.models.commands.scan.ScanOptions;
import glide.api.models.configuration.GlideClientConfiguration;
import glide.api.models.configuration.GlideClusterClientConfiguration;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import redis.clients.jedis.ClusterConfigurationMapper;
import redis.clients.jedis.ClusterConnectionProvider;
import redis.clients.jedis.ConfigurationMapper;
import redis.clients.jedis.ConnectionProvider;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.ResourceLifecycleManager;
import redis.clients.jedis.args.BitCountOption;
import redis.clients.jedis.args.BitOP;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.SortingParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.JedisURIHelper;

public class UnifiedJedis
implements Closeable {
    protected final BaseClient baseClient;
    protected final GlideClient glideClient;
    protected final GlideClusterClient glideClusterClient;
    protected final JedisClientConfig config;
    protected final String resourceId;
    protected final boolean isClusterMode;
    protected volatile boolean closed = false;

    public UnifiedJedis() {
        this(new HostAndPort("localhost", 6379));
    }

    public UnifiedJedis(String host, int port) {
        this(new HostAndPort(host, port));
    }

    public UnifiedJedis(HostAndPort hostAndPort) {
        this(hostAndPort, (JedisClientConfig)DefaultJedisClientConfig.builder().build());
    }

    public UnifiedJedis(String url) {
        this(URI.create(url));
    }

    public UnifiedJedis(URI uri) {
        this(UnifiedJedis.extractHostAndPort(uri), UnifiedJedis.buildConfigFromURI(uri, DefaultJedisClientConfig.builder().build()));
    }

    public UnifiedJedis(URI uri, JedisClientConfig config) {
        this(UnifiedJedis.extractHostAndPort(uri), UnifiedJedis.buildConfigFromURI(uri, config));
    }

    public UnifiedJedis(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.config = clientConfig;
        this.isClusterMode = false;
        this.glideClusterClient = null;
        GlideClientConfiguration glideConfig = ConfigurationMapper.mapToGlideConfig(hostAndPort.getHost(), hostAndPort.getPort(), clientConfig);
        try {
            this.glideClient = (GlideClient)GlideClient.createClient((GlideClientConfiguration)glideConfig).get();
            this.baseClient = this.glideClient;
            this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisConnectionException("Failed to create GLIDE client", e);
        }
    }

    public UnifiedJedis(String host, int port, JedisClientConfig clientConfig) {
        this(new HostAndPort(host, port), clientConfig);
    }

    public UnifiedJedis(String host, int port, int timeout, String password) {
        this(host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).password(password).build());
    }

    public UnifiedJedis(String host, int port, int timeout) {
        this(host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).build());
    }

    public UnifiedJedis(String host, int port, int timeout, String password, int database) {
        this(host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).password(password).database(database).build());
    }

    public UnifiedJedis(String host, int port, int timeout, String password, int database, String clientName) {
        this(host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).password(password).database(database).clientName(clientName).build());
    }

    public UnifiedJedis(Set<HostAndPort> jedisClusterNodes) {
        this(jedisClusterNodes, (JedisClientConfig)DefaultJedisClientConfig.builder().build());
    }

    public UnifiedJedis(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig) {
        this.config = clientConfig;
        this.isClusterMode = true;
        this.glideClient = null;
        GlideClusterClientConfiguration glideConfig = ClusterConfigurationMapper.mapToGlideClusterConfig(jedisClusterNodes, clientConfig);
        try {
            this.glideClusterClient = (GlideClusterClient)GlideClusterClient.createClient((GlideClusterClientConfiguration)glideConfig).get();
            this.baseClient = this.glideClusterClient;
            this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisConnectionException("Failed to create GLIDE cluster client", e);
        }
    }

    public UnifiedJedis(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig, int maxAttempts) {
        this(jedisClusterNodes, clientConfig);
    }

    public UnifiedJedis(Set<HostAndPort> jedisClusterNodes, JedisClientConfig clientConfig, int maxAttempts, Duration maxTotalRetriesDuration) {
        this(jedisClusterNodes, clientConfig);
    }

    public UnifiedJedis(ConnectionProvider provider) {
        JedisClientConfig config;
        if (provider instanceof ClusterConnectionProvider) {
            JedisClientConfig config2;
            ClusterConnectionProvider clusterProvider = (ClusterConnectionProvider)provider;
            Set<HostAndPort> nodes = clusterProvider.getNodes();
            this.config = config2 = clusterProvider.getClientConfig();
            this.isClusterMode = true;
            this.glideClient = null;
            GlideClusterClientConfiguration glideConfig = ClusterConfigurationMapper.mapToGlideClusterConfig(nodes, config2);
            try {
                this.glideClusterClient = (GlideClusterClient)GlideClusterClient.createClient((GlideClusterClientConfiguration)glideConfig).get();
                this.baseClient = this.glideClusterClient;
                this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new JedisConnectionException("Failed to create GLIDE cluster client", e);
            }
        }
        HostAndPort hostAndPort = provider.getConnection().getHostAndPort();
        this.config = config = provider.getClientConfig();
        this.isClusterMode = false;
        this.glideClusterClient = null;
        GlideClientConfiguration glideConfig = ConfigurationMapper.mapToGlideConfig(hostAndPort.getHost(), hostAndPort.getPort(), config);
        try {
            this.glideClient = (GlideClient)GlideClient.createClient((GlideClientConfiguration)glideConfig).get();
            this.baseClient = this.glideClient;
            this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisConnectionException("Failed to create GLIDE client", e);
        }
    }

    public UnifiedJedis(ConnectionProvider provider, int maxAttempts, Duration maxTotalRetriesDuration) {
        this(provider);
    }

    protected UnifiedJedis(GlideClient glideClient, JedisClientConfig jedisConfig) {
        this.glideClient = glideClient;
        this.glideClusterClient = null;
        this.baseClient = glideClient;
        this.config = jedisConfig;
        this.isClusterMode = false;
        this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
    }

    protected UnifiedJedis(GlideClusterClient glideClusterClient, JedisClientConfig jedisConfig) {
        this.glideClient = null;
        this.glideClusterClient = glideClusterClient;
        this.baseClient = glideClusterClient;
        this.config = jedisConfig;
        this.isClusterMode = true;
        this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
    }

    private static HostAndPort extractHostAndPort(URI uri) {
        String host = uri.getHost() != null ? uri.getHost() : "localhost";
        int port = uri.getPort() != -1 ? uri.getPort() : JedisURIHelper.getDefaultPort(uri);
        return new HostAndPort(host, port);
    }

    private static JedisClientConfig buildConfigFromURI(URI uri, JedisClientConfig baseConfig) {
        DefaultJedisClientConfig.Builder builder = DefaultJedisClientConfig.builder();
        if (baseConfig != null) {
            builder.socketTimeoutMillis(baseConfig.getSocketTimeoutMillis()).connectionTimeoutMillis(baseConfig.getConnectionTimeoutMillis()).blockingSocketTimeoutMillis(baseConfig.getBlockingSocketTimeoutMillis()).user(baseConfig.getUser()).password(baseConfig.getPassword()).database(baseConfig.getDatabase()).clientName(baseConfig.getClientName()).ssl(baseConfig.isSsl());
        }
        if (uri.getUserInfo() != null) {
            String[] userInfo = uri.getUserInfo().split(":");
            if (userInfo.length == 1) {
                builder.password(userInfo[0]);
            } else if (userInfo.length == 2) {
                builder.user(userInfo[0]).password(userInfo[1]);
            }
        }
        if ("rediss".equals(uri.getScheme())) {
            builder.ssl(true);
        }
        return builder.build();
    }

    protected void checkNotClosed() {
        if (this.closed) {
            throw new JedisException("UnifiedJedis has been closed");
        }
    }

    public String set(String key, String value) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.set(key, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SET operation failed", e);
        }
    }

    public String get(String key) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.get(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GET operation failed", e);
        }
    }

    public long del(String ... keys) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.del(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DEL operation failed", e);
        }
    }

    public long del(String key) {
        return this.del(new String[]{key});
    }

    public long del(byte[] ... keys) {
        this.checkNotClosed();
        try {
            GlideString[] glideKeys = new GlideString[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                glideKeys[i] = GlideString.of((byte[])keys[i]);
            }
            return (Long)this.baseClient.del(glideKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DEL operation failed", e);
        }
    }

    public long del(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.del(new GlideString[]{GlideString.of((byte[])key)}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DEL operation failed", e);
        }
    }

    public String ping() {
        this.checkNotClosed();
        try {
            if (this.isClusterMode) {
                return (String)this.glideClusterClient.ping().get();
            }
            return (String)this.glideClient.ping().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PING operation failed", e);
        }
    }

    public String ping(String message) {
        this.checkNotClosed();
        try {
            if (this.isClusterMode) {
                return (String)this.glideClusterClient.ping(message).get();
            }
            return (String)this.glideClient.ping(message).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PING operation failed", e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.baseClient != null) {
                    this.baseClient.close();
                }
            }
            catch (ExecutionException e) {
                System.err.println("Error closing GLIDE client: " + e.getMessage());
            }
            finally {
                if (this.resourceId != null) {
                    ResourceLifecycleManager.getInstance().unregisterResource(this.resourceId);
                }
            }
        }
    }

    public String clientInfo() {
        this.checkNotClosed();
        try {
            String[] infoCommands = new String[]{"CLIENT", "INFO"};
            if (this.isClusterMode) {
                return (String)((ClusterValue)this.glideClusterClient.customCommand(infoCommands).get()).getSingleValue();
            }
            return (String)this.glideClient.customCommand(infoCommands).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("CLIENT INFO operation failed", e);
        }
    }

    public String set(String key, String value, SetParams params) {
        this.checkNotClosed();
        try {
            if (params == null) {
                return (String)this.baseClient.set(key, value).get();
            }
            SetOptions options = this.convertSetParams(params);
            return (String)this.baseClient.set(key, value, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SET operation failed", e);
        }
    }

    private SetOptions convertSetParams(SetParams params) {
        return this.convertSetParams(params, false);
    }

    public String setGet(String key, String value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().returnOldValue(true).build();
            return (String)this.baseClient.set(key, value, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETGET operation failed", e);
        }
    }

    public String setGet(String key, String value, SetParams params) {
        this.checkNotClosed();
        try {
            SetOptions options = params == null ? SetOptions.builder().returnOldValue(true).build() : this.convertSetParams(params, true);
            return (String)this.baseClient.set(key, value, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETGET operation failed with SetParams: " + String.valueOf(params), e);
        }
    }

    private SetOptions convertSetParams(SetParams params, boolean forceReturnOldValue) {
        SetOptions.SetOptionsBuilder builder = SetOptions.builder();
        if (params.getExistenceCondition() != null) {
            switch (params.getExistenceCondition()) {
                case NX: {
                    builder.conditionalSetOnlyIfNotExist();
                    break;
                }
                case XX: {
                    builder.conditionalSetOnlyIfExists();
                }
            }
        }
        if (params.getExpirationType() != null) {
            switch (params.getExpirationType()) {
                case EX: {
                    if (params.getExpirationValue() == null) break;
                    builder.expiry(SetOptions.Expiry.Seconds((Long)params.getExpirationValue()));
                    break;
                }
                case PX: {
                    if (params.getExpirationValue() == null) break;
                    builder.expiry(SetOptions.Expiry.Milliseconds((Long)params.getExpirationValue()));
                    break;
                }
                case EXAT: {
                    if (params.getExpirationValue() == null) break;
                    builder.expiry(SetOptions.Expiry.UnixSeconds((Long)params.getExpirationValue()));
                    break;
                }
                case PXAT: {
                    if (params.getExpirationValue() == null) break;
                    builder.expiry(SetOptions.Expiry.UnixMilliseconds((Long)params.getExpirationValue()));
                    break;
                }
                case KEEPTTL: {
                    builder.expiry(SetOptions.Expiry.KeepExisting());
                }
            }
        }
        if (forceReturnOldValue || params.isGet()) {
            builder.returnOldValue(true);
        }
        return builder.build();
    }

    public List<String> mget(String ... keys) {
        this.checkNotClosed();
        try {
            String[] result = (String[])this.baseClient.mget(keys).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MGET operation failed", e);
        }
    }

    public String mset(String ... keysvalues) {
        this.checkNotClosed();
        try {
            if (keysvalues.length % 2 != 0) {
                throw new IllegalArgumentException("Wrong number of arguments for MSET");
            }
            HashMap<String, String> keyValueMap = new HashMap<String, String>();
            for (int i = 0; i < keysvalues.length; i += 2) {
                keyValueMap.put(keysvalues[i], keysvalues[i + 1]);
            }
            return (String)this.baseClient.mset(keyValueMap).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MSET operation failed", e);
        }
    }

    public long setnx(String key, String value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().conditionalSetOnlyIfNotExist().build();
            String result = (String)this.baseClient.set(key, value, options).get();
            return result != null ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETNX operation failed", e);
        }
    }

    public String setex(String key, long seconds, String value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().expiry(SetOptions.Expiry.Seconds((Long)seconds)).build();
            return (String)this.baseClient.set(key, value, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETEX operation failed", e);
        }
    }

    public String psetex(String key, long milliseconds, String value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().expiry(SetOptions.Expiry.Milliseconds((Long)milliseconds)).build();
            return (String)this.baseClient.set(key, value, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PSETEX operation failed", e);
        }
    }

    @Deprecated
    public String getSet(String key, String value) {
        return this.setGet(key, value);
    }

    public String getDel(String key) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.getdel(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETDEL operation failed", e);
        }
    }

    public String getEx(String key, GetExParams params) {
        this.checkNotClosed();
        try {
            if (params == null) {
                return (String)this.baseClient.get(key).get();
            }
            GetExOptions options = this.convertGetExParams(params);
            return (String)this.baseClient.getex(key, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETEX operation failed", e);
        }
    }

    private GetExOptions convertGetExParams(GetExParams params) {
        if (params.getExpirationType() == null) {
            return GetExOptions.Persist();
        }
        switch (params.getExpirationType()) {
            case EX: {
                return GetExOptions.Seconds((Long)params.getExpirationValue());
            }
            case PX: {
                return GetExOptions.Milliseconds((Long)params.getExpirationValue());
            }
            case EXAT: {
                return GetExOptions.UnixSeconds((Long)params.getExpirationValue());
            }
            case PXAT: {
                return GetExOptions.UnixMilliseconds((Long)params.getExpirationValue());
            }
            case PERSIST: {
                return GetExOptions.Persist();
            }
        }
        return GetExOptions.Persist();
    }

    public long append(String key, String value) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.append(key, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("APPEND operation failed", e);
        }
    }

    public long strlen(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.strlen(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("STRLEN operation failed", e);
        }
    }

    public long incr(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.incr(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("INCR operation failed", e);
        }
    }

    public long incrBy(String key, long increment) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.incrBy(key, increment).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("INCRBY operation failed", e);
        }
    }

    public double incrByFloat(String key, double increment) {
        this.checkNotClosed();
        try {
            return (Double)this.baseClient.incrByFloat(key, increment).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("INCRBYFLOAT operation failed", e);
        }
    }

    public long decr(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.decr(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DECR operation failed", e);
        }
    }

    public long decrBy(String key, long decrement) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.decrBy(key, decrement).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DECRBY operation failed", e);
        }
    }

    public String getrange(String key, long startOffset, long endOffset) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.getrange(key, (int)startOffset, (int)endOffset).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETRANGE operation failed", e);
        }
    }

    public long setrange(String key, long offset, String value) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.setrange(key, (int)offset, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETRANGE operation failed", e);
        }
    }

    public String substr(String key, int start, int end) {
        return this.getrange(key, (long)start, (long)end);
    }

    public boolean exists(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.exists(new String[]{key}).get() > 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXISTS operation failed", e);
        }
    }

    public long exists(String ... keys) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.exists(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXISTS operation failed", e);
        }
    }

    public long unlink(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.unlink(new String[]{key}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("UNLINK operation failed", e);
        }
    }

    public long unlink(String ... keys) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.unlink(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("UNLINK operation failed", e);
        }
    }

    public String type(String key) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.type(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TYPE operation failed", e);
        }
    }

    public Set<String> keys(String pattern) {
        this.checkNotClosed();
        try {
            String[] args = new String[]{"KEYS", pattern};
            Object result = this.isClusterMode ? this.glideClusterClient.customCommand(args).get() : this.glideClient.customCommand(args).get();
            if (result instanceof String[]) {
                HashSet<String> keySet = new HashSet<String>();
                for (String key : (String[])result) {
                    keySet.add(key);
                }
                return keySet;
            }
            if (result == null) {
                return new HashSet<String>();
            }
            throw new JedisException("Unexpected response type for KEYS command: " + String.valueOf(result.getClass()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("KEYS operation failed", e);
        }
    }

    public String randomKey() {
        this.checkNotClosed();
        try {
            if (this.isClusterMode) {
                return (String)this.glideClusterClient.randomKey().get();
            }
            return (String)this.glideClient.randomKey().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RANDOMKEY operation failed", e);
        }
    }

    public String rename(String oldkey, String newkey) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.rename(oldkey, newkey).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RENAME operation failed", e);
        }
    }

    public long renamenx(String oldkey, String newkey) {
        this.checkNotClosed();
        try {
            Boolean result = (Boolean)this.baseClient.renamenx(oldkey, newkey).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RENAMENX operation failed", e);
        }
    }

    public long expire(String key, long seconds) {
        this.checkNotClosed();
        try {
            Boolean result = (Boolean)this.baseClient.expire(key, seconds).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIRE operation failed", e);
        }
    }

    public long expire(String key, long seconds, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            if (expiryOption == null) {
                return this.expire(key, seconds);
            }
            ExpireOptions options = this.convertExpiryOption(expiryOption);
            Boolean result = (Boolean)this.baseClient.expire(key, seconds, options).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIRE operation failed", e);
        }
    }

    private ExpireOptions convertExpiryOption(ExpiryOption expiryOption) {
        switch (expiryOption) {
            case NX: {
                return ExpireOptions.HAS_NO_EXPIRY;
            }
            case XX: {
                return ExpireOptions.HAS_EXISTING_EXPIRY;
            }
            case GT: {
                return ExpireOptions.NEW_EXPIRY_GREATER_THAN_CURRENT;
            }
            case LT: {
                return ExpireOptions.NEW_EXPIRY_LESS_THAN_CURRENT;
            }
        }
        throw new IllegalArgumentException("Unsupported ExpiryOption: " + String.valueOf((Object)expiryOption));
    }

    public long expireAt(String key, long unixTime) {
        this.checkNotClosed();
        try {
            Boolean result = (Boolean)this.baseClient.expireAt(key, unixTime).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIREAT operation failed", e);
        }
    }

    public long expireAt(String key, long unixTime, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            if (expiryOption == null) {
                return this.expireAt(key, unixTime);
            }
            ExpireOptions options = this.convertExpiryOption(expiryOption);
            Boolean result = (Boolean)this.baseClient.expireAt(key, unixTime, options).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIREAT operation failed", e);
        }
    }

    public long pexpire(String key, long milliseconds) {
        this.checkNotClosed();
        try {
            Boolean result = (Boolean)this.baseClient.pexpire(key, milliseconds).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIRE operation failed", e);
        }
    }

    public long pexpire(String key, long milliseconds, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            if (expiryOption == null) {
                return this.pexpire(key, milliseconds);
            }
            ExpireOptions options = this.convertExpiryOption(expiryOption);
            Boolean result = (Boolean)this.baseClient.pexpire(key, milliseconds, options).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIRE operation failed", e);
        }
    }

    public long pexpireAt(String key, long millisecondsTimestamp) {
        this.checkNotClosed();
        try {
            Boolean result = (Boolean)this.baseClient.pexpireAt(key, millisecondsTimestamp).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIREAT operation failed", e);
        }
    }

    public long pexpireAt(String key, long millisecondsTimestamp, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            if (expiryOption == null) {
                return this.pexpireAt(key, millisecondsTimestamp);
            }
            ExpireOptions options = this.convertExpiryOption(expiryOption);
            Boolean result = (Boolean)this.baseClient.pexpireAt(key, millisecondsTimestamp, options).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIREAT operation failed", e);
        }
    }

    public long expireTime(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.expiretime(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIRETIME operation failed", e);
        }
    }

    public long pexpireTime(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.pexpiretime(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIRETIME operation failed", e);
        }
    }

    public long ttl(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.ttl(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TTL operation failed", e);
        }
    }

    public long pttl(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.pttl(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PTTL operation failed", e);
        }
    }

    public long persist(String key) {
        this.checkNotClosed();
        try {
            Boolean result = (Boolean)this.baseClient.persist(key).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PERSIST operation failed", e);
        }
    }

    public List<String> sort(String key) {
        this.checkNotClosed();
        try {
            String[] result = (String[])this.baseClient.sort(key).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT operation failed", e);
        }
    }

    public List<String> sort(String key, SortingParams sortingParams) {
        this.checkNotClosed();
        try {
            if (sortingParams == null) {
                return this.sort(key);
            }
            SortOptions options = this.convertSortingParams(sortingParams);
            String[] result = (String[])this.baseClient.sort(key, options).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT operation failed", e);
        }
    }

    private SortOptions convertSortingParams(SortingParams params) {
        SortOptions.SortOptionsBuilder builder = SortOptions.builder();
        String[] args = params.getParams();
        block16: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (arg.toUpperCase()) {
                case "BY": {
                    String byPattern;
                    if (i + 1 >= args.length || "NOSORT".equals(byPattern = args[++i])) continue block16;
                    builder.byPattern(byPattern);
                    continue block16;
                }
                case "LIMIT": {
                    if (i + 2 >= args.length) continue block16;
                    long offset = Long.parseLong(args[++i]);
                    long count = Long.parseLong(args[++i]);
                    builder.limit(new SortBaseOptions.Limit(offset, count));
                    continue block16;
                }
                case "GET": {
                    if (i + 1 >= args.length) continue block16;
                    builder.getPattern(args[++i]);
                    continue block16;
                }
                case "ASC": {
                    builder.orderBy(SortBaseOptions.OrderBy.ASC);
                    continue block16;
                }
                case "DESC": {
                    builder.orderBy(SortBaseOptions.OrderBy.DESC);
                    continue block16;
                }
                case "ALPHA": {
                    builder.alpha();
                }
            }
        }
        return builder.build();
    }

    private SortOptionsBinary convertSortingParamsBinary(SortingParams params) {
        SortOptionsBinary.SortOptionsBinaryBuilder builder = SortOptionsBinary.builder();
        String[] args = params.getParams();
        block16: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (arg.toUpperCase()) {
                case "BY": {
                    String byPattern;
                    if (i + 1 >= args.length || "NOSORT".equals(byPattern = args[++i])) continue block16;
                    builder.byPattern(GlideString.of((String)byPattern));
                    continue block16;
                }
                case "LIMIT": {
                    if (i + 2 >= args.length) continue block16;
                    long offset = Long.parseLong(args[++i]);
                    long count = Long.parseLong(args[++i]);
                    builder.limit(new SortBaseOptions.Limit(offset, count));
                    continue block16;
                }
                case "GET": {
                    if (i + 1 >= args.length) continue block16;
                    String getPattern = args[++i];
                    builder.getPattern(GlideString.of((String)getPattern));
                    continue block16;
                }
                case "ASC": {
                    builder.orderBy(SortBaseOptions.OrderBy.ASC);
                    continue block16;
                }
                case "DESC": {
                    builder.orderBy(SortBaseOptions.OrderBy.DESC);
                    continue block16;
                }
                case "ALPHA": {
                    builder.alpha();
                }
            }
        }
        return builder.build();
    }

    public long sort(String key, String dstkey) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.sortStore(key, dstkey).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT STORE operation failed", e);
        }
    }

    public long sort(String key, SortingParams sortingParams, String dstkey) {
        this.checkNotClosed();
        try {
            if (sortingParams == null) {
                return this.sort(key, dstkey);
            }
            SortOptions options = this.convertSortingParams(sortingParams);
            return (Long)this.baseClient.sortStore(key, dstkey, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT STORE operation failed", e);
        }
    }

    public List<String> sortReadonly(String key, SortingParams sortingParams) {
        this.checkNotClosed();
        try {
            if (sortingParams == null) {
                return this.sort(key);
            }
            SortOptions options = this.convertSortingParams(sortingParams);
            String[] result = (String[])this.baseClient.sortReadOnly(key, options).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT_RO operation failed", e);
        }
    }

    public byte[] dump(String key) {
        this.checkNotClosed();
        try {
            return (byte[])this.baseClient.dump(GlideString.of((String)key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DUMP operation failed", e);
        }
    }

    public String restore(String key, long ttl, byte[] serializedValue) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.restore(GlideString.of((String)key), ttl, serializedValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RESTORE operation failed", e);
        }
    }

    public String restore(String key, long ttl, byte[] serializedValue, RestoreParams params) {
        this.checkNotClosed();
        try {
            if (params == null) {
                return this.restore(key, ttl, serializedValue);
            }
            RestoreOptions options = this.convertRestoreParams(params);
            return (String)this.baseClient.restore(GlideString.of((String)key), ttl, serializedValue, options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RESTORE operation failed", e);
        }
    }

    private RestoreOptions convertRestoreParams(RestoreParams params) {
        RestoreOptions.RestoreOptionsBuilder builder = RestoreOptions.builder();
        String[] args = params.getParams();
        block12: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (arg.toUpperCase()) {
                case "REPLACE": {
                    builder.replace();
                    continue block12;
                }
                case "ABSTTL": {
                    builder.absttl();
                    continue block12;
                }
                case "IDLETIME": {
                    if (i + 1 >= args.length) continue block12;
                    builder.idletime(Long.valueOf(Long.parseLong(args[++i])));
                    continue block12;
                }
                case "FREQ": {
                    if (i + 1 >= args.length) continue block12;
                    builder.frequency(Long.valueOf(Long.parseLong(args[++i])));
                }
            }
        }
        return builder.build();
    }

    public String migrate(String host, int port, String key, int timeout) {
        this.checkNotClosed();
        try {
            String[] args = new String[]{"MIGRATE", host, String.valueOf(port), key, "0", String.valueOf(timeout)};
            Object result = this.isClusterMode ? this.glideClusterClient.customCommand(args).get() : this.glideClient.customCommand(args).get();
            return result != null ? result.toString() : "OK";
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MIGRATE operation failed", e);
        }
    }

    public String migrate(String host, int port, int timeout, MigrateParams params, String ... keys) {
        this.checkNotClosed();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("MIGRATE");
            args.add(host);
            args.add(String.valueOf(port));
            args.add("");
            args.add("0");
            args.add(String.valueOf(timeout));
            if (params != null) {
                String[] paramArray;
                String[] stringArray = paramArray = params.getParams();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String param = stringArray[i];
                    args.add(param);
                }
            }
            args.add("KEYS");
            for (String key : keys) {
                args.add(key);
            }
            Object result = this.isClusterMode ? this.glideClusterClient.customCommand(args.toArray(new String[0])).get() : this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result != null ? result.toString() : "OK";
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MIGRATE operation failed", e);
        }
    }

    public long move(String key, int dbIndex) {
        this.checkNotClosed();
        if (this.isClusterMode) {
            throw new JedisException("MOVE is not supported in cluster mode");
        }
        try {
            Boolean result = (Boolean)this.glideClient.move(key, (long)dbIndex).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MOVE operation failed", e);
        }
    }

    public ScanResult<String> scan(String cursor) {
        this.checkNotClosed();
        try {
            Object[] result;
            if (this.isClusterMode) {
                if (!"0".equals(cursor)) {
                    String[] args = new String[]{"SCAN", cursor};
                    ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args).get();
                    Object[] customArray = (Object[])clusterResult.getSingleValue();
                    String nextCursor = customArray[0].toString();
                    Object[] keys = (Object[])customArray[1];
                    ArrayList<String> keyList = new ArrayList<String>();
                    for (Object key : keys) {
                        keyList.add(key.toString());
                    }
                    return new ScanResult<String>(nextCursor, keyList);
                }
                ClusterScanCursor clusterCursor = ClusterScanCursor.initalCursor();
                result = (Object[])this.glideClusterClient.scan(clusterCursor).get();
            } else {
                result = (Object[])this.glideClient.scan(cursor).get();
            }
            String nextCursor = (String)result[0];
            String[] keys = (String[])result[1];
            return new ScanResult<String>(nextCursor, Arrays.asList(keys));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScanResult<String> scan(String cursor, ScanParams params) {
        this.checkNotClosed();
        try {
            Object[] result;
            block11: {
                if (params == null) {
                    return this.scan(cursor);
                }
                ScanOptions options = this.convertScanParams(params);
                if (this.isClusterMode) {
                    if ("0".equals(cursor)) {
                        ClusterScanCursor clusterCursor = ClusterScanCursor.initalCursor();
                        result = (Object[])this.glideClusterClient.scan(clusterCursor, options).get();
                        break block11;
                    } else {
                        ArrayList<String> args = new ArrayList<String>();
                        args.add("SCAN");
                        args.add(cursor);
                        if (params.getMatchPattern() != null) {
                            args.add("MATCH");
                            args.add(params.getMatchPattern());
                        }
                        if (params.getCount() != null) {
                            args.add("COUNT");
                            args.add(params.getCount().toString());
                        }
                        if (params.getType() != null) {
                            args.add("TYPE");
                            args.add(params.getType());
                        }
                        ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args.toArray(new String[0])).get();
                        Object[] customArray = (Object[])clusterResult.getSingleValue();
                        String nextCursor = customArray[0].toString();
                        Object[] keys = (Object[])customArray[1];
                        ArrayList<String> keyList = new ArrayList<String>();
                        Object[] objectArray = keys;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                return new ScanResult<String>(nextCursor, keyList);
                            }
                            Object key = objectArray[n2];
                            keyList.add(key.toString());
                            ++n2;
                        }
                    }
                }
                result = (Object[])this.glideClient.scan(cursor, options).get();
            }
            String nextCursor = (String)result[0];
            String[] keys = (String[])result[1];
            return new ScanResult<String>(nextCursor, Arrays.asList(keys));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    private ScanOptions convertScanParams(ScanParams params) {
        ScanOptions.ObjectType objectType;
        ScanOptions.ScanOptionsBuilder builder = ScanOptions.builder();
        if (params.getMatchPattern() != null) {
            builder.matchPattern(params.getMatchPattern());
        }
        if (params.getCount() != null) {
            builder.count(params.getCount());
        }
        if (params.getType() != null && (objectType = this.convertStringToObjectType(params.getType())) != null) {
            builder.type(objectType);
        }
        return builder.build();
    }

    private ScanOptions.ObjectType convertStringToObjectType(String type) {
        if (type == null) {
            return null;
        }
        switch (type.toLowerCase()) {
            case "string": {
                return ScanOptions.ObjectType.STRING;
            }
            case "list": {
                return ScanOptions.ObjectType.LIST;
            }
            case "set": {
                return ScanOptions.ObjectType.SET;
            }
            case "zset": {
                return ScanOptions.ObjectType.ZSET;
            }
            case "hash": {
                return ScanOptions.ObjectType.HASH;
            }
            case "stream": {
                return ScanOptions.ObjectType.STREAM;
            }
        }
        return null;
    }

    public ScanResult<String> scan(String cursor, ScanParams params, String type) {
        this.checkNotClosed();
        try {
            Object[] result;
            if (this.isClusterMode) {
                ArrayList<String> args = new ArrayList<String>();
                args.add("SCAN");
                args.add(cursor);
                if (params != null) {
                    if (params.getMatchPattern() != null) {
                        args.add("MATCH");
                        args.add(params.getMatchPattern());
                    }
                    if (params.getCount() != null) {
                        args.add("COUNT");
                        args.add(params.getCount().toString());
                    }
                }
                if (type != null) {
                    args.add("TYPE");
                    args.add(type);
                }
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args.toArray(new String[0])).get();
                result = (Object[])clusterResult.getSingleValue();
            } else {
                ScanOptions.ObjectType objectType;
                ScanOptions.ScanOptionsBuilder builder = ScanOptions.builder();
                if (type != null && (objectType = this.convertStringToObjectType(type)) != null) {
                    builder.type(objectType);
                }
                if (params != null) {
                    if (params.getMatchPattern() != null) {
                        builder.matchPattern(params.getMatchPattern());
                    }
                    if (params.getCount() != null) {
                        builder.count(params.getCount());
                    }
                }
                ScanOptions options = builder.build();
                result = (Object[])this.glideClient.scan(cursor, options).get();
            }
            String nextCursor = (String)result[0];
            String[] keys = (String[])result[1];
            return new ScanResult<String>(nextCursor, Arrays.asList(keys));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public long touch(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.touch(new String[]{key}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TOUCH operation failed", e);
        }
    }

    public long touch(String ... keys) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.touch(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TOUCH operation failed", e);
        }
    }

    public boolean copy(String srcKey, String dstKey, boolean replace) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.copy(srcKey, dstKey, replace).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("COPY operation failed", e);
        }
    }

    public long msetnx(String ... keysvalues) {
        this.checkNotClosed();
        try {
            if (keysvalues.length % 2 != 0) {
                throw new IllegalArgumentException("Wrong number of arguments for MSETNX");
            }
            HashMap<String, String> keyValueMap = new HashMap<String, String>();
            for (int i = 0; i < keysvalues.length; i += 2) {
                keyValueMap.put(keysvalues[i], keysvalues[i + 1]);
            }
            Boolean result = (Boolean)this.baseClient.msetnx(keyValueMap).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MSETNX operation failed", e);
        }
    }

    public boolean setbit(String key, long offset, boolean value) {
        this.checkNotClosed();
        try {
            Long result = (Long)this.baseClient.setbit(key, offset, value ? 1L : 0L).get();
            return result == 1L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETBIT operation failed", e);
        }
    }

    public boolean getbit(String key, long offset) {
        this.checkNotClosed();
        try {
            Long result = (Long)this.baseClient.getbit(key, offset).get();
            return result == 1L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETBIT operation failed", e);
        }
    }

    public long bitcount(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.bitcount(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITCOUNT operation failed", e);
        }
    }

    public long bitcount(String key, long start, long end) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.bitcount(key, start, end).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITCOUNT operation failed", e);
        }
    }

    public long bitcount(String key, long start, long end, BitCountOption option) {
        this.checkNotClosed();
        try {
            BitmapIndexType indexType = option == BitCountOption.BYTE ? BitmapIndexType.BYTE : BitmapIndexType.BIT;
            return (Long)this.baseClient.bitcount(key, start, end, indexType).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITCOUNT operation failed", e);
        }
    }

    public long bitpos(String key, boolean value) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.bitpos(key, value ? 1L : 0L).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITPOS operation failed", e);
        }
    }

    public long bitpos(String key, boolean value, BitPosParams params) {
        this.checkNotClosed();
        try {
            long bitValue;
            if (params == null) {
                return this.bitpos(key, value);
            }
            long l = bitValue = value ? 1L : 0L;
            if (params.getStart() != null && params.getEnd() != null) {
                BitmapIndexType indexType = params.getModifier() != null && params.getModifier().equals((Object)BitCountOption.BIT) ? BitmapIndexType.BIT : BitmapIndexType.BYTE;
                return (Long)this.baseClient.bitpos(key, bitValue, params.getStart().longValue(), params.getEnd().longValue(), indexType).get();
            }
            if (params.getStart() != null) {
                return (Long)this.baseClient.bitpos(key, bitValue, params.getStart().longValue()).get();
            }
            return (Long)this.baseClient.bitpos(key, bitValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITPOS operation failed", e);
        }
    }

    public long bitop(BitOP op, String destKey, String ... srcKeys) {
        this.checkNotClosed();
        try {
            BitwiseOperation operation;
            switch (op) {
                case AND: {
                    operation = BitwiseOperation.AND;
                    break;
                }
                case OR: {
                    operation = BitwiseOperation.OR;
                    break;
                }
                case XOR: {
                    operation = BitwiseOperation.XOR;
                    break;
                }
                case NOT: {
                    operation = BitwiseOperation.NOT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported BitOP operation: " + String.valueOf((Object)op));
                }
            }
            return (Long)this.baseClient.bitop(operation, destKey, srcKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITOP operation failed", e);
        }
    }

    public List<Long> bitfield(String key, String ... arguments) {
        this.checkNotClosed();
        try {
            String[] args = new String[arguments.length + 2];
            args[0] = "BITFIELD";
            args[1] = key;
            System.arraycopy(arguments, 0, args, 2, arguments.length);
            if (this.isClusterMode) {
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args).get();
                Object[] result = (Object[])clusterResult.getSingleValue();
                return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
            }
            Object[] result = (Object[])this.glideClient.customCommand(args).get();
            return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD operation failed", e);
        }
    }

    public List<Long> bitfieldReadonly(String key, String ... arguments) {
        this.checkNotClosed();
        try {
            String[] args = new String[arguments.length + 2];
            args[0] = "BITFIELD_RO";
            args[1] = key;
            System.arraycopy(arguments, 0, args, 2, arguments.length);
            if (this.isClusterMode) {
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args).get();
                Object[] result = (Object[])clusterResult.getSingleValue();
                return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
            }
            Object[] result = (Object[])this.glideClient.customCommand(args).get();
            return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD_RO operation failed", e);
        }
    }

    public long pfadd(String key, String ... elements) {
        this.checkNotClosed();
        try {
            Boolean result = (Boolean)this.baseClient.pfadd(key, elements).get();
            return result != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFADD operation failed", e);
        }
    }

    public long pfcount(String key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.pfcount(new String[]{key}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFCOUNT operation failed", e);
        }
    }

    public long pfcount(String ... keys) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.pfcount(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFCOUNT operation failed", e);
        }
    }

    public String pfmerge(String destkey, String ... sourcekeys) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.pfmerge(destkey, sourcekeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFMERGE operation failed", e);
        }
    }

    public long append(byte[] key, byte[] value) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.append(GlideString.of((byte[])key), GlideString.of((byte[])value)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("APPEND operation failed", e);
        }
    }

    public long bitcount(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.bitcount(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITCOUNT operation failed", e);
        }
    }

    public long bitcount(byte[] key, long start, long end) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.bitcount(GlideString.of((byte[])key), start, end).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITCOUNT operation failed", e);
        }
    }

    public long bitcount(byte[] key, long start, long end, BitCountOption option) {
        this.checkNotClosed();
        try {
            BitmapIndexType indexType = option == BitCountOption.BYTE ? BitmapIndexType.BYTE : BitmapIndexType.BIT;
            return (Long)this.baseClient.bitcount(GlideString.of((byte[])key), start, end, indexType).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITCOUNT operation failed", e);
        }
    }

    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        this.checkNotClosed();
        try {
            GlideString[] args = new GlideString[arguments.length + 2];
            args[0] = GlideString.of((String)"BITFIELD");
            args[1] = GlideString.of((byte[])key);
            for (int i = 0; i < arguments.length; ++i) {
                args[i + 2] = GlideString.of((byte[])arguments[i]);
            }
            if (this.isClusterMode) {
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args).get();
                Object[] result = (Object[])clusterResult.getSingleValue();
                return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
            }
            Object[] result = (Object[])this.glideClient.customCommand(args).get();
            return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD operation failed", e);
        }
    }

    public long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.checkNotClosed();
        try {
            BitwiseOperation operation = BitwiseOperation.valueOf((String)op.name());
            GlideString[] glideSrcKeys = (GlideString[])Arrays.stream(srcKeys).map(GlideString::of).toArray(GlideString[]::new);
            return (Long)this.baseClient.bitop(operation, GlideString.of((byte[])destKey), glideSrcKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITOP operation failed", e);
        }
    }

    public long bitpos(byte[] key, boolean value) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.bitpos(GlideString.of((byte[])key), value ? 1L : 0L).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITPOS operation failed", e);
        }
    }

    public long bitpos(byte[] key, boolean value, BitPosParams params) {
        this.checkNotClosed();
        try {
            if (params.getStart() != null && params.getEnd() != null) {
                BitmapIndexType indexType = params.getModifier() != null && params.getModifier().equals((Object)BitCountOption.BIT) ? BitmapIndexType.BIT : BitmapIndexType.BYTE;
                return (Long)this.baseClient.bitpos(GlideString.of((byte[])key), value ? 1L : 0L, params.getStart().longValue(), params.getEnd().longValue(), indexType).get();
            }
            if (params.getStart() != null) {
                return (Long)this.baseClient.bitpos(GlideString.of((byte[])key), value ? 1L : 0L, params.getStart().longValue()).get();
            }
            return (Long)this.baseClient.bitpos(GlideString.of((byte[])key), value ? 1L : 0L).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITPOS operation failed", e);
        }
    }

    public boolean copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.copy(GlideString.of((byte[])srcKey), GlideString.of((byte[])dstKey), replace).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("COPY operation failed", e);
        }
    }

    public long decr(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.decr(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DECR operation failed", e);
        }
    }

    public long decrBy(byte[] key, long decrement) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.decrBy(GlideString.of((byte[])key), decrement).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DECRBY operation failed", e);
        }
    }

    public byte[] dump(byte[] key) {
        this.checkNotClosed();
        try {
            return (byte[])this.baseClient.dump(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("DUMP operation failed", e);
        }
    }

    public boolean exists(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.exists(new GlideString[]{GlideString.of((byte[])key)}).get() > 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXISTS operation failed", e);
        }
    }

    public long exists(byte[] ... keys) {
        this.checkNotClosed();
        try {
            GlideString[] glideKeys = (GlideString[])Arrays.stream(keys).map(GlideString::of).toArray(GlideString[]::new);
            return (Long)this.baseClient.exists(glideKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXISTS operation failed", e);
        }
    }

    public long expire(byte[] key, long seconds) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.expire(GlideString.of((byte[])key), seconds).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIRE operation failed", e);
        }
    }

    public long expire(byte[] key, long seconds, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            ExpireOptions options = expiryOption == ExpiryOption.NX ? ExpireOptions.HAS_NO_EXPIRY : (expiryOption == ExpiryOption.XX ? ExpireOptions.HAS_EXISTING_EXPIRY : (expiryOption == ExpiryOption.GT ? ExpireOptions.NEW_EXPIRY_GREATER_THAN_CURRENT : ExpireOptions.NEW_EXPIRY_LESS_THAN_CURRENT));
            return (Boolean)this.baseClient.expire(GlideString.of((byte[])key), seconds, options).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIRE operation failed", e);
        }
    }

    public long expireAt(byte[] key, long unixTime) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.expireAt(GlideString.of((byte[])key), unixTime).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIREAT operation failed", e);
        }
    }

    public long expireAt(byte[] key, long unixTime, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            ExpireOptions options = expiryOption == ExpiryOption.NX ? ExpireOptions.HAS_NO_EXPIRY : (expiryOption == ExpiryOption.XX ? ExpireOptions.HAS_EXISTING_EXPIRY : (expiryOption == ExpiryOption.GT ? ExpireOptions.NEW_EXPIRY_GREATER_THAN_CURRENT : ExpireOptions.NEW_EXPIRY_LESS_THAN_CURRENT));
            return (Boolean)this.baseClient.expireAt(GlideString.of((byte[])key), unixTime, options).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIREAT operation failed", e);
        }
    }

    public long expireTime(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.expiretime(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("EXPIRETIME operation failed", e);
        }
    }

    public byte[] get(byte[] key) {
        this.checkNotClosed();
        try {
            GlideString result = (GlideString)this.baseClient.get(GlideString.of((byte[])key)).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GET operation failed", e);
        }
    }

    public byte[] getDel(byte[] key) {
        this.checkNotClosed();
        try {
            GlideString result = (GlideString)this.baseClient.getdel(GlideString.of((byte[])key)).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETDEL operation failed", e);
        }
    }

    public boolean getbit(byte[] key, long offset) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.getbit(GlideString.of((byte[])key), offset).get() == 1L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETBIT operation failed", e);
        }
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        this.checkNotClosed();
        try {
            GlideString result = (GlideString)this.baseClient.getrange(GlideString.of((byte[])key), (int)startOffset, (int)endOffset).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETRANGE operation failed", e);
        }
    }

    public long incr(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.incr(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("INCR operation failed", e);
        }
    }

    public long incrBy(byte[] key, long increment) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.incrBy(GlideString.of((byte[])key), increment).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("INCRBY operation failed", e);
        }
    }

    public double incrByFloat(byte[] key, double increment) {
        this.checkNotClosed();
        try {
            return (Double)this.baseClient.incrByFloat(GlideString.of((byte[])key), increment).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("INCRBYFLOAT operation failed", e);
        }
    }

    public List<byte[]> mget(byte[] ... keys) {
        this.checkNotClosed();
        try {
            GlideString[] glideKeys = (GlideString[])Arrays.stream(keys).map(GlideString::of).toArray(GlideString[]::new);
            GlideString[] results = (GlideString[])this.baseClient.mget(glideKeys).get();
            return Arrays.stream(results).map(s -> s != null ? s.getBytes() : null).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MGET operation failed", e);
        }
    }

    public String mset(byte[] ... keysvalues) {
        this.checkNotClosed();
        try {
            HashMap<GlideString, GlideString> keyValueMap = new HashMap<GlideString, GlideString>();
            for (int i = 0; i < keysvalues.length; i += 2) {
                keyValueMap.put(GlideString.of((byte[])keysvalues[i]), GlideString.of((byte[])keysvalues[i + 1]));
            }
            return (String)this.baseClient.msetBinary(keyValueMap).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MSET operation failed", e);
        }
    }

    public long msetnx(byte[] ... keysvalues) {
        this.checkNotClosed();
        try {
            HashMap<GlideString, GlideString> keyValueMap = new HashMap<GlideString, GlideString>();
            for (int i = 0; i < keysvalues.length; i += 2) {
                keyValueMap.put(GlideString.of((byte[])keysvalues[i]), GlideString.of((byte[])keysvalues[i + 1]));
            }
            return (Boolean)this.baseClient.msetnxBinary(keyValueMap).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MSETNX operation failed", e);
        }
    }

    public long persist(byte[] key) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.persist(GlideString.of((byte[])key)).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PERSIST operation failed", e);
        }
    }

    public long pexpire(byte[] key, long milliseconds) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.pexpire(GlideString.of((byte[])key), milliseconds).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIRE operation failed", e);
        }
    }

    public long pexpire(byte[] key, long milliseconds, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            ExpireOptions options = expiryOption == ExpiryOption.NX ? ExpireOptions.HAS_NO_EXPIRY : (expiryOption == ExpiryOption.XX ? ExpireOptions.HAS_EXISTING_EXPIRY : (expiryOption == ExpiryOption.GT ? ExpireOptions.NEW_EXPIRY_GREATER_THAN_CURRENT : ExpireOptions.NEW_EXPIRY_LESS_THAN_CURRENT));
            return (Boolean)this.baseClient.pexpire(GlideString.of((byte[])key), milliseconds, options).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIRE operation failed", e);
        }
    }

    public long pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.pexpireAt(GlideString.of((byte[])key), millisecondsTimestamp).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIREAT operation failed", e);
        }
    }

    public long pexpireAt(byte[] key, long millisecondsTimestamp, ExpiryOption expiryOption) {
        this.checkNotClosed();
        try {
            ExpireOptions options = expiryOption == ExpiryOption.NX ? ExpireOptions.HAS_NO_EXPIRY : (expiryOption == ExpiryOption.XX ? ExpireOptions.HAS_EXISTING_EXPIRY : (expiryOption == ExpiryOption.GT ? ExpireOptions.NEW_EXPIRY_GREATER_THAN_CURRENT : ExpireOptions.NEW_EXPIRY_LESS_THAN_CURRENT));
            return (Boolean)this.baseClient.pexpireAt(GlideString.of((byte[])key), millisecondsTimestamp, options).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIREAT operation failed", e);
        }
    }

    public long pexpireTime(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.pexpiretime(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PEXPIRETIME operation failed", e);
        }
    }

    public long pfadd(byte[] key, byte[] ... elements) {
        this.checkNotClosed();
        try {
            GlideString[] glideElements = (GlideString[])Arrays.stream(elements).map(GlideString::of).toArray(GlideString[]::new);
            return (Boolean)this.baseClient.pfadd(GlideString.of((byte[])key), glideElements).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFADD operation failed", e);
        }
    }

    public long pfcount(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.pfcount(new GlideString[]{GlideString.of((byte[])key)}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFCOUNT operation failed", e);
        }
    }

    public long pfcount(byte[] ... keys) {
        this.checkNotClosed();
        try {
            GlideString[] glideKeys = (GlideString[])Arrays.stream(keys).map(GlideString::of).toArray(GlideString[]::new);
            return (Long)this.baseClient.pfcount(glideKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFCOUNT operation failed", e);
        }
    }

    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.checkNotClosed();
        try {
            GlideString[] glideSourceKeys = (GlideString[])Arrays.stream(sourcekeys).map(GlideString::of).toArray(GlideString[]::new);
            return (String)this.baseClient.pfmerge(GlideString.of((byte[])destkey), glideSourceKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFMERGE operation failed", e);
        }
    }

    public String psetex(byte[] key, long milliseconds, byte[] value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().expiry(SetOptions.Expiry.Milliseconds((Long)milliseconds)).build();
            return (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value), options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PSETEX operation failed", e);
        }
    }

    public long pttl(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.pttl(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PTTL operation failed", e);
        }
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.rename(GlideString.of((byte[])oldkey), GlideString.of((byte[])newkey)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RENAME operation failed", e);
        }
    }

    public long renamenx(byte[] oldkey, byte[] newkey) {
        this.checkNotClosed();
        try {
            return (Boolean)this.baseClient.renamenx(GlideString.of((byte[])oldkey), GlideString.of((byte[])newkey)).get() != false ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RENAMENX operation failed", e);
        }
    }

    public String restore(byte[] key, long ttl, byte[] serializedValue) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.restore(GlideString.of((byte[])key), ttl, serializedValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RESTORE operation failed", e);
        }
    }

    public String restore(byte[] key, long ttl, byte[] serializedValue, RestoreParams params) {
        this.checkNotClosed();
        try {
            RestoreOptions.RestoreOptionsBuilder optionsBuilder = RestoreOptions.builder();
            return (String)this.baseClient.restore(GlideString.of((byte[])key), ttl, serializedValue, optionsBuilder.build()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RESTORE operation failed", e);
        }
    }

    public String set(byte[] key, byte[] value) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SET operation failed", e);
        }
    }

    public String set(byte[] key, byte[] value, SetParams params) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SET operation failed", e);
        }
    }

    public byte[] setGet(byte[] key, byte[] value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().returnOldValue(true).build();
            String result = (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value), options).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SET operation failed", e);
        }
    }

    public byte[] setGet(byte[] key, byte[] value, SetParams params) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().returnOldValue(true).build();
            String result = (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value), options).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETGET operation failed with SetParams: " + String.valueOf(params), e);
        }
    }

    public boolean setbit(byte[] key, long offset, boolean value) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.setbit(GlideString.of((byte[])key), offset, value ? 1L : 0L).get() == 1L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETBIT operation failed", e);
        }
    }

    public String setex(byte[] key, long seconds, byte[] value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().expiry(SetOptions.Expiry.Seconds((Long)seconds)).build();
            return (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value), options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETEX operation failed", e);
        }
    }

    public long setnx(byte[] key, byte[] value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().conditionalSet(SetOptions.ConditionalSet.ONLY_IF_DOES_NOT_EXIST).build();
            String result = (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value), options).get();
            return result != null ? 1L : 0L;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETNX operation failed", e);
        }
    }

    public long setrange(byte[] key, long offset, byte[] value) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.setrange(GlideString.of((byte[])key), (int)offset, GlideString.of((byte[])value)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETRANGE operation failed", e);
        }
    }

    public List<byte[]> sort(byte[] key) {
        this.checkNotClosed();
        try {
            GlideString[] results = (GlideString[])this.baseClient.sort(GlideString.of((byte[])key)).get();
            return Arrays.stream(results).map(GlideString::getBytes).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT operation failed", e);
        }
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParams) {
        this.checkNotClosed();
        try {
            if (sortingParams == null) {
                return this.sort(key);
            }
            SortOptionsBinary options = this.convertSortingParamsBinary(sortingParams);
            GlideString[] results = (GlideString[])this.baseClient.sort(GlideString.of((byte[])key), options).get();
            return Arrays.stream(results).map(GlideString::getBytes).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT operation failed", e);
        }
    }

    public long sort(byte[] key, byte[] dstkey) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.sortStore(GlideString.of((byte[])key), GlideString.of((byte[])dstkey)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT operation failed", e);
        }
    }

    public long sort(byte[] key, SortingParams sortingParams, byte[] dstkey) {
        this.checkNotClosed();
        try {
            if (sortingParams == null) {
                return this.sort(key, dstkey);
            }
            SortOptionsBinary options = this.convertSortingParamsBinary(sortingParams);
            return (Long)this.baseClient.sortStore(GlideString.of((byte[])key), GlideString.of((byte[])dstkey), options).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT operation failed", e);
        }
    }

    public List<byte[]> sortReadonly(byte[] key, SortingParams sortingParams) {
        this.checkNotClosed();
        try {
            if (sortingParams == null) {
                return this.sort(key);
            }
            SortOptionsBinary options = this.convertSortingParamsBinary(sortingParams);
            GlideString[] results = (GlideString[])this.baseClient.sortReadOnly(GlideString.of((byte[])key), options).get();
            return Arrays.stream(results).map(GlideString::getBytes).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT_RO operation failed", e);
        }
    }

    public long strlen(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.strlen(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("STRLEN operation failed", e);
        }
    }

    public byte[] substr(byte[] key, int start, int end) {
        this.checkNotClosed();
        try {
            GlideString result = (GlideString)this.baseClient.getrange(GlideString.of((byte[])key), start, end).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SUBSTR operation failed", e);
        }
    }

    public long touch(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.touch(new GlideString[]{GlideString.of((byte[])key)}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TOUCH operation failed", e);
        }
    }

    public long touch(byte[] ... keys) {
        this.checkNotClosed();
        try {
            GlideString[] glideKeys = (GlideString[])Arrays.stream(keys).map(GlideString::of).toArray(GlideString[]::new);
            return (Long)this.baseClient.touch(glideKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TOUCH operation failed", e);
        }
    }

    public long ttl(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.ttl(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TTL operation failed", e);
        }
    }

    public String type(byte[] key) {
        this.checkNotClosed();
        try {
            return (String)this.baseClient.type(GlideString.of((byte[])key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("TYPE operation failed", e);
        }
    }

    public long unlink(byte[] key) {
        this.checkNotClosed();
        try {
            return (Long)this.baseClient.unlink(new GlideString[]{GlideString.of((byte[])key)}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("UNLINK operation failed", e);
        }
    }

    public long unlink(byte[] ... keys) {
        this.checkNotClosed();
        try {
            GlideString[] glideKeys = (GlideString[])Arrays.stream(keys).map(GlideString::of).toArray(GlideString[]::new);
            return (Long)this.baseClient.unlink(glideKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("UNLINK operation failed", e);
        }
    }

    public List<Long> bitfieldReadonly(byte[] key, byte[] ... arguments) {
        this.checkNotClosed();
        try {
            GlideString[] args = new GlideString[arguments.length + 2];
            args[0] = GlideString.of((String)"BITFIELD_RO");
            args[1] = GlideString.of((byte[])key);
            for (int i = 0; i < arguments.length; ++i) {
                args[i + 2] = GlideString.of((byte[])arguments[i]);
            }
            if (this.isClusterMode) {
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args).get();
                Object[] result = (Object[])clusterResult.getSingleValue();
                return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
            }
            Object[] result = (Object[])this.glideClient.customCommand(args).get();
            return Arrays.stream(result).map(obj -> obj != null ? Long.valueOf(((Number)obj).longValue()) : null).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD_RO operation failed", e);
        }
    }

    public byte[] getEx(byte[] key, GetExParams params) {
        this.checkNotClosed();
        try {
            if (params == null) {
                GlideString result = (GlideString)this.baseClient.getex(GlideString.of((byte[])key)).get();
                return result != null ? result.getBytes() : null;
            }
            GetExOptions options = this.convertGetExParams(params);
            GlideString result = (GlideString)this.baseClient.getex(GlideString.of((byte[])key), options).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETEX operation failed", e);
        }
    }

    public byte[] getSet(byte[] key, byte[] value) {
        this.checkNotClosed();
        try {
            SetOptions options = SetOptions.builder().returnOldValue(true).build();
            String result = (String)this.baseClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value), options).get();
            return result != null ? result.getBytes() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("GETSET operation failed", e);
        }
    }

    public Set<byte[]> keys(byte[] pattern) {
        this.checkNotClosed();
        try {
            GlideString[] args = new GlideString[]{GlideString.of((String)"KEYS"), GlideString.of((byte[])pattern)};
            Object result = this.isClusterMode ? this.glideClusterClient.customCommand(args).get() : this.glideClient.customCommand(args).get();
            if (result instanceof String[]) {
                HashSet<byte[]> keySet = new HashSet<byte[]>();
                for (String key : (String[])result) {
                    keySet.add(key.getBytes());
                }
                return keySet;
            }
            if (result == null) {
                return new HashSet<byte[]>();
            }
            throw new JedisException("Unexpected response type for KEYS command: " + String.valueOf(result.getClass()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("KEYS operation failed", e);
        }
    }

    public String migrate(String host, int port, byte[] key, int timeout) {
        this.checkNotClosed();
        try {
            GlideString[] args = new GlideString[]{GlideString.of((String)"MIGRATE"), GlideString.of((String)host), GlideString.of((String)String.valueOf(port)), GlideString.of((byte[])key), GlideString.of((String)"0"), GlideString.of((String)String.valueOf(timeout))};
            Object result = this.isClusterMode ? this.glideClusterClient.customCommand(args).get() : this.glideClient.customCommand(args).get();
            return result != null ? result.toString() : "OK";
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MIGRATE operation failed", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String migrate(String host, int port, int timeout, MigrateParams params, byte[] ... keys) {
        this.checkNotClosed();
        try {
            void var7_12;
            ArrayList<GlideString> args = new ArrayList<GlideString>();
            args.add(GlideString.of((String)"MIGRATE"));
            args.add(GlideString.of((String)host));
            args.add(GlideString.of((String)String.valueOf(port)));
            args.add(GlideString.of((String)""));
            args.add(GlideString.of((String)"0"));
            args.add(GlideString.of((String)String.valueOf(timeout)));
            if (params != null) {
                String[] stringArray;
                String[] stringArray2 = stringArray = params.getParams();
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String param = stringArray2[i];
                    args.add(GlideString.of((String)param));
                }
            }
            args.add(GlideString.of((String)"KEYS"));
            for (byte[] key : keys) {
                args.add(GlideString.of((byte[])key));
            }
            if (this.isClusterMode) {
                Object t = this.glideClusterClient.customCommand(args.toArray(new GlideString[0])).get();
            } else {
                Object t = this.glideClient.customCommand(args.toArray(new GlideString[0])).get();
            }
            return var7_12 != null ? var7_12.toString() : "OK";
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MIGRATE operation failed", e);
        }
    }

    public ScanResult<byte[]> scan(byte[] cursor) {
        this.checkNotClosed();
        try {
            String cursorStr = new String(cursor);
            if (this.isClusterMode) {
                if ("0".equals(cursorStr)) {
                    ClusterScanCursor clusterCursor = ClusterScanCursor.initalCursor();
                    Object[] result = (Object[])this.glideClusterClient.scan(clusterCursor).get();
                    ClusterScanCursor nextCursor = (ClusterScanCursor)result[0];
                    String[] keys = (String[])result[1];
                    List binaryKeys = Arrays.stream(keys).map(String::getBytes).collect(Collectors.toList());
                    return new ScanResult<byte[]>(nextCursor.toString().getBytes(), binaryKeys);
                }
                GlideString[] args = new GlideString[]{GlideString.of((String)"SCAN"), GlideString.of((String)cursorStr)};
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args).get();
                Object[] customArray = (Object[])clusterResult.getSingleValue();
                String nextCursor = customArray[0].toString();
                Object[] keys = (Object[])customArray[1];
                ArrayList<byte[]> keyList = new ArrayList<byte[]>();
                for (Object key : keys) {
                    keyList.add(key.toString().getBytes());
                }
                return new ScanResult<byte[]>(nextCursor.getBytes(), keyList);
            }
            Object[] result = (Object[])this.glideClient.scan(cursorStr).get();
            String newCursor = (String)result[0];
            String[] keys = (String[])result[1];
            List binaryKeys = Arrays.stream(keys).map(String::getBytes).collect(Collectors.toList());
            return new ScanResult<byte[]>(newCursor.getBytes(), binaryKeys);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        this.checkNotClosed();
        try {
            String cursorStr = new String(cursor);
            if (params == null) {
                return this.scan(cursor);
            }
            ScanOptions options = this.convertScanParams(params);
            if (this.isClusterMode) {
                if ("0".equals(cursorStr)) {
                    ClusterScanCursor clusterCursor = ClusterScanCursor.initalCursor();
                    Object[] result = (Object[])this.glideClusterClient.scan(clusterCursor, options).get();
                    ClusterScanCursor nextCursor = (ClusterScanCursor)result[0];
                    String[] keys = (String[])result[1];
                    List binaryKeys = Arrays.stream(keys).map(String::getBytes).collect(Collectors.toList());
                    return new ScanResult<byte[]>(nextCursor.toString().getBytes(), binaryKeys);
                }
                ArrayList<GlideString> args = new ArrayList<GlideString>();
                args.add(GlideString.of((String)"SCAN"));
                args.add(GlideString.of((String)cursorStr));
                if (params.getMatchPattern() != null) {
                    args.add(GlideString.of((String)"MATCH"));
                    args.add(GlideString.of((String)params.getMatchPattern()));
                }
                if (params.getCount() != null) {
                    args.add(GlideString.of((String)"COUNT"));
                    args.add(GlideString.of((String)params.getCount().toString()));
                }
                if (params.getType() != null) {
                    args.add(GlideString.of((String)"TYPE"));
                    args.add(GlideString.of((String)params.getType()));
                }
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args.toArray(new GlideString[0])).get();
                Object[] customArray = (Object[])clusterResult.getSingleValue();
                String nextCursor = customArray[0].toString();
                Object[] keys = (Object[])customArray[1];
                ArrayList<byte[]> keyList = new ArrayList<byte[]>();
                for (Object key : keys) {
                    keyList.add(key.toString().getBytes());
                }
                return new ScanResult<byte[]>(nextCursor.getBytes(), keyList);
            }
            Object[] result = (Object[])this.glideClient.scan(cursorStr, options).get();
            String newCursor = (String)result[0];
            String[] keys = (String[])result[1];
            List binaryKeys = Arrays.stream(keys).map(String::getBytes).collect(Collectors.toList());
            return new ScanResult<byte[]>(newCursor.getBytes(), binaryKeys);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params, byte[] type) {
        this.checkNotClosed();
        try {
            Object[] result;
            String cursorStr = new String(cursor);
            String typeStr = type != null ? new String(type) : null;
            ArrayList<GlideString> args = new ArrayList<GlideString>();
            args.add(GlideString.of((String)"SCAN"));
            args.add(GlideString.of((String)cursorStr));
            if (params != null) {
                if (params.getMatchPattern() != null) {
                    args.add(GlideString.of((String)"MATCH"));
                    args.add(GlideString.of((String)params.getMatchPattern()));
                }
                if (params.getCount() != null) {
                    args.add(GlideString.of((String)"COUNT"));
                    args.add(GlideString.of((String)params.getCount().toString()));
                }
            }
            if (typeStr != null) {
                args.add(GlideString.of((String)"TYPE"));
                args.add(GlideString.of((String)typeStr));
            }
            if (this.isClusterMode) {
                ClusterValue clusterResult = (ClusterValue)this.glideClusterClient.customCommand(args.toArray(new GlideString[0])).get();
                result = (Object[])clusterResult.getSingleValue();
            } else {
                result = (Object[])this.glideClient.customCommand(args.toArray(new GlideString[0])).get();
            }
            String newCursor = result[0].toString();
            Object[] keys = (Object[])result[1];
            ArrayList<byte[]> keyList = new ArrayList<byte[]>();
            for (Object key : keys) {
                keyList.add(key.toString().getBytes());
            }
            return new ScanResult<byte[]>(newCursor.getBytes(), keyList);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public String select(int database) {
        this.checkNotClosed();
        if (this.isClusterMode) {
            throw new JedisException("SELECT is not supported in cluster mode");
        }
        try {
            return (String)this.glideClient.select((long)database).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SELECT operation failed", e);
        }
    }
}

