/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.GlideJedisFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.util.JedisURIHelper;
import redis.clients.jedis.util.Pool;

public class JedisPool
extends Pool<Jedis> {
    public JedisPool() {
        this("localhost", 6379);
    }

    public JedisPool(String url) {
        this(URI.create(url));
    }

    public JedisPool(String url, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(URI.create(url), sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(String host, int port) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), host, port);
    }

    public JedisPool(String host, int port, boolean ssl) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), host, port, ssl);
    }

    public JedisPool(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(String host, int port, String user, String password) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), host, port, user, password);
    }

    public JedisPool(String host, int port, int timeout) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).build());
    }

    public JedisPool(String host, int port, String password) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), host, port, DefaultJedisClientConfig.builder().password(password).build());
    }

    public JedisPool(String host, int port, int timeout, String password) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).password(password).build());
    }

    public JedisPool(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), hostAndPort.getHost(), hostAndPort.getPort(), clientConfig);
    }

    public JedisPool(PooledObjectFactory<Jedis> factory) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), factory);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig) {
        this(poolConfig, "localhost", 6379);
    }

    public JedisPool(URI uri) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), uri);
    }

    public JedisPool(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), uri, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(URI uri, int timeout) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), uri, timeout);
    }

    public JedisPool(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this((GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String url) {
        this(poolConfig, URI.create(url));
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, boolean ssl) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().ssl(ssl).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout, String password) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).password(password).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout, String password, int database) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).password(password).database(database).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout, String password, int database, String clientName) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).password(password).database(database).clientName(clientName).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).password(password).database(database).clientName(clientName).ssl(ssl).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).password(password).database(database).clientName(clientName).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout, String user, String password, int database, String clientName) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).user(user).password(password).database(database).clientName(clientName).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int timeout, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).user(user).password(password).database(database).clientName(clientName).ssl(ssl).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).password(password).database(database).clientName(clientName).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).password(password).database(database).clientName(clientName).ssl(ssl).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).password(password).database(database).clientName(clientName).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).user(user).password(password).database(database).clientName(clientName).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).user(user).password(password).database(database).clientName(clientName).ssl(ssl).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().connectionTimeoutMillis(connectionTimeout).socketTimeoutMillis(soTimeout).user(user).password(password).database(database).clientName(clientName).ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, String user, String password) {
        this(poolConfig, host, port, DefaultJedisClientConfig.builder().user(user).password(password).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, String host, int port, JedisClientConfig clientConfig) {
        GlideJedisFactory factory = new GlideJedisFactory(host, port, clientConfig);
        this.initPool(poolConfig, factory);
        factory.setPool(this);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri) {
        this(poolConfig, uri, DefaultJedisClientConfig.builder().build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri, DefaultJedisClientConfig.builder().ssl(JedisURIHelper.isRedisSSLScheme(uri)).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri, int timeout) {
        this(poolConfig, uri, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).build());
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(poolConfig, uri, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).ssl(JedisURIHelper.isRedisSSLScheme(uri)).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    private JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, URI uri, JedisClientConfig clientConfig) {
        String host = uri.getHost();
        int port = uri.getPort() != -1 ? uri.getPort() : JedisURIHelper.getDefaultPort(uri);
        GlideJedisFactory factory = new GlideJedisFactory(host, port, JedisPool.mergeUriConfig(uri, clientConfig));
        this.initPool(poolConfig, factory);
        factory.setPool(this);
    }

    public JedisPool(GenericObjectPoolConfig<Jedis> poolConfig, PooledObjectFactory<Jedis> factory) {
        this.initPool(poolConfig, factory);
        if (factory instanceof GlideJedisFactory) {
            ((GlideJedisFactory)factory).setPool(this);
        }
    }

    private static JedisClientConfig mergeUriConfig(URI uri, JedisClientConfig clientConfig) {
        String path;
        DefaultJedisClientConfig.Builder builder = DefaultJedisClientConfig.builder();
        builder.socketTimeoutMillis(clientConfig.getSocketTimeoutMillis()).connectionTimeoutMillis(clientConfig.getConnectionTimeoutMillis()).blockingSocketTimeoutMillis(clientConfig.getBlockingSocketTimeoutMillis()).user(clientConfig.getUser()).password(clientConfig.getPassword()).database(clientConfig.getDatabase()).clientName(clientConfig.getClientName()).ssl(clientConfig.isSsl()).sslSocketFactory(clientConfig.getSslSocketFactory()).sslParameters(clientConfig.getSslParameters()).hostnameVerifier(clientConfig.getHostnameVerifier()).sslOptions(clientConfig.getSslOptions());
        if (JedisURIHelper.isRedisSSLScheme(uri)) {
            builder.ssl(true);
        }
        if (uri.getUserInfo() != null) {
            String[] userInfo = uri.getUserInfo().split(":", 2);
            if (userInfo.length == 2) {
                builder.user(userInfo[0]).password(userInfo[1]);
            } else {
                builder.password(userInfo[0]);
            }
        }
        if ((path = uri.getPath()) != null && path.length() > 1) {
            try {
                int database = Integer.parseInt(path.substring(1));
                builder.database(database);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    @Override
    protected void returnResourceObject(Jedis resource) {
        if (resource != null) {
            resource.resetForReuse();
            super.returnResourceObject(resource);
        }
    }
}

