/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import glide.api.GlideClient;
import glide.api.models.GlideString;
import glide.api.models.commands.ExpireOptions;
import glide.api.models.commands.GetExOptions;
import glide.api.models.commands.LInsertOptions;
import glide.api.models.commands.LPosOptions;
import glide.api.models.commands.SetOptions;
import glide.api.models.commands.SortBaseOptions;
import glide.api.models.commands.SortOptions;
import glide.api.models.commands.bitmap.BitFieldOptions;
import glide.api.models.commands.bitmap.BitmapIndexType;
import glide.api.models.commands.bitmap.BitwiseOperation;
import glide.api.models.commands.scan.HScanOptions;
import glide.api.models.commands.scan.HScanOptionsBinary;
import glide.api.models.commands.scan.ScanOptions;
import glide.api.models.configuration.GlideClientConfiguration;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.ConfigurationMapper;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ResourceLifecycleManager;
import redis.clients.jedis.args.BitCountOption;
import redis.clients.jedis.args.BitOP;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.args.ListPosition;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.params.BitPosParams;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.HGetExParams;
import redis.clients.jedis.params.HSetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.KeyValue;
import redis.clients.jedis.util.Pool;

public final class Jedis
implements Closeable {
    private static final Logger logger = Logger.getLogger(Jedis.class.getName());
    private static final Charset VALKEY_CHARSET = StandardCharsets.UTF_8;
    private static final String FIELDS_KEYWORD = "FIELDS";
    private volatile GlideClient glideClient;
    private final boolean isPooled;
    private volatile String resourceId;
    private final JedisClientConfig config;
    private Pool<Jedis> dataSource;
    private volatile boolean closed = false;
    private volatile boolean lazyInitialized = false;
    private final String host;
    private final int port;

    public Jedis() {
        this("localhost", 6379);
    }

    public Jedis(String host, int port) {
        this(host, port, DefaultJedisClientConfig.builder().build());
    }

    public Jedis(String host, int port, boolean useSsl) {
        this(host, port, DefaultJedisClientConfig.builder().ssl(useSsl).build());
    }

    public Jedis(String host, int port, JedisClientConfig config) {
        this.host = host;
        this.port = port;
        this.isPooled = false;
        this.dataSource = null;
        this.config = config;
        this.glideClient = null;
        this.resourceId = null;
        this.lazyInitialized = false;
    }

    private synchronized void ensureInitialized() {
        if (this.lazyInitialized) {
            return;
        }
        if (this.isPooled) {
            this.lazyInitialized = true;
            return;
        }
        int i = 0;
        try {
            GlideClientConfiguration glideConfig = ConfigurationMapper.mapToGlideConfig(this.host, this.port, this.config);
            ++i;
            this.glideClient = (GlideClient)GlideClient.createClient((GlideClientConfiguration)glideConfig).get();
            ++i;
            this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
            ++i;
            this.lazyInitialized = true;
        }
        catch (ConfigurationMapper.JedisConfigurationException e) {
            throw new JedisConnectionException("Failed to convert Jedis configuration to GLIDE: " + e.getMessage() + ". Please check your SSL/TLS certificate configuration or consider using PEM format certificates.", e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisConnectionException("Failed to create GLIDE client", e);
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null && e.getMessage().contains("native")) {
                throw new JedisConnectionException("Native library loading failed - this may be due to environment restrictions (e.g., DataGrip). " + i + "Error: " + e.getMessage(), e);
            }
            throw e;
        }
    }

    public Jedis(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, DefaultJedisClientConfig.builder().ssl(ssl).sslSocketFactory(sslSocketFactory).sslParameters(sslParameters).hostnameVerifier(hostnameVerifier).build());
    }

    public Jedis(String host, int port, int timeout) {
        this(host, port, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).connectionTimeoutMillis(timeout).build());
    }

    public Jedis(HostAndPort hostAndPort, JedisClientConfig config) {
        this(hostAndPort.getHost(), hostAndPort.getPort(), config);
    }

    protected Jedis(GlideClient glideClient, JedisClientConfig config) {
        this.host = null;
        this.port = 0;
        this.glideClient = glideClient;
        this.isPooled = true;
        this.dataSource = null;
        this.config = config;
        this.resourceId = ResourceLifecycleManager.getInstance().registerResource(this);
        this.lazyInitialized = true;
    }

    public String set(String key, String value) {
        return this.executeCommandWithGlide("SET", () -> (String)this.glideClient.set(key, value).get());
    }

    public String set(byte[] key, byte[] value) {
        return this.executeCommandWithGlide("SET", () -> (String)this.glideClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value)).get());
    }

    public String set(String key, String value, SetParams params) {
        return this.executeCommandWithGlide("SET", () -> {
            SetOptions options = Jedis.convertSetParamsToSetOptions(params);
            return (String)this.glideClient.set(key, value, options).get();
        });
    }

    public String set(byte[] key, byte[] value, SetParams params) {
        return this.executeCommandWithGlide("SET", () -> {
            SetOptions options = Jedis.convertSetParamsToSetOptions(params);
            return (String)this.glideClient.set(GlideString.of((byte[])key), GlideString.of((byte[])value), options).get();
        });
    }

    private static BitmapIndexType convertBitCountOptionToBitmapIndexType(BitCountOption option) {
        switch (option) {
            case BYTE: {
                return BitmapIndexType.BYTE;
            }
            case BIT: {
                return BitmapIndexType.BIT;
            }
        }
        throw new IllegalArgumentException("Unknown BitCountOption: " + String.valueOf((Object)option));
    }

    private static ExpireOptions convertExpiryOptionToExpireOptions(ExpiryOption expiryOption) {
        switch (expiryOption) {
            case NX: {
                return ExpireOptions.HAS_NO_EXPIRY;
            }
            case XX: {
                return ExpireOptions.HAS_EXISTING_EXPIRY;
            }
            case GT: {
                return ExpireOptions.NEW_EXPIRY_GREATER_THAN_CURRENT;
            }
            case LT: {
                return ExpireOptions.NEW_EXPIRY_LESS_THAN_CURRENT;
            }
        }
        throw new IllegalArgumentException("Unknown ExpiryOption: " + String.valueOf((Object)expiryOption));
    }

    private static SetOptions convertSetParamsToSetOptions(SetParams params) {
        SetOptions.SetOptionsBuilder builder = SetOptions.builder();
        if (params.getExistenceCondition() != null) {
            switch (params.getExistenceCondition()) {
                case NX: {
                    builder.conditionalSet(SetOptions.ConditionalSet.ONLY_IF_DOES_NOT_EXIST);
                    break;
                }
                case XX: {
                    builder.conditionalSet(SetOptions.ConditionalSet.ONLY_IF_EXISTS);
                }
            }
        }
        if (params.getExpirationType() != null) {
            switch (params.getExpirationType()) {
                case EX: {
                    builder.expiry(SetOptions.Expiry.Seconds((Long)params.getExpirationValue()));
                    break;
                }
                case PX: {
                    builder.expiry(SetOptions.Expiry.Milliseconds((Long)params.getExpirationValue()));
                    break;
                }
                case EXAT: {
                    builder.expiry(SetOptions.Expiry.UnixSeconds((Long)params.getExpirationValue()));
                    break;
                }
                case PXAT: {
                    builder.expiry(SetOptions.Expiry.UnixMilliseconds((Long)params.getExpirationValue()));
                    break;
                }
                case KEEPTTL: {
                    builder.expiry(SetOptions.Expiry.KeepExisting());
                }
            }
        }
        if (params.isGet()) {
            builder.returnOldValue(true);
        }
        return builder.build();
    }

    private static void addSetParamsToArgs(List<String> args, SetParams params) {
        if (params.getExistenceCondition() != null) {
            switch (params.getExistenceCondition()) {
                case NX: {
                    args.add("NX");
                    break;
                }
                case XX: {
                    args.add("XX");
                }
            }
        }
        if (params.getExpirationType() != null) {
            switch (params.getExpirationType()) {
                case EX: {
                    args.add("EX");
                    args.add(String.valueOf(params.getExpirationValue()));
                    break;
                }
                case PX: {
                    args.add("PX");
                    args.add(String.valueOf(params.getExpirationValue()));
                    break;
                }
                case EXAT: {
                    args.add("EXAT");
                    args.add(String.valueOf(params.getExpirationValue()));
                    break;
                }
                case PXAT: {
                    args.add("PXAT");
                    args.add(String.valueOf(params.getExpirationValue()));
                    break;
                }
                case KEEPTTL: {
                    args.add("KEEPTTL");
                }
            }
        }
    }

    private static void addSetParamsToGlideStringArgs(List<GlideString> args, SetParams params) {
        if (params.getExistenceCondition() != null) {
            switch (params.getExistenceCondition()) {
                case NX: {
                    args.add(GlideString.of((String)"NX"));
                    break;
                }
                case XX: {
                    args.add(GlideString.of((String)"XX"));
                }
            }
        }
        if (params.getExpirationType() != null) {
            switch (params.getExpirationType()) {
                case EX: {
                    args.add(GlideString.of((String)"EX"));
                    args.add(GlideString.of((String)String.valueOf(params.getExpirationValue())));
                    break;
                }
                case PX: {
                    args.add(GlideString.of((String)"PX"));
                    args.add(GlideString.of((String)String.valueOf(params.getExpirationValue())));
                    break;
                }
                case EXAT: {
                    args.add(GlideString.of((String)"EXAT"));
                    args.add(GlideString.of((String)String.valueOf(params.getExpirationValue())));
                    break;
                }
                case PXAT: {
                    args.add(GlideString.of((String)"PXAT"));
                    args.add(GlideString.of((String)String.valueOf(params.getExpirationValue())));
                    break;
                }
                case KEEPTTL: {
                    args.add(GlideString.of((String)"KEEPTTL"));
                }
            }
        }
    }

    private static GetExOptions convertGetExParamsToGetExOptions(GetExParams params) {
        if (params.getExpirationType() != null) {
            switch (params.getExpirationType()) {
                case EX: {
                    return GetExOptions.Seconds((Long)params.getExpirationValue());
                }
                case PX: {
                    return GetExOptions.Milliseconds((Long)params.getExpirationValue());
                }
                case EXAT: {
                    return GetExOptions.UnixSeconds((Long)params.getExpirationValue());
                }
                case PXAT: {
                    return GetExOptions.UnixMilliseconds((Long)params.getExpirationValue());
                }
                case PERSIST: {
                    return GetExOptions.Persist();
                }
            }
        }
        throw new IllegalArgumentException("Invalid GetExParams: no expiration type specified");
    }

    public String get(String key) {
        return this.executeCommandWithGlide("GET", () -> (String)this.glideClient.get(key).get());
    }

    public byte[] get(byte[] key) {
        return this.executeCommandWithGlide("GET", () -> {
            GlideString result = (GlideString)this.glideClient.get(GlideString.of((byte[])key)).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public String ping() {
        return this.executeCommandWithGlide("PING", () -> (String)this.glideClient.ping().get());
    }

    public String ping(String message) {
        return this.executeCommandWithGlide("PING", () -> (String)this.glideClient.ping(message).get());
    }

    public byte[] ping(byte[] message) {
        return this.executeCommandWithGlide("PING", () -> {
            GlideString result = (GlideString)this.glideClient.ping(GlideString.of((byte[])message)).get();
            return result.getBytes();
        });
    }

    public String select(int index) {
        this.checkNotClosed();
        if (this.config.getDatabase() != index) {
            logger.warning("Database selection may behave differently in GLIDE compatibility mode");
        }
        return "OK";
    }

    public String auth(String password) {
        this.checkNotClosed();
        return "OK";
    }

    public String auth(String user, String password) {
        this.checkNotClosed();
        return "OK";
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void connect() {
        this.checkNotClosed();
        this.ensureInitialized();
    }

    public JedisClientConfig getConfig() {
        return this.config;
    }

    protected void setDataSource(Pool<Jedis> jedisPool) {
        this.dataSource = jedisPool;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.resourceId != null) {
            ResourceLifecycleManager.getInstance().unregisterResource(this.resourceId);
        }
        if (this.dataSource != null) {
            Pool<Jedis> pool = this.dataSource;
            this.dataSource = null;
            pool.returnResource(this);
        } else if (this.glideClient != null) {
            try {
                this.glideClient.close();
            }
            catch (Exception e) {
                throw new JedisException("Failed to close GLIDE client", e);
            }
        }
        try {
            ConfigurationMapper.cleanupTempFiles();
        }
        catch (Exception e) {
            System.err.println("Warning: Failed to cleanup temporary certificate files:");
            e.printStackTrace();
        }
    }

    protected GlideClient getGlideClient() {
        this.ensureInitialized();
        return this.glideClient;
    }

    protected boolean isPooled() {
        return this.isPooled;
    }

    protected void resetForReuse() {
        if (this.isPooled) {
            this.closed = false;
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new JedisException("Connection is closed");
        }
    }

    private <T> T executeCommandWithGlide(String operationName, GlideOperation<T> operation) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            return operation.execute();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException(operationName + " operation failed", e);
        }
    }

    public long del(String key) {
        return this.executeCommandWithGlide("DEL", () -> (Long)this.glideClient.del(new String[]{key}).get());
    }

    public long del(String ... keys) {
        return this.executeCommandWithGlide("DEL", () -> (Long)this.glideClient.del(keys).get());
    }

    public long del(byte[] key) {
        return this.executeCommandWithGlide("DEL", () -> (Long)this.glideClient.del(new GlideString[]{GlideString.of((byte[])key)}).get());
    }

    public long del(byte[] ... keys) {
        return this.executeCommandWithGlide("DEL", () -> {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            return (Long)this.glideClient.del(glideKeys).get();
        });
    }

    public Set<String> keys(String pattern) {
        this.checkNotClosed();
        try {
            Object result = this.glideClient.customCommand(new String[]{"KEYS", pattern}).get();
            if (result instanceof String[]) {
                return new HashSet<String>(Arrays.asList((String[])result));
            }
            if (result instanceof Object[]) {
                Object[] objArray = (Object[])result;
                HashSet<String> keySet = new HashSet<String>();
                for (Object obj : objArray) {
                    if (obj == null) continue;
                    keySet.add(obj.toString());
                }
                return keySet;
            }
            if (result == null) {
                return new HashSet<String>();
            }
            logger.warning("Unexpected KEYS result type: " + result.getClass().getName());
            return new HashSet<String>();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("KEYS operation failed", e);
        }
    }

    public Set<byte[]> keys(byte[] pattern) {
        this.checkNotClosed();
        try {
            Object result = this.glideClient.customCommand(new GlideString[]{GlideString.of((String)"KEYS"), GlideString.of((byte[])pattern)}).get();
            if (result instanceof GlideString[]) {
                GlideString[] glideArray = (GlideString[])result;
                HashSet<byte[]> keySet = new HashSet<byte[]>();
                for (GlideString gs : glideArray) {
                    if (gs == null) continue;
                    keySet.add(gs.getBytes());
                }
                return keySet;
            }
            if (result instanceof Object[]) {
                Object[] objArray = (Object[])result;
                HashSet<byte[]> keySet = new HashSet<byte[]>();
                for (Object obj : objArray) {
                    if (obj instanceof GlideString) {
                        keySet.add(((GlideString)obj).getBytes());
                        continue;
                    }
                    if (obj == null) continue;
                    keySet.add(obj.toString().getBytes(VALKEY_CHARSET));
                }
                return keySet;
            }
            return new HashSet<byte[]>();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("KEYS operation failed", e);
        }
    }

    public String mset(String ... keysvalues) {
        return this.executeCommandWithGlide("MSET", () -> {
            if (keysvalues.length % 2 == 1) {
                throw new IllegalArgumentException("keyvalues must be of even length");
            }
            HashMap<String, String> keyValueMap = new HashMap<String, String>();
            for (int i = 0; i < keysvalues.length; i += 2) {
                if (i + 1 >= keysvalues.length) continue;
                keyValueMap.put(keysvalues[i], keysvalues[i + 1]);
            }
            return (String)this.glideClient.mset(keyValueMap).get();
        });
    }

    public String mset(Map<String, String> keyValueMap) {
        return this.executeCommandWithGlide("MSET", () -> (String)this.glideClient.mset(keyValueMap).get());
    }

    public String mset(byte[] ... keysvalues) {
        return this.executeCommandWithGlide("MSET", () -> {
            if (keysvalues.length % 2 == 1) {
                throw new IllegalArgumentException("keyvalues must be of even length");
            }
            HashMap<GlideString, GlideString> keyValueMap = new HashMap<GlideString, GlideString>();
            for (int i = 0; i < keysvalues.length; i += 2) {
                if (i + 1 >= keysvalues.length) continue;
                keyValueMap.put(GlideString.of((byte[])keysvalues[i]), GlideString.of((byte[])keysvalues[i + 1]));
            }
            return (String)this.glideClient.msetBinary(keyValueMap).get();
        });
    }

    public List<String> mget(String ... keys) {
        return this.executeCommandWithGlide("MGET", () -> {
            String[] result = (String[])this.glideClient.mget(keys).get();
            return Arrays.asList(result);
        });
    }

    public List<byte[]> mget(byte[] ... keys) {
        return this.executeCommandWithGlide("MGET", () -> {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            GlideString[] result = (GlideString[])this.glideClient.mget(glideKeys).get();
            ArrayList<byte[]> byteList = new ArrayList<byte[]>();
            for (GlideString gs : result) {
                byteList.add(gs != null ? gs.getBytes() : null);
            }
            return byteList;
        });
    }

    public long setnx(String key, String value) {
        return this.executeCommandWithGlide("SETNX", () -> {
            Object result = this.glideClient.customCommand(new String[]{"SETNX", key, value}).get();
            if (result instanceof Long) {
                return (Long)result;
            }
            if (result instanceof Boolean) {
                return (Boolean)result != false ? 1L : 0L;
            }
            return Long.parseLong(result.toString());
        });
    }

    public long setnx(byte[] key, byte[] value) {
        return this.executeCommandWithGlide("SETNX", () -> {
            Object result = this.glideClient.customCommand(new GlideString[]{GlideString.of((String)"SETNX"), GlideString.of((byte[])key), GlideString.of((byte[])value)}).get();
            if (result instanceof Long) {
                return (Long)result;
            }
            if (result instanceof Boolean) {
                return (Boolean)result != false ? 1L : 0L;
            }
            return Long.parseLong(result.toString());
        });
    }

    public String setex(String key, long seconds, String value) {
        return this.executeCommandWithGlide("SETEX", () -> {
            Object result = this.glideClient.customCommand(new String[]{"SETEX", key, String.valueOf(seconds), value}).get();
            return result != null ? result.toString() : null;
        });
    }

    public String setex(byte[] key, long seconds, byte[] value) {
        return this.executeCommandWithGlide("SETEX", () -> {
            Object result = this.glideClient.customCommand(new GlideString[]{GlideString.of((String)"SETEX"), GlideString.of((byte[])key), GlideString.of((String)String.valueOf(seconds)), GlideString.of((byte[])value)}).get();
            return result != null ? result.toString() : null;
        });
    }

    public String psetex(String key, long milliseconds, String value) {
        return this.executeCommandWithGlide("PSETEX", () -> {
            Object result = this.glideClient.customCommand(new String[]{"PSETEX", key, String.valueOf(milliseconds), value}).get();
            return result != null ? result.toString() : null;
        });
    }

    public String psetex(byte[] key, long milliseconds, byte[] value) {
        return this.executeCommandWithGlide("PSETEX", () -> {
            Object result = this.glideClient.customCommand(new GlideString[]{GlideString.of((String)"PSETEX"), GlideString.of((byte[])key), GlideString.of((String)String.valueOf(milliseconds)), GlideString.of((byte[])value)}).get();
            return result != null ? result.toString() : null;
        });
    }

    @Deprecated
    public String getSet(String key, String value) {
        return this.executeCommandWithGlide("GETSET", () -> {
            Object result = this.glideClient.customCommand(new String[]{"GETSET", key, value}).get();
            return result != null ? result.toString() : null;
        });
    }

    @Deprecated
    public byte[] getSet(byte[] key, byte[] value) {
        return this.executeCommandWithGlide("GETSET", () -> {
            Object result = this.glideClient.customCommand(new GlideString[]{GlideString.of((String)"GETSET"), GlideString.of((byte[])key), GlideString.of((byte[])value)}).get();
            return result != null ? result.toString().getBytes(VALKEY_CHARSET) : null;
        });
    }

    public String setGet(String key, String value) {
        this.checkNotClosed();
        try {
            Object result = this.glideClient.customCommand(new String[]{"SET", key, value, "GET"}).get();
            return result != null ? result.toString() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETGET operation failed", e);
        }
    }

    public byte[] setGet(byte[] key, byte[] value) {
        this.checkNotClosed();
        try {
            Object result = this.glideClient.customCommand(new GlideString[]{GlideString.of((String)"SET"), GlideString.of((byte[])key), GlideString.of((byte[])value), GlideString.of((String)"GET")}).get();
            return result != null ? result.toString().getBytes(VALKEY_CHARSET) : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SETGET operation failed", e);
        }
    }

    public String setGet(String key, String value, SetParams params) {
        return this.executeCommandWithGlide("SETGET", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("SET");
            args.add(key);
            args.add(value);
            Jedis.addSetParamsToArgs(args, params);
            args.add("GET");
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result != null ? result.toString() : null;
        });
    }

    public byte[] setGet(byte[] key, byte[] value, SetParams params) {
        return this.executeCommandWithGlide("SETGET", () -> {
            ArrayList<GlideString> args = new ArrayList<GlideString>();
            args.add(GlideString.of((String)"SET"));
            args.add(GlideString.of((byte[])key));
            args.add(GlideString.of((byte[])value));
            Jedis.addSetParamsToGlideStringArgs(args, params);
            args.add(GlideString.of((String)"GET"));
            Object result = this.glideClient.customCommand(args.toArray(new GlideString[0])).get();
            return result != null ? result.toString().getBytes(VALKEY_CHARSET) : null;
        });
    }

    public String getDel(String key) {
        return this.executeCommandWithGlide("GETDEL", () -> (String)this.glideClient.getdel(key).get());
    }

    public byte[] getDel(byte[] key) {
        return this.executeCommandWithGlide("GETDEL", () -> {
            GlideString result = (GlideString)this.glideClient.getdel(GlideString.of((byte[])key)).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public String getEx(String key, GetExParams params) {
        return this.executeCommandWithGlide("GETEX", () -> {
            GetExOptions getExOptions = Jedis.convertGetExParamsToGetExOptions(params);
            return (String)this.glideClient.getex(key, getExOptions).get();
        });
    }

    public byte[] getEx(byte[] key, GetExParams params) {
        return this.executeCommandWithGlide("GETEX", () -> {
            GetExOptions getExOptions = Jedis.convertGetExParamsToGetExOptions(params);
            GlideString result = (GlideString)this.glideClient.getex(GlideString.of((byte[])key), getExOptions).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public long append(String key, String value) {
        return this.executeCommandWithGlide("APPEND", () -> (Long)this.glideClient.append(key, value).get());
    }

    public long append(byte[] key, byte[] value) {
        return this.executeCommandWithGlide("APPEND", () -> (Long)this.glideClient.append(GlideString.of((byte[])key), GlideString.of((byte[])value)).get());
    }

    public long strlen(String key) {
        return this.executeCommandWithGlide("STRLEN", () -> (Long)this.glideClient.strlen(key).get());
    }

    public long strlen(byte[] key) {
        return this.executeCommandWithGlide("STRLEN", () -> (Long)this.glideClient.strlen(GlideString.of((byte[])key)).get());
    }

    public long incr(String key) {
        return this.executeCommandWithGlide("INCR", () -> (Long)this.glideClient.incr(key).get());
    }

    public long incr(byte[] key) {
        return this.executeCommandWithGlide("INCR", () -> (Long)this.glideClient.incr(GlideString.of((byte[])key)).get());
    }

    public long incrBy(String key, long increment) {
        return this.executeCommandWithGlide("INCRBY", () -> (Long)this.glideClient.incrBy(key, increment).get());
    }

    public double incrByFloat(String key, double increment) {
        return this.executeCommandWithGlide("INCRBYFLOAT", () -> (Double)this.glideClient.incrByFloat(key, increment).get());
    }

    public long incrBy(byte[] key, long increment) {
        return this.executeCommandWithGlide("INCRBY", () -> (Long)this.glideClient.incrBy(GlideString.of((byte[])key), increment).get());
    }

    public double incrByFloat(byte[] key, double increment) {
        return this.executeCommandWithGlide("INCRBYFLOAT", () -> (Double)this.glideClient.incrByFloat(GlideString.of((byte[])key), increment).get());
    }

    public long decr(String key) {
        return this.executeCommandWithGlide("DECR", () -> (Long)this.glideClient.decr(key).get());
    }

    public long decr(byte[] key) {
        return this.executeCommandWithGlide("DECR", () -> (Long)this.glideClient.decr(GlideString.of((byte[])key)).get());
    }

    public long decrBy(String key, long decrement) {
        return this.executeCommandWithGlide("DECRBY", () -> (Long)this.glideClient.decrBy(key, decrement).get());
    }

    public long decrBy(byte[] key, long decrement) {
        return this.executeCommandWithGlide("DECRBY", () -> (Long)this.glideClient.decrBy(GlideString.of((byte[])key), decrement).get());
    }

    public long unlink(String ... keys) {
        return this.executeCommandWithGlide("UNLINK", () -> (Long)this.glideClient.unlink(keys).get());
    }

    public long unlink(byte[] key) {
        return this.executeCommandWithGlide("UNLINK", () -> (Long)this.glideClient.unlink(new GlideString[]{GlideString.of((byte[])key)}).get());
    }

    public long unlink(byte[] ... keys) {
        return this.executeCommandWithGlide("UNLINK", () -> {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            return (Long)this.glideClient.unlink(glideKeys).get();
        });
    }

    public long exists(String ... keys) {
        return this.executeCommandWithGlide("EXISTS", () -> (Long)this.glideClient.exists(keys).get());
    }

    public boolean exists(byte[] key) {
        return this.executeCommandWithGlide("EXISTS", () -> (Long)this.glideClient.exists(new GlideString[]{GlideString.of((byte[])key)}).get() > 0L);
    }

    public boolean exists(String key) {
        return this.executeCommandWithGlide("EXISTS", () -> (Long)this.glideClient.exists(new String[]{key}).get() > 0L);
    }

    public boolean keyExists(String key) {
        return this.executeCommandWithGlide("EXISTS", () -> (Long)this.glideClient.exists(new String[]{key}).get() > 0L);
    }

    public boolean keyExists(byte[] key) {
        return this.executeCommandWithGlide("EXISTS", () -> (Long)this.glideClient.exists(new GlideString[]{GlideString.of((byte[])key)}).get() > 0L);
    }

    public long exists(byte[] ... keys) {
        return this.executeCommandWithGlide("EXISTS", () -> {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            return (Long)this.glideClient.exists(glideKeys).get();
        });
    }

    public String type(String key) {
        return this.executeCommandWithGlide("TYPE", () -> (String)this.glideClient.type(key).get());
    }

    public String type(byte[] key) {
        return this.executeCommandWithGlide("TYPE", () -> (String)this.glideClient.type(GlideString.of((byte[])key)).get());
    }

    public String randomKey() {
        return this.executeCommandWithGlide("RANDOMKEY", () -> (String)this.glideClient.randomKey().get());
    }

    public String rename(String oldkey, String newkey) {
        return this.executeCommandWithGlide("RENAME", () -> (String)this.glideClient.rename(oldkey, newkey).get());
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        return this.executeCommandWithGlide("RENAME", () -> (String)this.glideClient.rename(GlideString.of((byte[])oldkey), GlideString.of((byte[])newkey)).get());
    }

    public long renamenx(String oldkey, String newkey) {
        return this.executeCommandWithGlide("RENAMENX", () -> {
            Boolean result = (Boolean)this.glideClient.renamenx(oldkey, newkey).get();
            return result != false ? 1L : 0L;
        });
    }

    public long renamenx(byte[] oldkey, byte[] newkey) {
        return this.executeCommandWithGlide("RENAMENX", () -> {
            Boolean result = (Boolean)this.glideClient.renamenx(GlideString.of((byte[])oldkey), GlideString.of((byte[])newkey)).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expire(String key, long seconds) {
        return this.executeCommandWithGlide("EXPIRE", () -> {
            Boolean result = (Boolean)this.glideClient.expire(key, seconds).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expire(byte[] key, long seconds) {
        return this.executeCommandWithGlide("EXPIRE", () -> {
            Boolean result = (Boolean)this.glideClient.expire(GlideString.of((byte[])key), seconds).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expire(byte[] key, long seconds, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("EXPIRE", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.expire(GlideString.of((byte[])key), seconds, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expire(String key, long seconds, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("EXPIRE", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.expire(key, seconds, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expireAt(String key, long unixTime) {
        return this.executeCommandWithGlide("EXPIREAT", () -> {
            Boolean result = (Boolean)this.glideClient.expireAt(key, unixTime).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expireAt(byte[] key, long unixTime) {
        return this.executeCommandWithGlide("EXPIREAT", () -> {
            Boolean result = (Boolean)this.glideClient.expireAt(GlideString.of((byte[])key), unixTime).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expireAt(String key, long unixTime, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("EXPIREAT", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.expireAt(key, unixTime, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expireAt(byte[] key, long unixTime, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("EXPIREAT", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.expireAt(GlideString.of((byte[])key), unixTime, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpire(String key, long milliseconds) {
        return this.executeCommandWithGlide("PEXPIRE", () -> {
            Boolean result = (Boolean)this.glideClient.pexpire(key, milliseconds).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpire(byte[] key, long milliseconds) {
        return this.executeCommandWithGlide("PEXPIRE", () -> {
            Boolean result = (Boolean)this.glideClient.pexpire(GlideString.of((byte[])key), milliseconds).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpire(byte[] key, long milliseconds, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("PEXPIRE", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.pexpire(GlideString.of((byte[])key), milliseconds, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpire(String key, long milliseconds, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("PEXPIRE", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.pexpire(key, milliseconds, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpireAt(String key, long millisecondsTimestamp) {
        return this.executeCommandWithGlide("PEXPIREAT", () -> {
            Boolean result = (Boolean)this.glideClient.pexpireAt(key, millisecondsTimestamp).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpireAt(byte[] key, long millisecondsTimestamp) {
        return this.executeCommandWithGlide("PEXPIREAT", () -> {
            Boolean result = (Boolean)this.glideClient.pexpireAt(GlideString.of((byte[])key), millisecondsTimestamp).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpireAt(String key, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("PEXPIREAT", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.pexpireAt(key, millisecondsTimestamp, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pexpireAt(byte[] key, long millisecondsTimestamp, ExpiryOption expiryOption) {
        return this.executeCommandWithGlide("PEXPIREAT", () -> {
            ExpireOptions glideOption = Jedis.convertExpiryOptionToExpireOptions(expiryOption);
            Boolean result = (Boolean)this.glideClient.pexpireAt(GlideString.of((byte[])key), millisecondsTimestamp, glideOption).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expireTime(String key) {
        return this.executeCommandWithGlide("EXPIRETIME", () -> (Long)this.glideClient.expiretime(key).get());
    }

    public long pexpireTime(String key) {
        return this.executeCommandWithGlide("PEXPIRETIME", () -> (Long)this.glideClient.pexpiretime(key).get());
    }

    public long pexpireat(byte[] key, long millisecondsTimestamp) {
        return this.executeCommandWithGlide("PEXPIREAT", () -> {
            Boolean result = (Boolean)this.glideClient.pexpireAt(GlideString.of((byte[])key), millisecondsTimestamp).get();
            return result != false ? 1L : 0L;
        });
    }

    public long expireTime(byte[] key) {
        return this.executeCommandWithGlide("EXPIRETIME", () -> (Long)this.glideClient.expiretime(GlideString.of((byte[])key)).get());
    }

    public long pexpireTime(byte[] key) {
        return this.executeCommandWithGlide("PEXPIRETIME", () -> (Long)this.glideClient.pexpiretime(GlideString.of((byte[])key)).get());
    }

    public long ttl(String key) {
        return this.executeCommandWithGlide("TTL", () -> (Long)this.glideClient.ttl(key).get());
    }

    public long ttl(byte[] key) {
        return this.executeCommandWithGlide("TTL", () -> (Long)this.glideClient.ttl(GlideString.of((byte[])key)).get());
    }

    public long pttl(String key) {
        return this.executeCommandWithGlide("PTTL", () -> (Long)this.glideClient.pttl(key).get());
    }

    public long pttl(byte[] key) {
        return this.executeCommandWithGlide("PTTL", () -> (Long)this.glideClient.pttl(GlideString.of((byte[])key)).get());
    }

    public long persist(String key) {
        return this.executeCommandWithGlide("PERSIST", () -> {
            Boolean result = (Boolean)this.glideClient.persist(key).get();
            return result != false ? 1L : 0L;
        });
    }

    public long persist(byte[] key) {
        return this.executeCommandWithGlide("PERSIST", () -> {
            Boolean result = (Boolean)this.glideClient.persist(GlideString.of((byte[])key)).get();
            return result != false ? 1L : 0L;
        });
    }

    public List<String> sort(String key) {
        return this.executeCommandWithGlide("SORT", () -> {
            String[] result = (String[])this.glideClient.sort(key).get();
            return Arrays.asList(result);
        });
    }

    public List<String> sort(String key, String ... sortingParameters) {
        this.checkNotClosed();
        try {
            if (sortingParameters.length == 0) {
                String[] result = (String[])this.glideClient.sort(key).get();
                return Arrays.asList(result);
            }
            SortOptions sortOptions = Jedis.parseSortParameters(sortingParameters);
            String[] result = (String[])this.glideClient.sort(key, sortOptions).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SORT operation failed", e);
        }
    }

    private static SortOptions parseSortParameters(String[] params) {
        SortOptions.SortOptionsBuilder builder = SortOptions.builder();
        block18: for (int i = 0; i < params.length; ++i) {
            String param;
            switch (param = params[i].toUpperCase()) {
                case "BY": {
                    if (i + 1 >= params.length) continue block18;
                    builder.byPattern(params[++i]);
                    continue block18;
                }
                case "LIMIT": {
                    if (i + 2 >= params.length) continue block18;
                    try {
                        long offset = Long.parseLong(params[++i]);
                        long count = Long.parseLong(params[++i]);
                        builder.limit(new SortBaseOptions.Limit(offset, count));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block18;
                }
                case "GET": {
                    if (i + 1 >= params.length) continue block18;
                    builder.getPattern(params[++i]);
                    continue block18;
                }
                case "ASC": {
                    builder.orderBy(SortBaseOptions.OrderBy.ASC);
                    continue block18;
                }
                case "DESC": {
                    builder.orderBy(SortBaseOptions.OrderBy.DESC);
                    continue block18;
                }
                case "ALPHA": {
                    builder.alpha();
                    continue block18;
                }
            }
        }
        return builder.build();
    }

    public byte[] dump(String key) {
        return this.executeCommandWithGlide("DUMP", () -> (byte[])this.glideClient.dump(GlideString.of((String)key)).get());
    }

    public byte[] dump(byte[] key) {
        return this.executeCommandWithGlide("DUMP", () -> (byte[])this.glideClient.dump(GlideString.of((byte[])key)).get());
    }

    public String restore(String key, long ttl, byte[] serializedValue) {
        return this.executeCommandWithGlide("RESTORE", () -> (String)this.glideClient.restore(GlideString.of((String)key), ttl, serializedValue).get());
    }

    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.checkNotClosed();
        try {
            Object result = this.glideClient.customCommand(new String[]{"MIGRATE", host, String.valueOf(port), key, String.valueOf(destinationDb), String.valueOf(timeout)}).get();
            return result != null ? result.toString() : "OK";
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("MIGRATE operation failed", e);
        }
    }

    public long move(String key, int dbIndex) {
        return this.executeCommandWithGlide("MOVE", () -> {
            Boolean result = (Boolean)this.glideClient.move(key, (long)dbIndex).get();
            return result != false ? 1L : 0L;
        });
    }

    public long move(byte[] key, int dbIndex) {
        return this.executeCommandWithGlide("MOVE", () -> {
            Boolean result = (Boolean)this.glideClient.move(GlideString.of((byte[])key), (long)dbIndex).get();
            return result != false ? 1L : 0L;
        });
    }

    private static LPosOptions convertLPosParamsToLPosOptions(LPosParams params) {
        LPosOptions.LPosOptionsBuilder builder = LPosOptions.builder();
        if (params.getRank() != null) {
            builder.rank(Long.valueOf(params.getRank().intValue()));
        }
        if (params.getMaxlen() != null) {
            builder.maxLength(Long.valueOf(params.getMaxlen().intValue()));
        }
        return builder.build();
    }

    private static glide.api.models.commands.ListDirection convertToGlideListDirection(ListDirection jedisDirection) {
        return jedisDirection == ListDirection.LEFT ? glide.api.models.commands.ListDirection.LEFT : glide.api.models.commands.ListDirection.RIGHT;
    }

    private static GlideString[] convertToGlideStringArray(String[] strings) {
        GlideString[] glideStrings = new GlideString[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            glideStrings[i] = GlideString.of((String)strings[i]);
        }
        return glideStrings;
    }

    private static GlideString[] convertToGlideStringArray(byte[][] bytes) {
        GlideString[] glideStrings = new GlideString[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            glideStrings[i] = GlideString.of((byte[])bytes[i]);
        }
        return glideStrings;
    }

    private static ScanResult<String> convertToScanResult(Object[] result) {
        if (result != null && result.length >= 2) {
            String newCursor = result[0].toString();
            Object keysObj = result[1];
            if (keysObj instanceof Object[]) {
                Object[] keysArray = (Object[])keysObj;
                ArrayList<String> keys = new ArrayList<String>();
                for (Object key : keysArray) {
                    keys.add(key != null ? key.toString() : null);
                }
                return new ScanResult<String>(newCursor, keys);
            }
        }
        return new ScanResult<String>("0", Collections.emptyList());
    }

    private static ScanOptions convertScanParamsToScanOptions(ScanParams params) {
        ScanOptions.ScanOptionsBuilder builder = ScanOptions.builder();
        if (params.getMatchPattern() != null) {
            builder.matchPattern(params.getMatchPattern());
        }
        if (params.getCount() != null) {
            builder.count(params.getCount());
        }
        if (params.getType() != null) {
            try {
                ScanOptions.ObjectType objectType = ScanOptions.ObjectType.valueOf((String)params.getType().toUpperCase());
                builder.type(objectType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public ScanResult<String> scan(String cursor, ScanParams params) {
        return this.executeCommandWithGlide("SCAN", () -> {
            ScanOptions options = Jedis.convertScanParamsToScanOptions(params);
            Object[] result = (Object[])this.glideClient.scan(cursor, options).get();
            return Jedis.convertToScanResult(result);
        });
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        this.checkNotClosed();
        try {
            ScanOptions options = Jedis.convertScanParamsToScanOptions(params);
            Object[] result = (Object[])this.glideClient.scan(new String(cursor, VALKEY_CHARSET), options).get();
            if (result != null && result.length >= 2) {
                String newCursor = result[0].toString();
                Object keysObj = result[1];
                if (keysObj instanceof Object[]) {
                    Object[] keysArray = (Object[])keysObj;
                    ArrayList<byte[]> keys = new ArrayList<byte[]>();
                    for (Object key : keysArray) {
                        keys.add(key != null ? key.toString().getBytes(VALKEY_CHARSET) : null);
                    }
                    return new ScanResult<byte[]>(newCursor, keys);
                }
            }
            return new ScanResult<byte[]>("0", Collections.emptyList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public ScanResult<byte[]> scan(byte[] cursor) {
        this.checkNotClosed();
        try {
            Object[] result = (Object[])this.glideClient.scan(new String(cursor, VALKEY_CHARSET)).get();
            if (result != null && result.length >= 2) {
                String newCursor = result[0].toString();
                Object keysObj = result[1];
                if (keysObj instanceof Object[]) {
                    Object[] keysArray = (Object[])keysObj;
                    ArrayList<byte[]> keys = new ArrayList<byte[]>();
                    for (Object key : keysArray) {
                        keys.add(key != null ? key.toString().getBytes(VALKEY_CHARSET) : null);
                    }
                    return new ScanResult<byte[]>(newCursor, keys);
                }
            }
            return new ScanResult<byte[]>("0", Collections.emptyList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public ScanResult<String> scan(String cursor) {
        return this.executeCommandWithGlide("SCAN", () -> {
            Object[] result = (Object[])this.glideClient.scan(cursor).get();
            return Jedis.convertToScanResult(result);
        });
    }

    public ScanResult<String> scan(String cursor, ScanParams params, String type) {
        this.checkNotClosed();
        try {
            ScanOptions options = Jedis.convertScanParamsToScanOptions(params);
            if (type != null) {
                try {
                    ScanOptions.ObjectType objectType = ScanOptions.ObjectType.valueOf((String)type.toUpperCase());
                    options = ((ScanOptions.ScanOptionsBuilder)((ScanOptions.ScanOptionsBuilder)ScanOptions.builder().matchPattern(params.getMatchPattern())).count(params.getCount())).type(objectType).build();
                }
                catch (IllegalArgumentException objectType) {
                    // empty catch block
                }
            }
            Object[] result = (Object[])this.glideClient.scan(cursor, options).get();
            return Jedis.convertToScanResult(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params, byte[] type) {
        this.checkNotClosed();
        try {
            Object[] result;
            ScanOptions options = Jedis.convertScanParamsToScanOptions(params);
            if (type != null) {
                try {
                    String typeStr = new String(type, VALKEY_CHARSET);
                    ScanOptions.ObjectType objectType = ScanOptions.ObjectType.valueOf((String)typeStr.toUpperCase());
                    options = ((ScanOptions.ScanOptionsBuilder)((ScanOptions.ScanOptionsBuilder)ScanOptions.builder().matchPattern(params.getMatchPattern())).count(params.getCount())).type(objectType).build();
                }
                catch (IllegalArgumentException typeStr) {
                    // empty catch block
                }
            }
            if ((result = (Object[])this.glideClient.scan(new String(cursor, VALKEY_CHARSET), options).get()) != null && result.length >= 2) {
                String newCursor = result[0].toString();
                Object keysObj = result[1];
                if (keysObj instanceof Object[]) {
                    Object[] keysArray = (Object[])keysObj;
                    ArrayList<byte[]> keys = new ArrayList<byte[]>();
                    for (Object key : keysArray) {
                        keys.add(key != null ? key.toString().getBytes(VALKEY_CHARSET) : null);
                    }
                    return new ScanResult<byte[]>(newCursor, keys);
                }
            }
            return new ScanResult<byte[]>("0", Collections.emptyList());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("SCAN operation failed", e);
        }
    }

    public long touch(String ... keys) {
        return this.executeCommandWithGlide("TOUCH", () -> (Long)this.glideClient.touch(keys).get());
    }

    public long touch(byte[] key) {
        return this.executeCommandWithGlide("TOUCH", () -> (Long)this.glideClient.touch(new GlideString[]{GlideString.of((byte[])key)}).get());
    }

    public long touch(byte[] ... keys) {
        return this.executeCommandWithGlide("TOUCH", () -> {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            return (Long)this.glideClient.touch(glideKeys).get();
        });
    }

    public boolean copy(String srcKey, String dstKey, boolean replace) {
        return this.executeCommandWithGlide("COPY", () -> (Boolean)this.glideClient.copy(srcKey, dstKey, replace).get());
    }

    public boolean copy(byte[] srcKey, byte[] dstKey, boolean replace) {
        return this.executeCommandWithGlide("COPY", () -> (Boolean)this.glideClient.copy(GlideString.of((byte[])srcKey), GlideString.of((byte[])dstKey), replace).get());
    }

    public boolean copy(String srcKey, String dstKey, int db, boolean replace) {
        this.checkNotClosed();
        try {
            String[] stringArray;
            if (replace) {
                String[] stringArray2 = new String[6];
                stringArray2[0] = "COPY";
                stringArray2[1] = srcKey;
                stringArray2[2] = dstKey;
                stringArray2[3] = "DB";
                stringArray2[4] = String.valueOf(db);
                stringArray = stringArray2;
                stringArray2[5] = "REPLACE";
            } else {
                String[] stringArray3 = new String[5];
                stringArray3[0] = "COPY";
                stringArray3[1] = srcKey;
                stringArray3[2] = dstKey;
                stringArray3[3] = "DB";
                stringArray = stringArray3;
                stringArray3[4] = String.valueOf(db);
            }
            String[] args = stringArray;
            Object result = this.glideClient.customCommand(args).get();
            if (result instanceof Long) {
                return ((Long)result).equals(1L);
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return "1".equals(result.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("COPY operation failed", e);
        }
    }

    public boolean copy(byte[] srcKey, byte[] dstKey, int db, boolean replace) {
        this.checkNotClosed();
        try {
            GlideString[] glideStringArray;
            if (replace) {
                GlideString[] glideStringArray2 = new GlideString[6];
                glideStringArray2[0] = GlideString.of((String)"COPY");
                glideStringArray2[1] = GlideString.of((byte[])srcKey);
                glideStringArray2[2] = GlideString.of((byte[])dstKey);
                glideStringArray2[3] = GlideString.of((String)"DB");
                glideStringArray2[4] = GlideString.of((String)String.valueOf(db));
                glideStringArray = glideStringArray2;
                glideStringArray2[5] = GlideString.of((String)"REPLACE");
            } else {
                GlideString[] glideStringArray3 = new GlideString[5];
                glideStringArray3[0] = GlideString.of((String)"COPY");
                glideStringArray3[1] = GlideString.of((byte[])srcKey);
                glideStringArray3[2] = GlideString.of((byte[])dstKey);
                glideStringArray3[3] = GlideString.of((String)"DB");
                glideStringArray = glideStringArray3;
                glideStringArray3[4] = GlideString.of((String)String.valueOf(db));
            }
            GlideString[] args = glideStringArray;
            Object result = this.glideClient.customCommand(args).get();
            if (result instanceof Long) {
                return ((Long)result).equals(1L);
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return "1".equals(result.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("COPY operation failed", e);
        }
    }

    public boolean setbit(String key, long offset, boolean value) {
        return this.executeCommandWithGlide("SETBIT", () -> {
            Long result = (Long)this.glideClient.setbit(key, offset, value ? 1L : 0L).get();
            return result.equals(1L);
        });
    }

    public boolean setbit(byte[] key, long offset, boolean value) {
        return this.executeCommandWithGlide("SETBIT", () -> {
            Long result = (Long)this.glideClient.setbit(GlideString.of((byte[])key), offset, value ? 1L : 0L).get();
            return result.equals(1L);
        });
    }

    public boolean getbit(String key, long offset) {
        return this.executeCommandWithGlide("GETBIT", () -> {
            Long result = (Long)this.glideClient.getbit(key, offset).get();
            return result.equals(1L);
        });
    }

    public boolean getbit(byte[] key, long offset) {
        return this.executeCommandWithGlide("GETBIT", () -> {
            Long result = (Long)this.glideClient.getbit(GlideString.of((byte[])key), offset).get();
            return result.equals(1L);
        });
    }

    public long bitcount(String key) {
        return this.executeCommandWithGlide("BITCOUNT", () -> (Long)this.glideClient.bitcount(key).get());
    }

    public long bitcount(String key, long start, long end) {
        return this.executeCommandWithGlide("BITCOUNT", () -> (Long)this.glideClient.bitcount(key, start, end).get());
    }

    public long bitcount(byte[] key) {
        return this.executeCommandWithGlide("BITCOUNT", () -> (Long)this.glideClient.bitcount(GlideString.of((byte[])key)).get());
    }

    public long bitcount(byte[] key, long start, long end) {
        return this.executeCommandWithGlide("BITCOUNT", () -> (Long)this.glideClient.bitcount(GlideString.of((byte[])key), start, end).get());
    }

    public long bitcount(byte[] key, long start, long end, BitCountOption option) {
        return this.executeCommandWithGlide("BITCOUNT", () -> {
            BitmapIndexType indexType = Jedis.convertBitCountOptionToBitmapIndexType(option);
            return (Long)this.glideClient.bitcount(GlideString.of((byte[])key), start, end, indexType).get();
        });
    }

    public long bitcount(String key, long start, long end, BitCountOption option) {
        return this.executeCommandWithGlide("BITCOUNT", () -> {
            BitmapIndexType indexType = Jedis.convertBitCountOptionToBitmapIndexType(option);
            return (Long)this.glideClient.bitcount(key, start, end, indexType).get();
        });
    }

    public long bitpos(String key, boolean value) {
        return this.executeCommandWithGlide("BITPOS", () -> (Long)this.glideClient.bitpos(key, value ? 1L : 0L).get());
    }

    public long bitpos(byte[] key, boolean value) {
        return this.executeCommandWithGlide("BITPOS", () -> (Long)this.glideClient.bitpos(GlideString.of((byte[])key), value ? 1L : 0L).get());
    }

    public long bitpos(String key, boolean value, BitPosParams params) {
        this.checkNotClosed();
        try {
            long bitValue;
            long l = bitValue = value ? 1L : 0L;
            if (params.getStart() != null && params.getEnd() != null) {
                if (params.getModifier() != null) {
                    BitmapIndexType indexType = Jedis.convertBitCountOptionToBitmapIndexType(params.getModifier());
                    return (Long)this.glideClient.bitpos(key, bitValue, params.getStart().longValue(), params.getEnd().longValue(), indexType).get();
                }
                return (Long)this.glideClient.bitpos(key, bitValue, params.getStart().longValue(), params.getEnd().longValue()).get();
            }
            if (params.getStart() != null) {
                return (Long)this.glideClient.bitpos(key, bitValue, params.getStart().longValue()).get();
            }
            return (Long)this.glideClient.bitpos(key, bitValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITPOS operation failed", e);
        }
    }

    public long bitpos(byte[] key, boolean value, BitPosParams params) {
        this.checkNotClosed();
        try {
            long bitValue = value ? 1L : 0L;
            GlideString glideKey = GlideString.of((byte[])key);
            if (params.getStart() != null && params.getEnd() != null) {
                if (params.getModifier() != null) {
                    BitmapIndexType indexType = Jedis.convertBitCountOptionToBitmapIndexType(params.getModifier());
                    return (Long)this.glideClient.bitpos(glideKey, bitValue, params.getStart().longValue(), params.getEnd().longValue(), indexType).get();
                }
                return (Long)this.glideClient.bitpos(glideKey, bitValue, params.getStart().longValue(), params.getEnd().longValue()).get();
            }
            if (params.getStart() != null) {
                return (Long)this.glideClient.bitpos(glideKey, bitValue, params.getStart().longValue()).get();
            }
            return (Long)this.glideClient.bitpos(glideKey, bitValue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITPOS operation failed", e);
        }
    }

    public long bitop(BitOP op, String destKey, String ... srcKeys) {
        this.checkNotClosed();
        try {
            BitwiseOperation operation;
            switch (op) {
                case AND: {
                    operation = BitwiseOperation.AND;
                    break;
                }
                case OR: {
                    operation = BitwiseOperation.OR;
                    break;
                }
                case XOR: {
                    operation = BitwiseOperation.XOR;
                    break;
                }
                case NOT: {
                    operation = BitwiseOperation.NOT;
                    break;
                }
                case DIFF: 
                case DIFF1: 
                case ANDOR: 
                case ONE: {
                    throw new UnsupportedOperationException("BITOP operation " + String.valueOf((Object)op) + " is not supported by GLIDE");
                }
                default: {
                    throw new IllegalArgumentException("Unsupported bitwise operation: " + String.valueOf((Object)op));
                }
            }
            return (Long)this.glideClient.bitop(operation, destKey, srcKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITOP operation failed", e);
        }
    }

    public long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.checkNotClosed();
        try {
            BitwiseOperation operation;
            switch (op) {
                case AND: {
                    operation = BitwiseOperation.AND;
                    break;
                }
                case OR: {
                    operation = BitwiseOperation.OR;
                    break;
                }
                case XOR: {
                    operation = BitwiseOperation.XOR;
                    break;
                }
                case NOT: {
                    operation = BitwiseOperation.NOT;
                    break;
                }
                case DIFF: 
                case DIFF1: 
                case ANDOR: 
                case ONE: {
                    throw new UnsupportedOperationException("BITOP operation " + String.valueOf((Object)op) + " is not supported by GLIDE");
                }
                default: {
                    throw new IllegalArgumentException("Unsupported bitwise operation: " + String.valueOf((Object)op));
                }
            }
            String[] stringSrcKeys = new String[srcKeys.length];
            for (int i = 0; i < srcKeys.length; ++i) {
                stringSrcKeys[i] = new String(srcKeys[i], VALKEY_CHARSET);
            }
            return (Long)this.glideClient.bitop(operation, new String(destKey, VALKEY_CHARSET), stringSrcKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITOP operation failed", e);
        }
    }

    public List<Long> bitfield(String key, String ... arguments) {
        this.checkNotClosed();
        try {
            if (arguments.length == 0) {
                return Arrays.asList(new Long[0]);
            }
            BitFieldOptions.BitFieldSubCommands[] subCommands = Jedis.parseBitFieldArguments(arguments);
            Long[] result = (Long[])this.glideClient.bitfield(key, subCommands).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD operation failed", e);
        }
    }

    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        this.checkNotClosed();
        try {
            if (arguments.length == 0) {
                return Arrays.asList(new Long[0]);
            }
            String[] stringArguments = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                stringArguments[i] = new String(arguments[i], VALKEY_CHARSET);
            }
            BitFieldOptions.BitFieldSubCommands[] subCommands = Jedis.parseBitFieldArguments(stringArguments);
            Long[] result = (Long[])this.glideClient.bitfield(GlideString.of((byte[])key), subCommands).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD operation failed", e);
        }
    }

    public List<Long> bitfieldReadonly(String key, String ... arguments) {
        this.checkNotClosed();
        try {
            if (arguments.length == 0) {
                return Arrays.asList(new Long[0]);
            }
            BitFieldOptions.BitFieldReadOnlySubCommands[] subCommands = Jedis.parseBitFieldReadOnlyArguments(arguments);
            Long[] result = (Long[])this.glideClient.bitfieldReadOnly(key, subCommands).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD_RO operation failed", e);
        }
    }

    public List<Long> bitfieldReadonly(byte[] key, byte[] ... arguments) {
        this.checkNotClosed();
        try {
            if (arguments.length == 0) {
                return Arrays.asList(new Long[0]);
            }
            String[] stringArguments = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                stringArguments[i] = new String(arguments[i], VALKEY_CHARSET);
            }
            BitFieldOptions.BitFieldReadOnlySubCommands[] subCommands = Jedis.parseBitFieldReadOnlyArguments(stringArguments);
            Long[] result = (Long[])this.glideClient.bitfieldReadOnly(GlideString.of((byte[])key), subCommands).get();
            return Arrays.asList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BITFIELD_RO operation failed", e);
        }
    }

    private static BitFieldOptions.BitFieldSubCommands[] parseBitFieldArguments(String[] args) {
        ArrayList<Object> commands = new ArrayList<Object>();
        int i = 0;
        block12: while (i < args.length) {
            String command;
            switch (command = args[i].toUpperCase()) {
                case "GET": {
                    if (i + 2 < args.length) {
                        commands.add(Jedis.createBitFieldGet(args[i + 1], args[i + 2]));
                        i += 3;
                        continue block12;
                    }
                    throw new IllegalArgumentException("GET command requires encoding and offset parameters");
                }
                case "SET": {
                    if (i + 3 < args.length) {
                        long value = Long.parseLong(args[i + 3]);
                        commands.add(Jedis.createBitFieldSet(args[i + 1], args[i + 2], value));
                        i += 4;
                        continue block12;
                    }
                    throw new IllegalArgumentException("SET command requires encoding, offset, and value parameters");
                }
                case "INCRBY": {
                    if (i + 3 < args.length) {
                        long increment = Long.parseLong(args[i + 3]);
                        commands.add(Jedis.createBitFieldIncrby(args[i + 1], args[i + 2], increment));
                        i += 4;
                        continue block12;
                    }
                    throw new IllegalArgumentException("INCRBY command requires encoding, offset, and increment parameters");
                }
                case "OVERFLOW": {
                    if (i + 1 < args.length) {
                        BitFieldOptions.BitFieldOverflow.BitOverflowControl control = Jedis.parseOverflowControl(args[i + 1]);
                        commands.add(new BitFieldOptions.BitFieldOverflow(control));
                        i += 2;
                        continue block12;
                    }
                    throw new IllegalArgumentException("OVERFLOW command requires control parameter");
                }
            }
            throw new IllegalArgumentException("Unknown bitfield command: " + command);
        }
        return commands.toArray(new BitFieldOptions.BitFieldSubCommands[0]);
    }

    private static BitFieldOptions.BitFieldReadOnlySubCommands[] parseBitFieldReadOnlyArguments(String[] args) {
        ArrayList<BitFieldOptions.BitFieldGet> commands = new ArrayList<BitFieldOptions.BitFieldGet>();
        for (int i = 0; i < args.length; i += 3) {
            String command = args[i].toUpperCase();
            if ("GET".equals(command)) {
                if (i + 2 < args.length) {
                    commands.add(Jedis.createBitFieldGet(args[i + 1], args[i + 2]));
                    continue;
                }
                throw new IllegalArgumentException("GET command requires encoding and offset parameters");
            }
            throw new IllegalArgumentException("BITFIELD_RO only supports GET operations, found: " + command);
        }
        return commands.toArray(new BitFieldOptions.BitFieldReadOnlySubCommands[0]);
    }

    private static Object parseEncoding(String encodingStr) {
        if (encodingStr.startsWith("u")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            return new BitFieldOptions.UnsignedEncoding(bits);
        }
        if (encodingStr.startsWith("i")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            return new BitFieldOptions.SignedEncoding(bits);
        }
        throw new IllegalArgumentException("Invalid encoding format: " + encodingStr + ". Must start with 'u' or 'i'");
    }

    private static Object parseOffset(String offsetStr) {
        if (offsetStr.startsWith("#")) {
            long offset = Long.parseLong(offsetStr.substring(1));
            return new BitFieldOptions.OffsetMultiplier(offset);
        }
        long offset = Long.parseLong(offsetStr);
        return new BitFieldOptions.Offset(offset);
    }

    private static BitFieldOptions.BitFieldGet createBitFieldGet(String encodingStr, String offsetStr) {
        if (encodingStr.startsWith("u")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            BitFieldOptions.UnsignedEncoding encoding = new BitFieldOptions.UnsignedEncoding(bits);
            if (offsetStr.startsWith("#")) {
                long offset = Long.parseLong(offsetStr.substring(1));
                return new BitFieldOptions.BitFieldGet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.OffsetMultiplier(offset));
            }
            long offset = Long.parseLong(offsetStr);
            return new BitFieldOptions.BitFieldGet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.Offset(offset));
        }
        if (encodingStr.startsWith("i")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            BitFieldOptions.SignedEncoding encoding = new BitFieldOptions.SignedEncoding(bits);
            if (offsetStr.startsWith("#")) {
                long offset = Long.parseLong(offsetStr.substring(1));
                return new BitFieldOptions.BitFieldGet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.OffsetMultiplier(offset));
            }
            long offset = Long.parseLong(offsetStr);
            return new BitFieldOptions.BitFieldGet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.Offset(offset));
        }
        throw new IllegalArgumentException("Invalid encoding format: " + encodingStr + ". Must start with 'u' or 'i'");
    }

    private static BitFieldOptions.BitFieldSet createBitFieldSet(String encodingStr, String offsetStr, long value) {
        if (encodingStr.startsWith("u")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            BitFieldOptions.UnsignedEncoding encoding = new BitFieldOptions.UnsignedEncoding(bits);
            if (offsetStr.startsWith("#")) {
                long offset = Long.parseLong(offsetStr.substring(1));
                return new BitFieldOptions.BitFieldSet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.OffsetMultiplier(offset), value);
            }
            long offset = Long.parseLong(offsetStr);
            return new BitFieldOptions.BitFieldSet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.Offset(offset), value);
        }
        if (encodingStr.startsWith("i")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            BitFieldOptions.SignedEncoding encoding = new BitFieldOptions.SignedEncoding(bits);
            if (offsetStr.startsWith("#")) {
                long offset = Long.parseLong(offsetStr.substring(1));
                return new BitFieldOptions.BitFieldSet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.OffsetMultiplier(offset), value);
            }
            long offset = Long.parseLong(offsetStr);
            return new BitFieldOptions.BitFieldSet((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.Offset(offset), value);
        }
        throw new IllegalArgumentException("Invalid encoding format: " + encodingStr + ". Must start with 'u' or 'i'");
    }

    private static BitFieldOptions.BitFieldIncrby createBitFieldIncrby(String encodingStr, String offsetStr, long increment) {
        if (encodingStr.startsWith("u")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            BitFieldOptions.UnsignedEncoding encoding = new BitFieldOptions.UnsignedEncoding(bits);
            if (offsetStr.startsWith("#")) {
                long offset = Long.parseLong(offsetStr.substring(1));
                return new BitFieldOptions.BitFieldIncrby((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.OffsetMultiplier(offset), increment);
            }
            long offset = Long.parseLong(offsetStr);
            return new BitFieldOptions.BitFieldIncrby((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.Offset(offset), increment);
        }
        if (encodingStr.startsWith("i")) {
            long bits = Long.parseLong(encodingStr.substring(1));
            BitFieldOptions.SignedEncoding encoding = new BitFieldOptions.SignedEncoding(bits);
            if (offsetStr.startsWith("#")) {
                long offset = Long.parseLong(offsetStr.substring(1));
                return new BitFieldOptions.BitFieldIncrby((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.OffsetMultiplier(offset), increment);
            }
            long offset = Long.parseLong(offsetStr);
            return new BitFieldOptions.BitFieldIncrby((BitFieldOptions.BitEncoding)encoding, (BitFieldOptions.BitOffset)new BitFieldOptions.Offset(offset), increment);
        }
        throw new IllegalArgumentException("Invalid encoding format: " + encodingStr + ". Must start with 'u' or 'i'");
    }

    private static BitFieldOptions.BitFieldOverflow.BitOverflowControl parseOverflowControl(String controlStr) {
        switch (controlStr.toUpperCase()) {
            case "WRAP": {
                return BitFieldOptions.BitFieldOverflow.BitOverflowControl.WRAP;
            }
            case "SAT": {
                return BitFieldOptions.BitFieldOverflow.BitOverflowControl.SAT;
            }
            case "FAIL": {
                return BitFieldOptions.BitFieldOverflow.BitOverflowControl.FAIL;
            }
        }
        throw new IllegalArgumentException("Invalid overflow control: " + controlStr + ". Must be WRAP, SAT, or FAIL");
    }

    private static String[] concatenateArrays(String[] array1, String[] array2) {
        String[] result = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public long pfadd(String key, String ... elements) {
        return this.executeCommandWithGlide("PFADD", () -> {
            Boolean result = (Boolean)this.glideClient.pfadd(key, elements).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pfadd(byte[] key, byte[] ... elements) {
        return this.executeCommandWithGlide("PFADD", () -> {
            String[] stringElements = new String[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                stringElements[i] = new String(elements[i], VALKEY_CHARSET);
            }
            Boolean result = (Boolean)this.glideClient.pfadd(new String(key, VALKEY_CHARSET), stringElements).get();
            return result != false ? 1L : 0L;
        });
    }

    public long pfcount(String key) {
        return this.executeCommandWithGlide("PFCOUNT", () -> (Long)this.glideClient.pfcount(new String[]{key}).get());
    }

    public long pfcount(String ... keys) {
        return this.executeCommandWithGlide("PFCOUNT", () -> (Long)this.glideClient.pfcount(keys).get());
    }

    public String pfmerge(String destKey, String ... sourceKeys) {
        return this.executeCommandWithGlide("PFMERGE", () -> (String)this.glideClient.pfmerge(destKey, sourceKeys).get());
    }

    public long pfcount(byte[] key) {
        return this.executeCommandWithGlide("PFCOUNT", () -> (Long)this.glideClient.pfcount(new String[]{new String(key, VALKEY_CHARSET)}).get());
    }

    public long pfcount(byte[] ... keys) {
        this.checkNotClosed();
        try {
            String[] stringKeys = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                stringKeys[i] = new String(keys[i], VALKEY_CHARSET);
            }
            return (Long)this.glideClient.pfcount(stringKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFCOUNT operation failed", e);
        }
    }

    public String pfmerge(byte[] destKey, byte[] ... sourceKeys) {
        this.checkNotClosed();
        try {
            String[] stringSourceKeys = new String[sourceKeys.length];
            for (int i = 0; i < sourceKeys.length; ++i) {
                stringSourceKeys[i] = new String(sourceKeys[i], VALKEY_CHARSET);
            }
            return (String)this.glideClient.pfmerge(new String(destKey, VALKEY_CHARSET), stringSourceKeys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("PFMERGE operation failed", e);
        }
    }

    public Object sendCommand(ProtocolCommand cmd, byte[] ... args) {
        this.checkNotClosed();
        if (cmd instanceof Protocol.Command) {
            Protocol.Command command = (Protocol.Command)cmd;
            try {
                return this.executeProtocolCommandWithByteArgs(command.name(), args);
            }
            catch (Exception e) {
                throw new JedisException("Command execution failed: " + command.name(), e);
            }
        }
        throw new UnsupportedOperationException("ProtocolCommand type " + cmd.getClass().getSimpleName() + " is not supported in GLIDE compatibility layer. Supported types: Protocol.Command. Use specific typed methods instead.");
    }

    public Object sendCommand(ProtocolCommand cmd, String ... args) {
        this.checkNotClosed();
        if (cmd instanceof Protocol.Command) {
            Protocol.Command command = (Protocol.Command)cmd;
            try {
                return this.executeProtocolCommandWithStringArgs(command.name(), args);
            }
            catch (Exception e) {
                throw new JedisException("Command execution failed: " + command.name(), e);
            }
        }
        throw new UnsupportedOperationException("ProtocolCommand type " + cmd.getClass().getSimpleName() + " is not supported in GLIDE compatibility layer. Supported types: Protocol.Command. Use specific typed methods instead.");
    }

    public Object sendCommand(ProtocolCommand cmd) {
        return this.sendCommand(cmd, new byte[0][]);
    }

    private Object executeProtocolCommandWithStringArgs(String commandName, String ... args) throws Exception {
        String[] stringArgs = new String[args.length + 1];
        stringArgs[0] = commandName;
        System.arraycopy(args, 0, stringArgs, 1, args.length);
        try {
            return this.glideClient.customCommand(stringArgs).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("Command " + commandName + " execution failed", e);
        }
    }

    private Object executeProtocolCommandWithByteArgs(String commandName, byte[] ... args) throws Exception {
        GlideString[] glideArgs = new GlideString[args.length + 1];
        glideArgs[0] = GlideString.of((String)commandName);
        for (int i = 0; i < args.length; ++i) {
            glideArgs[i + 1] = GlideString.of((byte[])args[i]);
        }
        try {
            return this.glideClient.customCommand(glideArgs).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("Command " + commandName + " execution failed", e);
        }
    }

    public long hset(String key, String field, String value) {
        return this.executeCommandWithGlide("HSET", () -> {
            HashMap<String, String> fieldValueMap = new HashMap<String, String>();
            fieldValueMap.put(field, value);
            return (Long)this.glideClient.hset(key, fieldValueMap).get();
        });
    }

    public long hset(byte[] key, byte[] field, byte[] value) {
        return this.executeCommandWithGlide("HSET", () -> {
            HashMap<GlideString, GlideString> fieldValueMap = new HashMap<GlideString, GlideString>();
            fieldValueMap.put(GlideString.of((byte[])field), GlideString.of((byte[])value));
            return (Long)this.glideClient.hset(GlideString.of((byte[])key), fieldValueMap).get();
        });
    }

    public long hset(String key, Map<String, String> hash) {
        return this.executeCommandWithGlide("HSET", () -> (Long)this.glideClient.hset(key, hash).get());
    }

    public long hset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            HashMap<GlideString, GlideString> glideHash = new HashMap<GlideString, GlideString>();
            for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
                glideHash.put(GlideString.of((byte[])entry.getKey()), GlideString.of((byte[])entry.getValue()));
            }
            return (Long)this.glideClient.hset(GlideString.of((byte[])key), glideHash).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSET operation failed", e);
        }
    }

    public String hget(String key, String field) {
        return this.executeCommandWithGlide("HGET", () -> (String)this.glideClient.hget(key, field).get());
    }

    public byte[] hget(byte[] key, byte[] field) {
        return this.executeCommandWithGlide("HGET", () -> {
            GlideString result = (GlideString)this.glideClient.hget(GlideString.of((byte[])key), GlideString.of((byte[])field)).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public String hmset(String key, Map<String, String> hash) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HMSET");
            args.add(key);
            for (Map.Entry<String, String> entry : hash.entrySet()) {
                args.add(entry.getKey());
                args.add(entry.getValue());
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result != null ? result.toString() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HMSET operation failed", e);
        }
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HMSET");
            args.add(new String(key));
            for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
                args.add(new String(entry.getKey()));
                args.add(new String(entry.getValue()));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result != null ? result.toString() : null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HMSET operation failed", e);
        }
    }

    public List<String> hmget(String key, String ... fields) {
        return this.executeCommandWithGlide("HMGET", () -> {
            String[] result = (String[])this.glideClient.hmget(key, fields).get();
            return Arrays.asList(result);
        });
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] glideFields = Jedis.convertToGlideStringArray(fields);
            GlideString[] result = (GlideString[])this.glideClient.hmget(GlideString.of((byte[])key), glideFields).get();
            ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
            for (GlideString gs : result) {
                byteResult.add(gs != null ? gs.getBytes() : null);
            }
            return byteResult;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HMGET operation failed", e);
        }
    }

    public Map<String, String> hgetAll(String key) {
        return this.executeCommandWithGlide("HGETALL", () -> (Map)this.glideClient.hgetall(key).get());
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            Map result = (Map)this.glideClient.hgetall(GlideString.of((byte[])key)).get();
            HashMap<byte[], byte[]> byteResult = new HashMap<byte[], byte[]>();
            for (Map.Entry entry : result.entrySet()) {
                byteResult.put(((GlideString)entry.getKey()).getBytes(), ((GlideString)entry.getValue()).getBytes());
            }
            return byteResult;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HGETALL operation failed", e);
        }
    }

    public long hdel(String key, String ... fields) {
        return this.executeCommandWithGlide("HDEL", () -> (Long)this.glideClient.hdel(key, fields).get());
    }

    public long hdel(byte[] key, byte[] ... fields) {
        return this.executeCommandWithGlide("HDEL", () -> {
            GlideString[] glideFields = Jedis.convertToGlideStringArray(fields);
            return (Long)this.glideClient.hdel(GlideString.of((byte[])key), glideFields).get();
        });
    }

    public boolean hexists(String key, String field) {
        return this.executeCommandWithGlide("HEXISTS", () -> (Boolean)this.glideClient.hexists(key, field).get());
    }

    public boolean hexists(byte[] key, byte[] field) {
        return this.executeCommandWithGlide("HEXISTS", () -> (Boolean)this.glideClient.hexists(GlideString.of((byte[])key), GlideString.of((byte[])field)).get());
    }

    public long hlen(String key) {
        return this.executeCommandWithGlide("HLEN", () -> (Long)this.glideClient.hlen(key).get());
    }

    public long hlen(byte[] key) {
        return this.executeCommandWithGlide("HLEN", () -> (Long)this.glideClient.hlen(GlideString.of((byte[])key)).get());
    }

    public Set<String> hkeys(String key) {
        return this.executeCommandWithGlide("HKEYS", () -> {
            String[] keys = (String[])this.glideClient.hkeys(key).get();
            return new HashSet<String>(Arrays.asList(keys));
        });
    }

    public Set<byte[]> hkeys(byte[] key) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] keys = (GlideString[])this.glideClient.hkeys(GlideString.of((byte[])key)).get();
            HashSet<byte[]> byteKeys = new HashSet<byte[]>();
            for (GlideString gs : keys) {
                byteKeys.add(gs.getBytes());
            }
            return byteKeys;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HKEYS operation failed", e);
        }
    }

    public List<String> hvals(String key) {
        return this.executeCommandWithGlide("HVALS", () -> {
            String[] values = (String[])this.glideClient.hvals(key).get();
            return Arrays.asList(values);
        });
    }

    public List<byte[]> hvals(byte[] key) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] values = (GlideString[])this.glideClient.hvals(GlideString.of((byte[])key)).get();
            ArrayList<byte[]> byteValues = new ArrayList<byte[]>();
            for (GlideString gs : values) {
                byteValues.add(gs.getBytes());
            }
            return byteValues;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HVALS operation failed", e);
        }
    }

    public long hincrBy(String key, String field, long value) {
        return this.executeCommandWithGlide("HINCRBY", () -> (Long)this.glideClient.hincrBy(key, field, value).get());
    }

    public long hincrBy(byte[] key, byte[] field, long value) {
        return this.executeCommandWithGlide("HINCRBY", () -> (Long)this.glideClient.hincrBy(GlideString.of((byte[])key), GlideString.of((byte[])field), value).get());
    }

    public double hincrByFloat(String key, String field, double value) {
        return this.executeCommandWithGlide("HINCRBYFLOAT", () -> (Double)this.glideClient.hincrByFloat(key, field, value).get());
    }

    public double hincrByFloat(byte[] key, byte[] field, double value) {
        return this.executeCommandWithGlide("HINCRBYFLOAT", () -> (Double)this.glideClient.hincrByFloat(GlideString.of((byte[])key), GlideString.of((byte[])field), value).get());
    }

    public long hsetnx(String key, String field, String value) {
        return this.executeCommandWithGlide("HSETNX", () -> (Boolean)this.glideClient.hsetnx(key, field, value).get() != false ? 1L : 0L);
    }

    public long hsetnx(byte[] key, byte[] field, byte[] value) {
        return this.executeCommandWithGlide("HSETNX", () -> (Boolean)this.glideClient.hsetnx(GlideString.of((byte[])key), GlideString.of((byte[])field), GlideString.of((byte[])value)).get() != false ? 1L : 0L);
    }

    public long hstrlen(String key, String field) {
        return this.executeCommandWithGlide("HSTRLEN", () -> (Long)this.glideClient.hstrlen(key, field).get());
    }

    public long hstrlen(byte[] key, byte[] field) {
        return this.executeCommandWithGlide("HSTRLEN", () -> (Long)this.glideClient.hstrlen(GlideString.of((byte[])key), GlideString.of((byte[])field)).get());
    }

    public String hrandfield(String key) {
        return this.executeCommandWithGlide("HRANDFIELD", () -> (String)this.glideClient.hrandfield(key).get());
    }

    public byte[] hrandfield(byte[] key) {
        return this.executeCommandWithGlide("HRANDFIELD", () -> {
            GlideString result = (GlideString)this.glideClient.hrandfield(GlideString.of((byte[])key)).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public List<String> hrandfield(String key, long count) {
        return this.executeCommandWithGlide("HRANDFIELD", () -> {
            String[] fields = (String[])this.glideClient.hrandfieldWithCount(key, count).get();
            return Arrays.asList(fields);
        });
    }

    public List<byte[]> hrandfield(byte[] key, long count) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] fields = (GlideString[])this.glideClient.hrandfieldWithCount(GlideString.of((byte[])key), count).get();
            ArrayList<byte[]> byteFields = new ArrayList<byte[]>();
            for (GlideString gs : fields) {
                byteFields.add(gs.getBytes());
            }
            return byteFields;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HRANDFIELD operation failed", e);
        }
    }

    public List<Map.Entry<String, String>> hrandfieldWithValues(String key, long count) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            String[][] result = (String[][])this.glideClient.hrandfieldWithCountWithValues(key, count).get();
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
            for (String[] pair : result) {
                if (pair.length != 2) continue;
                entries.add(new AbstractMap.SimpleEntry<String, String>(pair[0], pair[1]));
            }
            return entries;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HRANDFIELD operation failed", e);
        }
    }

    public List<Map.Entry<byte[], byte[]>> hrandfieldWithValues(byte[] key, long count) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[][] result = (GlideString[][])this.glideClient.hrandfieldWithCountWithValues(GlideString.of((byte[])key), count).get();
            ArrayList<Map.Entry<byte[], byte[]>> entries = new ArrayList<Map.Entry<byte[], byte[]>>();
            for (GlideString[] pair : result) {
                if (pair.length != 2) continue;
                entries.add(new AbstractMap.SimpleEntry<byte[], byte[]>(pair[0].getBytes(), pair[1].getBytes()));
            }
            return entries;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HRANDFIELD operation failed", e);
        }
    }

    public long hsetex(String key, HSetExParams params, String field, String value) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HSETEX");
            args.add(key);
            if (params.getExistenceCondition() != null) {
                args.add(params.getExistenceCondition().name());
            }
            if (params.getExpirationType() != null) {
                args.add(params.getExpirationType().name());
                if (params.getExpirationValue() != null) {
                    args.add(params.getExpirationValue().toString());
                }
            }
            args.add(FIELDS_KEYWORD);
            args.add("1");
            args.add(field);
            args.add(value);
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result instanceof Long ? (Long)result : Long.parseLong(result.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSETEX operation failed", e);
        }
    }

    public long hsetex(String key, HSetExParams params, Map<String, String> hash) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HSETEX");
            args.add(key);
            if (params.getExistenceCondition() != null) {
                args.add(params.getExistenceCondition().name());
            }
            if (params.getExpirationType() != null) {
                args.add(params.getExpirationType().name());
                if (params.getExpirationValue() != null) {
                    args.add(params.getExpirationValue().toString());
                }
            }
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(hash.size()));
            for (Map.Entry<String, String> entry : hash.entrySet()) {
                args.add(entry.getKey());
                args.add(entry.getValue());
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result instanceof Long ? (Long)result : Long.parseLong(result.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSETEX operation failed", e);
        }
    }

    public List<String> hgetex(String key, HGetExParams params, String ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HGETEX");
            args.add(key);
            if (params.getExpirationType() != null) {
                args.add(params.getExpirationType().name());
                if (params.getExpirationValue() != null) {
                    args.add(params.getExpirationValue().toString());
                }
            }
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            if (result instanceof Object[]) {
                Object[] resultArray = (Object[])result;
                ArrayList<String> stringResult = new ArrayList<String>();
                for (Object obj : resultArray) {
                    stringResult.add(obj != null ? obj.toString() : null);
                }
                return stringResult;
            }
            return Arrays.asList(result != null ? result.toString() : null);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HGETEX operation failed", e);
        }
    }

    public List<String> hgetdel(String key, String ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HGETDEL");
            args.add(key);
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            if (result instanceof Object[]) {
                Object[] resultArray = (Object[])result;
                ArrayList<String> stringResult = new ArrayList<String>();
                for (Object obj : resultArray) {
                    stringResult.add(obj != null ? obj.toString() : null);
                }
                return stringResult;
            }
            return Arrays.asList(result != null ? result.toString() : null);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HGETDEL operation failed", e);
        }
    }

    public long hsetex(byte[] key, HSetExParams params, byte[] field, byte[] value) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HSETEX");
            args.add(new String(key));
            if (params.getExistenceCondition() != null) {
                args.add(params.getExistenceCondition().name());
            }
            if (params.getExpirationType() != null) {
                args.add(params.getExpirationType().name());
                if (params.getExpirationValue() != null) {
                    args.add(params.getExpirationValue().toString());
                }
            }
            args.add(FIELDS_KEYWORD);
            args.add("1");
            args.add(new String(field));
            args.add(new String(value));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result instanceof Long ? (Long)result : Long.parseLong(result.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSETEX operation failed", e);
        }
    }

    public long hsetex(byte[] key, HSetExParams params, Map<byte[], byte[]> hash) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HSETEX");
            args.add(new String(key));
            if (params.getExistenceCondition() != null) {
                args.add(params.getExistenceCondition().name());
            }
            if (params.getExpirationType() != null) {
                args.add(params.getExpirationType().name());
                if (params.getExpirationValue() != null) {
                    args.add(params.getExpirationValue().toString());
                }
            }
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(hash.size()));
            for (Map.Entry<byte[], byte[]> entry : hash.entrySet()) {
                args.add(new String(entry.getKey()));
                args.add(new String(entry.getValue()));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return result instanceof Long ? (Long)result : Long.parseLong(result.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSETEX operation failed", e);
        }
    }

    public List<byte[]> hgetex(byte[] key, HGetExParams params, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HGETEX");
            args.add(new String(key));
            if (params.getExpirationType() != null) {
                args.add(params.getExpirationType().name());
                if (params.getExpirationValue() != null) {
                    args.add(params.getExpirationValue().toString());
                }
            }
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            if (result instanceof Object[]) {
                Object[] resultArray = (Object[])result;
                ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
                for (Object obj : resultArray) {
                    byteResult.add(obj != null ? obj.toString().getBytes() : null);
                }
                return byteResult;
            }
            return Arrays.asList(new byte[][]{result != null ? result.toString().getBytes() : null});
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HGETEX operation failed", e);
        }
    }

    public List<byte[]> hgetdel(byte[] key, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HGETDEL");
            args.add(new String(key));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            if (result instanceof Object[]) {
                Object[] resultArray = (Object[])result;
                ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
                for (Object obj : resultArray) {
                    byteResult.add(obj != null ? obj.toString().getBytes() : null);
                }
                return byteResult;
            }
            return Arrays.asList(new byte[][]{result != null ? result.toString().getBytes() : null});
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HGETDEL operation failed", e);
        }
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            HScanOptions options = Jedis.convertScanParamsToHScanOptions(params);
            Object[] result = (Object[])this.glideClient.hscan(key, cursor, options).get();
            String nextCursor = (String)result[0];
            Object[] fieldsAndValues = (Object[])result[1];
            ArrayList<AbstractMap.SimpleEntry<String, String>> entries = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                String field = (String)fieldsAndValues[i];
                String value = (String)fieldsAndValues[i + 1];
                entries.add(new AbstractMap.SimpleEntry<String, String>(field, value));
            }
            return new ScanResult<Map.Entry<String, String>>(nextCursor, entries);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSCAN operation failed", e);
        }
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            HScanOptionsBinary options = Jedis.convertScanParamsToHScanOptionsBinary(params);
            Object[] result = (Object[])this.glideClient.hscan(GlideString.of((byte[])key), GlideString.of((byte[])cursor), options).get();
            String nextCursor = (String)result[0];
            Object[] fieldsAndValues = (Object[])result[1];
            ArrayList<AbstractMap.SimpleEntry<byte[], byte[]>> entries = new ArrayList<AbstractMap.SimpleEntry<byte[], byte[]>>();
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                GlideString field = (GlideString)fieldsAndValues[i];
                GlideString value = (GlideString)fieldsAndValues[i + 1];
                entries.add(new AbstractMap.SimpleEntry<byte[], byte[]>(field.getBytes(), value.getBytes()));
            }
            return new ScanResult<Map.Entry<byte[], byte[]>>(nextCursor.getBytes(), entries);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSCAN operation failed", e);
        }
    }

    public ScanResult<String> hscanNoValues(String key, String cursor) {
        return this.hscanNoValues(key, cursor, new ScanParams());
    }

    public ScanResult<byte[]> hscanNoValues(byte[] key, byte[] cursor) {
        return this.hscanNoValues(key, cursor, new ScanParams());
    }

    public ScanResult<String> hscanNoValues(String key, String cursor, ScanParams params) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            HScanOptions options = Jedis.convertScanParamsToHScanOptions(params);
            Object[] result = (Object[])this.glideClient.hscan(key, cursor, options).get();
            String nextCursor = (String)result[0];
            Object[] fieldsAndValues = (Object[])result[1];
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                fields.add((String)fieldsAndValues[i]);
            }
            return new ScanResult<String>(nextCursor, fields);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSCAN operation failed", e);
        }
    }

    public ScanResult<byte[]> hscanNoValues(byte[] key, byte[] cursor, ScanParams params) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            HScanOptionsBinary options = Jedis.convertScanParamsToHScanOptionsBinary(params);
            Object[] result = (Object[])this.glideClient.hscan(GlideString.of((byte[])key), GlideString.of((byte[])cursor), options).get();
            String nextCursor = (String)result[0];
            Object[] fieldsAndValues = (Object[])result[1];
            ArrayList<byte[]> fields = new ArrayList<byte[]>();
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                GlideString field = (GlideString)fieldsAndValues[i];
                fields.add(field.getBytes());
            }
            return new ScanResult<byte[]>(nextCursor.getBytes(), fields);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HSCAN operation failed", e);
        }
    }

    public List<Long> hexpire(String key, long seconds, String ... fields) {
        return this.executeCommandWithGlide("HEXPIRE", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIRE");
            args.add(key);
            args.add(String.valueOf(seconds));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hexpire(String key, long seconds, ExpiryOption condition, String ... fields) {
        return this.executeCommandWithGlide("HEXPIRE", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIRE");
            args.add(key);
            args.add(String.valueOf(seconds));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hpexpire(String key, long milliseconds, String ... fields) {
        return this.executeCommandWithGlide("HPEXPIRE", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIRE");
            args.add(key);
            args.add(String.valueOf(milliseconds));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hpexpire(String key, long milliseconds, ExpiryOption condition, String ... fields) {
        return this.executeCommandWithGlide("HPEXPIRE", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIRE");
            args.add(key);
            args.add(String.valueOf(milliseconds));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hexpireAt(String key, long unixTimeSeconds, String ... fields) {
        return this.executeCommandWithGlide("HEXPIREAT", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIREAT");
            args.add(key);
            args.add(String.valueOf(unixTimeSeconds));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hexpireAt(String key, long unixTimeSeconds, ExpiryOption condition, String ... fields) {
        return this.executeCommandWithGlide("HEXPIREAT", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIREAT");
            args.add(key);
            args.add(String.valueOf(unixTimeSeconds));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hpexpireAt(String key, long unixTimeMillis, String ... fields) {
        return this.executeCommandWithGlide("HPEXPIREAT", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIREAT");
            args.add(key);
            args.add(String.valueOf(unixTimeMillis));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hpexpireAt(String key, long unixTimeMillis, ExpiryOption condition, String ... fields) {
        return this.executeCommandWithGlide("HPEXPIREAT", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIREAT");
            args.add(key);
            args.add(String.valueOf(unixTimeMillis));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hexpireTime(String key, String ... fields) {
        return this.executeCommandWithGlide("HEXPIRETIME", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIRETIME");
            args.add(key);
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hpexpireTime(String key, String ... fields) {
        return this.executeCommandWithGlide("HPEXPIRETIME", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIRETIME");
            args.add(key);
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> httl(String key, String ... fields) {
        return this.executeCommandWithGlide("HTTL", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HTTL");
            args.add(key);
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hpttl(String key, String ... fields) {
        return this.executeCommandWithGlide("HPTTL", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPTTL");
            args.add(key);
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hpersist(String key, String ... fields) {
        return this.executeCommandWithGlide("HPERSIST", () -> {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPERSIST");
            args.add(key);
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            args.addAll(Arrays.asList(fields));
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        });
    }

    public List<Long> hexpire(byte[] key, long seconds, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIRE");
            args.add(new String(key));
            args.add(String.valueOf(seconds));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HEXPIRE operation failed", e);
        }
    }

    public List<Long> hexpire(byte[] key, long seconds, ExpiryOption condition, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIRE");
            args.add(new String(key));
            args.add(String.valueOf(seconds));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HEXPIRE operation failed", e);
        }
    }

    public List<Long> hpexpire(byte[] key, long milliseconds, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIRE");
            args.add(new String(key));
            args.add(String.valueOf(milliseconds));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HPEXPIRE operation failed", e);
        }
    }

    public List<Long> hpexpire(byte[] key, long milliseconds, ExpiryOption condition, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIRE");
            args.add(new String(key));
            args.add(String.valueOf(milliseconds));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HPEXPIRE operation failed", e);
        }
    }

    public List<Long> hexpireAt(byte[] key, long unixTimeSeconds, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIREAT");
            args.add(new String(key));
            args.add(String.valueOf(unixTimeSeconds));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HEXPIREAT operation failed", e);
        }
    }

    public List<Long> hexpireAt(byte[] key, long unixTimeSeconds, ExpiryOption condition, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIREAT");
            args.add(new String(key));
            args.add(String.valueOf(unixTimeSeconds));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HEXPIREAT operation failed", e);
        }
    }

    public List<Long> hpexpireAt(byte[] key, long unixTimeMillis, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIREAT");
            args.add(new String(key));
            args.add(String.valueOf(unixTimeMillis));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HPEXPIREAT operation failed", e);
        }
    }

    public List<Long> hpexpireAt(byte[] key, long unixTimeMillis, ExpiryOption condition, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIREAT");
            args.add(new String(key));
            args.add(String.valueOf(unixTimeMillis));
            args.add(condition.name());
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HPEXPIREAT operation failed", e);
        }
    }

    public List<Long> hexpireTime(byte[] key, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HEXPIRETIME");
            args.add(new String(key));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HEXPIRETIME operation failed", e);
        }
    }

    public List<Long> hpexpireTime(byte[] key, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPEXPIRETIME");
            args.add(new String(key));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HPEXPIRETIME operation failed", e);
        }
    }

    public List<Long> httl(byte[] key, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HTTL");
            args.add(new String(key));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HTTL operation failed", e);
        }
    }

    public List<Long> hpttl(byte[] key, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPTTL");
            args.add(new String(key));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HPTTL operation failed", e);
        }
    }

    public List<Long> hpersist(byte[] key, byte[] ... fields) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("HPERSIST");
            args.add(new String(key));
            args.add(FIELDS_KEYWORD);
            args.add(String.valueOf(fields.length));
            for (byte[] field : fields) {
                args.add(new String(field));
            }
            Object result = this.glideClient.customCommand(args.toArray(new String[0])).get();
            return Jedis.convertToLongList(result);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("HPERSIST operation failed", e);
        }
    }

    private static List<Long> convertToLongList(Object result) {
        if (result instanceof Object[]) {
            Object[] resultArray = (Object[])result;
            ArrayList<Long> longResult = new ArrayList<Long>();
            for (Object obj : resultArray) {
                if (obj instanceof Long) {
                    longResult.add((Long)obj);
                    continue;
                }
                if (obj != null) {
                    longResult.add(Long.parseLong(obj.toString()));
                    continue;
                }
                longResult.add(null);
            }
            return longResult;
        }
        if (result instanceof Long) {
            return Arrays.asList((Long)result);
        }
        if (result != null) {
            return Arrays.asList(Long.parseLong(result.toString()));
        }
        return Arrays.asList(new Long[]{null});
    }

    private static HScanOptions convertScanParamsToHScanOptions(ScanParams params) {
        HScanOptions.HScanOptionsBuilder builder = HScanOptions.builder();
        if (params.getMatchPattern() != null) {
            builder.matchPattern(params.getMatchPattern());
        }
        if (params.getCount() != null) {
            builder.count(params.getCount());
        }
        return builder.build();
    }

    private static HScanOptionsBinary convertScanParamsToHScanOptionsBinary(ScanParams params) {
        HScanOptionsBinary.HScanOptionsBinaryBuilder builder = HScanOptionsBinary.builder();
        if (params.getMatchPattern() != null) {
            builder.matchPattern(GlideString.of((String)params.getMatchPattern()));
        }
        if (params.getCount() != null) {
            builder.count(params.getCount());
        }
        return builder.build();
    }

    public Jedis(Connection connection) {
        this(connection.getHost(), connection.getPort());
    }

    public Object sendBlockingCommand(ProtocolCommand cmd, String ... args) {
        return this.sendCommand(cmd, args);
    }

    public Object sendBlockingCommand(ProtocolCommand cmd, byte[] ... args) {
        return this.sendCommand(cmd, args);
    }

    public int getDB() {
        return 0;
    }

    public long lpush(String key, String ... strings) {
        return this.executeCommandWithGlide("LPUSH", () -> (Long)this.glideClient.lpush(key, strings).get());
    }

    public long lpush(byte[] key, byte[] ... strings) {
        return this.executeCommandWithGlide("LPUSH", () -> {
            GlideString[] glideStrings = Jedis.convertToGlideStringArray(strings);
            return (Long)this.glideClient.lpush(GlideString.of((byte[])key), glideStrings).get();
        });
    }

    public long rpush(String key, String ... strings) {
        return this.executeCommandWithGlide("RPUSH", () -> (Long)this.glideClient.rpush(key, strings).get());
    }

    public long rpush(byte[] key, byte[] ... strings) {
        return this.executeCommandWithGlide("RPUSH", () -> {
            GlideString[] glideStrings = Jedis.convertToGlideStringArray(strings);
            return (Long)this.glideClient.rpush(GlideString.of((byte[])key), glideStrings).get();
        });
    }

    public String lpop(String key) {
        return this.executeCommandWithGlide("LPOP", () -> (String)this.glideClient.lpop(key).get());
    }

    public byte[] lpop(byte[] key) {
        return this.executeCommandWithGlide("LPOP", () -> {
            GlideString result = (GlideString)this.glideClient.lpop(GlideString.of((byte[])key)).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public List<String> lpop(String key, int count) {
        return this.executeCommandWithGlide("LPOP", () -> {
            String[] result = (String[])this.glideClient.lpopCount(key, (long)count).get();
            return result != null ? Arrays.asList(result) : Collections.emptyList();
        });
    }

    public List<byte[]> lpop(byte[] key, int count) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] result = (GlideString[])this.glideClient.lpopCount(GlideString.of((byte[])key), (long)count).get();
            if (result == null) {
                return Collections.emptyList();
            }
            ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
            for (GlideString gs : result) {
                byteResult.add(gs.getBytes());
            }
            return byteResult;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("LPOP operation failed", e);
        }
    }

    public String rpop(String key) {
        return this.executeCommandWithGlide("RPOP", () -> (String)this.glideClient.rpop(key).get());
    }

    public byte[] rpop(byte[] key) {
        return this.executeCommandWithGlide("RPOP", () -> {
            GlideString result = (GlideString)this.glideClient.rpop(GlideString.of((byte[])key)).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public List<String> rpop(String key, int count) {
        return this.executeCommandWithGlide("RPOP", () -> {
            String[] result = (String[])this.glideClient.rpopCount(key, (long)count).get();
            return result != null ? Arrays.asList(result) : Collections.emptyList();
        });
    }

    public List<byte[]> rpop(byte[] key, int count) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] result = (GlideString[])this.glideClient.rpopCount(GlideString.of((byte[])key), (long)count).get();
            if (result == null) {
                return Collections.emptyList();
            }
            ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
            for (GlideString gs : result) {
                byteResult.add(gs.getBytes());
            }
            return byteResult;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("RPOP operation failed", e);
        }
    }

    public long llen(String key) {
        return this.executeCommandWithGlide("LLEN", () -> (Long)this.glideClient.llen(key).get());
    }

    public long llen(byte[] key) {
        return this.executeCommandWithGlide("LLEN", () -> (Long)this.glideClient.llen(GlideString.of((byte[])key)).get());
    }

    public List<String> lrange(String key, long start, long stop) {
        return this.executeCommandWithGlide("LRANGE", () -> {
            String[] result = (String[])this.glideClient.lrange(key, start, stop).get();
            return result != null ? Arrays.asList(result) : Collections.emptyList();
        });
    }

    public List<byte[]> lrange(byte[] key, long start, long stop) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] result = (GlideString[])this.glideClient.lrange(GlideString.of((byte[])key), start, stop).get();
            if (result == null) {
                return Collections.emptyList();
            }
            ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
            for (GlideString gs : result) {
                byteResult.add(gs.getBytes());
            }
            return byteResult;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("LRANGE operation failed", e);
        }
    }

    public String ltrim(String key, long start, long stop) {
        return this.executeCommandWithGlide("LTRIM", () -> (String)this.glideClient.ltrim(key, start, stop).get());
    }

    public String ltrim(byte[] key, long start, long stop) {
        return this.executeCommandWithGlide("LTRIM", () -> (String)this.glideClient.ltrim(GlideString.of((byte[])key), start, stop).get());
    }

    public String lindex(String key, long index) {
        return this.executeCommandWithGlide("LINDEX", () -> (String)this.glideClient.lindex(key, index).get());
    }

    public byte[] lindex(byte[] key, long index) {
        return this.executeCommandWithGlide("LINDEX", () -> {
            GlideString result = (GlideString)this.glideClient.lindex(GlideString.of((byte[])key), index).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public String lset(String key, long index, String element) {
        return this.executeCommandWithGlide("LSET", () -> (String)this.glideClient.lset(key, index, element).get());
    }

    public String lset(byte[] key, long index, byte[] element) {
        return this.executeCommandWithGlide("LSET", () -> (String)this.glideClient.lset(GlideString.of((byte[])key), index, GlideString.of((byte[])element)).get());
    }

    public long lrem(String key, long count, String element) {
        return this.executeCommandWithGlide("LREM", () -> (Long)this.glideClient.lrem(key, count, element).get());
    }

    public long lrem(byte[] key, long count, byte[] element) {
        return this.executeCommandWithGlide("LREM", () -> (Long)this.glideClient.lrem(GlideString.of((byte[])key), count, GlideString.of((byte[])element)).get());
    }

    public long linsert(String key, ListPosition where, String pivot, String element) {
        return this.executeCommandWithGlide("LINSERT", () -> {
            LInsertOptions.InsertPosition position = where == ListPosition.BEFORE ? LInsertOptions.InsertPosition.BEFORE : LInsertOptions.InsertPosition.AFTER;
            return (Long)this.glideClient.linsert(key, position, pivot, element).get();
        });
    }

    public long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] element) {
        return this.executeCommandWithGlide("LINSERT", () -> {
            LInsertOptions.InsertPosition position = where == ListPosition.BEFORE ? LInsertOptions.InsertPosition.BEFORE : LInsertOptions.InsertPosition.AFTER;
            return (Long)this.glideClient.linsert(GlideString.of((byte[])key), position, GlideString.of((byte[])pivot), GlideString.of((byte[])element)).get();
        });
    }

    public long lpushx(String key, String ... strings) {
        return this.executeCommandWithGlide("LPUSHX", () -> (Long)this.glideClient.lpushx(key, strings).get());
    }

    public long lpushx(byte[] key, byte[] ... strings) {
        return this.executeCommandWithGlide("LPUSHX", () -> {
            GlideString[] glideStrings = Jedis.convertToGlideStringArray(strings);
            return (Long)this.glideClient.lpushx(GlideString.of((byte[])key), glideStrings).get();
        });
    }

    public long rpushx(String key, String ... strings) {
        return this.executeCommandWithGlide("RPUSHX", () -> (Long)this.glideClient.rpushx(key, strings).get());
    }

    public long rpushx(byte[] key, byte[] ... strings) {
        return this.executeCommandWithGlide("RPUSHX", () -> {
            GlideString[] glideStrings = Jedis.convertToGlideStringArray(strings);
            return (Long)this.glideClient.rpushx(GlideString.of((byte[])key), glideStrings).get();
        });
    }

    public List<String> blpop(int timeout, String ... keys) {
        return this.executeCommandWithGlide("BLPOP", () -> {
            String[] result = (String[])this.glideClient.blpop(keys, (double)timeout).get();
            return result != null ? Arrays.asList(result) : null;
        });
    }

    public KeyValue<String, String> blpop(double timeout, String ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            String[] result = (String[])this.glideClient.blpop(keys, timeout).get();
            if (result != null && result.length >= 2) {
                return new KeyValue<String, String>(result[0], result[1]);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BLPOP operation failed", e);
        }
    }

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            GlideString[] result = (GlideString[])this.glideClient.blpop(glideKeys, (double)timeout).get();
            if (result != null) {
                ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
                for (GlideString gs : result) {
                    byteResult.add(gs.getBytes());
                }
                return byteResult;
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BLPOP operation failed", e);
        }
    }

    public KeyValue<byte[], byte[]> blpop(double timeout, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            GlideString[] result = (GlideString[])this.glideClient.blpop(glideKeys, timeout).get();
            if (result != null && result.length >= 2) {
                return new KeyValue<byte[], byte[]>(result[0].getBytes(), result[1].getBytes());
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BLPOP operation failed", e);
        }
    }

    public List<String> brpop(int timeout, String ... keys) {
        return this.executeCommandWithGlide("BRPOP", () -> {
            String[] result = (String[])this.glideClient.brpop(keys, (double)timeout).get();
            return result != null ? Arrays.asList(result) : null;
        });
    }

    public KeyValue<String, String> brpop(double timeout, String ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            String[] result = (String[])this.glideClient.brpop(keys, timeout).get();
            if (result != null && result.length >= 2) {
                return new KeyValue<String, String>(result[0], result[1]);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BRPOP operation failed", e);
        }
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            GlideString[] result = (GlideString[])this.glideClient.brpop(glideKeys, (double)timeout).get();
            if (result != null) {
                ArrayList<byte[]> byteResult = new ArrayList<byte[]>();
                for (GlideString gs : result) {
                    byteResult.add(gs.getBytes());
                }
                return byteResult;
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BRPOP operation failed", e);
        }
    }

    public KeyValue<byte[], byte[]> brpop(double timeout, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            GlideString[] result = (GlideString[])this.glideClient.brpop(glideKeys, timeout).get();
            if (result != null && result.length >= 2) {
                return new KeyValue<byte[], byte[]>(result[0].getBytes(), result[1].getBytes());
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BRPOP operation failed", e);
        }
    }

    public List<String> blpop(int timeout, String key) {
        return this.blpop(timeout, new String[]{key});
    }

    public KeyValue<String, String> blpop(double timeout, String key) {
        return this.blpop(timeout, new String[]{key});
    }

    public List<String> brpop(int timeout, String key) {
        return this.brpop(timeout, new String[]{key});
    }

    public KeyValue<String, String> brpop(double timeout, String key) {
        return this.brpop(timeout, new String[]{key});
    }

    public Long lpos(String key, String element) {
        return this.executeCommandWithGlide("LPOS", () -> (Long)this.glideClient.lpos(key, element).get());
    }

    public Long lpos(byte[] key, byte[] element) {
        return this.executeCommandWithGlide("LPOS", () -> (Long)this.glideClient.lpos(GlideString.of((byte[])key), GlideString.of((byte[])element)).get());
    }

    public Long lpos(String key, String element, LPosParams params) {
        return this.executeCommandWithGlide("LPOS", () -> {
            LPosOptions options = Jedis.convertLPosParamsToLPosOptions(params);
            return (Long)this.glideClient.lpos(key, element, options).get();
        });
    }

    public Long lpos(byte[] key, byte[] element, LPosParams params) {
        return this.executeCommandWithGlide("LPOS", () -> {
            LPosOptions options = Jedis.convertLPosParamsToLPosOptions(params);
            return (Long)this.glideClient.lpos(GlideString.of((byte[])key), GlideString.of((byte[])element), options).get();
        });
    }

    public List<Long> lpos(String key, String element, LPosParams params, long count) {
        return this.executeCommandWithGlide("LPOS", () -> {
            LPosOptions options = Jedis.convertLPosParamsToLPosOptions(params);
            Long[] result = (Long[])this.glideClient.lposCount(key, element, count, options).get();
            return result != null ? Arrays.asList(result) : Collections.emptyList();
        });
    }

    public List<Long> lpos(byte[] key, byte[] element, LPosParams params, long count) {
        return this.executeCommandWithGlide("LPOS", () -> {
            LPosOptions options = Jedis.convertLPosParamsToLPosOptions(params);
            Long[] result = (Long[])this.glideClient.lposCount(GlideString.of((byte[])key), GlideString.of((byte[])element), count, options).get();
            return result != null ? Arrays.asList(result) : Collections.emptyList();
        });
    }

    public String lmove(String srcKey, String dstKey, ListDirection from, ListDirection to) {
        return this.executeCommandWithGlide("LMOVE", () -> {
            glide.api.models.commands.ListDirection glideFrom = Jedis.convertToGlideListDirection(from);
            glide.api.models.commands.ListDirection glideTo = Jedis.convertToGlideListDirection(to);
            return (String)this.glideClient.lmove(srcKey, dstKey, glideFrom, glideTo).get();
        });
    }

    public byte[] lmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to) {
        return this.executeCommandWithGlide("LMOVE", () -> {
            glide.api.models.commands.ListDirection glideFrom = Jedis.convertToGlideListDirection(from);
            glide.api.models.commands.ListDirection glideTo = Jedis.convertToGlideListDirection(to);
            GlideString result = (GlideString)this.glideClient.lmove(GlideString.of((byte[])srcKey), GlideString.of((byte[])dstKey), glideFrom, glideTo).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public String blmove(String srcKey, String dstKey, ListDirection from, ListDirection to, double timeout) {
        return this.executeCommandWithGlide("BLMOVE", () -> {
            glide.api.models.commands.ListDirection glideFrom = Jedis.convertToGlideListDirection(from);
            glide.api.models.commands.ListDirection glideTo = Jedis.convertToGlideListDirection(to);
            return (String)this.glideClient.blmove(srcKey, dstKey, glideFrom, glideTo, timeout).get();
        });
    }

    public byte[] blmove(byte[] srcKey, byte[] dstKey, ListDirection from, ListDirection to, double timeout) {
        return this.executeCommandWithGlide("BLMOVE", () -> {
            glide.api.models.commands.ListDirection glideFrom = Jedis.convertToGlideListDirection(from);
            glide.api.models.commands.ListDirection glideTo = Jedis.convertToGlideListDirection(to);
            GlideString result = (GlideString)this.glideClient.blmove(GlideString.of((byte[])srcKey), GlideString.of((byte[])dstKey), glideFrom, glideTo, timeout).get();
            return result != null ? result.getBytes() : null;
        });
    }

    public KeyValue<String, List<String>> lmpop(ListDirection direction, String ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            Map result = (Map)this.glideClient.lmpop(keys, glideDirection).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                return new KeyValue<String, List<String>>((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("LMPOP operation failed", e);
        }
    }

    public KeyValue<String, List<String>> lmpop(ListDirection direction, int count, String ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            Map result = (Map)this.glideClient.lmpop(keys, glideDirection, (long)count).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                return new KeyValue<String, List<String>>((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("LMPOP operation failed", e);
        }
    }

    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection direction, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            Map result = (Map)this.glideClient.lmpop(glideKeys, glideDirection).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                for (GlideString gs : (GlideString[])entry.getValue()) {
                    values.add(gs.getBytes());
                }
                return new KeyValue<byte[], List<byte[]>>(((GlideString)entry.getKey()).getBytes(), values);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("LMPOP operation failed", e);
        }
    }

    public KeyValue<byte[], List<byte[]>> lmpop(ListDirection direction, int count, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            Map result = (Map)this.glideClient.lmpop(glideKeys, glideDirection, (long)count).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                for (GlideString gs : (GlideString[])entry.getValue()) {
                    values.add(gs.getBytes());
                }
                return new KeyValue<byte[], List<byte[]>>(((GlideString)entry.getKey()).getBytes(), values);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("LMPOP operation failed", e);
        }
    }

    public KeyValue<String, List<String>> blmpop(double timeout, ListDirection direction, String ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            Map result = (Map)this.glideClient.blmpop(keys, glideDirection, timeout).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                return new KeyValue<String, List<String>>((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BLMPOP operation failed", e);
        }
    }

    public KeyValue<String, List<String>> blmpop(double timeout, ListDirection direction, int count, String ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            Map result = (Map)this.glideClient.blmpop(keys, glideDirection, (long)count, timeout).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                return new KeyValue<String, List<String>>((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BLMPOP operation failed", e);
        }
    }

    public KeyValue<byte[], List<byte[]>> blmpop(double timeout, ListDirection direction, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            Map result = (Map)this.glideClient.blmpop(glideKeys, glideDirection, timeout).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                for (GlideString gs : (GlideString[])entry.getValue()) {
                    values.add(gs.getBytes());
                }
                return new KeyValue<byte[], List<byte[]>>(((GlideString)entry.getKey()).getBytes(), values);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BLMPOP operation failed", e);
        }
    }

    public KeyValue<byte[], List<byte[]>> blmpop(double timeout, ListDirection direction, int count, byte[] ... keys) {
        this.checkNotClosed();
        this.ensureInitialized();
        try {
            glide.api.models.commands.ListDirection glideDirection = Jedis.convertToGlideListDirection(direction);
            GlideString[] glideKeys = Jedis.convertToGlideStringArray(keys);
            Map result = (Map)this.glideClient.blmpop(glideKeys, glideDirection, (long)count, timeout).get();
            if (result != null && !result.isEmpty()) {
                Map.Entry entry = result.entrySet().iterator().next();
                ArrayList<byte[]> values = new ArrayList<byte[]>();
                for (GlideString gs : (GlideString[])entry.getValue()) {
                    values.add(gs.getBytes());
                }
                return new KeyValue<byte[], List<byte[]>>(((GlideString)entry.getKey()).getBytes(), values);
            }
            return null;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("BLMPOP operation failed", e);
        }
    }

    @Deprecated
    public String rpoplpush(String srckey, String dstkey) {
        return this.lmove(srckey, dstkey, ListDirection.RIGHT, ListDirection.LEFT);
    }

    @Deprecated
    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        return this.lmove(srckey, dstkey, ListDirection.RIGHT, ListDirection.LEFT);
    }

    @Deprecated
    public String brpoplpush(String source, String destination, int timeout) {
        return this.blmove(source, destination, ListDirection.RIGHT, ListDirection.LEFT, (double)timeout);
    }

    @Deprecated
    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        return this.blmove(source, destination, ListDirection.RIGHT, ListDirection.LEFT, (double)timeout);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ConfigurationMapper.cleanupTempFiles();
            }
            catch (Exception e) {
                System.err.println("Warning: Failed to cleanup temporary certificate files during shutdown:");
                e.printStackTrace();
            }
        }, "Jedis-Certificate-Cleanup"));
    }

    @FunctionalInterface
    private static interface GlideOperation<T> {
        public T execute() throws InterruptedException, ExecutionException;
    }
}

