/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import glide.api.GlideClient;
import glide.api.logging.Logger;
import glide.api.models.configuration.GlideClientConfiguration;
import java.util.concurrent.ExecutionException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import redis.clients.jedis.ConfigurationMapper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public class GlideJedisFactory
implements PooledObjectFactory<Jedis> {
    private final String host;
    private final int port;
    private final JedisClientConfig clientConfig;
    private JedisPool pool;

    public GlideJedisFactory(String host, int port, JedisClientConfig clientConfig) {
        this.host = host;
        this.port = port;
        this.clientConfig = clientConfig;
        this.pool = null;
    }

    public void setPool(JedisPool pool) {
        this.pool = pool;
    }

    public PooledObject<Jedis> makeObject() throws Exception {
        try {
            GlideClientConfiguration glideConfig = ConfigurationMapper.mapToGlideConfig(this.host, this.port, this.clientConfig);
            GlideClient glideClient = (GlideClient)GlideClient.createClient((GlideClientConfiguration)glideConfig).get();
            Jedis jedis = new Jedis(glideClient, this.clientConfig);
            if (this.pool != null) {
                jedis.setDataSource(this.pool);
            }
            return new DefaultPooledObject((Object)jedis);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new JedisException("Failed to create Jedis connection", e);
        }
    }

    public void destroyObject(PooledObject<Jedis> pooledObject) throws Exception {
        Jedis jedis = (Jedis)pooledObject.getObject();
        if (jedis != null && !jedis.isClosed()) {
            try {
                jedis.close();
            }
            catch (Exception e) {
                Logger.log((Logger.Level)Logger.Level.WARN, (String)"GlideJedisFactory", (String)"Error closing Jedis connection during destroy", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public boolean validateObject(PooledObject<Jedis> pooledObject) {
        Jedis jedis = (Jedis)pooledObject.getObject();
        if (jedis == null || jedis.isClosed()) {
            return false;
        }
        try {
            String response = jedis.ping();
            return "PONG".equals(response);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void activateObject(PooledObject<Jedis> pooledObject) throws Exception {
        Jedis jedis = (Jedis)pooledObject.getObject();
        if (jedis != null) {
            jedis.resetForReuse();
        }
    }

    public void passivateObject(PooledObject<Jedis> pooledObject) throws Exception {
        Jedis jedis = (Jedis)pooledObject.getObject();
        if (jedis != null) {
            jedis.resetForReuse();
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public JedisClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public JedisPool getPool() {
        return this.pool;
    }
}

