/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import glide.api.models.configuration.AdvancedGlideClientConfiguration;
import glide.api.models.configuration.GlideClientConfiguration;
import glide.api.models.configuration.NodeAddress;
import glide.api.models.configuration.ProtocolVersion;
import glide.api.models.configuration.ServerCredentials;
import glide.api.models.configuration.TlsAdvancedConfiguration;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import redis.clients.jedis.DefaultRedisCredentialsProvider;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.SslOptions;
import redis.clients.jedis.SslVerifyMode;
import redis.clients.jedis.exceptions.JedisException;

public class ConfigurationMapper {
    private static final Logger logger = Logger.getLogger(ConfigurationMapper.class.getName());
    private static final String JEDIS_ADAPTER_LIB_NAME = "GlideJedisAdapter";

    public static GlideClientConfiguration mapToGlideConfig(String host, int port, JedisClientConfig jedisConfig) {
        if (jedisConfig.getAuthXManager() != null) {
            throw new JedisConfigurationException("AuthXManager is not supported in GLIDE. Please use username/password authentication.");
        }
        GlideClientConfiguration.GlideClientConfigurationBuilder builder = GlideClientConfiguration.builder();
        ConfigurationMapper.mapConnectionSettings(jedisConfig, host, port, builder);
        ConfigurationMapper.mapCredentialsAndSsl(jedisConfig, builder);
        ConfigurationMapper.mapAdvancedSettings(jedisConfig, builder);
        builder.libName(JEDIS_ADAPTER_LIB_NAME);
        return builder.build();
    }

    private static void mapConnectionSettings(JedisClientConfig jedisConfig, String host, int port, GlideClientConfiguration.GlideClientConfigurationBuilder builder) {
        int timeout;
        builder.address(NodeAddress.builder().host(host).port(Integer.valueOf(port)).build());
        if (jedisConfig.getDatabase() != 0) {
            logger.warning("Database selection specified (" + jedisConfig.getDatabase() + "). GLIDE may handle database selection differently than Jedis.");
        }
        if (jedisConfig.getClientName() != null) {
            builder.clientName(jedisConfig.getClientName());
        }
        if ((timeout = ConfigurationMapper.calculateGlideRequestTimeout(jedisConfig)) > 0) {
            builder.requestTimeout(Integer.valueOf(timeout));
        }
        if (jedisConfig.getRedisProtocol() != null) {
            builder.protocol(jedisConfig.getRedisProtocol().toGlideProtocol());
        } else {
            builder.protocol(ProtocolVersion.RESP2);
        }
    }

    private static void mapCredentialsAndSsl(JedisClientConfig jedisConfig, GlideClientConfiguration.GlideClientConfigurationBuilder builder) {
        boolean hasPassword;
        ServerCredentials.ServerCredentialsBuilder credentialsBuilder = null;
        boolean hasUser = jedisConfig.getUser() != null && !jedisConfig.getUser().isEmpty();
        boolean bl = hasPassword = jedisConfig.getPassword() != null && !jedisConfig.getPassword().isEmpty();
        if (hasUser || hasPassword) {
            credentialsBuilder = ServerCredentials.builder();
            if (hasUser) {
                credentialsBuilder.username(jedisConfig.getUser());
            }
            if (hasPassword) {
                credentialsBuilder.password(jedisConfig.getPassword());
            }
        }
        if (jedisConfig.isSsl()) {
            builder.useTLS(true);
            if (credentialsBuilder == null) {
                credentialsBuilder = ServerCredentials.builder();
            }
            ConfigurationMapper.mapSslConfiguration(jedisConfig, credentialsBuilder, builder);
        }
        if (credentialsBuilder != null) {
            builder.credentials(credentialsBuilder.build());
        }
    }

    private static void mapSslConfiguration(JedisClientConfig jedisConfig, ServerCredentials.ServerCredentialsBuilder credentialsBuilder, GlideClientConfiguration.GlideClientConfigurationBuilder glideBuilder) {
        logger.info("Mapping SSL/TLS configuration from Jedis to GLIDE");
        AdvancedGlideClientConfiguration.AdvancedGlideClientConfigurationBuilder advancedBuilder = AdvancedGlideClientConfiguration.builder();
        boolean needsAdvancedConfig = false;
        if (jedisConfig.getSslOptions() != null) {
            needsAdvancedConfig = ConfigurationMapper.processSslOptions(jedisConfig.getSslOptions(), advancedBuilder);
        } else {
            if (jedisConfig.getSslSocketFactory() != null) {
                throw new JedisConfigurationException("Custom SSLSocketFactory is not supported in GLIDE. Please use system certificate store or SslOptions with SslVerifyMode.INSECURE for testing.");
            }
            if (jedisConfig.getHostnameVerifier() != null) {
                throw new JedisConfigurationException("Custom HostnameVerifier is not supported in GLIDE. Please use system hostname verification or SslOptions with SslVerifyMode.INSECURE for testing.");
            }
        }
        if (jedisConfig.getSslParameters() != null) {
            boolean sslParamsNeedAdvanced = ConfigurationMapper.processSslParameters(jedisConfig.getSslParameters(), advancedBuilder);
            boolean bl = needsAdvancedConfig = needsAdvancedConfig || sslParamsNeedAdvanced;
        }
        if (needsAdvancedConfig) {
            glideBuilder.advancedConfiguration(advancedBuilder.build());
            logger.info("Applied advanced TLS configuration to GLIDE client");
        } else {
            logger.info("Using default secure TLS configuration");
        }
    }

    private static boolean processSslOptions(SslOptions sslOptions, AdvancedGlideClientConfiguration.AdvancedGlideClientConfigurationBuilder advancedBuilder) {
        SslVerifyMode verifyMode;
        if (sslOptions.getKeystoreResource() != null) {
            throw new JedisConfigurationException("Keystore configuration is not supported in GLIDE. Please use system certificate store or SslOptions with SslVerifyMode.INSECURE for testing.");
        }
        if (sslOptions.getTruststoreResource() != null) {
            throw new JedisConfigurationException("Truststore configuration is not supported in GLIDE. Please use system certificate store or SslOptions with SslVerifyMode.INSECURE for testing.");
        }
        boolean needsAdvancedConfig = false;
        if (sslOptions.getSslParameters() != null) {
            boolean sslParamsNeedAdvanced = ConfigurationMapper.processSslParameters(sslOptions.getSslParameters(), advancedBuilder);
            boolean bl = needsAdvancedConfig = needsAdvancedConfig || sslParamsNeedAdvanced;
        }
        if ((verifyMode = sslOptions.getSslVerifyMode()) == SslVerifyMode.INSECURE) {
            logger.warning("SSL Configuration: SSL verification disabled via SslVerifyMode.INSECURE - using insecure TLS");
            advancedBuilder.tlsAdvancedConfiguration(TlsAdvancedConfiguration.builder().useInsecureTLS(true).build());
            return true;
        }
        logger.info("SSL Configuration: SSL verification enabled via SslVerifyMode." + String.valueOf((Object)verifyMode) + " - using secure TLS");
        return needsAdvancedConfig;
    }

    private static boolean processSslParameters(SSLParameters sslParameters, AdvancedGlideClientConfiguration.AdvancedGlideClientConfigurationBuilder advancedBuilder) {
        if (sslParameters.getCipherSuites() != null && sslParameters.getCipherSuites().length > 0) {
            throw new JedisConfigurationException("Custom cipher suites are not supported in GLIDE. GLIDE automatically selects secure cipher suites. Please remove custom cipher suite configuration.");
        }
        if (sslParameters.getProtocols() != null && sslParameters.getProtocols().length > 0) {
            throw new JedisConfigurationException("Custom SSL protocols are not supported in GLIDE. GLIDE automatically selects the best available TLS protocol. Please remove custom protocol configuration.");
        }
        if (sslParameters.getNeedClientAuth()) {
            throw new JedisConfigurationException("Client authentication (needClientAuth) is not supported in GLIDE. Please remove client authentication configuration or use server-side authentication.");
        }
        if (sslParameters.getWantClientAuth()) {
            throw new JedisConfigurationException("Client authentication (wantClientAuth) is not supported in GLIDE. Please remove client authentication configuration or use server-side authentication.");
        }
        logger.info("SSL Configuration: Client authentication disabled - compatible with GLIDE");
        String endpointAlgorithm = sslParameters.getEndpointIdentificationAlgorithm();
        if (endpointAlgorithm != null && endpointAlgorithm.isEmpty()) {
            throw new JedisConfigurationException("Disabled endpoint identification is not supported in GLIDE. GLIDE enforces hostname verification for security. Use SslOptions with SslVerifyMode.INSECURE if you need to bypass verification.");
        }
        if (endpointAlgorithm != null) {
            logger.info("SSL Configuration: Endpoint identification algorithm: " + endpointAlgorithm + " - compatible with GLIDE");
        }
        return false;
    }

    private static void mapAdvancedSettings(JedisClientConfig jedisConfig, GlideClientConfiguration.GlideClientConfigurationBuilder builder) {
        AdvancedGlideClientConfiguration.AdvancedGlideClientConfigurationBuilder advancedBuilder = AdvancedGlideClientConfiguration.builder();
        boolean hasAdvancedConfig = false;
        if (jedisConfig.getConnectionTimeoutMillis() > 0) {
            advancedBuilder.connectionTimeout(Integer.valueOf(jedisConfig.getConnectionTimeoutMillis()));
            hasAdvancedConfig = true;
        }
        if (jedisConfig.getBlockingSocketTimeoutMillis() > 0) {
            logger.warning("Blocking socket timeout specified (" + jedisConfig.getBlockingSocketTimeoutMillis() + "ms). GLIDE uses a unified request timeout for all operations. Blocking commands will use the same timeout as non-blocking commands.");
        }
        if (jedisConfig.getCredentialsProvider() != null && !(jedisConfig.getCredentialsProvider() instanceof DefaultRedisCredentialsProvider)) {
            throw new JedisConfigurationException("Custom credentials provider is not supported in GLIDE. GLIDE uses static credentials. Please extract credentials manually and use username/password configuration.");
        }
        if (hasAdvancedConfig) {
            builder.advancedConfiguration(advancedBuilder.build());
        }
    }

    private static int calculateGlideRequestTimeout(JedisClientConfig jedisConfig) {
        return jedisConfig.getSocketTimeoutMillis();
    }

    public static GlideClientConfiguration createDefaultConfig(String host, int port, boolean useSsl) {
        return ((GlideClientConfiguration.GlideClientConfigurationBuilder)((GlideClientConfiguration.GlideClientConfigurationBuilder)((GlideClientConfiguration.GlideClientConfigurationBuilder)GlideClientConfiguration.builder().address(NodeAddress.builder().host(host).port(Integer.valueOf(port)).build())).useTLS(useSsl)).requestTimeout(Integer.valueOf(2000))).build();
    }

    public static void cleanupTempFiles() {
    }

    public static class JedisConfigurationException
    extends JedisException {
        public JedisConfigurationException(String message) {
            super(message);
        }

        public JedisConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

