/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import glide.api.models.GlideString;
import glide.api.models.configuration.BaseSubscriptionConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public final class ClusterSubscriptionConfiguration
extends BaseSubscriptionConfiguration {
    private final Map<PubSubClusterChannelMode, Set<GlideString>> subscriptions;

    private ClusterSubscriptionConfiguration(Optional<BaseSubscriptionConfiguration.MessageCallback> callback, Optional<Object> context, Map<PubSubClusterChannelMode, Set<GlideString>> subscriptions) {
        super(callback, context);
        this.subscriptions = subscriptions;
    }

    public static ClusterSubscriptionConfigurationBuilder builder() {
        return new ClusterSubscriptionConfigurationBuilder();
    }

    @Generated
    public Map<PubSubClusterChannelMode, Set<GlideString>> getSubscriptions() {
        return this.subscriptions;
    }

    public static final class ClusterSubscriptionConfigurationBuilder
    extends BaseSubscriptionConfiguration.BaseSubscriptionConfigurationBuilder<ClusterSubscriptionConfigurationBuilder, ClusterSubscriptionConfiguration> {
        private Map<PubSubClusterChannelMode, Set<GlideString>> subscriptions = new HashMap<PubSubClusterChannelMode, Set<GlideString>>(3);

        private ClusterSubscriptionConfigurationBuilder() {
        }

        public ClusterSubscriptionConfigurationBuilder subscription(PubSubClusterChannelMode mode, GlideString channelOrPattern) {
            this.addSubscription(this.subscriptions, mode, channelOrPattern);
            return this;
        }

        public ClusterSubscriptionConfigurationBuilder subscription(PubSubClusterChannelMode mode, String channelOrPattern) {
            this.addSubscription(this.subscriptions, mode, GlideString.gs(channelOrPattern));
            return this;
        }

        public ClusterSubscriptionConfigurationBuilder subscriptions(Map<PubSubClusterChannelMode, Set<GlideString>> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        public ClusterSubscriptionConfigurationBuilder subscriptions(PubSubClusterChannelMode mode, Set<GlideString> subscriptions) {
            this.subscriptions.put(mode, subscriptions);
            return this;
        }

        @Override
        protected ClusterSubscriptionConfigurationBuilder self() {
            return this;
        }

        @Override
        public ClusterSubscriptionConfiguration build() {
            return new ClusterSubscriptionConfiguration(this.callback, this.context, this.subscriptions);
        }
    }

    public static enum PubSubClusterChannelMode implements BaseSubscriptionConfiguration.ChannelMode
    {
        EXACT,
        PATTERN,
        SHARDED;

    }
}

