/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.stream;

import glide.api.models.GlideString;
import glide.utils.ArrayTransformUtils;
import lombok.Generated;

public interface StreamRange {
    public static final String MINIMUM_RANGE_VALKEY_API = "-";
    public static final String MAXIMUM_RANGE_VALKEY_API = "+";
    public static final String RANGE_COUNT_VALKEY_API = "COUNT";
    public static final String EXCLUSIVE_RANGE_VALKEY_API = "(";

    public String getValkeyApi();

    public static String[] toArgs(StreamRange start, StreamRange end) {
        return new String[]{start.getValkeyApi(), end.getValkeyApi()};
    }

    public static String[] toArgs(StreamRange start, StreamRange end, long count) {
        return ArrayTransformUtils.concatenateArrays(StreamRange.toArgs(start, end), {RANGE_COUNT_VALKEY_API, Long.toString(count)});
    }

    public static class IdBound
    implements StreamRange {
        private final String valkeyApi;

        private IdBound(String id) {
            this.valkeyApi = id;
        }

        private IdBound(GlideString id) {
            this.valkeyApi = id.getString();
        }

        public static IdBound of(String id) {
            return new IdBound(id);
        }

        public static IdBound of(GlideString id) {
            return new IdBound(id);
        }

        public static IdBound of(long timestamp) {
            return new IdBound(Long.toString(timestamp));
        }

        public static IdBound ofExclusive(long timestamp) {
            return new IdBound(StreamRange.EXCLUSIVE_RANGE_VALKEY_API + timestamp);
        }

        public static IdBound ofExclusive(String id) {
            return new IdBound(StreamRange.EXCLUSIVE_RANGE_VALKEY_API + id);
        }

        public static IdBound ofExclusive(GlideString id) {
            return new IdBound(StreamRange.EXCLUSIVE_RANGE_VALKEY_API + id.getString());
        }

        @Override
        @Generated
        public String getValkeyApi() {
            return this.valkeyApi;
        }
    }

    public static enum InfRangeBound implements StreamRange
    {
        MIN("-"),
        MAX("+");

        private final String valkeyApi;

        @Generated
        private InfRangeBound(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }

        @Override
        @Generated
        public String getValkeyApi() {
            return this.valkeyApi;
        }
    }
}

