/*
 * Decompiled with CFR 0.152.
 */
package glide.api.commands.servermodules;

import glide.api.BaseClient;
import glide.api.GlideClient;
import glide.api.GlideClusterClient;
import glide.api.models.ClusterValue;
import glide.api.models.GlideString;
import glide.api.models.commands.FT.FTAggregateOptions;
import glide.api.models.commands.FT.FTCreateOptions;
import glide.api.models.commands.FT.FTProfileOptions;
import glide.api.models.commands.FT.FTSearchOptions;
import glide.utils.ArrayTransformUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class FT {
    public static CompletableFuture<String> create(@NonNull BaseClient client, @NonNull String indexName, @NonNull FTCreateOptions.FieldInfo[] schema) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        return FT.create(client, indexName, schema, FTCreateOptions.builder().build());
    }

    public static CompletableFuture<String> create(@NonNull BaseClient client, @NonNull String indexName, @NonNull FTCreateOptions.FieldInfo[] schema, @NonNull FTCreateOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return FT.create(client, GlideString.gs(indexName), schema, options);
    }

    public static CompletableFuture<String> create(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull FTCreateOptions.FieldInfo[] schema) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        return FT.create(client, indexName, schema, FTCreateOptions.builder().build());
    }

    public static CompletableFuture<String> create(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull FTCreateOptions.FieldInfo[] schema, @NonNull FTCreateOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] args = (GlideString[])Stream.of({GlideString.gs("FT.CREATE"), indexName}, options.toArgs(), {GlideString.gs("SCHEMA")}, (GlideString[])Arrays.stream(schema).map(FTCreateOptions.FieldInfo::toArgs).flatMap(Arrays::stream).toArray(GlideString[]::new)).flatMap(Arrays::stream).toArray(GlideString[]::new);
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<Object[]> search(@NonNull BaseClient client, @NonNull String indexName, @NonNull String query, @NonNull FTSearchOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({GlideString.gs("FT.SEARCH"), GlideString.gs(indexName), GlideString.gs(query)}, options.toArgs());
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<Object[]> search(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull GlideString query, @NonNull FTSearchOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({GlideString.gs("FT.SEARCH"), indexName, query}, options.toArgs());
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<Object[]> search(@NonNull BaseClient client, @NonNull String indexName, @NonNull String query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.SEARCH"), GlideString.gs(indexName), GlideString.gs(query)};
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<Object[]> search(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull GlideString query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.SEARCH"), indexName, query};
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<String> dropindex(@NonNull BaseClient client, @NonNull String indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        return FT.executeCommand(client, new GlideString[]{GlideString.gs("FT.DROPINDEX"), GlideString.gs(indexName)}, false);
    }

    public static CompletableFuture<String> dropindex(@NonNull BaseClient client, @NonNull GlideString indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        return FT.executeCommand(client, new GlideString[]{GlideString.gs("FT.DROPINDEX"), indexName}, false);
    }

    public static CompletableFuture<Map<GlideString, Object>[]> aggregate(@NonNull BaseClient client, @NonNull String indexName, @NonNull String query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        return FT.aggregate(client, GlideString.gs(indexName), GlideString.gs(query));
    }

    public static CompletableFuture<Map<GlideString, Object>[]> aggregate(@NonNull BaseClient client, @NonNull String indexName, @NonNull String query, @NonNull FTAggregateOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return FT.aggregate(client, GlideString.gs(indexName), GlideString.gs(query), options);
    }

    public static CompletableFuture<Map<GlideString, Object>[]> aggregate(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull GlideString query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.AGGREGATE"), indexName, query};
        return FT.executeCommand(client, args, false).thenApply(res -> ArrayTransformUtils.castArray(res, Map.class));
    }

    public static CompletableFuture<Map<GlideString, Object>[]> aggregate(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull GlideString query, @NonNull FTAggregateOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({GlideString.gs("FT.AGGREGATE"), indexName, query}, options.toArgs());
        return FT.executeCommand(client, args, false).thenApply(res -> ArrayTransformUtils.castArray(res, Map.class));
    }

    public static CompletableFuture<Object[]> profile(@NonNull BaseClient client, @NonNull String indexName, @NonNull FTProfileOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return FT.profile(client, GlideString.gs(indexName), options);
    }

    public static CompletableFuture<Object[]> profile(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull FTProfileOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({GlideString.gs("FT.PROFILE"), indexName}, options.toArgs());
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<Map<String, Object>> info(@NonNull BaseClient client, @NonNull String indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        return FT.info(client, GlideString.gs(indexName));
    }

    public static CompletableFuture<Map<String, Object>> info(@NonNull BaseClient client, @NonNull GlideString indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (client instanceof GlideClusterClient) {
            return FT.executeCommand(client, new GlideString[]{GlideString.gs("FT.INFO"), indexName}, true);
        }
        return FT.executeCommand(client, new GlideString[]{GlideString.gs("FT.INFO"), indexName}, true).thenApply(map -> map.entrySet().stream().collect(Collectors.toMap(e -> ((GlideString)e.getKey()).toString(), Map.Entry::getValue)));
    }

    public static CompletableFuture<GlideString[]> list(@NonNull BaseClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        return FT.executeCommand(client, new GlideString[]{GlideString.gs("FT._LIST")}, false).thenApply(arr -> ArrayTransformUtils.castArray(arr, GlideString.class));
    }

    public static CompletableFuture<String> aliasadd(@NonNull BaseClient client, @NonNull String aliasName, @NonNull String indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (aliasName == null) {
            throw new NullPointerException("aliasName is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        return FT.aliasadd(client, GlideString.gs(aliasName), GlideString.gs(indexName));
    }

    public static CompletableFuture<String> aliasadd(@NonNull BaseClient client, @NonNull GlideString aliasName, @NonNull GlideString indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (aliasName == null) {
            throw new NullPointerException("aliasName is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.ALIASADD"), aliasName, indexName};
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<String> aliasdel(@NonNull BaseClient client, @NonNull String aliasName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (aliasName == null) {
            throw new NullPointerException("aliasName is marked non-null but is null");
        }
        return FT.aliasdel(client, GlideString.gs(aliasName));
    }

    public static CompletableFuture<String> aliasdel(@NonNull BaseClient client, @NonNull GlideString aliasName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (aliasName == null) {
            throw new NullPointerException("aliasName is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.ALIASDEL"), aliasName};
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<String> aliasupdate(@NonNull BaseClient client, @NonNull String aliasName, @NonNull String indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (aliasName == null) {
            throw new NullPointerException("aliasName is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        return FT.aliasupdate(client, GlideString.gs(aliasName), GlideString.gs(indexName));
    }

    public static CompletableFuture<String> aliasupdate(@NonNull BaseClient client, @NonNull GlideString aliasName, @NonNull GlideString indexName) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (aliasName == null) {
            throw new NullPointerException("aliasName is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.ALIASUPDATE"), aliasName, indexName};
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<Map<GlideString, GlideString>> aliaslist(@NonNull BaseClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (client instanceof GlideClient) {
            return FT.executeCommand(client, new GlideString[]{GlideString.gs("FT._ALIASLIST")}, true);
        }
        return FT.executeCommand(client, new GlideString[]{GlideString.gs("FT._ALIASLIST")}, true).thenApply(map -> map.entrySet().stream().collect(Collectors.toMap(e -> GlideString.gs((String)e.getKey()), Map.Entry::getValue)));
    }

    public static CompletableFuture<String> explain(@NonNull BaseClient client, @NonNull String indexName, @NonNull String query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.EXPLAIN"), GlideString.gs(indexName), GlideString.gs(query)};
        return FT.executeCommand(client, args, false).thenApply(GlideString::toString);
    }

    public static CompletableFuture<GlideString> explain(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull GlideString query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.EXPLAIN"), indexName, query};
        return FT.executeCommand(client, args, false);
    }

    public static CompletableFuture<String[]> explaincli(@NonNull BaseClient client, @NonNull String indexName, @NonNull String query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        CompletableFuture<GlideString[]> result = FT.explaincli(client, GlideString.gs(indexName), GlideString.gs(query));
        return result.thenApply(ret -> (String[])Arrays.stream(ret).map(GlideString::toString).toArray(String[]::new));
    }

    public static CompletableFuture<GlideString[]> explaincli(@NonNull BaseClient client, @NonNull GlideString indexName, @NonNull GlideString query) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{GlideString.gs("FT.EXPLAINCLI"), indexName, query};
        return FT.executeCommand(client, args, false).thenApply(ret -> ArrayTransformUtils.castArray(ret, GlideString.class));
    }

    private static <T> CompletableFuture<T> executeCommand(BaseClient client, GlideString[] args, boolean returnsMap) {
        if (client instanceof GlideClient) {
            return ((GlideClient)client).customCommand(args).thenApply(r -> r);
        }
        if (client instanceof GlideClusterClient) {
            return ((CompletableFuture)((GlideClusterClient)client).customCommand(args).thenApply(returnsMap ? ClusterValue::getMultiValue : ClusterValue::getSingleValue)).thenApply(r -> r);
        }
        throw new IllegalArgumentException("Unknown type of client, should be either `GlideClient` or `GlideClusterClient`");
    }
}

