/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Objects;

public class StreamEntryID {
    private final long time;
    private final long sequence;

    public StreamEntryID(long time, long sequence) {
        this.time = time;
        this.sequence = sequence;
    }

    public StreamEntryID(String id) {
        String[] parts = id.split("-");
        this.time = Long.parseLong(parts[0]);
        this.sequence = parts.length > 1 ? Long.parseLong(parts[1]) : 0L;
    }

    public long getTime() {
        return this.time;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String toString() {
        return this.time + "-" + this.sequence;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StreamEntryID that = (StreamEntryID)obj;
        return this.time == that.time && this.sequence == that.sequence;
    }

    public int hashCode() {
        return Objects.hash(this.time, this.sequence);
    }
}

