/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import javax.net.ssl.SSLParameters;
import redis.clients.jedis.SslVerifyMode;

public class SslOptions {
    private final String keyStoreType;
    private final String trustStoreType;
    private final Resource keystoreResource;
    private final char[] keystorePassword;
    private final Resource truststoreResource;
    private final char[] truststorePassword;
    private final SSLParameters sslParameters;
    private final SslVerifyMode sslVerifyMode;
    private final String sslProtocol;

    private SslOptions(Builder builder) {
        this.keyStoreType = builder.keyStoreType;
        this.trustStoreType = builder.trustStoreType;
        this.keystoreResource = builder.keystoreResource;
        this.keystorePassword = builder.keystorePassword;
        this.truststoreResource = builder.truststoreResource;
        this.truststorePassword = builder.truststorePassword;
        this.sslParameters = builder.sslParameters;
        this.sslVerifyMode = builder.sslVerifyMode;
        this.sslProtocol = builder.sslProtocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public Resource getTruststoreResource() {
        return this.truststoreResource;
    }

    public char[] getTruststorePassword() {
        return this.truststorePassword;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public SslVerifyMode getSslVerifyMode() {
        return this.sslVerifyMode;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    @FunctionalInterface
    public static interface Resource {
        public static Resource from(URL url) {
            Objects.requireNonNull(url, "URL must not be null");
            return () -> url.openConnection().getInputStream();
        }

        public static Resource from(File file) {
            Objects.requireNonNull(file, "File must not be null");
            return () -> new FileInputStream(file);
        }

        public InputStream get() throws IOException;
    }

    public static class Builder {
        private String keyStoreType;
        private String trustStoreType;
        private Resource keystoreResource;
        private char[] keystorePassword = null;
        private Resource truststoreResource;
        private char[] truststorePassword = null;
        private SSLParameters sslParameters;
        private SslVerifyMode sslVerifyMode = SslVerifyMode.FULL;
        private String sslProtocol = "TLS";

        private Builder() {
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = Objects.requireNonNull(keyStoreType, "KeyStoreType must not be null");
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = Objects.requireNonNull(trustStoreType, "TrustStoreType must not be null");
            return this;
        }

        public Builder keystore(File keystore) {
            return this.keystore(keystore, null);
        }

        public Builder keystore(File keystore, char[] keystorePassword) {
            Objects.requireNonNull(keystore, "Keystore must not be null");
            return this.keystore(Resource.from(keystore), keystorePassword);
        }

        public Builder keystore(URL keystore) {
            return this.keystore(keystore, null);
        }

        public Builder keystore(URL keystore, char[] keystorePassword) {
            Objects.requireNonNull(keystore, "Keystore must not be null");
            return this.keystore(Resource.from(keystore), keystorePassword);
        }

        public Builder keystore(Resource resource, char[] keystorePassword) {
            this.keystoreResource = Objects.requireNonNull(resource, "Keystore InputStreamProvider must not be null");
            this.keystorePassword = keystorePassword != null ? (char[])keystorePassword.clone() : null;
            return this;
        }

        public Builder truststore(File truststore) {
            return this.truststore(truststore, null);
        }

        public Builder truststore(File truststore, char[] truststorePassword) {
            Objects.requireNonNull(truststore, "Truststore must not be null");
            return this.truststore(Resource.from(truststore), truststorePassword);
        }

        public Builder truststore(URL truststore) {
            return this.truststore(truststore, null);
        }

        public Builder truststore(URL truststore, char[] truststorePassword) {
            Objects.requireNonNull(truststore, "Truststore must not be null");
            return this.truststore(Resource.from(truststore), truststorePassword);
        }

        public Builder truststore(Resource resource, char[] truststorePassword) {
            this.truststoreResource = Objects.requireNonNull(resource, "Truststore InputStreamProvider must not be null");
            this.truststorePassword = truststorePassword != null ? (char[])truststorePassword.clone() : null;
            return this;
        }

        public Builder sslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder sslVerifyMode(SslVerifyMode sslVerifyMode) {
            this.sslVerifyMode = sslVerifyMode;
            return this;
        }

        public Builder sslProtocol(String sslProtocol) {
            this.sslProtocol = sslProtocol;
            return this;
        }

        public SslOptions build() {
            return new SslOptions(this);
        }
    }
}

