/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.SSLParametersUtils;
import redis.clients.jedis.SslOptions;

public class DefaultJedisClientConfig
implements JedisClientConfig {
    public static final int DEFAULT_TIMEOUT_MILLIS = 2000;
    public static final int DEFAULT_DATABASE = 0;
    public static final RedisProtocol DEFAULT_PROTOCOL = RedisProtocol.RESP2;
    private final int connectionTimeoutMillis;
    private final int socketTimeoutMillis;
    private final int blockingSocketTimeoutMillis;
    private final String user;
    private final String password;
    private final int database;
    private final String clientName;
    private final boolean ssl;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLParameters sslParameters;
    private final HostnameVerifier hostnameVerifier;
    private final SslOptions sslOptions;
    private final RedisProtocol redisProtocol;

    private DefaultJedisClientConfig(Builder builder) {
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.socketTimeoutMillis = builder.socketTimeoutMillis;
        this.blockingSocketTimeoutMillis = builder.blockingSocketTimeoutMillis;
        this.user = builder.user;
        this.password = builder.password;
        this.database = builder.database;
        this.clientName = builder.clientName;
        this.ssl = builder.ssl;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.sslParameters = builder.sslParameters;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.sslOptions = builder.sslOptions;
        this.redisProtocol = builder.redisProtocol;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    @Override
    public int getBlockingSocketTimeoutMillis() {
        return this.blockingSocketTimeoutMillis;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public SSLParameters getSslParameters() {
        return SSLParametersUtils.copy(this.sslParameters);
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    public SslOptions getSslOptions() {
        return this.sslOptions;
    }

    @Override
    public RedisProtocol getRedisProtocol() {
        return this.redisProtocol;
    }

    public static class Builder {
        private int connectionTimeoutMillis = 2000;
        private int socketTimeoutMillis = 2000;
        private int blockingSocketTimeoutMillis = 0;
        private String user;
        private String password;
        private int database = 0;
        private String clientName;
        private boolean ssl = false;
        private SSLSocketFactory sslSocketFactory;
        private SSLParameters sslParameters;
        private HostnameVerifier hostnameVerifier;
        private SslOptions sslOptions;
        private RedisProtocol redisProtocol = DEFAULT_PROTOCOL;

        public Builder connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public Builder blockingSocketTimeoutMillis(int blockingSocketTimeoutMillis) {
            this.blockingSocketTimeoutMillis = blockingSocketTimeoutMillis;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder database(int database) {
            this.database = database;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder sslParameters(SSLParameters sslParameters) {
            this.sslParameters = SSLParametersUtils.copy(sslParameters);
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder sslOptions(SslOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        public Builder protocol(RedisProtocol redisProtocol) {
            this.redisProtocol = redisProtocol;
            return this;
        }

        public DefaultJedisClientConfig build() {
            return new DefaultJedisClientConfig(this);
        }
    }
}

