/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import java.util.ArrayList;
import lombok.Generated;

public final class HGetExExpiry {
    private final HGetExExpiryType type;
    private final Long count;

    private HGetExExpiry(HGetExExpiryType type) {
        this.type = type;
        this.count = null;
    }

    private HGetExExpiry(HGetExExpiryType type, Long count) {
        this.type = type;
        this.count = count;
    }

    public static HGetExExpiry Seconds(Long seconds) {
        if (seconds == null || seconds <= 0L) {
            throw new IllegalArgumentException("Seconds must be positive");
        }
        return new HGetExExpiry(HGetExExpiryType.SECONDS, seconds);
    }

    public static HGetExExpiry Milliseconds(Long milliseconds) {
        if (milliseconds == null || milliseconds <= 0L) {
            throw new IllegalArgumentException("Milliseconds must be positive");
        }
        return new HGetExExpiry(HGetExExpiryType.MILLISECONDS, milliseconds);
    }

    public static HGetExExpiry UnixSeconds(Long unixSeconds) {
        if (unixSeconds == null || unixSeconds <= 0L) {
            throw new IllegalArgumentException("Unix seconds must be positive");
        }
        return new HGetExExpiry(HGetExExpiryType.UNIX_SECONDS, unixSeconds);
    }

    public static HGetExExpiry UnixMilliseconds(Long unixMilliseconds) {
        if (unixMilliseconds == null || unixMilliseconds <= 0L) {
            throw new IllegalArgumentException("Unix milliseconds must be positive");
        }
        return new HGetExExpiry(HGetExExpiryType.UNIX_MILLISECONDS, unixMilliseconds);
    }

    public static HGetExExpiry Persist() {
        return new HGetExExpiry(HGetExExpiryType.PERSIST);
    }

    public String[] toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.type.valkeyApi);
        if (this.type != HGetExExpiryType.PERSIST) {
            assert (this.count != null) : "HGETEX expiry command received expiry type " + String.valueOf((Object)this.type) + ", but count was not set.";
            args.add(this.count.toString());
        }
        return args.toArray(new String[0]);
    }

    public String toString() {
        return "HGetExExpiry{type=" + String.valueOf((Object)this.type) + ", count=" + this.count + "}";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HGetExExpiry)) {
            return false;
        }
        HGetExExpiry other = (HGetExExpiry)o;
        Long this$count = this.count;
        Long other$count = other.count;
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        HGetExExpiryType this$type = this.type;
        HGetExExpiryType other$type = other.type;
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $count = this.count;
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        HGetExExpiryType $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    protected static enum HGetExExpiryType {
        PERSIST("PERSIST"),
        SECONDS("EX"),
        MILLISECONDS("PX"),
        UNIX_SECONDS("EXAT"),
        UNIX_MILLISECONDS("PXAT");

        private final String valkeyApi;

        @Generated
        private HGetExExpiryType(String valkeyApi) {
            this.valkeyApi = valkeyApi;
        }
    }
}

