/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.FT;

import glide.api.models.GlideString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class FTCreateOptions {
    private final DataType dataType;
    private final GlideString[] prefixes;

    FTCreateOptions(DataType dataType, GlideString[] prefixes) {
        this.dataType = dataType;
        this.prefixes = prefixes;
    }

    public static FTCreateOptionsBuilder builder() {
        return new FTCreateOptionsBuilder();
    }

    public GlideString[] toArgs() {
        ArrayList<GlideString> args = new ArrayList<GlideString>();
        if (this.dataType != null) {
            args.add(GlideString.gs("ON"));
            args.add(GlideString.gs(this.dataType.toString()));
        }
        if (this.prefixes != null && this.prefixes.length > 0) {
            args.add(GlideString.gs("PREFIX"));
            args.add(GlideString.gs(Integer.toString(this.prefixes.length)));
            args.addAll(List.of(this.prefixes));
        }
        return (GlideString[])args.toArray(GlideString[]::new);
    }

    public static class FieldInfo {
        private final GlideString name;
        private final GlideString alias;
        private final Field field;

        public FieldInfo(@NonNull String name, @NonNull Field field) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.name = GlideString.gs(name);
            this.field = field;
            this.alias = null;
        }

        public FieldInfo(@NonNull String name, @NonNull String alias, @NonNull Field field) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.name = GlideString.gs(name);
            this.alias = GlideString.gs(alias);
            this.field = field;
        }

        public FieldInfo(@NonNull GlideString name, @NonNull Field field) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.name = name;
            this.field = field;
            this.alias = null;
        }

        public FieldInfo(@NonNull GlideString name, @NonNull GlideString alias, @NonNull Field field) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (alias == null) {
                throw new NullPointerException("alias is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.name = name;
            this.alias = alias;
            this.field = field;
        }

        public GlideString[] toArgs() {
            ArrayList<GlideString> args = new ArrayList<GlideString>();
            args.add(this.name);
            if (this.alias != null) {
                args.add(GlideString.gs("AS"));
                args.add(this.alias);
            }
            args.addAll(Stream.of(this.field.toArgs()).map(GlideString::gs).collect(Collectors.toList()));
            return (GlideString[])args.toArray(GlideString[]::new);
        }
    }

    static abstract class VectorFieldBuilder<T extends VectorFieldBuilder<T>> {
        final Map<VectorAlgorithmParam, String> params = new HashMap<VectorAlgorithmParam, String>();

        VectorFieldBuilder(DistanceMetric distanceMetric, int dimensions) {
            this.params.put(VectorAlgorithmParam.TYPE, "FLOAT32");
            this.params.put(VectorAlgorithmParam.DIM, Integer.toString(dimensions));
            this.params.put(VectorAlgorithmParam.DISTANCE_METRIC, distanceMetric.toString());
        }

        public T initialCapacity(int initialCapacity) {
            this.params.put(VectorAlgorithmParam.INITIAL_CAP, Integer.toString(initialCapacity));
            return (T)this;
        }

        public abstract VectorField build();
    }

    public static class VectorFieldFlatBuilder
    extends VectorFieldBuilder<VectorFieldFlatBuilder> {
        VectorFieldFlatBuilder(DistanceMetric distanceMetric, int dimensions) {
            super(distanceMetric, dimensions);
        }

        @Override
        public VectorFieldFlat build() {
            return new VectorFieldFlat(this.params);
        }
    }

    public static class VectorFieldFlat
    extends VectorField {
        private VectorFieldFlat(Map<VectorAlgorithmParam, String> params) {
            super(params, VectorAlgorithm.FLAT);
        }

        public static VectorFieldFlatBuilder builder(@NonNull DistanceMetric distanceMetric, int dimensions) {
            if (distanceMetric == null) {
                throw new NullPointerException("distanceMetric is marked non-null but is null");
            }
            return new VectorFieldFlatBuilder(distanceMetric, dimensions);
        }
    }

    public static class VectorFieldHnswBuilder
    extends VectorFieldBuilder<VectorFieldHnswBuilder> {
        VectorFieldHnswBuilder(DistanceMetric distanceMetric, int dimensions) {
            super(distanceMetric, dimensions);
        }

        @Override
        public VectorFieldHnsw build() {
            return new VectorFieldHnsw(this.params);
        }

        public VectorFieldHnswBuilder numberOfEdges(int numberOfEdges) {
            this.params.put(VectorAlgorithmParam.M, Integer.toString(numberOfEdges));
            return this;
        }

        public VectorFieldHnswBuilder vectorsExaminedOnConstruction(int vectorsExaminedOnConstruction) {
            this.params.put(VectorAlgorithmParam.EF_CONSTRUCTION, Integer.toString(vectorsExaminedOnConstruction));
            return this;
        }

        public VectorFieldHnswBuilder vectorsExaminedOnRuntime(int vectorsExaminedOnRuntime) {
            this.params.put(VectorAlgorithmParam.EF_RUNTIME, Integer.toString(vectorsExaminedOnRuntime));
            return this;
        }
    }

    public static class VectorFieldHnsw
    extends VectorField {
        private VectorFieldHnsw(Map<VectorAlgorithmParam, String> params) {
            super(params, VectorAlgorithm.HNSW);
        }

        public static VectorFieldHnswBuilder builder(@NonNull DistanceMetric distanceMetric, int dimensions) {
            if (distanceMetric == null) {
                throw new NullPointerException("distanceMetric is marked non-null but is null");
            }
            return new VectorFieldHnswBuilder(distanceMetric, dimensions);
        }
    }

    private static enum VectorAlgorithmParam {
        M,
        EF_CONSTRUCTION,
        EF_RUNTIME,
        TYPE,
        DIM,
        DISTANCE_METRIC,
        INITIAL_CAP;

    }

    private static enum VectorAlgorithm {
        HNSW,
        FLAT;

    }

    static abstract class VectorField
    implements Field {
        private final Map<VectorAlgorithmParam, String> params;
        private final VectorAlgorithm algorithm;

        @Override
        public String[] toArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(FieldType.VECTOR.toString());
            args.add(this.algorithm.toString());
            args.add(Integer.toString(this.params.size() * 2));
            this.params.forEach((name, value) -> {
                args.add(name.toString());
                args.add((String)value);
            });
            return (String[])args.toArray(String[]::new);
        }

        @Generated
        protected VectorField(Map<VectorAlgorithmParam, String> params, VectorAlgorithm algorithm) {
            this.params = params;
            this.algorithm = algorithm;
        }
    }

    public static enum DistanceMetric {
        L2,
        IP,
        COSINE;

    }

    public static class TagField
    implements Field {
        private Optional<Character> separator;
        private final boolean caseSensitive;

        public TagField() {
            this.separator = Optional.empty();
            this.caseSensitive = false;
        }

        public TagField(char separator) {
            this.separator = Optional.of(Character.valueOf(separator));
            this.caseSensitive = false;
        }

        public TagField(char separator, boolean caseSensitive) {
            this.separator = Optional.of(Character.valueOf(separator));
            this.caseSensitive = caseSensitive;
        }

        public TagField(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public String[] toArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(FieldType.TAG.toString());
            if (this.separator.isPresent()) {
                args.add("SEPARATOR");
                args.add(this.separator.get().toString());
            }
            if (this.caseSensitive) {
                args.add("CASESENSITIVE");
            }
            return (String[])args.toArray(String[]::new);
        }
    }

    public static class TextField
    implements Field {
        @Override
        public String[] toArgs() {
            return new String[]{FieldType.TEXT.toString()};
        }
    }

    public static class NumericField
    implements Field {
        @Override
        public String[] toArgs() {
            return new String[]{FieldType.NUMERIC.toString()};
        }
    }

    private static enum FieldType {
        NUMERIC,
        TEXT,
        TAG,
        VECTOR;

    }

    public static interface Field {
        public String[] toArgs();
    }

    public static enum DataType {
        HASH,
        JSON;

    }

    public static class FTCreateOptionsBuilder {
        @Generated
        private DataType dataType;
        @Generated
        private GlideString[] prefixes;

        public FTCreateOptionsBuilder prefixes(@NonNull String[] prefixes) {
            if (prefixes == null) {
                throw new NullPointerException("prefixes is marked non-null but is null");
            }
            this.prefixes = (GlideString[])Stream.of(prefixes).map(GlideString::gs).toArray(GlideString[]::new);
            return this;
        }

        @Generated
        FTCreateOptionsBuilder() {
        }

        @Generated
        public FTCreateOptionsBuilder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        @Generated
        public FTCreateOptions build() {
            return new FTCreateOptions(this.dataType, this.prefixes);
        }

        @Generated
        public String toString() {
            return "FTCreateOptions.FTCreateOptionsBuilder(dataType=" + String.valueOf((Object)this.dataType) + ", prefixes=" + Arrays.deepToString(this.prefixes) + ")";
        }
    }
}

